/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.contenttweaker.modules.vanilla.tileentity;

import com.google.common.collect.Maps;
import com.teamacronymcoders.base.tileentities.TileEntityBase;
import com.teamacronymcoders.contenttweaker.api.ctobjects.blockpos.MCBlockPos;
import com.teamacronymcoders.contenttweaker.api.ctobjects.world.MCWorld;
import com.teamacronymcoders.contenttweaker.modules.vanilla.tileentity.TileEntityRepresentation;
import crafttweaker.api.data.DataMap;
import crafttweaker.api.data.IData;
import crafttweaker.mc1120.data.NBTConverter;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileEntityContent
extends TileEntityBase
implements ITickable {
    public static final Map<String, TileEntityRepresentation> REPRESENTATION_MAP = Maps.newHashMap();
    private TileEntityRepresentation representation;
    private IData tileEntityData;
    private MCWorld zenWorld;
    private MCBlockPos zenPos;

    public TileEntityContent() {
        this(new TileEntityRepresentation("none"));
    }

    public TileEntityContent(TileEntityRepresentation representation) {
        this.representation = representation;
        this.tileEntityData = new DataMap((Map)Maps.newHashMap(), false);
    }

    protected void readFromDisk(NBTTagCompound data) {
        String representationName = data.func_74779_i("representation");
        this.representation = Optional.ofNullable(REPRESENTATION_MAP.get(representationName)).orElseGet(() -> new TileEntityRepresentation(representationName));
        this.tileEntityData = NBTConverter.from((NBTBase)data.func_74775_l("data"), (boolean)false);
    }

    protected NBTTagCompound writeToDisk(NBTTagCompound data) {
        data.func_74778_a("representation", this.representation.name);
        data.func_74782_a("data", NBTConverter.from((IData)this.tileEntityData));
        return data;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            this.representation.clientUpdate.onUpdate(this.zenWorld, this.zenPos, this.tileEntityData);
        } else {
            this.representation.serverUpdate.onUpdate(this.zenWorld, this.zenPos, this.tileEntityData);
        }
    }

    public void func_145834_a(@Nonnull World world) {
        super.func_145834_a(world);
        this.zenWorld = new MCWorld(world);
    }

    public void func_174878_a(BlockPos blockPos) {
        super.func_174878_a(blockPos);
        this.zenPos = new MCBlockPos(blockPos);
    }
}

