/*
 * Decompiled with CFR 0.152.
 */
package prospector.traverse.config;

import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class TraverseConfig {
    public static final String CATEGORY_BIOMES = "Biomes";
    public static File configDir;
    public static File mainConfig;
    public static Configuration config;
    public static TraverseConfig traverseConfiguration;
    public static boolean useVanillaWood;
    public static boolean registerBiomesRegardless;
    public static boolean disableCustomSkies;
    public static boolean vanillaCanyonBlocks;
    public static int findBiomeCommandTimeout;
    public static boolean disallowVillages;
    public static boolean disallowBoulders;
    public static boolean disableAutumnalWoods;
    public static boolean disableWoodlands;
    public static boolean disableMiniJungle;
    public static boolean disableMeadow;
    public static boolean disableLushSwamp;
    public static boolean disableRedDesert;
    public static boolean disableTemperateRainforest;
    public static boolean disableBadlands;
    public static boolean disableMountainousDesert;
    public static boolean disableRockyPlateau;
    public static boolean disableForestedHills;
    public static boolean disableBirchForestedHills;
    public static boolean disableAutumnalWoodedHills;
    public static boolean disableCliffs;
    public static boolean disableGlacier;
    public static boolean disableGlacierSpikes;
    public static boolean disableSnowyConiferousForest;
    public static boolean disableLushHills;
    public static boolean disableCanyon;
    public static boolean disableCragCliffs;
    public static boolean disableDesertShrubland;
    public static boolean disableThicket;
    public static boolean disableAridHighland;
    public static boolean disableRockyPlains;
    public static boolean enableNewTextures;
    private static TraverseConfig instance;

    private TraverseConfig() {
        config = new Configuration(mainConfig);
        config.load();
        useVanillaWood = config.get("general", "useVanillaWood", useVanillaWood, "Use vanilla logs for Traverse trees (might not look as nice)").getBoolean();
        registerBiomesRegardless = config.get("general", "registerBiomesRegardless", registerBiomesRegardless, "All biomes will always be registered, ignoring the instance traverse_world_data (WARNING: This will cause ugly world generation borders at the edge of what has previously been generated and what is new!!)").getBoolean();
        disableCustomSkies = config.get("general", "disableCustomSkies", disableCustomSkies, "When true, Traverse will only use the default sky colour.").getBoolean();
        vanillaCanyonBlocks = config.get("general", "vanillaCanyonBlocks", vanillaCanyonBlocks, "Use vanilla Red Sandstone instead of Red Rock in the Canyon biome.").getBoolean();
        findBiomeCommandTimeout = config.get("general", "findBiomeCommandTimeout", findBiomeCommandTimeout, "How long, in ms, the /findbiome command will search for biomes before timing out, normally 20000ms").getInt();
        disallowVillages = config.get("general", "disallowVillages", disallowVillages, "With this enabled, villages will not spawn in Traverse biomes").getBoolean();
        disallowBoulders = config.get("general", "disallowBoulders", disallowBoulders, "With this enabled, cobblestone boulder formations will not spawn in Traverse biomes").getBoolean();
        disableAutumnalWoods = config.get(CATEGORY_BIOMES, "disableAutumnalWoods", disableAutumnalWoods, "Force disable the Autumnal Woods biome").getBoolean();
        disableWoodlands = config.get(CATEGORY_BIOMES, "disableWoodlands", disableWoodlands, "Force disable the Woodlands biome").getBoolean();
        disableMiniJungle = config.get(CATEGORY_BIOMES, "disableMiniJungle", disableMiniJungle, "Force disable the Mini Jungle biome").getBoolean();
        disableMeadow = config.get(CATEGORY_BIOMES, "disableMeadow", disableMeadow, "Force disable the Meadow biome").getBoolean();
        disableLushSwamp = config.get(CATEGORY_BIOMES, "disableLushSwamp", disableLushSwamp, "Force disable the Lush Swamp biome").getBoolean();
        disableRedDesert = config.get(CATEGORY_BIOMES, "disableRedDesert", disableRedDesert, "Force disable the Red Desert biome").getBoolean();
        disableTemperateRainforest = config.get(CATEGORY_BIOMES, "disableTemperateRainforest", disableTemperateRainforest, "Force disable the Temperate Rainforest biome").getBoolean();
        disableBadlands = config.get(CATEGORY_BIOMES, "disableBadlands", disableBadlands, "Force disable the Badlands biome").getBoolean();
        disableMountainousDesert = config.get(CATEGORY_BIOMES, "disableMountainousDesert", disableMountainousDesert, "Force disable the Mountainous Desert biome").getBoolean();
        disableRockyPlateau = config.get(CATEGORY_BIOMES, "disableRockyPlateau", disableRockyPlateau, "Force disable the Rocky Plateau biome").getBoolean();
        disableForestedHills = config.get(CATEGORY_BIOMES, "disableForestedHills", disableForestedHills, "Force disable the Forested Hills biome").getBoolean();
        disableBirchForestedHills = config.get(CATEGORY_BIOMES, "disableBirchForestedHills", disableBirchForestedHills, "Force disable the Birch Forested Hills biome").getBoolean();
        disableAutumnalWoodedHills = config.get(CATEGORY_BIOMES, "disableAutumnalWoodedHills", disableAutumnalWoodedHills, "Force disable the Autumnal Wooded Hills biome").getBoolean();
        disableCliffs = config.get(CATEGORY_BIOMES, "disableCliffs", disableCliffs, "Force disable the Cliffs biome").getBoolean();
        disableGlacier = config.get(CATEGORY_BIOMES, "disableGlacier", disableGlacier, "Force disable the Glacier biome").getBoolean();
        disableGlacierSpikes = config.get(CATEGORY_BIOMES, "disableGlacierSpikes", disableGlacierSpikes, "Force disable the Glacier Spikes biome").getBoolean();
        disableSnowyConiferousForest = config.get(CATEGORY_BIOMES, "disableSnowyConiferousForest", disableSnowyConiferousForest, "Force disable the Snowy Coniferous Forest biome").getBoolean();
        disableLushHills = config.get(CATEGORY_BIOMES, "disableLushHills", disableLushHills, "Force disable the Lush Hills biome").getBoolean();
        disableCanyon = config.get(CATEGORY_BIOMES, "disableCanyon", disableCanyon, "Force disable the Canyon biome").getBoolean();
        disableCragCliffs = config.get(CATEGORY_BIOMES, "disableCragCliffs", disableCragCliffs, "Force disable the Crag Cliffs biome").getBoolean();
        disableDesertShrubland = config.get(CATEGORY_BIOMES, "disableDesertShrubland", disableDesertShrubland, "Force disable the Desert Shrubland biome").getBoolean();
        disableThicket = config.get(CATEGORY_BIOMES, "disableThicket", disableThicket, "Force disable the Thicket biome").getBoolean();
        disableAridHighland = config.get(CATEGORY_BIOMES, "disableAridHighland", disableAridHighland, "Force disable the Arid Highland biome").getBoolean();
        disableRockyPlains = config.get(CATEGORY_BIOMES, "disableRockyPlains", disableRockyPlains, "Force disable the Rocky Plains biome").getBoolean();
        enableNewTextures = config.get("client", "enableNewTextures", enableNewTextures, "Enable the new Traverse textures in the newer minecraft style").getBoolean();
        config.save();
    }

    public static TraverseConfig initialize() {
        if (instance != null) {
            throw new IllegalStateException("Cannot initialize config twice");
        }
        instance = new TraverseConfig();
        return instance;
    }

    public static TraverseConfig getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Instance of config requested before initialization");
        }
        return instance;
    }

    public static void initialize(FMLPreInitializationEvent event) {
        configDir = new File(event.getModConfigurationDirectory(), "traverse");
        if (!configDir.exists()) {
            configDir.mkdir();
        }
        mainConfig = new File(configDir, "traverse.cfg");
        traverseConfiguration = TraverseConfig.initialize();
    }

    static {
        useVanillaWood = false;
        registerBiomesRegardless = false;
        disableCustomSkies = false;
        vanillaCanyonBlocks = false;
        findBiomeCommandTimeout = 30000;
        disallowVillages = false;
        disallowBoulders = false;
        disableAutumnalWoods = false;
        disableWoodlands = false;
        disableMiniJungle = false;
        disableMeadow = false;
        disableLushSwamp = false;
        disableRedDesert = false;
        disableTemperateRainforest = false;
        disableBadlands = false;
        disableMountainousDesert = false;
        disableRockyPlateau = false;
        disableForestedHills = false;
        disableBirchForestedHills = false;
        disableAutumnalWoodedHills = false;
        disableCliffs = false;
        disableGlacier = false;
        disableGlacierSpikes = false;
        disableSnowyConiferousForest = false;
        disableLushHills = false;
        disableCanyon = true;
        disableCragCliffs = true;
        disableDesertShrubland = false;
        disableThicket = false;
        disableAridHighland = false;
        disableRockyPlains = false;
        enableNewTextures = false;
        instance = null;
    }
}

