/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.tile;

import com.globbypotato.rockhounding_chemistry.ModItems;
import com.globbypotato.rockhounding_chemistry.enums.EnumMiscBlocksA;
import com.globbypotato.rockhounding_chemistry.enums.EnumMiscItems;
import com.globbypotato.rockhounding_chemistry.enums.utils.EnumServer;
import com.globbypotato.rockhounding_chemistry.fluids.ModFluids;
import com.globbypotato.rockhounding_chemistry.handlers.ModConfig;
import com.globbypotato.rockhounding_chemistry.machines.io.MachineIO;
import com.globbypotato.rockhounding_chemistry.machines.recipe.BedReactorRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.BedReactorRecipe;
import com.globbypotato.rockhounding_chemistry.machines.tile.IInternalServer;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEPowerGenerator;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEServer;
import com.globbypotato.rockhounding_chemistry.machines.tile.TETubularBedBase;
import com.globbypotato.rockhounding_chemistry.machines.tile.TETubularBedLow;
import com.globbypotato.rockhounding_chemistry.machines.tile.TETubularBedMid;
import com.globbypotato.rockhounding_chemistry.machines.tile.TETubularBedTank;
import com.globbypotato.rockhounding_chemistry.machines.tile.TileStructure;
import com.globbypotato.rockhounding_chemistry.machines.tile.TileVessel;
import com.globbypotato.rockhounding_chemistry.utils.ModUtils;
import com.globbypotato.rockhounding_core.machines.tileentity.MachineStackHandler;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import com.globbypotato.rockhounding_core.machines.tileentity.WrappedItemHandler;
import com.globbypotato.rockhounding_core.utils.CoreUtils;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class TETubularBedController
extends TileEntityInv
implements IInternalServer {
    public static int templateSlots = 3;
    public static int upgradeSlots = 1;
    public static final int SPEED_SLOT = 0;
    public int currentFile = -1;
    public boolean isRepeatable = false;
    private int countCat;
    public BedReactorRecipe dummyRecipe;

    public TETubularBedController() {
        super(0, 0, templateSlots, upgradeSlots);
        this.upgrade = new MachineStackHandler(upgradeSlots, this){

            public ItemStack insertItem(int slot, ItemStack insertingStack, boolean simulate) {
                if (slot == 0 && ModUtils.isValidSpeedUpgrade(insertingStack)) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                return insertingStack;
            }
        };
        this.automationUpgrade = new WrappedItemHandler((IItemHandlerModifiable)this.upgrade, WrappedItemHandler.WriteMode.IN);
    }

    public ItemStack speedSlot() {
        return this.upgrade.getStackInSlot(0);
    }

    public int getGUIHeight() {
        return 200;
    }

    public static String getName() {
        return "tubular_bed_controller";
    }

    public int speedFactor() {
        return ModUtils.isValidSpeedUpgrade(this.speedSlot()) ? ModUtils.speedUpgrade(this.speedSlot()) : 1;
    }

    public int getCooktimeMax() {
        return ModUtils.isValidSpeedUpgrade(this.speedSlot()) ? ModConfig.speedBedReactor / ModUtils.speedUpgrade(this.speedSlot()) : ModConfig.speedBedReactor;
    }

    private static int deviceCode() {
        return EnumServer.BED_REACTOR.ordinal();
    }

    public BlockPos poweredPosition() {
        return this.chamberPos().func_177972_a(this.poweredFacing());
    }

    public EnumFacing poweredFacing() {
        return EnumFacing.func_176733_a((double)(this.getFacing().func_185119_l() + 270.0f));
    }

    public ArrayList<BedReactorRecipe> recipeList() {
        return BedReactorRecipes.bed_reactor_recipes;
    }

    public BedReactorRecipe getRecipeList(int x) {
        return this.recipeList().get(x);
    }

    public BedReactorRecipe getCurrentRecipe() {
        if (this.isActive() && this.isValidPreset() && this.hasCatalysts() && this.handleMainInput() && this.handleInput() && this.handleOutput()) {
            return this.getRecipeList(this.getRecipeIndex());
        }
        return null;
    }

    public BedReactorRecipe getDummyRecipe() {
        return this.dummyRecipe;
    }

    public boolean isValidPreset() {
        return this.getRecipeIndex() > -1 && this.getRecipeIndex() < this.recipeList().size();
    }

    public boolean isValidRecipe() {
        return this.getDummyRecipe() != null;
    }

    private boolean hasCatalysts() {
        if (this.hasTubularCatalysts()) {
            int x = 0;
            while (true) {
                this.getTubularCatalysts();
                if (x >= TETubularBedLow.SLOT_INPUTS.length) break;
                if (this.getTubularCatalysts().catalystSlot(x).func_185136_b(this.getRecipeCatalyst())) {
                    return true;
                }
                ++x;
            }
        }
        return false;
    }

    private boolean handleMainInput() {
        return this.verifyMainInput(this.hasInput1Tank(), this.getRecipeInput1(), this.tankInput1(), this.getRecipeInput1() != null ? this.calculatedAmount(this.getRecipeInput1().amount) : 0, true);
    }

    private boolean handleInput() {
        return this.verifyInput(this.hasInput2Tank(), this.getRecipeInput2(), this.tankInput2(), this.getRecipeInput2() != null ? this.calculatedAmount(this.getRecipeInput2().amount) : 0, false) && this.verifyInput(this.hasInput3Tank(), this.getRecipeInput3(), this.tankInput3(), this.getRecipeInput3() != null ? this.calculatedAmount(this.getRecipeInput3().amount) : 0, false) && this.verifyInput(this.hasInput4Tank(), this.getRecipeInput4(), this.tankInput4(), this.getRecipeInput4() != null ? this.calculatedAmount(this.getRecipeInput4().amount) : 0, false);
    }

    private boolean verifyMainInput(boolean tank, FluidStack recipeInput, FluidStack tankInput, int drain, boolean isMain) {
        return tank && this.input.canDrainFluid(tankInput, recipeInput, drain);
    }

    private boolean verifyInput(boolean tank, FluidStack recipeInput, FluidStack tankInput, int drain, boolean isMain) {
        if (tank && recipeInput != null && this.input.canDrainFluid(tankInput, recipeInput, drain)) {
            return true;
        }
        return recipeInput == null && tankInput == null;
    }

    private boolean handleOutput() {
        return this.getRecipeOutput() != null && this.hasOutTank() && this.input.canSetOrAddFluid(this.getOutTank().inputTank, this.getOutTank().inputTank.getFluid(), this.getRecipeOutput(), this.calculatedAmount(this.getRecipeOutput().amount));
    }

    private int calculatedAmount(int amount) {
        int multi = 0;
        int x = 0;
        while (true) {
            this.getTubularCatalysts();
            if (x >= TETubularBedLow.SLOT_INPUTS.length) break;
            if (this.getTubularCatalysts().catalystSlot(x).func_185136_b(this.getRecipeCatalyst())) {
                ++multi;
            }
            ++x;
        }
        return multi * amount;
    }

    public int catSize() {
        int multi = 0;
        int x = 0;
        while (true) {
            this.getTubularCatalysts();
            if (x >= TETubularBedLow.SLOT_INPUTS.length) break;
            if (this.getTubularCatalysts().catalystSlot(x).func_185136_b(this.getRecipeCatalyst())) {
                ++multi;
            }
            ++x;
        }
        return multi;
    }

    public FluidStack getRecipeInput1() {
        return this.isValidPreset() ? this.getRecipeList(this.getRecipeIndex()).getInput1() : null;
    }

    public FluidStack getRecipeInput2() {
        return this.isValidPreset() ? this.getRecipeList(this.getRecipeIndex()).getInput2() : null;
    }

    public FluidStack getRecipeInput3() {
        return this.isValidPreset() ? this.getRecipeList(this.getRecipeIndex()).getInput3() : null;
    }

    public FluidStack getRecipeInput4() {
        return this.isValidPreset() ? this.getRecipeList(this.getRecipeIndex()).getInput4() : null;
    }

    public FluidStack getRecipeOutput() {
        return this.isValidPreset() ? this.getRecipeList(this.getRecipeIndex()).getOutput() : null;
    }

    public ItemStack getRecipeCatalyst() {
        return this.isValidPreset() ? this.getRecipeList(this.getRecipeIndex()).getCatalyst() : ItemStack.field_190927_a;
    }

    public TEPowerGenerator getEngine() {
        TEPowerGenerator engine = TileStructure.getEngine(this.field_145850_b, this.field_174879_c.func_177979_c(1), this.isFacingAt(90), 1, 0);
        return engine != null ? engine : null;
    }

    public boolean hasEngine() {
        return this.getEngine() != null;
    }

    public boolean hasFuelPower() {
        return this.hasEngine() ? this.getEngine().getPower() > 0 : false;
    }

    public boolean hasRedstonePower() {
        return this.hasEngine() ? this.getEngine().getRedstone() >= this.powerConsume() : false;
    }

    private void drainPower() {
        --this.getEngine().powerCount;
        this.getEngine().redstoneCount -= this.powerConsume();
        this.getEngine().markDirtyClient();
    }

    public int powerConsume() {
        int baseConsume = 20 * ModConfig.basePower;
        return ModConfig.speedMultiplier ? baseConsume * this.speedFactor() : baseConsume;
    }

    public BlockPos chamberPos() {
        return this.field_174879_c.func_177979_c(1);
    }

    public TETubularBedTank getChamber() {
        TETubularBedTank tank;
        TileEntity te = this.field_145850_b.func_175625_s(this.chamberPos());
        if (this.field_145850_b.func_180495_p(this.chamberPos()) != null && te instanceof TETubularBedTank && (tank = (TETubularBedTank)te).getFacing() == this.getFacing()) {
            return tank;
        }
        return null;
    }

    public boolean hasChamber() {
        return this.getChamber() != null;
    }

    public BlockPos tubularBasePos() {
        return this.field_174879_c.func_177979_c(1).func_177967_a(this.getFacing(), 1);
    }

    public TETubularBedBase getTubularBase() {
        TETubularBedBase tank;
        TileEntity te = this.field_145850_b.func_175625_s(this.tubularBasePos());
        if (this.field_145850_b.func_180495_p(this.tubularBasePos()) != null && te instanceof TETubularBedBase && (tank = (TETubularBedBase)te).getFacing() == this.getFacing()) {
            return tank;
        }
        return null;
    }

    public boolean hasTubularBase() {
        return this.getTubularBase() != null;
    }

    public TETubularBedLow getTubularCatalysts() {
        TETubularBedLow tank;
        TileEntity te = this.field_145850_b.func_175625_s(this.tubularBasePos().func_177984_a());
        if (this.field_145850_b.func_180495_p(this.tubularBasePos()) != null && te instanceof TETubularBedLow && (tank = (TETubularBedLow)te).getFacing() == this.getFacing()) {
            return tank;
        }
        return null;
    }

    public boolean hasTubularCatalysts() {
        return this.getTubularCatalysts() != null;
    }

    public BlockPos tubularTopPos() {
        return this.field_174879_c.func_177967_a(this.getFacing(), 1);
    }

    public TETubularBedMid getTubularTop() {
        TETubularBedMid tank;
        TileEntity te = this.field_145850_b.func_175625_s(this.tubularTopPos());
        if (this.field_145850_b.func_180495_p(this.tubularTopPos()) != null && te instanceof TETubularBedMid && (tank = (TETubularBedMid)te).getFacing() == this.getFacing()) {
            return tank;
        }
        return null;
    }

    public boolean hasTubularTop() {
        return this.getTubularBase() != null;
    }

    public BlockPos routerPos() {
        return this.field_174879_c.func_177981_b(3).func_177967_a(this.getFacing(), 1);
    }

    public Block getRouter() {
        IBlockState sepState = this.field_145850_b.func_180495_p(this.routerPos());
        Block separator = sepState.func_177230_c();
        if (MachineIO.miscBlocksA(separator, sepState, EnumMiscBlocksA.GAS_ROUTER.ordinal())) {
            return separator;
        }
        return null;
    }

    public boolean hasRouter() {
        return this.getRouter() != null;
    }

    public TileVessel getOutTank() {
        TileVessel vessel = TileStructure.getHolder(this.field_145850_b, this.field_174879_c.func_177979_c(1).func_177967_a(this.getFacing(), 1), this.isFacingAt(270), 1, 0);
        return vessel != null ? vessel : null;
    }

    public boolean hasOutTank() {
        return this.getOutTank() != null;
    }

    public FluidStack outGas() {
        return this.hasOutTank() ? this.getOutTank().inputTank.getFluid() : null;
    }

    public TileVessel getPurgeTank() {
        TileVessel vessel = TileStructure.getHolder(this.field_145850_b, this.field_174879_c.func_177967_a(this.getFacing(), 1), this.getFacing(), 1, 0);
        return vessel != null ? vessel : null;
    }

    public boolean hasPurgeTank() {
        return this.getPurgeTank() != null;
    }

    public FluidStack purgeGas() {
        return this.hasPurgeTank() ? this.getPurgeTank().inputTank.getFluid() : null;
    }

    public TileVessel getInput1Tank() {
        TileVessel vessel = TileStructure.getHolder(this.field_145850_b, this.field_174879_c.func_177981_b(3), this.getFacing(), 0, 0);
        return vessel != null ? vessel : null;
    }

    public boolean hasInput1Tank() {
        return this.getInput1Tank() != null;
    }

    public FluidStack tankInput1() {
        return this.hasInput1Tank() ? this.getInput1Tank().inputTank.getFluid() : null;
    }

    public TileVessel getInput2Tank() {
        TileVessel vessel = TileStructure.getHolder(this.field_145850_b, this.field_174879_c.func_177981_b(3).func_177967_a(this.getFacing(), 1), this.isFacingAt(90), 1, 180);
        return vessel != null ? vessel : null;
    }

    public boolean hasInput2Tank() {
        return this.getInput2Tank() != null;
    }

    public FluidStack tankInput2() {
        return this.hasInput2Tank() ? this.getInput2Tank().inputTank.getFluid() : null;
    }

    public TileVessel getInput3Tank() {
        TileVessel vessel = TileStructure.getHolder(this.field_145850_b, this.routerPos().func_177967_a(this.getFacing(), 2), this.getFacing().func_176734_d(), 1, 0);
        return vessel != null ? vessel : null;
    }

    public boolean hasInput3Tank() {
        return this.getInput3Tank() != null;
    }

    public FluidStack tankInput3() {
        return this.hasInput3Tank() ? this.getInput3Tank().inputTank.getFluid() : null;
    }

    public TileVessel getInput4Tank() {
        TileVessel vessel = TileStructure.getHolder(this.field_145850_b, this.field_174879_c.func_177981_b(3).func_177967_a(this.getFacing(), 1), this.isFacingAt(270), 1, 180);
        return vessel != null ? vessel : null;
    }

    public boolean hasInput4Tank() {
        return this.getInput4Tank() != null;
    }

    public FluidStack tankInput4() {
        return this.hasInput4Tank() ? this.getInput4Tank().inputTank.getFluid() : null;
    }

    public TEServer getServer() {
        TEServer server = TileStructure.getServer(this.field_145850_b, this.field_174879_c.func_177979_c(1).func_177967_a(this.getFacing(), 1), this.getFacing(), 1, 0);
        return server != null ? server : null;
    }

    public boolean hasServer() {
        return this.getServer() != null;
    }

    private void doPreset() {
        if (this.hasEngine()) {
            if (!this.getEngine().enablePower) {
                this.getEngine().enablePower = true;
                this.getEngine().markDirtyClient();
            }
            if (!this.getEngine().enableRedstone) {
                this.getEngine().enableRedstone = true;
                this.getEngine().markDirtyClient();
            }
        }
        if (this.isValidPreset()) {
            if (this.hasInput1Tank() && this.getInput1Tank().getFilter() != this.getRecipeInput1()) {
                this.getInput1Tank().filter = this.getRecipeInput1();
            }
            if (this.hasInput2Tank()) {
                if (this.getInput2Tank().getFilter() != this.getRecipeInput2()) {
                    this.getInput2Tank().filter = this.getRecipeInput2();
                }
                if (this.getRecipeInput2() == null) {
                    this.getInput2Tank().filter = this.thin_air();
                }
            }
            if (this.hasInput3Tank()) {
                if (this.getInput3Tank().getFilter() != this.getRecipeInput3()) {
                    this.getInput3Tank().filter = this.getRecipeInput3();
                }
                if (this.getRecipeInput3() == null) {
                    this.getInput3Tank().filter = this.thin_air();
                }
            }
            if (this.hasInput4Tank()) {
                if (this.getInput4Tank().getFilter() != this.getRecipeInput4()) {
                    this.getInput4Tank().filter = this.getRecipeInput4();
                }
                if (this.getRecipeInput4() == null) {
                    this.getInput4Tank().filter = this.thin_air();
                }
            }
        } else {
            if (this.hasInput1Tank() && this.getInput1Tank().getFilter() != null) {
                this.getInput1Tank().filter = null;
            }
            if (this.hasInput2Tank() && this.getInput2Tank().getFilter() != null) {
                this.getInput2Tank().filter = null;
            }
            if (this.hasInput3Tank() && this.getInput3Tank().getFilter() != null) {
                this.getInput3Tank().filter = null;
            }
            if (this.hasInput4Tank() && this.getInput4Tank().getFilter() != null) {
                this.getInput4Tank().filter = null;
            }
        }
    }

    public FluidStack thin_air() {
        return new FluidStack(ModFluids.THIN_AIR, 1000);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.doPreset();
            this.handlePurge();
            this.initializeServer(this.isRepeatable, this.hasServer(), this.getServer(), TETubularBedController.deviceCode());
            if (this.getDummyRecipe() == null) {
                this.dummyRecipe = this.getCurrentRecipe();
                this.cooktime = 0;
            }
            if (this.canProcess()) {
                ++this.cooktime;
                this.drainPower();
                if (this.getCooktime() >= this.getCooktimeMax()) {
                    this.cooktime = 0;
                    this.process();
                }
                this.markDirtyClient();
            } else {
                this.tickOff();
            }
        }
    }

    private boolean canProcess() {
        return this.isActive() && this.isAssembled() && this.isValidRecipe() && this.hasFuelPower() && this.hasRedstonePower() && this.handleServer(this.hasServer(), this.getServer(), this.currentFile);
    }

    private void process() {
        if (this.isValidRecipe()) {
            if (this.hasOutTank()) {
                this.input.setOrFillFluid(this.getOutTank().inputTank, this.getRecipeOutput(), this.calculatedAmount(this.getRecipeOutput().amount));
            }
            if (this.hasTubularCatalysts()) {
                int cats = 0;
                while (true) {
                    this.getTubularCatalysts();
                    if (cats >= TETubularBedLow.SLOT_INPUTS.length) break;
                    if (this.getTubularCatalysts().catalystSlot(cats).func_185136_b(this.getRecipeCatalyst())) {
                        int unbreakingLevel = CoreUtils.getEnchantmentLevel((Enchantment)Enchantments.field_185307_s, (ItemStack)this.getTubularCatalysts().catalystSlot(cats));
                        ((MachineStackHandler)this.getTubularCatalysts().getInput()).damageUnbreakingSlot(unbreakingLevel, cats);
                    }
                    ++cats;
                }
            }
            if (this.hasInput1Tank() && this.getRecipeInput1() != null) {
                this.input.drainOrCleanFluid(this.getInput1Tank().inputTank, this.calculatedAmount(this.getRecipeInput1().amount), true);
            }
            if (this.hasInput2Tank() && this.getRecipeInput2() != null) {
                this.input.drainOrCleanFluid(this.getInput2Tank().inputTank, this.calculatedAmount(this.getRecipeInput2().amount), true);
            }
            if (this.hasInput3Tank() && this.getRecipeInput3() != null) {
                this.input.drainOrCleanFluid(this.getInput3Tank().inputTank, this.calculatedAmount(this.getRecipeInput3().amount), true);
            }
            if (this.hasInput4Tank() && this.getRecipeInput4() != null) {
                this.input.drainOrCleanFluid(this.getInput4Tank().inputTank, this.calculatedAmount(this.getRecipeInput4().amount), true);
            }
            this.updateServer(this.hasServer(), this.getServer(), this.currentFile);
        }
        this.dummyRecipe = null;
    }

    private boolean isAssembled() {
        return this.hasTubularBase() && this.hasTubularTop() && this.hasRouter() && this.hasEngine();
    }

    private void handlePurge() {
        if (!(!this.isActive() || this.isValidPreset() && this.isValidRecipe())) {
            if (this.hasPurgeTank()) {
                int canSend;
                int canReceive;
                if (this.hasInput1Tank() && this.isWrongInput1() && this.canPurge1()) {
                    canReceive = this.getPurgeTank().inputTank.getCapacity() - this.getPurgeTank().inputTank.getFluidAmount();
                    canSend = Math.min(this.getInput1Tank().inputTank.getFluidAmount(), canReceive);
                    this.input.setOrFillFluid(this.getPurgeTank().inputTank, this.tankInput1(), canSend);
                    this.input.drainOrCleanFluid(this.getInput1Tank().inputTank, canSend, true);
                }
                if (this.hasInput2Tank() && this.isWrongInput2() && this.canPurge2()) {
                    canReceive = this.getPurgeTank().inputTank.getCapacity() - this.getPurgeTank().inputTank.getFluidAmount();
                    canSend = Math.min(this.getInput2Tank().inputTank.getFluidAmount(), canReceive);
                    this.input.setOrFillFluid(this.getPurgeTank().inputTank, this.tankInput2(), canSend);
                    this.input.drainOrCleanFluid(this.getInput2Tank().inputTank, canSend, true);
                }
                if (this.hasInput3Tank() && this.isWrongInput3() && this.canPurge3()) {
                    canReceive = this.getPurgeTank().inputTank.getCapacity() - this.getPurgeTank().inputTank.getFluidAmount();
                    canSend = Math.min(this.getInput3Tank().inputTank.getFluidAmount(), canReceive);
                    this.input.setOrFillFluid(this.getPurgeTank().inputTank, this.tankInput3(), canSend);
                    this.input.drainOrCleanFluid(this.getInput3Tank().inputTank, canSend, true);
                }
                if (this.hasInput4Tank() && this.isWrongInput4() && this.canPurge4()) {
                    canReceive = this.getPurgeTank().inputTank.getCapacity() - this.getPurgeTank().inputTank.getFluidAmount();
                    canSend = Math.min(this.getInput4Tank().inputTank.getFluidAmount(), canReceive);
                    this.input.setOrFillFluid(this.getPurgeTank().inputTank, this.tankInput4(), canSend);
                    this.input.drainOrCleanFluid(this.getInput4Tank().inputTank, canSend, true);
                }
            }
            if (this.hasTubularCatalysts()) {
                this.getTubularCatalysts();
                if (this.countCat < TETubularBedLow.SLOT_INPUTS.length) {
                    if (!this.getTubularCatalysts().catalystSlot(this.countCat).func_190926_b() && (this.getRecipeCatalyst().func_190926_b() || !this.getTubularCatalysts().catalystSlot(this.countCat).func_185136_b(this.getRecipeCatalyst())) && ((MachineStackHandler)this.getTubularCatalysts().getOutput()).canSetOrStack(this.getTubularCatalysts().purgeSlot(), this.getTubularCatalysts().catalystSlot(this.countCat))) {
                        MachineStackHandler machineStackHandler = (MachineStackHandler)this.getTubularCatalysts().getOutput();
                        this.getTubularCatalysts();
                        machineStackHandler.setOrStack(0, this.getTubularCatalysts().catalystSlot(this.countCat));
                        ((ItemStackHandler)this.getTubularCatalysts().getInput()).setStackInSlot(this.countCat, ItemStack.field_190927_a);
                        ++this.countCat;
                    }
                } else {
                    this.countCat = 0;
                }
            }
        }
    }

    private boolean isWrongInput1() {
        return this.tankInput1() != null && (this.getRecipeInput1() == null || this.getRecipeInput1() != null && !this.getRecipeInput1().isFluidEqual(this.tankInput1()));
    }

    private boolean isWrongInput2() {
        return this.tankInput2() != null && (this.getRecipeInput2() == null || this.getRecipeInput2() != null && !this.getRecipeInput2().isFluidEqual(this.tankInput2()));
    }

    private boolean isWrongInput3() {
        return this.tankInput3() != null && (this.getRecipeInput3() == null || this.getRecipeInput3() != null && !this.getRecipeInput3().isFluidEqual(this.tankInput3()));
    }

    private boolean isWrongInput4() {
        return this.tankInput4() != null && (this.getRecipeInput4() == null || this.getRecipeInput4() != null && !this.getRecipeInput4().isFluidEqual(this.tankInput4()));
    }

    private boolean canPurge1() {
        return this.tankInput1() != null && this.input.canSetOrFillFluid(this.getPurgeTank().inputTank, this.purgeGas(), this.tankInput1());
    }

    private boolean canPurge2() {
        return this.tankInput2() != null && this.input.canSetOrFillFluid(this.getPurgeTank().inputTank, this.purgeGas(), this.tankInput2());
    }

    private boolean canPurge3() {
        return this.tankInput3() != null && this.input.canSetOrFillFluid(this.getPurgeTank().inputTank, this.purgeGas(), this.tankInput3());
    }

    private boolean canPurge4() {
        return this.tankInput4() != null && this.input.canSetOrFillFluid(this.getPurgeTank().inputTank, this.purgeGas(), this.tankInput4());
    }

    @Override
    public void loadServerStatus() {
        this.currentFile = -1;
        if (this.getServer().isActive()) {
            for (int x = 0; x < TEServer.FILE_SLOTS.length; ++x) {
                NBTTagCompound tag;
                ItemStack fileSlot = this.getServer().inputSlot(x).func_77946_l();
                if (!fileSlot.func_190926_b() && fileSlot.func_77969_a(new ItemStack(ModItems.MISC_ITEMS, 1, EnumMiscItems.SERVER_FILE.ordinal())) && fileSlot.func_77942_o() && this.isValidFile(tag = fileSlot.func_77978_p()) && tag.func_74762_e("Device") == TETubularBedController.deviceCode() && tag.func_74762_e("Recipe") < this.recipeList().size() && tag.func_74762_e("Done") > 0) {
                    if (this.recipeIndex != tag.func_74762_e("Recipe")) {
                        this.recipeIndex = tag.func_74762_e("Recipe");
                        this.markDirtyClient();
                    }
                    if (this.currentFile == x) break;
                    this.currentFile = x;
                    this.markDirtyClient();
                    break;
                }
                if (x != TEServer.FILE_SLOTS.length - 1) continue;
                this.resetFiles(this.getServer(), TETubularBedController.deviceCode());
            }
        }
    }
}

