/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.tile;

import com.globbypotato.rockhounding_chemistry.enums.EnumMiscBlocksA;
import com.globbypotato.rockhounding_chemistry.handlers.ModConfig;
import com.globbypotato.rockhounding_chemistry.machines.io.MachineIO;
import com.globbypotato.rockhounding_chemistry.machines.recipe.StirredTankRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.StirredTankRecipe;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEFluidInputTank;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEPowerGenerator;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEStirredTankOut;
import com.globbypotato.rockhounding_chemistry.machines.tile.TileStructure;
import com.globbypotato.rockhounding_chemistry.machines.tile.TileVessel;
import com.globbypotato.rockhounding_chemistry.utils.ModUtils;
import com.globbypotato.rockhounding_core.machines.tileentity.MachineStackHandler;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import com.globbypotato.rockhounding_core.machines.tileentity.WrappedItemHandler;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TEStirredTankTop
extends TileEntityInv {
    public static final int SPEED_SLOT = 0;
    public static int templateSlots = 1;
    public static int upgradeSlots = 1;

    public TEStirredTankTop() {
        super(0, 0, templateSlots, upgradeSlots);
        this.upgrade = new MachineStackHandler(upgradeSlots, this){

            public ItemStack insertItem(int slot, ItemStack insertingStack, boolean simulate) {
                if (slot == 0 && ModUtils.isValidSpeedUpgrade(insertingStack)) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                return insertingStack;
            }
        };
        this.automationUpgrade = new WrappedItemHandler((IItemHandlerModifiable)this.upgrade, WrappedItemHandler.WriteMode.IN);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        return compound;
    }

    public ItemStack speedSlot() {
        return this.upgrade.getStackInSlot(0);
    }

    public int getGUIHeight() {
        return 200;
    }

    public static String getName() {
        return "stirred_tank_top";
    }

    public int speedFactor() {
        return ModUtils.isValidSpeedUpgrade(this.speedSlot()) ? ModUtils.speedUpgrade(this.speedSlot()) : 1;
    }

    public BlockPos poweredPosition() {
        return this.chamberPos().func_177972_a(this.poweredFacing());
    }

    public EnumFacing poweredFacing() {
        return this.getFacing();
    }

    public ArrayList<StirredTankRecipe> recipeList() {
        return StirredTankRecipes.stirred_tank_recipes;
    }

    public StirredTankRecipe getRecipeList(int x) {
        return this.recipeList().get(x);
    }

    public StirredTankRecipe getCurrentRecipe() {
        if (this.hasIntank()) {
            for (int x = 0; x < this.recipeList().size(); ++x) {
                if (this.getIntank().getSolventFluid() == null || this.getIntank().getReagentFluid() == null || this.getRecipeList(x).getSolvent() == null || this.getRecipeList(x).getReagent() == null || !this.getIntank().getSolventFluid().isFluidEqual(this.getRecipeList(x).getSolvent()) || !this.getIntank().getReagentFluid().isFluidEqual(this.getRecipeList(x).getReagent())) continue;
                return this.getRecipeList(x);
            }
        }
        return null;
    }

    public boolean isValidRecipe() {
        return this.getCurrentRecipe() != null;
    }

    public FluidStack recipeSolvent() {
        return this.isValidRecipe() ? this.getCurrentRecipe().getSolvent() : null;
    }

    public FluidStack recipeReagent() {
        return this.isValidRecipe() ? this.getCurrentRecipe().getReagent() : null;
    }

    public FluidStack recipeSolution() {
        return this.isValidRecipe() ? this.getCurrentRecipe().getSolution() : null;
    }

    public FluidStack recipeFume() {
        return this.isValidRecipe() ? this.getCurrentRecipe().getFume() : null;
    }

    private boolean hasFume() {
        return this.recipeFume() != null;
    }

    public boolean hasVoltage() {
        return this.isValidRecipe() ? this.getCurrentRecipe().getVoltage() > 0 : false;
    }

    public int voltageLevel() {
        return this.isValidRecipe() ? this.getCurrentRecipe().getVoltage() : 0;
    }

    public BlockPos chamberPos() {
        return this.field_174879_c.func_177967_a(EnumFacing.DOWN, 1);
    }

    public TEPowerGenerator getEngine() {
        TEPowerGenerator engine = TileStructure.getEngine(this.field_145850_b, this.field_174879_c, this.getFacing(), 1, 0);
        return engine != null ? engine : null;
    }

    public boolean hasEngine() {
        return this.getEngine() != null;
    }

    public boolean hasFuelPower() {
        return this.hasEngine() ? this.getEngine().getPower() > 0 && this.getEngine().getRedstone() >= this.powerConsume() : false;
    }

    public boolean hasRedstonePower() {
        if (this.hasEngine()) {
            if (this.hasVoltage()) {
                return this.getEngine().getRedstone() >= this.powerConsume();
            }
            return true;
        }
        return false;
    }

    public TEFluidInputTank getIntank() {
        TEFluidInputTank tank;
        BlockPos intankPos = this.field_174879_c.func_177967_a(this.isFacingAt(270), 1);
        TileEntity te = this.field_145850_b.func_175625_s(intankPos);
        if (this.field_145850_b.func_180495_p(intankPos) != null && te instanceof TEFluidInputTank && (tank = (TEFluidInputTank)te).getFacing() == this.isFacingAt(270).func_176734_d()) {
            return tank;
        }
        return null;
    }

    public boolean hasIntank() {
        return this.getIntank() != null;
    }

    public TileVessel getFumeTank() {
        TileVessel vessel = TileStructure.getHolder(this.field_145850_b, this.field_174879_c, this.isFacingAt(90), 1, 0);
        return vessel != null ? vessel : null;
    }

    public boolean hasFumeTank() {
        return this.getFumeTank() != null;
    }

    public TEStirredTankOut getOuttank() {
        BlockPos tankPos = this.field_174879_c.func_177967_a(EnumFacing.DOWN, 2);
        TileEntity te = this.field_145850_b.func_175625_s(tankPos);
        if (this.field_145850_b.func_180495_p(tankPos) != null && te instanceof TEStirredTankOut) {
            TEStirredTankOut tank = (TEStirredTankOut)te;
            return tank;
        }
        return null;
    }

    public boolean hasOuttank() {
        return this.getOuttank() != null;
    }

    public Block getCharger() {
        BlockPos chargerPos = this.field_174879_c.func_177972_a(EnumFacing.UP);
        IBlockState chargerState = this.field_145850_b.func_180495_p(chargerPos);
        Block charger = chargerState.func_177230_c();
        if (MachineIO.miscBlocksA(charger, chargerState, EnumMiscBlocksA.EXTRACTOR_CHARGER.ordinal())) {
            return charger;
        }
        return null;
    }

    public boolean hasCharger() {
        return this.getCharger() != null;
    }

    private void drainPower() {
        --this.getEngine().powerCount;
        if (this.hasVoltage()) {
            this.getEngine().redstoneCount -= this.powerConsume();
        }
        this.getEngine().markDirtyClient();
    }

    public int powerConsume() {
        int baseConsume = 10 * this.voltageLevel() * ModConfig.basePower;
        return ModConfig.speedMultiplier ? baseConsume * this.speedFactor() : baseConsume;
    }

    public int getCooktimeMax() {
        return ModUtils.isValidSpeedUpgrade(this.speedSlot()) ? ModConfig.speedCstr / ModUtils.speedUpgrade(this.speedSlot()) : ModConfig.speedCstr;
    }

    public int getCalculatedSolvent() {
        return this.isValidRecipe() ? this.getCurrentRecipe().getSolvent().amount * this.speedFactor() : 0;
    }

    public int getCalculatedReagent() {
        return this.isValidRecipe() ? this.getCurrentRecipe().getReagent().amount * this.speedFactor() : 0;
    }

    public int getCalculatedSolution() {
        return this.isValidRecipe() ? this.getCurrentRecipe().getSolution().amount * this.speedFactor() : 0;
    }

    public int getCalculatedFume() {
        return this.isValidRecipe() ? this.getCurrentRecipe().getFume().amount * this.speedFactor() : 0;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.doPreset();
            if (this.isActive() && this.canProcess()) {
                this.drainPower();
                ++this.cooktime;
                if (this.getCooktime() >= this.getCooktimeMax()) {
                    this.cooktime = 0;
                    this.process();
                }
                this.markDirtyClient();
            }
        }
    }

    private void doPreset() {
        if (this.hasEngine()) {
            if (!this.getEngine().enablePower) {
                this.getEngine().enablePower = true;
                this.getEngine().markDirtyClient();
            }
            if (!this.getEngine().enableRedstone) {
                this.getEngine().enableRedstone = true;
                this.getEngine().markDirtyClient();
            }
        }
    }

    private boolean canProcess() {
        return this.isValidRecipe() && this.hasFuelPower() && this.hasRedstonePower() && this.canExtract() && this.hasCharger() && this.hasOuttank() && this.canOutput() && (this.hasFume() && this.hasFumeTank() && this.output.canSetOrAddFluid(this.getFumeTank().inputTank, this.getFumeTank().getTankFluid(), this.recipeFume(), this.getCalculatedFume()) || !this.hasFume());
    }

    private boolean canOutput() {
        return this.output.canSetOrAddFluid(this.getOuttank().inputTank, this.getOuttank().getTankFluid(), this.getCurrentRecipe().getSolution(), this.getCalculatedSolution());
    }

    private boolean canExtract() {
        return this.input.canDrainFluid(this.getIntank().getSolventFluid(), this.getCurrentRecipe().getSolvent(), this.getCalculatedSolvent()) && this.input.canDrainFluid(this.getIntank().getReagentFluid(), this.getCurrentRecipe().getReagent(), this.getCalculatedReagent());
    }

    private void process() {
        this.output.setOrFillFluid(this.getOuttank().inputTank, this.getCurrentRecipe().getSolution(), this.getCalculatedSolution());
        this.input.drainOrCleanFluid(this.getIntank().solventTank, this.getCalculatedSolvent(), true);
        this.input.drainOrCleanFluid(this.getIntank().reagentTank, this.getCalculatedReagent(), true);
        if (this.hasFume() && this.hasFumeTank() && this.output.canSetOrFillFluid(this.getFumeTank().inputTank, this.getFumeTank().getTankFluid(), this.recipeFume())) {
            this.output.setOrFillFluid(this.getFumeTank().inputTank, this.recipeFume(), this.getCalculatedFume());
        }
    }
}

