/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.tile;

import com.globbypotato.rockhounding_chemistry.handlers.ModConfig;
import com.globbypotato.rockhounding_chemistry.machines.recipe.SlurryPondRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.SlurryPondRecipe;
import com.globbypotato.rockhounding_chemistry.machines.tile.IToxic;
import com.globbypotato.rockhounding_core.machines.tileentity.MachineStackHandler;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityTank;
import com.globbypotato.rockhounding_core.machines.tileentity.WrappedItemHandler;
import com.globbypotato.rockhounding_core.utils.CoreUtils;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerConcatenate;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.oredict.OreDictionary;

public class TESlurryPond
extends TileEntityTank
implements IToxic {
    public FluidTank inputTank = new FluidTank(this.getTankCapacity()){

        public boolean canFillFluidType(FluidStack fluid) {
            return TESlurryPond.this.canFillFiltered(fluid);
        }

        public boolean canDrain() {
            return false;
        }
    };
    public FluidTank outputTank;
    public static final int FILL_BUCKET = 1;
    public static final int DRAIN_BUCKET = 2;
    public static int inputSlots = 3;
    public static int templateSlots = 5;
    public int concentration = 1;
    public FluidStack filter = null;

    public TESlurryPond() {
        super(inputSlots, 0, templateSlots, 0);
        this.inputTank.setTileEntity((TileEntity)this);
        this.outputTank = new FluidTank(this.getTankCapacity()){

            public boolean canFillFluidType(FluidStack fluid) {
                return false;
            }

            public boolean canDrain() {
                return true;
            }
        };
        this.outputTank.setTileEntity((TileEntity)this);
        this.input = new MachineStackHandler(inputSlots, (TileEntityInv)this){

            public ItemStack insertItem(int slot, ItemStack insertingStack, boolean simulate) {
                if (slot == 0 && TESlurryPond.isValidInput(insertingStack)) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                if (slot == 1 && TESlurryPond.isValidBath(FluidUtil.getFluidContained((ItemStack)insertingStack))) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                if (slot == 2 && CoreUtils.isEmptyBucket((ItemStack)insertingStack)) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                return insertingStack;
            }
        };
        this.automationInput = new WrappedItemHandler((IItemHandlerModifiable)this.input, WrappedItemHandler.WriteMode.IN);
        this.markDirtyClient();
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.concentration = compound.func_74762_e("Concentration");
        this.inputTank.readFromNBT(compound.func_74775_l("InputTank"));
        this.outputTank.readFromNBT(compound.func_74775_l("OutputTank"));
        this.filter = FluidStack.loadFluidStackFromNBT((NBTTagCompound)compound.func_74775_l("Filter"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("Concentration", this.getConcentration());
        NBTTagCompound inputTankNBT = new NBTTagCompound();
        this.inputTank.writeToNBT(inputTankNBT);
        compound.func_74782_a("InputTank", (NBTBase)inputTankNBT);
        NBTTagCompound outputTankNBT = new NBTTagCompound();
        this.outputTank.writeToNBT(outputTankNBT);
        compound.func_74782_a("OutputTank", (NBTBase)outputTankNBT);
        if (this.getFilter() != null) {
            NBTTagCompound filterNBT = new NBTTagCompound();
            this.filter.writeToNBT(filterNBT);
            compound.func_74782_a("Filter", (NBTBase)filterNBT);
        }
        return compound;
    }

    public FluidHandlerConcatenate getCombinedTank() {
        return new FluidHandlerConcatenate(new IFluidHandler[]{this.inputTank, this.outputTank});
    }

    public ItemStack inputSlot() {
        return this.input.getStackInSlot(0);
    }

    public ItemStack fillSlot() {
        return this.input.getStackInSlot(1);
    }

    public ItemStack drainSlot() {
        return this.input.getStackInSlot(2);
    }

    public int getGUIHeight() {
        return 200;
    }

    public static String getName() {
        return "slurry_pond";
    }

    public int getCooktimeMax() {
        return ModConfig.speedPond + 15 * this.getConcentration();
    }

    @Override
    public ArrayList<FluidTank> hazardList() {
        ArrayList<FluidTank> tanks = new ArrayList<FluidTank>();
        tanks.add(this.inputTank);
        tanks.add(this.outputTank);
        return tanks;
    }

    public int getConcentration() {
        return this.concentration;
    }

    public int actualConcentration() {
        return (11 - this.getConcentration()) * 10;
    }

    public FluidStack getFilter() {
        return this.filter;
    }

    public boolean hasFilter() {
        return this.getFilter() != null;
    }

    public boolean canFillFiltered(FluidStack fluid) {
        return this.hasFilter() ? this.getFilter().isFluidEqual(fluid) : TESlurryPond.isValidBath(fluid);
    }

    public int getTankCapacity() {
        return 10000;
    }

    public boolean hasInputFluid() {
        return this.inputTank.getFluid() != null;
    }

    public FluidStack getInputFluid() {
        return this.inputTank.getFluid();
    }

    public int getInputAmount() {
        return this.inputTank.getFluidAmount();
    }

    public boolean hasOutputFluid() {
        return this.outputTank.getFluid() != null;
    }

    public FluidStack getOutputFluid() {
        return this.outputTank.getFluid();
    }

    public int getOutputAmount() {
        return this.outputTank.getFluidAmount();
    }

    public static ArrayList<SlurryPondRecipe> recipeList() {
        return SlurryPondRecipes.slurry_pond_recipes;
    }

    public static SlurryPondRecipe getRecipeList(int x) {
        return TESlurryPond.recipeList().get(x);
    }

    public static boolean isValidInput(ItemStack stack) {
        if (!stack.func_190926_b()) {
            for (SlurryPondRecipe recipe : TESlurryPond.recipeList()) {
                ArrayList inputOreIDs;
                if (!(recipe.getType() ? !(inputOreIDs = CoreUtils.intArrayToList((int[])OreDictionary.getOreIDs((ItemStack)stack))).isEmpty() && inputOreIDs.contains(OreDictionary.getOreID((String)recipe.getOredict())) : recipe.getInput().func_77969_a(stack))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isValidBath(FluidStack fluid) {
        return TESlurryPond.recipeList().stream().anyMatch(recipe -> fluid != null && recipe.getBath() != null && fluid.isFluidEqual(recipe.getBath()));
    }

    public SlurryPondRecipe getCurrentRecipe() {
        if (!this.inputSlot().func_190926_b()) {
            for (int x = 0; x < TESlurryPond.recipeList().size(); ++x) {
                ArrayList inputOreIDs = CoreUtils.intArrayToList((int[])OreDictionary.getOreIDs((ItemStack)this.inputSlot()));
                if (!(TESlurryPond.getRecipeList(x).getType() ? inputOreIDs.contains(OreDictionary.getOreID((String)TESlurryPond.getRecipeList(x).getOredict())) : TESlurryPond.getRecipeList(x).getInput().func_77969_a(this.inputSlot()))) continue;
                return TESlurryPond.getRecipeList(x);
            }
        }
        return null;
    }

    public boolean isValidRecipe() {
        return this.getCurrentRecipe() != null;
    }

    public ItemStack input() {
        return this.getCurrentRecipe().getInput();
    }

    public int calculateInputAmount() {
        if (this.getConcentration() == 2 || this.getConcentration() == 3) {
            return 2;
        }
        if (this.getConcentration() >= 4 && this.getConcentration() <= 6) {
            return 3;
        }
        if (this.getConcentration() >= 7 && this.getConcentration() <= 10) {
            return 4;
        }
        return 1;
    }

    public ItemStack calculateInput() {
        return new ItemStack(this.input().func_77973_b(), this.calculateInputAmount(), this.input().func_77952_i());
    }

    public FluidStack solvent() {
        return this.isValidRecipe() ? this.getCurrentRecipe().getBath() : null;
    }

    public FluidStack slurry() {
        return this.isValidRecipe() ? this.getCurrentRecipe().getOutput() : null;
    }

    public int calculateSolventAmount() {
        return this.solvent() != null ? this.solvent().amount * (this.getConcentration() * 10) / 100 : 0;
    }

    public int calculateSlurryAmount() {
        return this.slurry() != null ? this.slurry().amount * (this.getConcentration() * 10) / 100 : 0;
    }

    public FluidStack calculateSolvent() {
        return this.solvent() != null ? new FluidStack(this.solvent(), this.calculateSolventAmount()) : null;
    }

    public FluidStack calculateSlurry() {
        return this.slurry() != null ? new FluidStack(this.slurry(), this.calculateSlurryAmount()) : null;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.emptyContainer(1, this.inputTank);
            this.fillContainer(2, this.outputTank);
            this.handleToxic(this.field_145850_b, this.field_174879_c);
            if (this.getConcentration() < 1) {
                this.concentration = 1;
            }
            if (!this.inputSlot().func_190926_b() && this.canProcess()) {
                ++this.cooktime;
                if (this.getCooktime() >= this.getCooktimeMax()) {
                    this.cooktime = 0;
                    this.process();
                }
            }
            this.markDirtyClient();
        }
    }

    private boolean canProcess() {
        return this.isValidRecipe() && this.inputSlot().func_190916_E() >= this.calculateInputAmount() && this.input.canDrainFluid(this.getInputFluid(), this.calculateSolvent()) && this.output.canSetOrFillFluid(this.outputTank, this.getOutputFluid(), this.calculateSlurry());
    }

    private void process() {
        this.output.setOrFillFluid(this.outputTank, this.calculateSlurry());
        this.input.drainOrCleanFluid(this.inputTank, this.calculateSolventAmount(), true);
        this.input.decrementSlotBy(0, this.calculateInputAmount());
    }
}

