/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.tile;

import com.globbypotato.rockhounding_chemistry.machines.recipe.SlurryDrumRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.SlurryDrumRecipe;
import com.globbypotato.rockhounding_chemistry.machines.tile.TileTank;
import com.globbypotato.rockhounding_chemistry.utils.ModUtils;
import com.globbypotato.rockhounding_core.machines.tileentity.MachineStackHandler;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import com.globbypotato.rockhounding_core.machines.tileentity.WrappedItemHandler;
import com.globbypotato.rockhounding_core.utils.CoreUtils;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.oredict.OreDictionary;

public class TESlurryDrum
extends TileTank {
    public TESlurryDrum() {
        this.input = new MachineStackHandler(inputSlots, (TileEntityInv)this){

            public ItemStack insertItem(int slot, ItemStack insertingStack, boolean simulate) {
                if (slot == TileTank.FILL_BUCKET && (TESlurryDrum.this.canFillFiltered(FluidUtil.getFluidContained((ItemStack)insertingStack)) || TESlurryDrum.isValidInput(insertingStack))) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                if (slot == TileTank.DRAIN_BUCKET && CoreUtils.isEmptyBucket((ItemStack)insertingStack)) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                return insertingStack;
            }
        };
        this.automationInput = new WrappedItemHandler((IItemHandlerModifiable)this.input, WrappedItemHandler.WriteMode.IN);
    }

    public static String getName() {
        return "slurry_drum";
    }

    public static ArrayList<SlurryDrumRecipe> recipeList() {
        return SlurryDrumRecipes.slurry_drum_recipes;
    }

    public static SlurryDrumRecipe getRecipeList(int x) {
        return TESlurryDrum.recipeList().get(x);
    }

    public static boolean isValidInput(ItemStack stack) {
        if (!stack.func_190926_b()) {
            for (SlurryDrumRecipe recipe : TESlurryDrum.recipeList()) {
                ArrayList inputOreIDs;
                if (!(recipe.getType() ? !(inputOreIDs = CoreUtils.intArrayToList((int[])OreDictionary.getOreIDs((ItemStack)stack))).isEmpty() && inputOreIDs.contains(OreDictionary.getOreID((String)recipe.getOredict())) : recipe.getInput().func_77969_a(stack))) continue;
                return true;
            }
        }
        return false;
    }

    public SlurryDrumRecipe getCurrentRecipe() {
        if (!this.fillSlot().func_190926_b()) {
            for (int x = 0; x < TESlurryDrum.recipeList().size(); ++x) {
                ArrayList inputOreIDs = CoreUtils.intArrayToList((int[])OreDictionary.getOreIDs((ItemStack)this.fillSlot()));
                if (!(TESlurryDrum.getRecipeList(x).getType() ? inputOreIDs.contains(OreDictionary.getOreID((String)TESlurryDrum.getRecipeList(x).getOredict())) : TESlurryDrum.getRecipeList(x).getInput().func_77969_a(this.fillSlot()))) continue;
                return TESlurryDrum.getRecipeList(x);
            }
        }
        return null;
    }

    public boolean isValidRecipe() {
        return this.getCurrentRecipe() != null;
    }

    public ItemStack recipeInput() {
        return this.isValidRecipe() ? this.getCurrentRecipe().getInput() : ItemStack.field_190927_a;
    }

    public FluidStack slurry() {
        return this.isValidRecipe() ? this.getCurrentRecipe().getOutput() : null;
    }

    @Override
    public boolean isValidSubstance(FluidStack fluid) {
        return ModUtils.isHeavyFluid(fluid.getFluid());
    }

    @Override
    public int getTankCapacity() {
        return 40000;
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.emptyContainer(FILL_BUCKET, this.inputTank);
            this.fillContainer(DRAIN_BUCKET, this.inputTank);
            if (!this.fillSlot().func_190926_b() && this.canSpill()) {
                this.spill();
            }
            this.markDirtyClient();
        }
    }

    private boolean canSpill() {
        return this.isValidRecipe() && ItemStack.func_179545_c((ItemStack)this.fillSlot(), (ItemStack)this.recipeInput()) && this.input.canSetOrFillFluid(this.inputTank, this.getTankFluid(), this.slurry());
    }

    private void spill() {
        this.output.setOrFillFluid(this.inputTank, this.slurry());
        this.input.decrementSlot(FILL_BUCKET);
    }
}

