/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.tile;

import com.globbypotato.rockhounding_chemistry.ModItems;
import com.globbypotato.rockhounding_chemistry.enums.EnumMiscItems;
import com.globbypotato.rockhounding_chemistry.enums.materials.EnumFluid;
import com.globbypotato.rockhounding_chemistry.enums.utils.EnumServer;
import com.globbypotato.rockhounding_chemistry.handlers.ModConfig;
import com.globbypotato.rockhounding_chemistry.machines.recipe.RetentionVatRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.RetentionVatRecipe;
import com.globbypotato.rockhounding_chemistry.machines.tile.IInternalServer;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEBufferTank;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEFlotationTank;
import com.globbypotato.rockhounding_chemistry.machines.tile.TELeachingVatCollector;
import com.globbypotato.rockhounding_chemistry.machines.tile.TELeachingVatTank;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEPowerGenerator;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEServer;
import com.globbypotato.rockhounding_chemistry.machines.tile.TileStructure;
import com.globbypotato.rockhounding_chemistry.machines.tile.TileVessel;
import com.globbypotato.rockhounding_chemistry.utils.BaseRecipes;
import com.globbypotato.rockhounding_chemistry.utils.ModUtils;
import com.globbypotato.rockhounding_core.machines.tileentity.MachineStackHandler;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import com.globbypotato.rockhounding_core.machines.tileentity.WrappedItemHandler;
import com.globbypotato.rockhounding_core.utils.CoreBasics;
import com.globbypotato.rockhounding_core.utils.CoreUtils;
import java.util.ArrayList;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class TERetentionVat
extends TileEntityInv
implements IInternalServer {
    public static final int SPEED_SLOT = 0;
    public static final int FILTER_SLOT = 1;
    public static int templateSlots = 3;
    public static int upgradeSlots = 2;
    public ArrayList<ItemStack> resultList;
    public int currentFile = -1;
    public boolean isRepeatable = false;
    public float gravity = 8.0f;
    public boolean isBugged = false;
    public RetentionVatRecipe dummyRecipe;

    public TERetentionVat() {
        super(0, 0, templateSlots, upgradeSlots);
        this.upgrade = new MachineStackHandler(upgradeSlots, this){

            public ItemStack insertItem(int slot, ItemStack insertingStack, boolean simulate) {
                if (slot == 0 && ModUtils.isValidSpeedUpgrade(insertingStack)) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                if (slot == 1 && ModUtils.isValidFilterUpgrade(insertingStack)) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                return insertingStack;
            }
        };
        this.automationUpgrade = new WrappedItemHandler((IItemHandlerModifiable)this.upgrade, WrappedItemHandler.WriteMode.IN);
    }

    public ItemStack speedSlot() {
        return this.upgrade.getStackInSlot(0);
    }

    public ItemStack filterSlot() {
        return this.upgrade.getStackInSlot(1);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.gravity = compound.func_74760_g("Gravity");
        this.isBugged = compound.func_74767_n("Bugged");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74776_a("Gravity", this.getGravity());
        compound.func_74757_a("Bugged", this.isBugged());
        return compound;
    }

    public int getGUIHeight() {
        return 200;
    }

    public static String getName() {
        return "retention_vat";
    }

    public int speedFactor() {
        return ModUtils.isValidSpeedUpgrade(this.speedSlot()) ? ModUtils.speedUpgrade(this.speedSlot()) : 1;
    }

    public int getCooktimeMax() {
        return ModUtils.isValidSpeedUpgrade(this.speedSlot()) ? ModConfig.speedLeaching / ModUtils.speedUpgrade(this.speedSlot()) : ModConfig.speedLeaching;
    }

    private static int sizedQuantity() {
        return ModConfig.maxLeachable > 0 ? ModConfig.maxLeachable : 1;
    }

    public int filterFactor() {
        return ModUtils.isValidFilterUpgrade(this.filterSlot()) ? ModUtils.filterUpgrade(this.filterSlot()) : 0;
    }

    public float filterRange() {
        return 2.6f - 0.5f * (float)this.filterFactor();
    }

    public float filterMove() {
        return ModUtils.isValidFilterUpgrade(this.filterSlot()) ? ModUtils.stepDivision(this.filterSlot().func_77952_i()) : 1.0f;
    }

    private static int deviceCode() {
        return EnumServer.RETENTION.ordinal();
    }

    public EnumFacing poweredFacing() {
        return this.getFacing().func_176734_d();
    }

    public ArrayList<RetentionVatRecipe> recipeList() {
        return RetentionVatRecipes.retention_vat_recipes;
    }

    public RetentionVatRecipe getRecipeList(int x) {
        return this.recipeList().get(x);
    }

    public RetentionVatRecipe getCurrentRecipe() {
        for (int x = 0; x < this.recipeList().size(); ++x) {
            if (this.getRecipeList(x).getInput() == null || !this.isMatchingFluid(x)) continue;
            return this.getRecipeList(x);
        }
        return null;
    }

    public RetentionVatRecipe getDummyRecipe() {
        return this.dummyRecipe;
    }

    private boolean isMatchingFluid(int x) {
        return this.hasTankPulp() && this.getTankPulp().getSolventFluid() != null && this.getRecipeList(x).getInput().isFluidEqual(this.getTankPulp().inputTank.getFluid());
    }

    public boolean isValidRecipe() {
        return this.getCurrentRecipe() != null;
    }

    public FluidStack recipeInput() {
        return this.getCurrentRecipe().getInput();
    }

    public ArrayList<ItemStack> recipeOutput() {
        return this.getCurrentRecipe().getOutput();
    }

    public ArrayList<Float> recipeGravity() {
        return this.getCurrentRecipe().getGravity();
    }

    public int calculatedPulp() {
        return this.getDummyRecipe() != null && this.getDummyRecipe().getInput() != null ? this.getDummyRecipe().getInput().amount : 0;
    }

    private void doPreset() {
        if (this.hasEngine()) {
            if (!this.getEngine().enablePower) {
                this.getEngine().enablePower = true;
                this.getEngine().markDirtyClient();
            }
            if (this.getEngine().enableRedstone) {
                this.getEngine().enableRedstone = false;
                this.getEngine().markDirtyClient();
            }
        }
        if (this.hasVatA() && this.getLeacherA().getFilter() != this.fluoridricAcid()) {
            this.getLeacherA().filter = this.fluoridricAcid();
        }
        if (this.hasVatB() && this.getLeacherB().getFilter() != CoreBasics.waterStack((int)1000)) {
            this.getLeacherB().filter = CoreBasics.waterStack((int)1000);
        }
        if (this.hasVesselA() && this.getVesselA().getFilter() != TERetentionVat.steam()) {
            this.getVesselA().filter = TERetentionVat.steam();
        }
        if (this.hasServer() && !this.getServer().isActive()) {
            this.emptyFilters();
        }
    }

    public void emptyFilters() {
        if (this.hasTankPulp()) {
            this.getTankPulp().filterSolvent = null;
            this.getTankPulp().isFiltered = false;
        }
    }

    public float getGravity() {
        return this.gravity;
    }

    public boolean isBugged() {
        return this.isBugged;
    }

    public FluidStack fluoridricAcid() {
        return new FluidStack(EnumFluid.pickFluid(EnumFluid.HYDROFLUORIC_ACID), 1000);
    }

    public int calculatedFluo() {
        return this.getGravity() > 0.0f ? (int)this.getGravity() * ModConfig.consumedFluo : 1;
    }

    public int calculatedWater() {
        return 500;
    }

    private static FluidStack steam() {
        return BaseRecipes.getFluid(EnumFluid.WATER_VAPOUR, 1000);
    }

    public int calculatedSteam() {
        return 100;
    }

    public TEPowerGenerator getEngine() {
        TEPowerGenerator engine = TileStructure.getEngine(this.field_145850_b, this.field_174879_c, this.isFacingAt(270), 1, 0);
        return engine != null ? engine : null;
    }

    public boolean hasEngine() {
        return this.getEngine() != null;
    }

    public boolean hasFuelPower() {
        return this.hasEngine() ? this.getEngine().getPower() > 0 : false;
    }

    private void drainPower() {
        --this.getEngine().powerCount;
        this.getEngine().markDirtyClient();
    }

    public TELeachingVatTank getLeacherA() {
        TELeachingVatTank tank = TileStructure.getLeacher(this.field_145850_b, this.field_174879_c, this.getFacing(), 1);
        return tank != null ? tank : null;
    }

    public boolean hasVatA() {
        return this.getLeacherA() != null;
    }

    public TELeachingVatTank getLeacherB() {
        TELeachingVatTank tank = TileStructure.getLeacher(this.field_145850_b, this.field_174879_c, this.getFacing(), 2);
        return tank != null ? tank : null;
    }

    public boolean hasVatB() {
        return this.getLeacherB() != null;
    }

    public TileVessel getVesselA() {
        TileVessel vessel = TileStructure.getHolder(this.field_145850_b, this.field_174879_c.func_177972_a(this.getFacing()), this.isFacingAt(270), 1, 180);
        return vessel != null ? vessel : null;
    }

    public boolean hasVesselA() {
        return this.getVesselA() != null;
    }

    public BlockPos collectorPos() {
        return this.field_174879_c.func_177967_a(this.getFacing(), 3);
    }

    public TELeachingVatCollector getCollector() {
        TELeachingVatCollector collector;
        TileEntity te = this.field_145850_b.func_175625_s(this.collectorPos());
        if (this.field_145850_b.func_180495_p(this.collectorPos()) != null && te instanceof TELeachingVatCollector && (collector = (TELeachingVatCollector)te).getFacing() == this.getFacing()) {
            return collector;
        }
        return null;
    }

    public boolean hasCollector() {
        return this.getCollector() != null;
    }

    public boolean isOutputEmpty() {
        return this.hasCollector() ? this.slotEmpty(0) && this.slotEmpty(1) && this.slotEmpty(2) : false;
    }

    private boolean slotEmpty(int i) {
        return this.getCollector().getOutput().getStackInSlot(i).func_190926_b();
    }

    public TEFlotationTank getTankPulp() {
        BlockPos flotationPos = this.field_174879_c.func_177972_a(this.getFacing());
        TEFlotationTank tank = TileStructure.getFlotationTank(this.field_145850_b, flotationPos, EnumFacing.UP, 1);
        return tank != null ? tank : null;
    }

    public boolean hasTankPulp() {
        return this.getTankPulp() != null;
    }

    public FluidStack getPulp() {
        return this.hasTankPulp() && this.getTankPulp().hasSolventFluid() ? this.getTankPulp().getSolventFluid() : null;
    }

    public TEBufferTank getTankWaste() {
        TEBufferTank tank = TileStructure.getBufferTank(this.field_145850_b, this.collectorPos(), EnumFacing.UP, 1);
        return tank != null ? tank : null;
    }

    public boolean hasTankWaste() {
        return this.getTankWaste() != null;
    }

    public boolean hasWaste() {
        return this.hasTankWaste() && this.input.canSetOrAddFluid(this.getTankWaste().inputTank, this.getTankWaste().getTankFluid(), this.waste(), this.calculatedWaste());
    }

    private int calculatedWaste() {
        return 400;
    }

    private FluidStack waste() {
        return BaseRecipes.getFluid(EnumFluid.TOXIC_WASTE, 1000);
    }

    public boolean hasLeacherA() {
        return this.hasVatA() && this.input.canDrainFluid(this.getLeacherA().inputTank.getFluid(), this.fluoridricAcid(), this.calculatedFluo()) && this.getLeacherA().hasConsumables() && this.hasVesselA() && this.input.canDrainFluid(this.getVesselA().inputTank.getFluid(), TERetentionVat.steam(), this.calculatedSteam());
    }

    public boolean hasLeacherB() {
        return this.hasVatB() && this.input.canDrainFluid(this.getLeacherB().inputTank.getFluid(), CoreBasics.waterStack((int)1000), this.calculatedWater()) && this.getLeacherB().hasConsumables();
    }

    public TEServer getServer() {
        TEServer server = TileStructure.getServer(this.field_145850_b, this.field_174879_c, this.isFacingAt(90), 1, 0);
        return server != null ? server : null;
    }

    public boolean hasServer() {
        return this.getServer() != null;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.doPreset();
            this.initializeServer(this.isRepeatable, this.hasServer(), this.getServer(), TERetentionVat.deviceCode());
            if (this.isActive() && this.getDummyRecipe() == null && this.hasAnyInput()) {
                this.dummyRecipe = this.getCurrentRecipe();
                this.getResult();
                this.cooktime = 0;
            }
            if (this.canProcess()) {
                ++this.cooktime;
                this.drainPower();
                if (this.getCooktime() >= this.getCooktimeMax()) {
                    this.cooktime = 0;
                    this.process();
                }
                this.markDirtyClient();
            } else {
                this.tickOff();
            }
        }
    }

    private boolean canProcess() {
        return this.isActive() && this.getDummyRecipe() != null && this.isAssembled() && this.hasFuelPower() && this.hasEnoughInput() && this.hasExposed() && this.handleServer(this.hasServer(), this.getServer(), this.currentFile);
    }

    private boolean isAssembled() {
        return this.isOutputEmpty() && this.hasTankWaste() && this.hasTankPulp() && this.hasLeacherA() && this.hasLeacherB();
    }

    private boolean hasEnoughInput() {
        return this.getDummyRecipe() != null && this.hasTankPulp() && this.getTankPulp().inputTank.getFluidAmount() >= this.calculatedPulp();
    }

    private boolean hasAnyInput() {
        return this.getPulp() != null;
    }

    private void process() {
        if (this.hasResult()) {
            int unbreakingLevel;
            this.isBugged = false;
            if (this.hasCollector()) {
                ((ItemStackHandler)this.getCollector().getOutput()).setStackInSlot(0, this.pickLevelOutput().func_77946_l());
                if (this.recipeOutput().size() > 1) {
                    ((ItemStackHandler)this.getCollector().getOutput()).getStackInSlot(0).func_190920_e(TERetentionVat.sizedQuantity());
                }
                if (this.resultList.size() > 1 && this.rand.nextInt(100) < 25) {
                    ((ItemStackHandler)this.getCollector().getOutput()).setStackInSlot(1, this.pickLevelOutput().func_77946_l());
                    ((ItemStackHandler)this.getCollector().getOutput()).getStackInSlot(1).func_190920_e(this.rand.nextInt(1 + TERetentionVat.sizedQuantity() / 2));
                    if (this.rand.nextInt(100) < 5) {
                        ((ItemStackHandler)this.getCollector().getOutput()).setStackInSlot(2, this.pickRecipeOutput().func_77946_l());
                        ((ItemStackHandler)this.getCollector().getOutput()).getStackInSlot(2).func_190920_e(1);
                    }
                }
            }
            if (this.hasTankWaste() && this.hasWaste()) {
                this.output.setOrFillFluid(this.getTankWaste().inputTank, this.waste(), this.calculatedWaste());
            }
            if (this.hasVatA()) {
                this.output.drainOrCleanFluid(this.getLeacherA().inputTank, this.calculatedFluo(), true);
                unbreakingLevel = CoreUtils.getEnchantmentLevel((Enchantment)Enchantments.field_185307_s, (ItemStack)this.getLeacherA().gearSlot());
                ((MachineStackHandler)this.getLeacherA().getInput()).damageUnbreakingSlot(unbreakingLevel, 0);
            }
            if (this.hasVesselA()) {
                this.output.drainOrCleanFluid(this.getVesselA().inputTank, this.calculatedSteam(), true);
            }
            if (this.hasVatB()) {
                this.output.drainOrCleanFluid(this.getLeacherB().inputTank, this.calculatedWater(), true);
                unbreakingLevel = CoreUtils.getEnchantmentLevel((Enchantment)Enchantments.field_185307_s, (ItemStack)this.getLeacherB().gearSlot());
                ((MachineStackHandler)this.getLeacherB().getInput()).damageUnbreakingSlot(unbreakingLevel, 0);
            }
            if (this.hasTankPulp()) {
                this.output.drainOrCleanFluid(this.getTankPulp().inputTank, this.calculatedPulp(), true);
            }
            this.updateServer(this.hasServer(), this.getServer(), this.currentFile);
        } else {
            this.isBugged = true;
        }
        this.dummyRecipe = null;
    }

    private ItemStack pickLevelOutput() {
        return this.resultList.get(this.rand.nextInt(this.resultList.size()));
    }

    private ItemStack pickRecipeOutput() {
        return this.recipeOutput().get(this.rand.nextInt(this.recipeOutput().size()));
    }

    public boolean isRecipeMulti() {
        return !this.resultList.isEmpty() && this.resultList.size() > 1;
    }

    public void getResult() {
        this.resultList = new ArrayList();
        if (this.isValidRecipe() && this.recipeOutput().size() > 0) {
            for (int stack = 0; stack < this.recipeOutput().size(); ++stack) {
                if (!(this.recipeGravity().get(stack).floatValue() >= this.minGravity()) || !(this.recipeGravity().get(stack).floatValue() <= this.maxGravity())) continue;
                this.resultList.add(this.recipeOutput().get(stack));
            }
        }
    }

    public boolean hasResult() {
        this.getResult();
        return this.hasExposed();
    }

    private boolean hasExposed() {
        return this.resultList != null && !this.resultList.isEmpty() && this.resultList.size() > 0;
    }

    public float minGravity() {
        return this.getGravity() - this.filterRange() >= 0.0f ? this.getGravity() - this.filterRange() : 0.0f;
    }

    public float maxGravity() {
        return this.getGravity() + this.filterRange();
    }

    public float currentGravity(int y) {
        return (float)this.getCurrentRecipe().getGravity().get(y).intValue() / 100.0f;
    }

    @Override
    public void loadServerStatus() {
        this.currentFile = -1;
        if (this.getServer().isActive()) {
            for (int x = 0; x < TEServer.FILE_SLOTS.length; ++x) {
                NBTTagCompound tag;
                ItemStack fileSlot = this.getServer().inputSlot(x).func_77946_l();
                if (!fileSlot.func_190926_b() && fileSlot.func_77969_a(new ItemStack(ModItems.MISC_ITEMS, 1, EnumMiscItems.SERVER_FILE.ordinal())) && fileSlot.func_77942_o() && this.isValidFile(tag = fileSlot.func_77978_p()) && tag.func_74762_e("Device") == TERetentionVat.deviceCode() && tag.func_74762_e("Recipe") < 16 && tag.func_74762_e("Done") > 0) {
                    if (this.gravity != (float)(tag.func_74762_e("Recipe") * 2) + 2.0f) {
                        this.gravity = (float)(tag.func_74762_e("Recipe") * 2) + 2.0f;
                        this.markDirtyClient();
                    }
                    if (this.currentFile != x) {
                        this.currentFile = x;
                        this.markDirtyClient();
                    }
                    if (tag.func_74764_b("FilterFluid") && this.hasTankPulp()) {
                        FluidStack temp = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.func_74775_l("FilterFluid"));
                        if (this.getTankPulp().getFilterSolvent() != null && this.getTankPulp().getFilterSolvent().isFluidEqual(temp)) break;
                        if (this.getTankPulp().filterSolvent != temp) {
                            this.getTankPulp().filterSolvent = temp;
                            this.markDirtyClient();
                        }
                        if (this.getTankPulp().filterManualSolvent != null) {
                            this.getTankPulp().filterManualSolvent = null;
                            this.markDirtyClient();
                        }
                        if (this.getTankPulp().isFiltered) break;
                        this.getTankPulp().isFiltered = true;
                        this.markDirtyClient();
                        break;
                    }
                    this.emptyFilters();
                    break;
                }
                if (x != TEServer.FILE_SLOTS.length - 1) continue;
                this.resetFiles(this.getServer(), TERetentionVat.deviceCode());
            }
        }
    }
}

