/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.tile;

import com.globbypotato.rockhounding_chemistry.ModItems;
import com.globbypotato.rockhounding_chemistry.enums.EnumMiscBlocksA;
import com.globbypotato.rockhounding_chemistry.enums.EnumMiscItems;
import com.globbypotato.rockhounding_chemistry.enums.utils.EnumServer;
import com.globbypotato.rockhounding_chemistry.handlers.ModConfig;
import com.globbypotato.rockhounding_chemistry.machines.io.MachineIO;
import com.globbypotato.rockhounding_chemistry.machines.recipe.GasReformerRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.GasReformerRecipe;
import com.globbypotato.rockhounding_chemistry.machines.tile.IInternalServer;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEBufferTank;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEPowerGenerator;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEReformerReactor;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEServer;
import com.globbypotato.rockhounding_chemistry.machines.tile.TileStructure;
import com.globbypotato.rockhounding_chemistry.machines.tile.TileVessel;
import com.globbypotato.rockhounding_chemistry.utils.BaseRecipes;
import com.globbypotato.rockhounding_chemistry.utils.ModUtils;
import com.globbypotato.rockhounding_core.machines.tileentity.MachineStackHandler;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import com.globbypotato.rockhounding_core.machines.tileentity.WrappedItemHandler;
import com.globbypotato.rockhounding_core.utils.CoreUtils;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TEReformerController
extends TileEntityInv
implements IInternalServer {
    public static final int SPEED_SLOT = 0;
    public static int upgradeSlots = 1;
    public static int templateSlots = 3;
    public int currentFile = -1;
    public boolean isRepeatable = false;
    public int[] catList = new int[5];
    public GasReformerRecipe dummyRecipe;

    public TEReformerController() {
        super(0, 0, templateSlots, upgradeSlots);
        this.upgrade = new MachineStackHandler(upgradeSlots, this){

            public ItemStack insertItem(int slot, ItemStack insertingStack, boolean simulate) {
                if (slot == 0 && ModUtils.isValidSpeedUpgrade(insertingStack)) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                return insertingStack;
            }
        };
        this.automationUpgrade = new WrappedItemHandler((IItemHandlerModifiable)this.upgrade, WrappedItemHandler.WriteMode.IN);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("Catalysts")) {
            NBTTagCompound elements = compound.func_74775_l("Catalysts");
            for (int i = 0; i < this.catList.length; ++i) {
                this.catList[i] = elements.func_74762_e("catalyst" + i);
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        NBTTagCompound elements = new NBTTagCompound();
        for (int i = 0; i < this.catList.length; ++i) {
            elements.func_74768_a("catalyst" + i, this.catList[i]);
        }
        compound.func_74782_a("Catalysts", (NBTBase)elements);
        return compound;
    }

    public ItemStack speedSlot() {
        return this.upgrade.getStackInSlot(0);
    }

    public int getGUIHeight() {
        return 200;
    }

    public static String getName() {
        return "reformer_controller";
    }

    public int getCooktimeMax() {
        return 60;
    }

    private static int deviceCode() {
        return EnumServer.REFORMER.ordinal();
    }

    public int speedFactor() {
        return ModUtils.isValidSpeedUpgrade(this.speedSlot()) ? ModUtils.speedUpgrade(this.speedSlot()) : 1;
    }

    public EnumFacing poweredFacing() {
        return this.getFacing().func_176734_d();
    }

    public ArrayList<GasReformerRecipe> recipeList() {
        return GasReformerRecipes.gas_reformer_recipes;
    }

    public GasReformerRecipe getRecipeList(int x) {
        return this.recipeList().get(x);
    }

    public GasReformerRecipe getCurrentRecipe() {
        if (this.isActive() && this.isValidPreset() && this.hasCatalysts() && this.handleInput() && this.handleOutput()) {
            return this.getRecipeList(this.getRecipeIndex());
        }
        return null;
    }

    public GasReformerRecipe getDummyRecipe() {
        return this.dummyRecipe;
    }

    public boolean isValidPreset() {
        return this.getRecipeIndex() > -1 && this.getRecipeIndex() < this.recipeList().size();
    }

    public boolean isValidRecipe() {
        return this.getDummyRecipe() != null;
    }

    public FluidStack getRecipeInputA() {
        return this.isValidPreset() ? this.getRecipeList(this.getRecipeIndex()).getInputA() : null;
    }

    public FluidStack getRecipeInputB() {
        return this.isValidPreset() ? this.getRecipeList(this.getRecipeIndex()).getInputB() : null;
    }

    public FluidStack getRecipeOutput() {
        return this.isValidPreset() ? this.getRecipeList(this.getRecipeIndex()).getOutput() : null;
    }

    public ItemStack getRecipeCatalyst() {
        return this.isValidPreset() ? this.getRecipeList(this.getRecipeIndex()).getCatalyst() : ItemStack.field_190927_a;
    }

    public boolean isOutputGaseous() {
        return this.getRecipeOutput() != null && this.getRecipeOutput().getFluid().isGaseous();
    }

    public ItemStack catalystA() {
        return BaseRecipes.nl_catalyst.func_77946_l();
    }

    public ItemStack catalystB() {
        return BaseRecipes.gr_catalyst.func_77946_l();
    }

    public ItemStack catalystC() {
        return BaseRecipes.wg_catalyst.func_77946_l();
    }

    public ItemStack catalystD() {
        return BaseRecipes.au_catalyst.func_77946_l();
    }

    public boolean hasSystemCatalysts() {
        this.catList[0] = 0;
        this.catList[1] = 0;
        this.catList[2] = 0;
        for (int x = 0; x < TEReformerReactor.SLOT_SYSTEM_CAT.length; ++x) {
            ItemStack systemSlot = this.getReactor().getInput().getStackInSlot(TEReformerReactor.SLOT_SYSTEM_CAT[x]);
            if (!this.isSystemCatalyst(systemSlot)) continue;
            if (systemSlot.func_185136_b(this.catalystA())) {
                this.catList[0] = this.catList[0] + 1;
                continue;
            }
            if (systemSlot.func_185136_b(this.catalystB())) {
                this.catList[1] = this.catList[1] + 1;
                continue;
            }
            if (!systemSlot.func_185136_b(this.catalystC())) continue;
            this.catList[2] = this.catList[2] + 1;
        }
        return this.catList[0] == 6 || this.catList[1] == 6 || this.catList[2] == 6;
    }

    public int systemCatalystFactor() {
        if (this.catList[0] == 6) {
            return 1;
        }
        if (this.catList[1] == 6) {
            return 2;
        }
        if (this.catList[2] == 6) {
            return 3;
        }
        return 0;
    }

    public boolean hasRecipeCatalysts() {
        this.catList[3] = 0;
        this.catList[4] = 0;
        for (int x = 0; x < TEReformerReactor.SLOT_RECIPE_CAT.length; ++x) {
            ItemStack recipeSlot = this.getReactor().getInput().getStackInSlot(TEReformerReactor.SLOT_RECIPE_CAT[x]);
            if (!this.isRecipeCatalyst(recipeSlot)) continue;
            if (recipeSlot.func_185136_b(this.catalystD())) {
                this.catList[3] = this.catList[3] + 1;
                continue;
            }
            if (!recipeSlot.func_185136_b(this.getRecipeCatalyst())) continue;
            this.catList[4] = this.catList[4] + 1;
        }
        return this.catList[3] == 4 || this.catList[4] == 4;
    }

    public int recipeCatalystFactor() {
        if (this.catList[3] == 4) {
            return 1;
        }
        if (this.catList[4] == 4) {
            return 2;
        }
        return 0;
    }

    public boolean isSystemCatalyst(ItemStack insertingStack) {
        return CoreUtils.hasConsumable((ItemStack)this.catalystA(), (ItemStack)insertingStack) || CoreUtils.hasConsumable((ItemStack)this.catalystB(), (ItemStack)insertingStack) || CoreUtils.hasConsumable((ItemStack)this.catalystC(), (ItemStack)insertingStack);
    }

    public boolean isRecipeCatalyst(ItemStack insertingStack) {
        return insertingStack.func_185136_b(this.getRecipeCatalyst()) || insertingStack.func_185136_b(this.catalystD());
    }

    public boolean hasCatalysts() {
        return this.hasReactor() && this.hasSystemCatalysts() && this.systemCatalystFactor() > 0 && this.hasRecipeCatalysts() && this.recipeCatalystFactor() > 0;
    }

    public int inputTier() {
        return this.hasReactor() ? this.systemCatalystFactor() : 0;
    }

    public int outputTier() {
        return this.hasReactor() ? this.recipeCatalystFactor() : 0;
    }

    private void doPreset() {
        if (this.hasEngine()) {
            if (this.getEngine().enablePower) {
                this.getEngine().enablePower = false;
                this.getEngine().markDirtyClient();
            }
            if (!this.getEngine().enableRedstone) {
                this.getEngine().enableRedstone = true;
                this.getEngine().markDirtyClient();
            }
        }
        if (this.isValidPreset()) {
            if (this.hasATank() && this.getATank().getFilter() != this.getRecipeInputA()) {
                this.getATank().filter = this.getRecipeInputA();
            }
            if (this.hasBTank() && this.getBTank().getFilter() != this.getRecipeInputB()) {
                this.getBTank().filter = this.getRecipeInputB();
            }
        } else {
            if (this.hasATank() && this.getATank().getFilter() != null) {
                this.getATank().filter = null;
            }
            if (this.hasBTank() && this.getBTank().getFilter() != null) {
                this.getBTank().filter = null;
            }
        }
    }

    public int powerConsume() {
        int baseConsume = 60 * ModConfig.basePower;
        return ModConfig.speedMultiplier ? baseConsume * this.speedFactor() : baseConsume;
    }

    public int baseDrainA() {
        return this.getRecipeInputA() != null ? this.getRecipeInputA().amount : 0;
    }

    public int calculatedDrainA() {
        return this.hasReactor() ? (4 - this.systemCatalystFactor()) * this.baseDrainA() * this.speedFactor() : 0;
    }

    public int baseDrainB() {
        return this.getRecipeInputB() != null ? this.getRecipeInputB().amount : 0;
    }

    public int calculatedDrainB() {
        return this.hasReactor() ? (4 - this.systemCatalystFactor()) * this.baseDrainB() * this.speedFactor() : 0;
    }

    public int baseProduct() {
        return this.getRecipeOutput() != null ? this.getRecipeOutput().amount : 0;
    }

    public int calculatedProduct() {
        return this.hasReactor() ? this.recipeCatalystFactor() * this.baseProduct() * this.speedFactor() : 0;
    }

    public TEPowerGenerator getEngine() {
        TEPowerGenerator engine = TileStructure.getEngine(this.field_145850_b, this.field_174879_c, this.getFacing(), 1, 0);
        return engine != null ? engine : null;
    }

    public boolean hasEngine() {
        return this.getEngine() != null;
    }

    public boolean hasRedstonePower() {
        return this.hasEngine() ? this.getEngine().getRedstone() >= this.powerConsume() : false;
    }

    private void drainPower() {
        this.getEngine().redstoneCount -= this.powerConsume();
        this.getEngine().markDirtyClient();
    }

    public BlockPos reactorPos() {
        return this.field_174879_c.func_177967_a(EnumFacing.UP, 1);
    }

    public TEReformerReactor getReactor() {
        TEReformerReactor reactor;
        TileEntity te = this.field_145850_b.func_175625_s(this.reactorPos());
        if (this.field_145850_b.func_180495_p(this.reactorPos()) != null && te instanceof TEReformerReactor && (reactor = (TEReformerReactor)te).getFacing() == this.getFacing()) {
            return reactor;
        }
        return null;
    }

    public boolean hasReactor() {
        return this.getReactor() != null;
    }

    public TileVessel getATank() {
        TileVessel vessel = TileStructure.getHolder(this.field_145850_b, this.separatorPos(), this.isFacingAt(90), 1, 180);
        return vessel != null ? vessel : null;
    }

    public boolean hasATank() {
        return this.getATank() != null;
    }

    public FluidStack tankAInput() {
        return this.hasATank() ? this.getATank().inputTank.getFluid() : null;
    }

    public TileVessel getBTank() {
        TileVessel vessel = TileStructure.getHolder(this.field_145850_b, this.separatorPos(), this.isFacingAt(270), 1, 180);
        return vessel != null ? vessel : null;
    }

    public boolean hasBTank() {
        return this.getBTank() != null;
    }

    public FluidStack tankBInput() {
        return this.hasBTank() ? this.getBTank().inputTank.getFluid() : null;
    }

    public TileVessel getOutTank() {
        TileVessel vessel = TileStructure.getHolder(this.field_145850_b, this.separatorPos(), this.getFacing(), 1, 0);
        return vessel != null ? vessel : null;
    }

    public boolean hasOutTank() {
        return this.getOutTank() != null;
    }

    public FluidStack outGas() {
        return this.hasOutTank() ? this.getOutTank().inputTank.getFluid() : null;
    }

    public TileVessel getPurgeTank() {
        TileVessel vessel = TileStructure.getHolder(this.field_145850_b, this.field_174879_c, this.isFacingAt(90), 1, 0);
        return vessel != null ? vessel : null;
    }

    public boolean hasPurgeTank() {
        return this.getPurgeTank() != null;
    }

    public FluidStack purgeGas() {
        return this.hasPurgeTank() ? this.getPurgeTank().inputTank.getFluid() : null;
    }

    public TEBufferTank getTank() {
        TEBufferTank tank = TileStructure.getBufferTank(this.field_145850_b, this.field_174879_c, EnumFacing.UP, 5);
        return tank != null ? tank : null;
    }

    public boolean hasTank() {
        return this.getTank() != null;
    }

    public BlockPos separatorPos() {
        return this.reactorPos().func_177967_a(this.getFacing(), 1);
    }

    public Block getSeparator() {
        IBlockState sepState = this.field_145850_b.func_180495_p(this.separatorPos());
        Block separator = sepState.func_177230_c();
        if (MachineIO.miscBlocksA(separator, sepState, EnumMiscBlocksA.SEPARATOR.ordinal())) {
            return separator;
        }
        return null;
    }

    public boolean hasTower() {
        int countTower = 0;
        for (int x = 2; x <= 3; ++x) {
            BlockPos tPos = new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + x, this.field_174879_c.func_177952_p());
            IBlockState state = this.field_145850_b.func_180495_p(tPos);
            Block block = state.func_177230_c();
            if (!MachineIO.miscBlocksA(block, state, EnumMiscBlocksA.REFORMER_TOWER.ordinal())) continue;
            ++countTower;
        }
        BlockPos tPos = new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + 4, this.field_174879_c.func_177952_p());
        IBlockState state = this.field_145850_b.func_180495_p(tPos);
        Block block = state.func_177230_c();
        if (MachineIO.miscBlocksA(block, state, EnumMiscBlocksA.REFORMER_TOWER_TOP.ordinal())) {
            ++countTower;
        }
        return countTower == 3 && this.getSeparator() != null;
    }

    public TEServer getServer() {
        TEServer server = TileStructure.getServer(this.field_145850_b, this.field_174879_c, this.isFacingAt(270), 1, 0);
        return server != null ? server : null;
    }

    public boolean hasServer() {
        return this.getServer() != null;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.doPreset();
            this.handlePurge();
            this.initializeServer(this.isRepeatable, this.hasServer(), this.getServer(), TEReformerController.deviceCode());
            if (this.getDummyRecipe() == null) {
                this.dummyRecipe = this.getCurrentRecipe();
                this.cooktime = 0;
            }
            if (this.canProcess()) {
                ++this.cooktime;
                this.drainPower();
                if (this.getCooktime() >= this.getCooktimeMax()) {
                    this.cooktime = 0;
                    this.process();
                }
                this.markDirtyClient();
            } else {
                this.tickOff();
            }
        }
    }

    private boolean canProcess() {
        return this.isActive() && this.isValidRecipe() && this.hasRedstonePower() && this.hasTower() && this.handleServer(this.hasServer(), this.getServer(), this.currentFile);
    }

    private boolean handleInput() {
        return this.getRecipeInputA() != null && this.hasATank() && this.input.canDrainFluid(this.tankAInput(), this.getRecipeInputA(), this.calculatedDrainA()) && this.getRecipeInputB() != null && this.hasBTank() && this.input.canDrainFluid(this.tankBInput(), this.getRecipeInputB(), this.calculatedDrainB());
    }

    private boolean handleOutput() {
        if (this.isOutputGaseous()) {
            return this.getRecipeOutput() != null && this.hasOutTank() && this.input.canSetOrAddFluid(this.getOutTank().inputTank, this.getOutTank().inputTank.getFluid(), this.getRecipeOutput(), this.calculatedProduct());
        }
        return this.getRecipeOutput() != null && this.hasTank() && this.input.canSetOrAddFluid(this.getTank().inputTank, this.getTank().inputTank.getFluid(), this.getRecipeOutput(), this.calculatedProduct());
    }

    private void process() {
        if (this.isValidRecipe() && this.hasCatalysts()) {
            if (this.isOutputGaseous()) {
                if (this.hasOutTank()) {
                    this.input.setOrFillFluid(this.getOutTank().inputTank, this.getRecipeOutput(), this.calculatedProduct());
                }
            } else if (this.hasTank()) {
                this.input.setOrFillFluid(this.getTank().inputTank, this.getRecipeOutput(), this.calculatedProduct());
            }
            if (this.hasReactor()) {
                for (int cats = 0; cats < TEReformerReactor.totCatalysts; ++cats) {
                    int unbreakingLevel = CoreUtils.getEnchantmentLevel((Enchantment)Enchantments.field_185307_s, (ItemStack)this.getReactor().inputSlot(cats));
                    ((MachineStackHandler)this.getReactor().getInput()).damageUnbreakingSlot(unbreakingLevel, cats);
                }
            }
            if (this.hasATank()) {
                this.input.drainOrCleanFluid(this.getATank().inputTank, this.calculatedDrainA(), true);
            }
            if (this.hasBTank()) {
                this.input.drainOrCleanFluid(this.getBTank().inputTank, this.calculatedDrainB(), true);
            }
            this.updateServer(this.hasServer(), this.getServer(), this.currentFile);
        }
        this.dummyRecipe = null;
    }

    private void handlePurge() {
        if (this.isActive() && (!this.isValidPreset() || !this.isValidRecipe()) && this.hasPurgeTank()) {
            int canSend;
            int canReceive;
            if (this.hasATank() && this.isWrongInputA() && this.canPurgeA()) {
                canReceive = this.getPurgeTank().inputTank.getCapacity() - this.getPurgeTank().inputTank.getFluidAmount();
                canSend = Math.min(this.getATank().inputTank.getFluidAmount(), canReceive);
                this.input.setOrFillFluid(this.getPurgeTank().inputTank, this.tankAInput(), canSend);
                this.input.drainOrCleanFluid(this.getATank().inputTank, canSend, true);
            }
            if (this.hasBTank() && this.isWrongInputB() && this.canPurgeB()) {
                canReceive = this.getPurgeTank().inputTank.getCapacity() - this.getPurgeTank().inputTank.getFluidAmount();
                canSend = Math.min(this.getBTank().inputTank.getFluidAmount(), canReceive);
                this.input.setOrFillFluid(this.getPurgeTank().inputTank, this.tankBInput(), canSend);
                this.input.drainOrCleanFluid(this.getBTank().inputTank, canSend, true);
            }
        }
    }

    private boolean isWrongInputA() {
        return this.tankAInput() != null && (this.getRecipeInputA() == null || this.getRecipeInputA() != null && !this.getRecipeInputA().isFluidEqual(this.tankAInput()));
    }

    private boolean isWrongInputB() {
        return this.tankBInput() != null && (this.getRecipeInputB() == null || this.getRecipeInputB() != null && !this.getRecipeInputB().isFluidEqual(this.tankBInput()));
    }

    private boolean canPurgeA() {
        return this.tankAInput() != null && this.input.canSetOrFillFluid(this.getPurgeTank().inputTank, this.purgeGas(), this.tankAInput());
    }

    private boolean canPurgeB() {
        return this.tankBInput() != null && this.input.canSetOrFillFluid(this.getPurgeTank().inputTank, this.purgeGas(), this.tankBInput());
    }

    @Override
    public void loadServerStatus() {
        this.currentFile = -1;
        if (this.getServer().isActive()) {
            for (int x = 0; x < TEServer.FILE_SLOTS.length; ++x) {
                NBTTagCompound tag;
                ItemStack fileSlot = this.getServer().inputSlot(x).func_77946_l();
                if (!fileSlot.func_190926_b() && fileSlot.func_77969_a(new ItemStack(ModItems.MISC_ITEMS, 1, EnumMiscItems.SERVER_FILE.ordinal())) && fileSlot.func_77942_o() && this.isValidFile(tag = fileSlot.func_77978_p()) && tag.func_74762_e("Device") == TEReformerController.deviceCode() && tag.func_74762_e("Recipe") < this.recipeList().size() && tag.func_74762_e("Done") > 0) {
                    if (this.recipeIndex != tag.func_74762_e("Recipe")) {
                        this.recipeIndex = tag.func_74762_e("Recipe");
                        this.markDirtyClient();
                    }
                    if (this.currentFile == x) break;
                    this.currentFile = x;
                    this.markDirtyClient();
                    break;
                }
                if (x != TEServer.FILE_SLOTS.length - 1) continue;
                this.resetFiles(this.getServer(), TEReformerController.deviceCode());
            }
        }
    }
}

