/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.tile;

import com.globbypotato.rockhounding_chemistry.ModItems;
import com.globbypotato.rockhounding_chemistry.enums.EnumMiscItems;
import com.globbypotato.rockhounding_chemistry.enums.utils.EnumServer;
import com.globbypotato.rockhounding_chemistry.handlers.ModConfig;
import com.globbypotato.rockhounding_chemistry.machines.recipe.PrecipitationRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.PrecipitationRecipe;
import com.globbypotato.rockhounding_chemistry.machines.tile.IInternalServer;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEBufferTank;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEFlotationTank;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEPowerGenerator;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEPrecipitationChamber;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEPrecipitationReactor;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEServer;
import com.globbypotato.rockhounding_chemistry.machines.tile.TileStructure;
import com.globbypotato.rockhounding_chemistry.utils.ModUtils;
import com.globbypotato.rockhounding_core.machines.tileentity.MachineStackHandler;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import com.globbypotato.rockhounding_core.machines.tileentity.WrappedItemHandler;
import com.globbypotato.rockhounding_core.utils.CoreUtils;
import com.google.common.base.Strings;
import java.util.ArrayList;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.oredict.OreDictionary;

public class TEPrecipitationController
extends TileEntityInv
implements IInternalServer {
    public static int inputSlots = 2;
    public static int outputSlots = 2;
    public static int templateSlots = 3;
    public static int upgradeSlots = 1;
    public static final int SOLUTE_SLOT = 0;
    public static final int CATALYST_SLOT = 1;
    public static final int SOLUTE_OUT_SLOT = 0;
    public static final int CATALYST_OUT_SLOT = 1;
    public static final int SPEED_SLOT = 0;
    public int currentFile = -1;
    public boolean isRepeatable = false;

    public TEPrecipitationController() {
        super(inputSlots, outputSlots, templateSlots, upgradeSlots);
        this.input = new MachineStackHandler(inputSlots, this){

            public ItemStack insertItem(int slot, ItemStack insertingStack, boolean simulate) {
                if (slot == 0 && TEPrecipitationController.this.isActive() && TEPrecipitationController.this.isValidInput(insertingStack)) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                if (slot == 1 && TEPrecipitationController.this.isActive() && TEPrecipitationController.this.isValidCatalyst(insertingStack)) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                return insertingStack;
            }
        };
        this.automationInput = new WrappedItemHandler((IItemHandlerModifiable)this.input, WrappedItemHandler.WriteMode.IN);
        this.upgrade = new MachineStackHandler(upgradeSlots, this){

            public ItemStack insertItem(int slot, ItemStack insertingStack, boolean simulate) {
                if (slot == 0 && ModUtils.isValidSpeedUpgrade(insertingStack)) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                return insertingStack;
            }
        };
        this.automationUpgrade = new WrappedItemHandler((IItemHandlerModifiable)this.upgrade, WrappedItemHandler.WriteMode.IN);
    }

    public ItemStack soluteSlot() {
        return this.input.getStackInSlot(0);
    }

    public ItemStack catalystSlot() {
        return this.input.getStackInSlot(1);
    }

    public ItemStack soluteOutSlot() {
        return this.output.getStackInSlot(0);
    }

    public ItemStack catalystOutSlot() {
        return this.output.getStackInSlot(1);
    }

    public ItemStack speedSlot() {
        return this.upgrade.getStackInSlot(0);
    }

    public int getGUIHeight() {
        return 200;
    }

    public static String getName() {
        return "precipitation_controller";
    }

    public int speedFactor() {
        return ModUtils.isValidSpeedUpgrade(this.speedSlot()) ? ModUtils.speedUpgrade(this.speedSlot()) : 1;
    }

    public int getCooktimeMax() {
        return ModUtils.isValidSpeedUpgrade(this.speedSlot()) ? ModConfig.speedOven / ModUtils.speedUpgrade(this.speedSlot()) : ModConfig.speedOven;
    }

    private static int deviceCode() {
        return EnumServer.PRECIPITATOR.ordinal();
    }

    public BlockPos poweredPosition() {
        return this.chamberPos().func_177972_a(this.poweredFacing());
    }

    public EnumFacing poweredFacing() {
        return EnumFacing.func_176733_a((double)(this.getFacing().func_185119_l() + 90.0f));
    }

    boolean isValidInput(ItemStack stack) {
        ArrayList inputOreIDs;
        return this.isValidPreset() && (this.recipeList().get(this.getRecipeIndex()).getType() ? !(inputOreIDs = CoreUtils.intArrayToList((int[])OreDictionary.getOreIDs((ItemStack)stack))).isEmpty() && inputOreIDs.contains(OreDictionary.getOreID((String)this.recipeList().get(this.getRecipeIndex()).getOredict())) : this.recipeList().get(this.getRecipeIndex()).getSolute().func_77969_a(stack));
    }

    public boolean isValidCatalyst(ItemStack stack) {
        return !stack.func_190926_b() && !this.recipeCatalyst().func_190926_b() && stack.func_185136_b(this.recipeCatalyst());
    }

    public ArrayList<PrecipitationRecipe> recipeList() {
        return PrecipitationRecipes.precipitation_recipes;
    }

    public PrecipitationRecipe getRecipeList(int x) {
        return this.recipeList().get(x);
    }

    public PrecipitationRecipe getCurrentRecipe() {
        if (this.isValidPreset()) {
            return this.getRecipeList(this.getRecipeIndex());
        }
        return null;
    }

    public boolean isValidRecipe() {
        return this.getCurrentRecipe() != null;
    }

    public boolean isValidPreset() {
        return this.getRecipeIndex() > -1 && this.getRecipeIndex() < this.recipeList().size();
    }

    public ItemStack recipeSolute() {
        return this.isValidRecipe() ? this.getCurrentRecipe().getSolute() : ItemStack.field_190927_a;
    }

    public ItemStack recipeCatalyst() {
        return this.isValidRecipe() ? this.getCurrentRecipe().getCatalyst() : ItemStack.field_190927_a;
    }

    public FluidStack recipeSolvent() {
        return this.isValidRecipe() ? this.getCurrentRecipe().getSolvent() : null;
    }

    public FluidStack recipeSolution() {
        return this.isValidRecipe() ? this.getCurrentRecipe().getSolution() : null;
    }

    public ItemStack recipePrecipitate() {
        return this.isValidRecipe() ? this.getCurrentRecipe().getPrecipitate() : ItemStack.field_190927_a;
    }

    public void doPreset() {
        if (this.hasEngine()) {
            if (!this.getEngine().enablePower) {
                this.getEngine().enablePower = true;
                this.getEngine().markDirtyClient();
            }
            if (!this.getEngine().enableRedstone) {
                this.getEngine().enableRedstone = true;
                this.getEngine().markDirtyClient();
            }
        }
        if (this.isValidPreset()) {
            if (this.hasIntank()) {
                if (this.getIntank().getFilterSolvent() != this.recipeSolvent()) {
                    this.getIntank().filterSolvent = this.recipeSolvent();
                }
                this.getIntank().filterManualSolvent = null;
                this.getIntank().isFiltered = true;
            }
        } else {
            this.emptyFilters();
        }
    }

    public void emptyFilters() {
        if (this.hasIntank()) {
            this.getIntank().filterSolvent = null;
            this.getIntank().isFiltered = false;
        }
    }

    public TEPowerGenerator getEngine() {
        TEPowerGenerator engine = TileStructure.getEngine(this.field_145850_b, this.chamberPos(), this.isFacingAt(270), 1, 0);
        return engine != null ? engine : null;
    }

    public boolean hasEngine() {
        return this.getEngine() != null;
    }

    public boolean hasFuelPower() {
        return this.hasEngine() ? this.getEngine().getPower() > 0 : false;
    }

    public boolean hasRedstonePower() {
        return this.hasEngine() ? this.getEngine().getRedstone() >= this.powerConsume() : false;
    }

    private void drainPower() {
        --this.getEngine().powerCount;
        this.getEngine().redstoneCount -= this.powerConsume();
        this.getEngine().markDirtyClient();
    }

    public int powerConsume() {
        int baseConsume = 20 * ModConfig.basePower;
        return ModConfig.speedMultiplier ? baseConsume * this.speedFactor() : baseConsume;
    }

    public BlockPos chamberPos() {
        return this.field_174879_c.func_177967_a(EnumFacing.DOWN, 1);
    }

    public TEPrecipitationChamber getChamber() {
        TEPrecipitationChamber tank;
        TileEntity te = this.field_145850_b.func_175625_s(this.chamberPos());
        if (this.field_145850_b.func_180495_p(this.chamberPos()) != null && te instanceof TEPrecipitationChamber && (tank = (TEPrecipitationChamber)te).getFacing() == this.getFacing()) {
            return tank;
        }
        return null;
    }

    public boolean hasChamber() {
        return this.getChamber() != null;
    }

    private boolean isChamberPowered() {
        return this.hasChamber() ? this.getChamber().isActive() : false;
    }

    public TEPrecipitationReactor getReactor1() {
        TEPrecipitationReactor tank;
        TileEntity te = this.field_145850_b.func_175625_s(this.chamberPos().func_177967_a(this.getFacing(), 1));
        if (this.field_145850_b.func_180495_p(this.chamberPos()) != null && te instanceof TEPrecipitationReactor && (tank = (TEPrecipitationReactor)te).getFacing() == this.getFacing()) {
            return tank;
        }
        return null;
    }

    public TEPrecipitationReactor getReactor2() {
        TEPrecipitationReactor tank;
        TileEntity te = this.field_145850_b.func_175625_s(this.chamberPos().func_177967_a(this.getFacing(), 2));
        if (this.field_145850_b.func_180495_p(this.chamberPos()) != null && te instanceof TEPrecipitationReactor && (tank = (TEPrecipitationReactor)te).getFacing() == this.getFacing().func_176734_d()) {
            return tank;
        }
        return null;
    }

    public boolean hasReactors() {
        return this.getReactor1() != null && this.getReactor2() != null;
    }

    public TEFlotationTank getIntank() {
        BlockPos intankPos = this.field_174879_c.func_177967_a(this.getFacing(), 1);
        TEFlotationTank tank = TileStructure.getFlotationTank(this.field_145850_b, intankPos, EnumFacing.UP, 0);
        return tank != null ? tank : null;
    }

    public boolean hasIntank() {
        return this.getIntank() != null;
    }

    public TEBufferTank getOuttank() {
        BlockPos outtankPos = this.field_174879_c.func_177967_a(this.getFacing(), 2);
        TEBufferTank tank = TileStructure.getBufferTank(this.field_145850_b, outtankPos, EnumFacing.UP, 0);
        return tank != null ? tank : null;
    }

    public boolean hasOuttank() {
        return this.getOuttank() != null;
    }

    public BlockPos serverPos() {
        return this.field_174879_c.func_177967_a(this.getFacing(), 2).func_177967_a(EnumFacing.DOWN, 1);
    }

    public TEServer getServer() {
        TEServer server = TileStructure.getServer(this.field_145850_b, this.chamberPos(), this.getFacing(), 3, 0);
        return server != null ? server : null;
    }

    public boolean hasServer() {
        return this.getServer() != null;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.doPreset();
            this.handlePurge();
            this.initializeServer(this.isRepeatable, this.hasServer(), this.getServer(), TEPrecipitationController.deviceCode());
            if (this.isActive()) {
                if (this.canProcess()) {
                    ++this.cooktime;
                    this.drainPower();
                    if (this.getCooktime() >= this.getCooktimeMax()) {
                        this.cooktime = 0;
                        this.process();
                    }
                    this.markDirtyClient();
                }
            } else {
                this.tickOff();
            }
            if (this.soluteSlot().func_190926_b() && this.catalystSlot().func_190926_b()) {
                this.tickOff();
            }
        }
    }

    private void handlePurge() {
        if (this.isActive() && (!this.isValidPreset() || this.isValidRecipe())) {
            if (!this.soluteSlot().func_190926_b() && !this.recipeSolute().func_190926_b() && !CoreUtils.isMatchingIngredient((ItemStack)this.recipeSolute(), (ItemStack)this.soluteSlot()) && this.output.canSetOrStack(this.soluteOutSlot(), this.soluteSlot())) {
                this.output.setOrStack(0, this.soluteSlot());
                this.input.setStackInSlot(0, ItemStack.field_190927_a);
            }
            if (!this.catalystSlot().func_190926_b() && !this.recipeSolute().func_190926_b() && !this.catalystSlot().func_185136_b(this.recipeCatalyst()) && this.output.canSetOrStack(this.catalystOutSlot(), this.catalystSlot())) {
                this.output.setOrStack(1, this.catalystSlot());
                this.input.setStackInSlot(1, ItemStack.field_190927_a);
            }
        }
    }

    private boolean canProcess() {
        return this.isActive() && this.hasReactors() && this.isValidRecipe() && this.hasFuelPower() && this.hasRedstonePower() && this.handleSolute() && this.handleCatalyst() && this.handleSolvent() && this.handleSolution() && this.handlePrecipitate() && this.handleServer(this.hasServer(), this.getServer(), this.currentFile);
    }

    private boolean handleSolute() {
        if (this.isValidRecipe() && !this.soluteSlot().func_190926_b()) {
            if (this.getCurrentRecipe().getType()) {
                ArrayList inputOreIDs = CoreUtils.intArrayToList((int[])OreDictionary.getOreIDs((ItemStack)this.soluteSlot()));
                if (!inputOreIDs.isEmpty() && !Strings.isNullOrEmpty((String)this.recipeList().get(this.getRecipeIndex()).getOredict()) && inputOreIDs.contains(OreDictionary.getOreID((String)this.recipeList().get(this.getRecipeIndex()).getOredict()))) {
                    return true;
                }
            } else {
                return !this.recipeSolute().func_190926_b() ? this.recipeList().get(this.getRecipeIndex()).getSolute().func_77969_a(this.soluteSlot()) : true;
            }
        }
        return false;
    }

    private boolean handleCatalyst() {
        return !this.recipeCatalyst().func_190926_b() ? this.isValidCatalyst(this.catalystSlot()) || CoreUtils.isMatchingIngredient((ItemStack)this.catalystSlot(), (ItemStack)this.recipeCatalyst()) : true;
    }

    private boolean handleSolvent() {
        return this.recipeSolvent() != null && this.hasIntank() && this.input.canDrainFluid(this.getIntank().getSolventFluid(), this.recipeSolvent());
    }

    private boolean handleSolution() {
        return this.recipeSolution() != null && this.hasOuttank() && this.input.canSetOrFillFluid(this.getOuttank().inputTank, this.getOuttank().getTankFluid(), this.recipeSolution());
    }

    private boolean handlePrecipitate() {
        return this.recipePrecipitate() == null || this.recipePrecipitate() != null && this.hasChamber() && this.input.canSetOrStack(this.getChamber().mainSlot(), this.recipePrecipitate());
    }

    private void process() {
        if (this.hasIntank() && this.recipeSolvent() != null) {
            this.getIntank().inputTank.drainInternal(this.recipeSolvent(), true);
        }
        if (this.hasOuttank() && this.recipeSolution() != null) {
            this.getOuttank().inputTank.fillInternal(this.recipeSolution(), true);
        }
        if (this.hasChamber() && !this.recipePrecipitate().func_190926_b()) {
            ((MachineStackHandler)this.getChamber().getOutput()).setOrStack(0, this.recipePrecipitate());
        }
        if (!this.catalystSlot().func_190926_b()) {
            int unbreakingLevel = CoreUtils.getEnchantmentLevel((Enchantment)Enchantments.field_185307_s, (ItemStack)this.catalystSlot());
            this.input.damageUnbreakingSlot(unbreakingLevel, 1);
        }
        if (!this.soluteSlot().func_190926_b()) {
            this.input.decrementSlot(0);
        }
        this.updateServer(this.hasServer(), this.getServer(), this.currentFile);
    }

    @Override
    public void loadServerStatus() {
        this.currentFile = -1;
        if (this.getServer().isActive()) {
            for (int x = 0; x < TEServer.FILE_SLOTS.length; ++x) {
                NBTTagCompound tag;
                ItemStack fileSlot = this.getServer().inputSlot(x).func_77946_l();
                if (!fileSlot.func_190926_b() && fileSlot.func_77969_a(new ItemStack(ModItems.MISC_ITEMS, 1, EnumMiscItems.SERVER_FILE.ordinal())) && fileSlot.func_77942_o() && this.isValidFile(tag = fileSlot.func_77978_p()) && tag.func_74762_e("Device") == TEPrecipitationController.deviceCode() && tag.func_74762_e("Recipe") < this.recipeList().size() && tag.func_74762_e("Done") > 0) {
                    if (this.recipeIndex != tag.func_74762_e("Recipe")) {
                        this.recipeIndex = tag.func_74762_e("Recipe");
                        this.markDirtyClient();
                    }
                    if (this.currentFile == x) break;
                    this.currentFile = x;
                    this.markDirtyClient();
                    break;
                }
                if (x != TEServer.FILE_SLOTS.length - 1) continue;
                this.resetFiles(this.getServer(), TEPrecipitationController.deviceCode());
            }
        }
    }
}

