/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.tile;

import com.globbypotato.rockhounding_core.gas.GasHandlerConcatenate;
import com.globbypotato.rockhounding_core.machines.tileentity.MachineStackHandler;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityPoweredVessel;
import com.globbypotato.rockhounding_core.machines.tileentity.WrappedItemHandler;
import com.globbypotato.rockhounding_core.utils.CoreBasics;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerConcatenate;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TEPowerGenerator
extends TileEntityPoweredVessel {
    public static final int REDSTONE_SLOT = 1;
    public boolean enablePower = false;
    public boolean enableRedstone = false;
    public static int inputSlots = 2;
    public static int templateSlots = 1;

    public TEPowerGenerator() {
        super(inputSlots, 0, templateSlots, 0);
        this.input = new MachineStackHandler(inputSlots, (TileEntityInv)this){

            public ItemStack insertItem(int slot, ItemStack insertingStack, boolean simulate) {
                if (slot == TEPowerGenerator.this.fuelID() && TEPowerGenerator.this.isGatedPowerSource(insertingStack)) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                if (slot == 1 && TEPowerGenerator.this.hasRedstone(insertingStack)) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                return insertingStack;
            }
        };
        this.automationInput = new WrappedItemHandler((IItemHandlerModifiable)this.input, WrappedItemHandler.WriteMode.IN);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.enablePower = compound.func_74767_n("EnablePower");
        this.enableRedstone = compound.func_74767_n("EnableRedstone");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("EnablePower", this.enablePower());
        compound.func_74757_a("EnableRedstone", this.enableRedstone());
        return compound;
    }

    public FluidHandlerConcatenate getCombinedTank() {
        return new FluidHandlerConcatenate(new IFluidHandler[]{this.lavaTank});
    }

    public GasHandlerConcatenate getCombinedGasTank() {
        return new GasHandlerConcatenate(new IFluidHandler[]{this.gasTank});
    }

    public ItemStack fuelSlot() {
        return this.input.getStackInSlot(this.fuelID());
    }

    public ItemStack redstoneSlot() {
        return this.input.getStackInSlot(1);
    }

    public int fuelID() {
        return 0;
    }

    public int getGUIHeight() {
        return 200;
    }

    public static String getName() {
        return "power_generator";
    }

    public boolean isRFGatedByBlend() {
        return true;
    }

    public boolean hasRF() {
        return true;
    }

    public boolean isComparatorSensible() {
        return false;
    }

    public boolean enablePower() {
        return this.enablePower;
    }

    public boolean enableRedstone() {
        return this.enableRedstone;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.debuffEnergy();
            this.handlePowerSupplies();
            if (this.enableRedstone()) {
                this.handleRedstoneSupplies();
            }
            if (this.isActive()) {
                this.provideEnergy();
                this.markDirtyClient();
            }
        }
    }

    private void debuffEnergy() {
        int energyReceived;
        if (!this.isFullRedstone() && this.storage.extractEnergy(energyReceived = Math.min(this.getRedstoneMax() - this.getRedstone(), this.storage.getEnergyStored()), true) > 0) {
            this.redstoneCount += this.storage.extractEnergy(energyReceived, false);
            this.markDirtyClient();
        }
    }

    private void handlePowerSupplies() {
        if (!this.fuelSlot().func_190926_b()) {
            if (this.fuelSlot().func_77969_a(CoreBasics.heat_inductor)) {
                this.powerHandler(this.fuelSlot());
                if (this.enablePower()) {
                    this.injectFuel();
                }
                this.markDirtyClient();
            } else if (this.enablePower()) {
                this.fuelHandler(this.fuelSlot());
            }
        }
        if (this.enablePower() && this.isInductionActive()) {
            this.injectFuel();
        }
        this.lavaHandler();
        this.gasHandler();
    }

    private void handleRedstoneSupplies() {
        if (!this.isFullRedstone()) {
            if (!this.redstoneSlot().func_190926_b()) {
                if (this.redstoneSlot().func_77973_b() == Item.func_150898_a((Block)Blocks.field_150451_bX) || this.redstoneSlot().func_77973_b() == Items.field_151137_ax) {
                    this.redstoneHandler(1, this.getRFConsume());
                    this.markDirtyClient();
                }
                if (this.redstoneSlot().func_77969_a(CoreBasics.gas_turbine)) {
                    this.turbineHandler(this.redstoneSlot());
                    this.markDirtyClient();
                }
            } else {
                this.injectEnergy();
            }
        }
    }

    private void provideEnergy() {
        TileEntity checkTile;
        if (this.getRedstone() > 0 && (checkTile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.getFacing()))) != null) {
            this.sendEnergy(checkTile, this.getFacing());
        }
    }
}

