/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.tile;

import com.globbypotato.rockhounding_chemistry.machines.PipelineDuct;
import com.globbypotato.rockhounding_chemistry.machines.PipelineValve;
import com.globbypotato.rockhounding_core.machines.tileentity.TemplateStackHandler;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TEPipelineValve
extends TileEntityInv {
    private ItemStackHandler template = new TemplateStackHandler(13);
    public boolean[] sideStatus = new boolean[]{true, true, true, true, true, true};
    public boolean[] tiltStatus = new boolean[]{false, false, false, false, false, false};
    public FluidStack[] sideFilter = new FluidStack[]{null, null, null, null, null, null};
    public boolean activation;
    public boolean robin;

    public TEPipelineValve() {
        super(0, 0, 0, 0);
    }

    public ItemStackHandler getTemplate() {
        return this.template;
    }

    public int getGUIHeight() {
        return 200;
    }

    public static String getName() {
        return "pipeline_valve";
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.activation = compound.func_74767_n("Activation");
        this.robin = compound.func_74767_n("Robin");
        NBTTagCompound lockList = compound.func_74775_l("Locks");
        for (int i = 0; i < lockList.func_186856_d(); ++i) {
            this.sideStatus[i] = lockList.func_74767_n("Lock" + i);
        }
        NBTTagCompound tiltList = compound.func_74775_l("Tilts");
        for (int i = 0; i < tiltList.func_186856_d(); ++i) {
            this.tiltStatus[i] = tiltList.func_74767_n("Tilt" + i);
        }
        NBTTagList nbttaglist = compound.func_150295_c("Filters", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            byte j = nbttagcompound.func_74771_c("Side");
            if (j < 0 || j >= this.sideFilter.length) continue;
            this.sideFilter[j] = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbttagcompound);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("Activation", this.isActive());
        compound.func_74757_a("Robin", this.hasRoundRobin());
        NBTTagCompound lockList = new NBTTagCompound();
        for (int i = 0; i < this.sideStatus.length; ++i) {
            lockList.func_74757_a("Lock" + i, this.sideStatus[i]);
        }
        compound.func_74782_a("Locks", (NBTBase)lockList);
        NBTTagCompound tiltList = new NBTTagCompound();
        for (int i = 0; i < this.tiltStatus.length; ++i) {
            tiltList.func_74757_a("Tilt" + i, this.tiltStatus[i]);
        }
        compound.func_74782_a("Tilts", (NBTBase)tiltList);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.sideFilter.length; ++i) {
            if (this.sideFilter[i] == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Side", (byte)i);
            this.sideFilter[i].writeToNBT(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("Filters", (NBTBase)nbttaglist);
        return compound;
    }

    public boolean isActive() {
        return this.activation;
    }

    public boolean hasRoundRobin() {
        return this.robin;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            for (EnumFacing facing : EnumFacing.values()) {
                BlockPos checkPos = this.field_174879_c.func_177972_a(facing);
                IBlockState checkState = this.field_145850_b.func_180495_p(checkPos);
                TileEntity checkTile = this.field_145850_b.func_175625_s(checkPos);
                if (checkState == null) continue;
                if (TEPipelineValve.isInternalPump(checkState) || TEPipelineValve.isInternalPipe(checkState) || TEPipelineValve.isAnyBlock(checkState) && !TEPipelineValve.hasCapability(checkTile, facing)) {
                    if (this.tiltStatus[facing.ordinal()]) continue;
                    this.tiltStatus[facing.ordinal()] = true;
                    continue;
                }
                if (!this.tiltStatus[facing.ordinal()]) continue;
                this.tiltStatus[facing.ordinal()] = false;
            }
            this.markDirtyClient();
        }
    }

    private static boolean isAnyBlock(IBlockState checkState) {
        return checkState.func_177230_c() != Blocks.field_150350_a;
    }

    private static boolean hasCapability(TileEntity checkTile, EnumFacing facing) {
        return checkTile != null && checkTile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing);
    }

    private static boolean isInternalPipe(IBlockState checkState) {
        return checkState.func_177230_c() instanceof PipelineDuct;
    }

    private static boolean isInternalPump(IBlockState checkState) {
        return checkState.func_177230_c() instanceof PipelineValve;
    }
}

