/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.tile;

import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TEParticulateCollector
extends TileEntityInv {
    public static int outputSlots = 2;
    public static int templateSlots = 2;
    public static final int PRIMARY_SLAG = 0;
    public static final int SECONDARY_SLAG = 1;
    public static final int PRIMARY_PREVIEW = 0;
    public static final int SECONDARY_PREVIEW = 1;
    public int primaryCount;
    public int secondaryCount;

    public TEParticulateCollector() {
        super(0, outputSlots, templateSlots, 0);
    }

    public ItemStack primSlot() {
        return this.output.getStackInSlot(0);
    }

    public ItemStack secoSlot() {
        return this.output.getStackInSlot(1);
    }

    public ItemStack primTempSlot() {
        return this.template.getStackInSlot(0);
    }

    public ItemStack secoTempSlot() {
        return this.template.getStackInSlot(1);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.primaryCount = compound.func_74762_e("PrimaryCount");
        this.secondaryCount = compound.func_74762_e("SecondaryCount");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("PrimaryCount", this.getPrimaryCount());
        compound.func_74768_a("SecondaryCount", this.getSecondaryCount());
        return compound;
    }

    public int getGUIHeight() {
        return 200;
    }

    public static String getName() {
        return "particulate_collector";
    }

    public int getPrimaryCount() {
        return this.primaryCount;
    }

    public int getSecondaryCount() {
        return this.secondaryCount;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.handleSlag();
        }
    }

    private void handleSlag() {
        if (this.getPrimaryCount() >= 100 && !this.template.getStackInSlot(0).func_190926_b() && this.output.canSetOrStack(this.primSlot(), this.template.getStackInSlot(0).func_77946_l())) {
            this.output.setOrStack(0, this.template.getStackInSlot(0).func_77946_l());
            this.primaryCount -= 100;
            this.markDirtyClient();
        }
        if (this.getSecondaryCount() >= 100 && !this.template.getStackInSlot(1).func_190926_b() && this.output.canSetOrStack(this.secoSlot(), this.template.getStackInSlot(1).func_77946_l())) {
            this.output.setOrStack(1, this.template.getStackInSlot(1).func_77946_l());
            this.secondaryCount -= 100;
            this.markDirtyClient();
        }
    }

    public void handlePreview(boolean hasMainSlag, ItemStack getMainSlag, boolean hasAltSlag, ItemStack getAltSlag) {
        boolean flag = false;
        if (hasMainSlag) {
            if (this.primTempSlot().func_190926_b() || !this.primTempSlot().func_77969_a(getMainSlag)) {
                this.template.setStackInSlot(0, getMainSlag.func_77946_l());
                this.primTempSlot().func_190920_e(1);
                flag = true;
            }
        } else if (!this.primTempSlot().func_190926_b() && this.getPrimaryCount() < 1) {
            this.template.setStackInSlot(0, ItemStack.field_190927_a);
            this.primaryCount = 0;
            flag = true;
        }
        if (hasAltSlag) {
            if (this.secoTempSlot().func_190926_b() || !this.secoTempSlot().func_77969_a(getAltSlag)) {
                this.template.setStackInSlot(1, getAltSlag.func_77946_l());
                this.secoTempSlot().func_190920_e(1);
                flag = true;
            }
        } else if (!this.secoTempSlot().func_190926_b() && this.getSecondaryCount() < 1) {
            this.template.setStackInSlot(1, ItemStack.field_190927_a);
            this.secondaryCount = 0;
            flag = true;
        }
        if (flag) {
            this.markDirtyClient();
        }
    }

    public void handleParticulate(boolean hasMainSlag, int main_slag, boolean hasAltSlag, int secondary_slag) {
        if (hasMainSlag && this.rand.nextInt(100) < main_slag) {
            this.primaryCount += this.rand.nextInt(10) + 1;
            this.markDirtyClient();
        }
        if (hasAltSlag && this.rand.nextInt(100) < secondary_slag) {
            this.secondaryCount += this.rand.nextInt(5) + 1;
            this.markDirtyClient();
        }
    }
}

