/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.tile;

import com.globbypotato.rockhounding_chemistry.enums.materials.EnumAirGases;
import com.globbypotato.rockhounding_chemistry.enums.materials.EnumFluid;
import com.globbypotato.rockhounding_chemistry.handlers.ModConfig;
import com.globbypotato.rockhounding_chemistry.machines.recipe.GanPlantRecipes;
import com.globbypotato.rockhounding_chemistry.machines.tile.ICollapse;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEGaslinePump;
import com.globbypotato.rockhounding_core.gas.GasHandlerConcatenate;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityVessel;
import java.util.ArrayList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TEMultivessel
extends TileEntityVessel
implements ICollapse {
    public static int templateSlots = 12;
    public FluidTank tank_Ar;
    public FluidTank tank_CO;
    public FluidTank tank_Ne;
    public FluidTank tank_He;
    public FluidTank tank_Kr;
    public FluidTank tank_Xe;
    public boolean[] drainValve = new boolean[6];
    public boolean[] rareEnabler = new boolean[]{true, true, true, true, true, true};
    public int collapseRate = 0;

    public TEMultivessel() {
        super(0, 0, templateSlots, 0);
        this.tank_Ar = new FluidTank(1000){

            public boolean canFillFluidType(FluidStack gas) {
                return TEMultivessel.this.isValidGas(TEMultivessel.this.tank_Ar, gas, EnumFluid.pickFluid(EnumFluid.ARGON));
            }

            public boolean canDrainFluidType(FluidStack gas) {
                return TEMultivessel.this.canDrainGas(0, TEMultivessel.this.tank_Ar);
            }
        };
        this.tank_Ar.setTileEntity((TileEntity)this);
        this.tank_CO = new FluidTank(1000){

            public boolean canFillFluidType(FluidStack gas) {
                return TEMultivessel.this.isValidGas(TEMultivessel.this.tank_CO, gas, EnumFluid.pickFluid(EnumFluid.CARBON_DIOXIDE));
            }

            public boolean canDrainFluidType(FluidStack gas) {
                return TEMultivessel.this.canDrainGas(1, TEMultivessel.this.tank_CO);
            }
        };
        this.tank_CO.setTileEntity((TileEntity)this);
        this.tank_Ne = new FluidTank(1000){

            public boolean canFillFluidType(FluidStack gas) {
                return TEMultivessel.this.isValidGas(TEMultivessel.this.tank_Ne, gas, EnumFluid.pickFluid(EnumFluid.NEON));
            }

            public boolean canDrainFluidType(FluidStack gas) {
                return TEMultivessel.this.canDrainGas(2, TEMultivessel.this.tank_Ne);
            }
        };
        this.tank_Ne.setTileEntity((TileEntity)this);
        this.tank_He = new FluidTank(1000){

            public boolean canFillFluidType(FluidStack gas) {
                return TEMultivessel.this.isValidGas(TEMultivessel.this.tank_He, gas, EnumFluid.pickFluid(EnumFluid.HELIUM));
            }

            public boolean canDrainFluidType(FluidStack gas) {
                return TEMultivessel.this.canDrainGas(3, TEMultivessel.this.tank_He);
            }
        };
        this.tank_He.setTileEntity((TileEntity)this);
        this.tank_Kr = new FluidTank(1000){

            public boolean canFillFluidType(FluidStack gas) {
                return TEMultivessel.this.isValidGas(TEMultivessel.this.tank_Kr, gas, EnumFluid.pickFluid(EnumFluid.KRYPTON));
            }

            public boolean canDrainFluidType(FluidStack gas) {
                return TEMultivessel.this.canDrainGas(4, TEMultivessel.this.tank_Kr);
            }
        };
        this.tank_Kr.setTileEntity((TileEntity)this);
        this.tank_Xe = new FluidTank(1000){

            public boolean canFillFluidType(FluidStack gas) {
                return TEMultivessel.this.isValidGas(TEMultivessel.this.tank_Xe, gas, EnumFluid.pickFluid(EnumFluid.XENON));
            }

            public boolean canDrainFluidType(FluidStack gas) {
                return TEMultivessel.this.canDrainGas(5, TEMultivessel.this.tank_Xe);
            }
        };
        this.tank_Xe.setTileEntity((TileEntity)this);
        this.markDirtyClient();
    }

    public GasHandlerConcatenate getCombinedGasTank() {
        return new GasHandlerConcatenate(new IFluidHandler[]{this.tank_Xe, this.tank_Kr, this.tank_He, this.tank_Ne, this.tank_CO, this.tank_Ar});
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.tank_Ar.readFromNBT(compound.func_74775_l("Tank_Ar"));
        this.tank_CO.readFromNBT(compound.func_74775_l("Tank_CO"));
        this.tank_Ne.readFromNBT(compound.func_74775_l("Tank_Ne"));
        this.tank_He.readFromNBT(compound.func_74775_l("Tank_He"));
        this.tank_Kr.readFromNBT(compound.func_74775_l("Tank_Kr"));
        this.tank_Xe.readFromNBT(compound.func_74775_l("Tank_Xe"));
        NBTTagCompound drainList = compound.func_74775_l("Drains");
        for (int i = 0; i < drainList.func_186856_d(); ++i) {
            this.drainValve[i] = drainList.func_74767_n("Drain" + i);
        }
        NBTTagCompound enableList = compound.func_74775_l("Enablers");
        for (int i = 0; i < enableList.func_186856_d(); ++i) {
            this.rareEnabler[i] = !GanPlantRecipes.inhibited_gases.contains(EnumAirGases.name(i)) ? enableList.func_74767_n("Enabler" + i) : false;
        }
        this.collapseRate = compound.func_74762_e("Collapse");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        NBTTagCompound tank_Ar = new NBTTagCompound();
        this.tank_Ar.writeToNBT(tank_Ar);
        compound.func_74782_a("Tank_Ar", (NBTBase)tank_Ar);
        NBTTagCompound tank_CO = new NBTTagCompound();
        this.tank_CO.writeToNBT(tank_CO);
        compound.func_74782_a("Tank_CO", (NBTBase)tank_CO);
        NBTTagCompound tank_Ne = new NBTTagCompound();
        this.tank_Ne.writeToNBT(tank_Ne);
        compound.func_74782_a("Tank_Ne", (NBTBase)tank_Ne);
        NBTTagCompound tank_He = new NBTTagCompound();
        this.tank_He.writeToNBT(tank_He);
        compound.func_74782_a("Tank_He", (NBTBase)tank_He);
        NBTTagCompound tank_Kr = new NBTTagCompound();
        this.tank_Kr.writeToNBT(tank_Kr);
        compound.func_74782_a("Tank_Kr", (NBTBase)tank_Kr);
        NBTTagCompound tank_Xe = new NBTTagCompound();
        this.tank_Xe.writeToNBT(tank_Xe);
        compound.func_74782_a("Tank_Xe", (NBTBase)tank_Xe);
        NBTTagCompound drainList = new NBTTagCompound();
        for (int i = 0; i < this.drainValve.length; ++i) {
            drainList.func_74757_a("Drain" + i, this.drainValve[i]);
        }
        compound.func_74782_a("Drains", (NBTBase)drainList);
        NBTTagCompound enableList = new NBTTagCompound();
        for (int i = 0; i < this.rareEnabler.length; ++i) {
            enableList.func_74757_a("Enabler" + i, this.rareEnabler[i]);
        }
        compound.func_74782_a("Enablers", (NBTBase)enableList);
        compound.func_74768_a("Collapse", this.getCollapse());
        return compound;
    }

    public int getGUIHeight() {
        return 200;
    }

    public static String getName() {
        return "multivessel";
    }

    public int getCollapse() {
        return this.collapseRate;
    }

    @Override
    public ArrayList<FluidTank> collapseList() {
        ArrayList<FluidTank> tanks = new ArrayList<FluidTank>();
        tanks.add(this.tank_Ar);
        tanks.add(this.tank_CO);
        tanks.add(this.tank_Ne);
        tanks.add(this.tank_He);
        tanks.add(this.tank_Kr);
        tanks.add(this.tank_Xe);
        return tanks;
    }

    public boolean has_Ar() {
        return this.tank_Ar.getFluid() != null && this.tank_Ar.getFluidAmount() > 0;
    }

    public boolean has_CO() {
        return this.tank_CO.getFluid() != null && this.tank_CO.getFluidAmount() > 0;
    }

    public boolean has_Ne() {
        return this.tank_Ne.getFluid() != null && this.tank_Ne.getFluidAmount() > 0;
    }

    public boolean has_He() {
        return this.tank_He.getFluid() != null && this.tank_He.getFluidAmount() > 0;
    }

    public boolean has_Kr() {
        return this.tank_Kr.getFluid() != null && this.tank_Kr.getFluidAmount() > 0;
    }

    public boolean has_Xe() {
        return this.tank_Xe.getFluid() != null && this.tank_Xe.getFluidAmount() > 0;
    }

    public boolean isValidGas(FluidTank tank, FluidStack gas, Fluid fluid) {
        return gas.getFluid().isGaseous() && gas.getFluid().equals(fluid) && this.canAddGas(tank, gas);
    }

    private boolean canAddGas(FluidTank tank, FluidStack gas) {
        return this.input.canSetOrAddFluid(tank, tank.getFluid(), gas, 1);
    }

    public boolean canDrainGas(int i, FluidTank tank) {
        return this.isValidPump() && this.drainValve[i] && tank.getFluidAmount() > 0;
    }

    public boolean isValidPump() {
        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.getFacing()));
        if (tile != null && tile instanceof TEGaslinePump) {
            TEGaslinePump pump = (TEGaslinePump)tile;
            return pump.isActive();
        }
        return false;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.checkCollapse();
            this.markDirtyClient();
        }
    }

    public void checkCollapse() {
        if (ModConfig.enableHazard && this.field_145850_b.field_73012_v.nextInt(ModConfig.hazardChance) == 0) {
            if (this.handleCollapse(this.getCollapse(), this.field_145850_b, this.field_174879_c)) {
                ++this.collapseRate;
                if (this.getCollapse() >= ModConfig.pressureTolerance) {
                    if (this.hasExhaust(this.field_145850_b, this.field_174879_c, 1)) {
                        this.doExhaustion(this.field_145850_b, this.field_174879_c, 1);
                        this.collapseRate /= 2;
                    } else {
                        this.field_145850_b.func_72876_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 2.0f, true);
                    }
                }
            } else if (this.handleRelease(this.getCollapse(), this.field_145850_b, this.field_174879_c) && this.getCollapse() > 0) {
                --this.collapseRate;
            }
        }
    }
}

