/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.tile;

import com.globbypotato.rockhounding_chemistry.ModItems;
import com.globbypotato.rockhounding_chemistry.enums.EnumMiscItems;
import com.globbypotato.rockhounding_chemistry.enums.utils.EnumServer;
import com.globbypotato.rockhounding_chemistry.handlers.ModConfig;
import com.globbypotato.rockhounding_chemistry.machines.recipe.MineralSizerRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.MineralSizerRecipe;
import com.globbypotato.rockhounding_chemistry.machines.tile.IInternalServer;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEMineralSizerCollector;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEMineralSizerTank;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEPowerGenerator;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEServer;
import com.globbypotato.rockhounding_chemistry.machines.tile.TileStructure;
import com.globbypotato.rockhounding_chemistry.utils.ModUtils;
import com.globbypotato.rockhounding_core.machines.tileentity.MachineStackHandler;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import com.globbypotato.rockhounding_core.machines.tileentity.WrappedItemHandler;
import com.globbypotato.rockhounding_core.utils.CoreUtils;
import java.util.ArrayList;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.oredict.OreDictionary;

public class TEMineralSizerController
extends TileEntityInv
implements IInternalServer {
    public static final int SPEED_SLOT = 0;
    public static final int PURGE_SLOT = 0;
    public static int inputSlots = 1;
    public static int outputSlots = 1;
    public static int templateSlots = 3;
    public static int upgradeSlots = 1;
    public ArrayList<ItemStack> resultList = new ArrayList();
    public int comminution;
    public ItemStack filter = ItemStack.field_190927_a;
    public int currentFile = -1;
    public boolean isRepeatable = false;

    public TEMineralSizerController() {
        super(inputSlots, outputSlots, templateSlots, upgradeSlots);
        this.input = new MachineStackHandler(inputSlots, this){

            public ItemStack insertItem(int slot, ItemStack insertingStack, boolean simulate) {
                if (slot == 0 && TEMineralSizerController.this.isValidInput(insertingStack)) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                return insertingStack;
            }
        };
        this.automationInput = new WrappedItemHandler((IItemHandlerModifiable)this.input, WrappedItemHandler.WriteMode.IN);
        this.upgrade = new MachineStackHandler(upgradeSlots, this){

            public ItemStack insertItem(int slot, ItemStack insertingStack, boolean simulate) {
                if (slot == 0 && ModUtils.isValidSpeedUpgrade(insertingStack)) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                return insertingStack;
            }
        };
        this.automationUpgrade = new WrappedItemHandler((IItemHandlerModifiable)this.upgrade, WrappedItemHandler.WriteMode.IN);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.comminution = compound.func_74762_e("Comminution");
        if (compound.func_74764_b("Filter")) {
            this.filter = new ItemStack(compound.func_74775_l("Filter"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("Comminution", this.getComminution());
        if (!this.getFilter().func_190926_b()) {
            NBTTagCompound filterstack = new NBTTagCompound();
            this.filter.func_77955_b(filterstack);
            compound.func_74782_a("Filter", (NBTBase)filterstack);
        }
        return compound;
    }

    public ItemStack inputSlot() {
        return this.input.getStackInSlot(0);
    }

    public ItemStack speedSlot() {
        return this.upgrade.getStackInSlot(0);
    }

    public ItemStack purgeSlot() {
        return this.output.getStackInSlot(0);
    }

    public ItemStackHandler getTemplate() {
        return this.template;
    }

    public int getGUIHeight() {
        return 200;
    }

    public static String getName() {
        return "mineral_sizer_controller";
    }

    public int baseSpeed() {
        return ModConfig.speedSizer + this.getComminution() * this.comminutionFactor();
    }

    public int speedFactor() {
        return ModUtils.isValidSpeedUpgrade(this.speedSlot()) ? ModUtils.speedUpgrade(this.speedSlot()) : 1;
    }

    public int getCooktimeMax() {
        return ModUtils.isValidSpeedUpgrade(this.speedSlot()) ? this.baseSpeed() / ModUtils.speedUpgrade(this.speedSlot()) : this.baseSpeed();
    }

    public int comminutionFactor() {
        return 40;
    }

    private static int sizedQuantity() {
        return ModConfig.maxSizeable > 0 ? ModConfig.maxSizeable : 1;
    }

    private static int deviceCode() {
        return EnumServer.SIZER.ordinal();
    }

    public EnumFacing poweredFacing() {
        return EnumFacing.func_176733_a((double)(this.getFacing().func_185119_l() + 270.0f));
    }

    public ArrayList<MineralSizerRecipe> recipeList() {
        return MineralSizerRecipes.mineral_sizer_recipes;
    }

    public MineralSizerRecipe getRecipeList(int x) {
        return this.recipeList().get(x);
    }

    boolean isValidInput(ItemStack stack) {
        if (!stack.func_190926_b()) {
            if (!this.getFilter().func_190926_b()) {
                if (this.getFilter().func_77969_a(stack)) {
                    return true;
                }
            } else {
                for (MineralSizerRecipe recipe : this.recipeList()) {
                    ArrayList inputOreIDs;
                    if (!(recipe.getType() ? !(inputOreIDs = CoreUtils.intArrayToList((int[])OreDictionary.getOreIDs((ItemStack)stack))).isEmpty() && inputOreIDs.contains(OreDictionary.getOreID((String)recipe.getOredict())) : recipe.getInput().func_77969_a(stack))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public MineralSizerRecipe getCurrentRecipe() {
        if (!this.inputSlot().func_190926_b()) {
            for (int x = 0; x < this.recipeList().size(); ++x) {
                ArrayList inputOreIDs = CoreUtils.intArrayToList((int[])OreDictionary.getOreIDs((ItemStack)this.inputSlot()));
                if (!(this.getRecipeList(x).getType() ? inputOreIDs.contains(OreDictionary.getOreID((String)this.getRecipeList(x).getOredict())) : this.getRecipeList(x).getInput().func_77969_a(this.inputSlot()))) continue;
                return this.getRecipeList(x);
            }
        }
        return null;
    }

    public boolean isValidRecipe() {
        return this.getCurrentRecipe() != null;
    }

    public ArrayList<ItemStack> recipeOutput() {
        return this.isValidRecipe() ? this.getCurrentRecipe().getOutput() : null;
    }

    public ArrayList<Integer> recipeComminution() {
        return this.isValidRecipe() ? this.getCurrentRecipe().getComminution() : null;
    }

    public int getComminution() {
        return this.comminution;
    }

    public ItemStack getFilter() {
        return this.filter;
    }

    public BlockPos tankPosA() {
        return this.field_174879_c.func_177967_a(this.getFacing(), 1);
    }

    public TEMineralSizerTank getTankA() {
        TileEntity te = this.field_145850_b.func_175625_s(this.tankPosA());
        if (this.field_145850_b.func_180495_p(this.tankPosA()) != null && te instanceof TEMineralSizerTank) {
            TEMineralSizerTank tank = (TEMineralSizerTank)te;
            if (this.getFacing() == tank.getFacing() || this.getFacing() == tank.getFacing().func_176734_d()) {
                return tank;
            }
        }
        return null;
    }

    public boolean hasTankA() {
        return this.getTankA() != null;
    }

    public boolean hasConsumablesA() {
        return this.hasTankA() ? this.getTankA().hasConsumables() : false;
    }

    public BlockPos tankPosB() {
        return this.field_174879_c.func_177967_a(this.getFacing(), 2);
    }

    public TEMineralSizerTank getTankB() {
        TileEntity te = this.field_145850_b.func_175625_s(this.tankPosB());
        if (this.field_145850_b.func_180495_p(this.tankPosB()) != null && te instanceof TEMineralSizerTank) {
            TEMineralSizerTank tank = (TEMineralSizerTank)te;
            if (this.getFacing() == tank.getFacing() || this.getFacing() == tank.getFacing().func_176734_d()) {
                return tank;
            }
        }
        return null;
    }

    public boolean hasTankB() {
        return this.getTankB() != null;
    }

    public boolean hasConsumablesB() {
        return this.hasTankB() ? this.getTankB().hasConsumables() : false;
    }

    public boolean hasFullTank() {
        return this.hasTankA() && this.hasTankB();
    }

    public boolean hasConsumables() {
        return this.hasConsumablesA() && this.hasConsumablesB();
    }

    public TEPowerGenerator getEngine() {
        TEPowerGenerator engine = TileStructure.getEngine(this.field_145850_b, this.field_174879_c, this.getFacing(), 4, 0);
        return engine != null ? engine : null;
    }

    public boolean hasEngine() {
        return this.getEngine() != null;
    }

    public boolean hasFuelPower() {
        return this.hasEngine() ? this.getEngine().getPower() >= this.getCooktimeMax() : false;
    }

    private void drainPower() {
        --this.getEngine().powerCount;
        this.getEngine().markDirtyClient();
    }

    public BlockPos collectorPos() {
        return this.field_174879_c.func_177967_a(this.getFacing(), 3);
    }

    public TEMineralSizerCollector getCollector() {
        TEMineralSizerCollector collector;
        TileEntity te = this.field_145850_b.func_175625_s(this.collectorPos());
        if (this.field_145850_b.func_180495_p(this.collectorPos()) != null && te instanceof TEMineralSizerCollector && (collector = (TEMineralSizerCollector)te).getFacing() == this.getFacing()) {
            return collector;
        }
        return null;
    }

    public boolean hasCollector() {
        return this.getCollector() != null;
    }

    public boolean isOutputEmpty() {
        return this.hasCollector() ? this.slotEmpty(0) && this.slotEmpty(1) && this.slotEmpty(2) : false;
    }

    private boolean slotEmpty(int i) {
        return this.getCollector().getOutput().getStackInSlot(i).func_190926_b();
    }

    public TEServer getServer() {
        TEServer server = TileStructure.getServer(this.field_145850_b, this.field_174879_c, this.isFacingAt(90), 1, 0);
        return server != null ? server : null;
    }

    public boolean hasServer() {
        return this.getServer() != null;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.doPreset();
            this.initializeServer(this.isRepeatable, this.hasServer(), this.getServer(), TEMineralSizerController.deviceCode());
            this.handlePurge();
            if (this.isActive()) {
                if (this.canProcess()) {
                    ++this.cooktime;
                    this.drainPower();
                    this.activateTank();
                    if (this.getCooktime() >= this.getCooktimeMax()) {
                        this.cooktime = 0;
                        this.process();
                        this.disableTank();
                    }
                    this.markDirtyClient();
                } else {
                    this.tickOff();
                }
            } else {
                this.tickOff();
            }
        }
    }

    public void tickOff() {
        if (this.getCooktime() > 0) {
            this.cooktime = 0;
            this.disableTank();
            this.markDirtyClient();
        }
    }

    private void handlePurge() {
        if (this.isActive() && !this.inputSlot().func_190926_b() && !this.getFilter().func_190926_b() && !CoreUtils.isMatchingIngredient((ItemStack)this.inputSlot(), (ItemStack)this.getFilter()) && this.output.canSetOrStack(this.purgeSlot(), this.inputSlot())) {
            this.output.setOrStack(0, this.inputSlot());
            this.input.setStackInSlot(0, ItemStack.field_190927_a);
        }
    }

    private void doPreset() {
        if (this.hasEngine()) {
            if (!this.getEngine().enablePower) {
                this.getEngine().enablePower = true;
                this.getEngine().markDirtyClient();
            }
            if (this.getEngine().enableRedstone) {
                this.getEngine().enableRedstone = false;
                this.getEngine().markDirtyClient();
            }
        }
    }

    public void activateTank() {
        if (this.getCooktime() > 0) {
            if (this.hasTankA() && !this.getTankA().isActive()) {
                this.getTankA().activation = true;
                this.getTankA().markDirtyClient();
            }
            if (this.hasTankB() && !this.getTankB().isActive()) {
                this.getTankB().activation = true;
                this.getTankA().markDirtyClient();
            }
        }
    }

    public void disableTank() {
        if (this.hasTankA() && this.getTankA().isActive()) {
            this.getTankA().activation = false;
            this.getTankA().markDirtyClient();
        }
        if (this.hasTankB() && this.getTankB().isActive()) {
            this.getTankB().activation = false;
            this.getTankB().markDirtyClient();
        }
    }

    private boolean canProcess() {
        return this.expectResult() && this.hasConsumables() && this.hasFuelPower() && this.isOutputEmpty() && this.handleFilter(this.inputSlot(), this.getFilter()) && this.handleServer(this.hasServer(), this.getServer(), this.currentFile);
    }

    public void getResult() {
        this.resultList = new ArrayList();
        if (this.isValidRecipe()) {
            for (int stack = 0; stack < this.recipeOutput().size(); ++stack) {
                if (this.recipeComminution().get(stack).intValue() != this.getComminution()) continue;
                this.resultList.add(this.recipeOutput().get(stack));
            }
        }
    }

    public boolean expectResult() {
        if (this.isValidRecipe()) {
            for (int stack = 0; stack < this.recipeOutput().size(); ++stack) {
                if (this.recipeComminution().get(stack).intValue() != this.getComminution()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasResult() {
        this.getResult();
        return this.hasExposed();
    }

    public boolean hasExposed() {
        return this.resultList != null && !this.resultList.isEmpty() && this.resultList.size() > 0;
    }

    public void process() {
        if (this.hasResult()) {
            ((ItemStackHandler)this.getCollector().getOutput()).setStackInSlot(0, this.pickLevelOutput().func_77946_l());
            if (this.recipeOutput().size() > 1) {
                ((ItemStackHandler)this.getCollector().getOutput()).getStackInSlot(0).func_190920_e(TEMineralSizerController.sizedQuantity());
            }
            if (this.resultList.size() > 1 && this.field_145850_b.field_73012_v.nextInt(100) < 25) {
                ((ItemStackHandler)this.getCollector().getOutput()).setStackInSlot(1, this.pickLevelOutput().func_77946_l());
                ((ItemStackHandler)this.getCollector().getOutput()).getStackInSlot(1).func_190920_e(this.rand.nextInt(1 + TEMineralSizerController.sizedQuantity() / 2));
                if (this.field_145850_b.field_73012_v.nextInt(100) < 5) {
                    ((ItemStackHandler)this.getCollector().getOutput()).setStackInSlot(2, this.pickRecipeOutput().func_77946_l());
                    ((ItemStackHandler)this.getCollector().getOutput()).getStackInSlot(2).func_190920_e(1);
                }
            }
            this.handleConsumableDamage();
            this.input.decrementSlot(0);
            this.updateServer(this.hasServer(), this.getServer(), this.currentFile);
        }
    }

    private ItemStack pickLevelOutput() {
        return this.resultList.get(this.rand.nextInt(this.resultList.size()));
    }

    private ItemStack pickRecipeOutput() {
        return this.isValidRecipe() ? this.recipeOutput().get(this.rand.nextInt(this.recipeOutput().size())) : ItemStack.field_190927_a;
    }

    public boolean isRecipeMulti() {
        return !this.resultList.isEmpty() && this.resultList.size() > 1;
    }

    private void handleConsumableDamage() {
        if (this.isValidRecipe()) {
            for (int damage = 0; damage <= this.getComminution(); ++damage) {
                int unbreakingLevel;
                int gearCount = damage / 2;
                if (gearCount < 4) {
                    if (this.getTankA().gearSlot(gearCount).func_190926_b()) continue;
                    unbreakingLevel = CoreUtils.getEnchantmentLevel((Enchantment)Enchantments.field_185307_s, (ItemStack)this.getTankA().gearSlot(gearCount));
                    ((MachineStackHandler)this.getTankA().getInput()).damageUnbreakingSlot(unbreakingLevel, gearCount);
                    continue;
                }
                if (this.getTankB().gearSlot(gearCount - 4).func_190926_b()) continue;
                unbreakingLevel = CoreUtils.getEnchantmentLevel((Enchantment)Enchantments.field_185307_s, (ItemStack)this.getTankB().gearSlot(gearCount - 4));
                ((MachineStackHandler)this.getTankB().getInput()).damageUnbreakingSlot(unbreakingLevel, gearCount - 4);
            }
        }
    }

    @Override
    public void loadServerStatus() {
        this.currentFile = -1;
        if (this.getServer().isActive()) {
            for (int x = 0; x < TEServer.FILE_SLOTS.length; ++x) {
                NBTTagCompound tag;
                ItemStack fileSlot = this.getServer().inputSlot(x).func_77946_l();
                if (!fileSlot.func_190926_b() && fileSlot.func_77969_a(new ItemStack(ModItems.MISC_ITEMS, 1, EnumMiscItems.SERVER_FILE.ordinal())) && fileSlot.func_77942_o() && this.isValidFile(tag = fileSlot.func_77978_p()) && tag.func_74762_e("Device") == TEMineralSizerController.deviceCode() && tag.func_74762_e("Recipe") < 16 && tag.func_74762_e("Done") > 0) {
                    if (this.comminution != tag.func_74762_e("Recipe")) {
                        this.comminution = tag.func_74762_e("Recipe");
                        this.markDirtyClient();
                    }
                    if (this.currentFile != x) {
                        this.currentFile = x;
                        this.markDirtyClient();
                    }
                    if (!tag.func_74764_b("FilterStack")) break;
                    ItemStack temp = new ItemStack(tag.func_74775_l("FilterStack"));
                    if (!this.getFilter().func_190926_b() && this.getFilter().func_77969_a(temp)) break;
                    this.filter = temp;
                    break;
                }
                if (x != TEServer.FILE_SLOTS.length - 1) continue;
                this.resetFiles(this.getServer(), TEMineralSizerController.deviceCode());
            }
        }
    }
}

