/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.tile;

import com.globbypotato.rockhounding_chemistry.handlers.ModConfig;
import com.globbypotato.rockhounding_chemistry.machines.recipe.MaterialCabinetRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.MaterialCabinetRecipe;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEMaterialCabinetBase;
import com.globbypotato.rockhounding_chemistry.utils.BaseRecipes;
import com.globbypotato.rockhounding_core.machines.tileentity.MachineStackHandler;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import com.globbypotato.rockhounding_core.machines.tileentity.WrappedItemHandler;
import com.globbypotato.rockhounding_core.utils.CoreUtils;
import java.util.ArrayList;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.oredict.OreDictionary;

public class TEMaterialCabinetTop
extends TileEntityInv {
    public static int inputSlots = 2;
    public static final int CYLINDER_SLOT = 1;

    public TEMaterialCabinetTop() {
        super(inputSlots, 0, 0, 0);
        this.input = new MachineStackHandler(inputSlots, this){

            public ItemStack insertItem(int slot, ItemStack insertingStack, boolean simulate) {
                if (slot == 0 && TEMaterialCabinetTop.this.isValidOredict(insertingStack)) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                if (slot == 1 && CoreUtils.hasConsumable((ItemStack)BaseRecipes.graduated_cylinder, (ItemStack)insertingStack)) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                return insertingStack;
            }
        };
        this.automationInput = new WrappedItemHandler((IItemHandlerModifiable)this.input, WrappedItemHandler.WriteMode.IN);
    }

    public ItemStack inputSlot() {
        return this.input.getStackInSlot(0);
    }

    public ItemStack cylinderSlot() {
        return this.input.getStackInSlot(1);
    }

    public int getGUIHeight() {
        return 200;
    }

    public static String getName() {
        return "material_cabinet_top";
    }

    public TEMaterialCabinetBase getCollector() {
        TEMaterialCabinetBase collector;
        BlockPos cabinetPos = this.field_174879_c.func_177972_a(EnumFacing.DOWN);
        TileEntity te = this.field_145850_b.func_175625_s(cabinetPos);
        if (this.field_145850_b.func_180495_p(cabinetPos) != null && te instanceof TEMaterialCabinetBase && (collector = (TEMaterialCabinetBase)te).getFacing() == this.getFacing()) {
            return collector;
        }
        return null;
    }

    public boolean hasCollector() {
        return this.getCollector() != null;
    }

    public boolean isValidOredict(ItemStack insertingStack) {
        ArrayList inputIDs;
        if (this.hasCollector() && !insertingStack.func_190926_b() && !(inputIDs = CoreUtils.intArrayToList((int[])OreDictionary.getOreIDs((ItemStack)insertingStack))).isEmpty() && inputIDs.size() > 0) {
            for (Integer input : inputIDs) {
                String inputDict = OreDictionary.getOreName((int)input);
                for (int x = 0; x < TEMaterialCabinetTop.recipeList().size(); ++x) {
                    if (!inputDict.matches(TEMaterialCabinetTop.getRecipeList(x).getOredict()) || this.getCollector().elementList[x] > ModConfig.extractorCap - ModConfig.extractorFactor) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean hasCylinder() {
        return !this.cylinderSlot().func_190926_b() && CoreUtils.hasConsumable((ItemStack)BaseRecipes.graduated_cylinder, (ItemStack)this.cylinderSlot());
    }

    public void isMatchingOredict() {
        ArrayList inputIDs;
        if (this.hasCollector() && this.hasCylinder() && !this.inputSlot().func_190926_b() && !(inputIDs = CoreUtils.intArrayToList((int[])OreDictionary.getOreIDs((ItemStack)this.inputSlot()))).isEmpty() && inputIDs.size() > 0) {
            for (Integer input : inputIDs) {
                String inputDict = OreDictionary.getOreName((int)input);
                for (int x = 0; x < TEMaterialCabinetTop.recipeList().size(); ++x) {
                    if (!inputDict.matches(TEMaterialCabinetTop.getRecipeList(x).getOredict()) || this.getCollector().elementList[x] > ModConfig.extractorCap - ModConfig.extractorFactor) continue;
                    int n = x;
                    this.getCollector().elementList[n] = this.getCollector().elementList[n] + ModConfig.extractorFactor;
                    int unbreakingLevel = CoreUtils.getEnchantmentLevel((Enchantment)Enchantments.field_185307_s, (ItemStack)this.cylinderSlot());
                    this.input.damageUnbreakingSlot(unbreakingLevel, 1);
                    this.input.decrementSlot(0);
                    this.getCollector().markDirtyClient();
                }
            }
        }
    }

    public static ArrayList<MaterialCabinetRecipe> recipeList() {
        return MaterialCabinetRecipes.material_cabinet_recipes;
    }

    public static MaterialCabinetRecipe getRecipeList(int x) {
        return TEMaterialCabinetTop.recipeList().get(x);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && !this.inputSlot().func_190926_b()) {
            this.isMatchingOredict();
        }
    }
}

