/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.tile;

import com.globbypotato.rockhounding_chemistry.ModItems;
import com.globbypotato.rockhounding_chemistry.enums.EnumMiscBlocksA;
import com.globbypotato.rockhounding_chemistry.enums.EnumMiscItems;
import com.globbypotato.rockhounding_chemistry.enums.utils.EnumServer;
import com.globbypotato.rockhounding_chemistry.handlers.ModConfig;
import com.globbypotato.rockhounding_chemistry.machines.io.MachineIO;
import com.globbypotato.rockhounding_chemistry.machines.recipe.LabOvenRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.LabOvenRecipe;
import com.globbypotato.rockhounding_chemistry.machines.tile.IInternalServer;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEFluidInputTank;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEFluidOutputTank;
import com.globbypotato.rockhounding_chemistry.machines.tile.TELabOvenChamber;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEPowerGenerator;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEServer;
import com.globbypotato.rockhounding_chemistry.machines.tile.TileStructure;
import com.globbypotato.rockhounding_chemistry.utils.ModUtils;
import com.globbypotato.rockhounding_core.machines.tileentity.MachineStackHandler;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import com.globbypotato.rockhounding_core.machines.tileentity.WrappedItemHandler;
import com.globbypotato.rockhounding_core.utils.CoreUtils;
import com.google.common.base.Strings;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.oredict.OreDictionary;

public class TELabOvenController
extends TileEntityInv
implements IInternalServer {
    public static int inputSlots = 2;
    public static int outputSlots = 2;
    public static int templateSlots = 3;
    public static int upgradeSlots = 1;
    public static final int SOLUTE_SLOT = 0;
    public static final int CATALYST_SLOT = 1;
    public static final int SOLUTE_OUT_SLOT = 0;
    public static final int CATALYST_OUT_SLOT = 1;
    public static final int SPEED_SLOT = 0;
    public int currentFile = -1;
    public boolean isRepeatable = false;

    public TELabOvenController() {
        super(inputSlots, outputSlots, templateSlots, upgradeSlots);
        this.input = new MachineStackHandler(inputSlots, this){

            public ItemStack insertItem(int slot, ItemStack insertingStack, boolean simulate) {
                if (slot == 0 && TELabOvenController.this.isActive() && TELabOvenController.this.isValidInput(insertingStack)) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                if (slot == 1 && TELabOvenController.this.isActive() && TELabOvenController.this.isValidCatalyst(insertingStack)) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                return insertingStack;
            }
        };
        this.automationInput = new WrappedItemHandler((IItemHandlerModifiable)this.input, WrappedItemHandler.WriteMode.IN);
        this.upgrade = new MachineStackHandler(upgradeSlots, this){

            public ItemStack insertItem(int slot, ItemStack insertingStack, boolean simulate) {
                if (slot == 0 && ModUtils.isValidSpeedUpgrade(insertingStack)) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                return insertingStack;
            }
        };
        this.automationUpgrade = new WrappedItemHandler((IItemHandlerModifiable)this.upgrade, WrappedItemHandler.WriteMode.IN);
    }

    public ItemStack soluteSlot() {
        return this.input.getStackInSlot(0);
    }

    public ItemStack catalystSlot() {
        return this.input.getStackInSlot(1);
    }

    public ItemStack soluteOutSlot() {
        return this.output.getStackInSlot(0);
    }

    public ItemStack catalystOutSlot() {
        return this.output.getStackInSlot(1);
    }

    public ItemStack speedSlot() {
        return this.upgrade.getStackInSlot(0);
    }

    public int getGUIHeight() {
        return 200;
    }

    public static String getName() {
        return "lab_oven_controller";
    }

    public int speedFactor() {
        return ModUtils.isValidSpeedUpgrade(this.speedSlot()) ? ModUtils.speedUpgrade(this.speedSlot()) : 1;
    }

    public int getCooktimeMax() {
        return ModUtils.isValidSpeedUpgrade(this.speedSlot()) ? ModConfig.speedOven / ModUtils.speedUpgrade(this.speedSlot()) : ModConfig.speedOven;
    }

    private static int deviceCode() {
        return EnumServer.LAB_OVEN.ordinal();
    }

    public BlockPos poweredPosition() {
        return this.chamberPos().func_177972_a(this.poweredFacing());
    }

    public EnumFacing poweredFacing() {
        return EnumFacing.func_176733_a((double)(this.getFacing().func_185119_l() + 90.0f));
    }

    boolean isValidInput(ItemStack stack) {
        ArrayList inputOreIDs;
        return this.isValidPreset() && (this.recipeList().get(this.getRecipeIndex()).getType() ? !(inputOreIDs = CoreUtils.intArrayToList((int[])OreDictionary.getOreIDs((ItemStack)stack))).isEmpty() && inputOreIDs.contains(OreDictionary.getOreID((String)this.recipeList().get(this.getRecipeIndex()).getOredict())) : this.recipeList().get(this.getRecipeIndex()).getSolute().func_77969_a(stack));
    }

    public boolean isValidCatalyst(ItemStack stack) {
        return !stack.func_190926_b() && !this.recipeCatalyst().func_190926_b() && stack.func_185136_b(this.recipeCatalyst());
    }

    public ArrayList<LabOvenRecipe> recipeList() {
        return LabOvenRecipes.lab_oven_recipes;
    }

    public LabOvenRecipe getRecipeList(int x) {
        return this.recipeList().get(x);
    }

    public LabOvenRecipe getCurrentRecipe() {
        if (this.isValidPreset()) {
            return this.getRecipeList(this.getRecipeIndex());
        }
        return null;
    }

    public boolean isValidRecipe() {
        return this.getCurrentRecipe() != null;
    }

    public boolean isValidPreset() {
        return this.getRecipeIndex() > -1 && this.getRecipeIndex() < this.recipeList().size();
    }

    public ItemStack recipeSolute() {
        return this.isValidRecipe() ? this.getCurrentRecipe().getSolute() : ItemStack.field_190927_a;
    }

    public ItemStack recipeCatalyst() {
        return this.isValidRecipe() ? this.getCurrentRecipe().getCatalyst() : ItemStack.field_190927_a;
    }

    public FluidStack recipeSolvent() {
        return this.isValidRecipe() ? this.getCurrentRecipe().getSolvent() : null;
    }

    public FluidStack recipeReagent() {
        return this.isValidRecipe() ? this.getCurrentRecipe().getReagent() : null;
    }

    public FluidStack recipeSolution() {
        return this.isValidRecipe() ? this.getCurrentRecipe().getSolution() : null;
    }

    public FluidStack recipeByproduct() {
        return this.isValidRecipe() ? this.getCurrentRecipe().getByproduct() : null;
    }

    public boolean oredictType() {
        return this.isValidRecipe() ? this.getCurrentRecipe().getType() : false;
    }

    public void doPreset() {
        if (this.hasEngine()) {
            if (!this.getEngine().enablePower) {
                this.getEngine().enablePower = true;
                this.getEngine().markDirtyClient();
            }
            if (!this.getEngine().enableRedstone) {
                this.getEngine().enableRedstone = true;
                this.getEngine().markDirtyClient();
            }
        }
        if (this.isValidPreset()) {
            if (this.hasIntank()) {
                if (this.getIntank().getFilterSolvent() != this.recipeSolvent()) {
                    this.getIntank().filterSolvent = this.recipeSolvent();
                }
                if (this.getIntank().getFilterReagent() != this.recipeReagent()) {
                    this.getIntank().filterReagent = this.recipeReagent();
                }
                this.getIntank().filterManualSolvent = null;
                this.getIntank().filterManualReagent = null;
                this.getIntank().isFiltered = true;
            }
        } else {
            this.emptyFilters();
        }
    }

    public void emptyFilters() {
        if (this.hasIntank()) {
            this.getIntank().filterSolvent = null;
            this.getIntank().filterReagent = null;
            this.getIntank().isFiltered = false;
        }
    }

    public TEPowerGenerator getEngine() {
        TEPowerGenerator engine = TileStructure.getEngine(this.field_145850_b, this.field_174879_c, this.getFacing(), 1, 0);
        return engine != null ? engine : null;
    }

    public boolean hasEngine() {
        return this.getEngine() != null;
    }

    public boolean hasFuelPower() {
        return this.hasEngine() ? this.getEngine().getPower() > 0 : false;
    }

    public boolean hasRedstonePower() {
        return this.hasEngine() ? this.getEngine().getRedstone() >= this.powerConsume() : false;
    }

    private void drainPower() {
        --this.getEngine().powerCount;
        this.getEngine().redstoneCount -= this.powerConsume();
        this.getEngine().markDirtyClient();
    }

    public int powerConsume() {
        int baseConsume = 20 * ModConfig.basePower;
        return ModConfig.speedMultiplier ? baseConsume * this.speedFactor() : baseConsume;
    }

    public BlockPos chamberPos() {
        return this.field_174879_c.func_177967_a(EnumFacing.DOWN, 1);
    }

    public TELabOvenChamber getChamber() {
        TELabOvenChamber tank;
        TileEntity te = this.field_145850_b.func_175625_s(this.chamberPos());
        if (this.field_145850_b.func_180495_p(this.chamberPos()) != null && te instanceof TELabOvenChamber && (tank = (TELabOvenChamber)te).getFacing() == this.getFacing()) {
            return tank;
        }
        return null;
    }

    public boolean hasChamber() {
        return this.getChamber() != null;
    }

    public BlockPos separatorPos() {
        return this.chamberPos().func_177967_a(this.getFacing(), 1);
    }

    public Block getSeparator() {
        IBlockState sepState = this.field_145850_b.func_180495_p(this.separatorPos());
        Block separator = sepState.func_177230_c();
        if (MachineIO.miscBlocksA(separator, sepState, EnumMiscBlocksA.SEPARATOR.ordinal())) {
            return separator;
        }
        return null;
    }

    public boolean hasSeparator() {
        return this.getSeparator() != null;
    }

    public TEFluidInputTank getIntank() {
        TEFluidInputTank tank;
        BlockPos intankPos = this.separatorPos().func_177967_a(this.isFacingAt(270), 1);
        TileEntity te = this.field_145850_b.func_175625_s(intankPos);
        if (this.field_145850_b.func_180495_p(intankPos) != null && te instanceof TEFluidInputTank && (tank = (TEFluidInputTank)te).getFacing() == this.isFacingAt(270).func_176734_d()) {
            return tank;
        }
        return null;
    }

    public boolean hasIntank() {
        return this.getIntank() != null;
    }

    public TEFluidOutputTank getOuttank() {
        TEFluidOutputTank tank;
        BlockPos outtankPos = this.separatorPos().func_177967_a(this.isFacingAt(90), 1);
        TileEntity te = this.field_145850_b.func_175625_s(outtankPos);
        if (this.field_145850_b.func_180495_p(outtankPos) != null && te instanceof TEFluidOutputTank && (tank = (TEFluidOutputTank)te).getFacing() == this.isFacingAt(90).func_176734_d()) {
            return tank;
        }
        return null;
    }

    public boolean hasOuttank() {
        return this.getOuttank() != null;
    }

    public BlockPos serverPos() {
        return this.field_174879_c.func_177967_a(this.getFacing(), 2).func_177967_a(EnumFacing.DOWN, 1);
    }

    public TEServer getServer() {
        TEServer server = TileStructure.getServer(this.field_145850_b, this.separatorPos(), this.getFacing(), 1, 0);
        return server != null ? server : null;
    }

    public boolean hasServer() {
        return this.getServer() != null;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.doPreset();
            this.handlePurge();
            this.initializeServer(this.isRepeatable, this.hasServer(), this.getServer(), TELabOvenController.deviceCode());
            if (this.isActive()) {
                if (this.canProcess()) {
                    ++this.cooktime;
                    this.drainPower();
                    if (this.getCooktime() >= this.getCooktimeMax()) {
                        this.cooktime = 0;
                        this.process();
                    }
                    this.markDirtyClient();
                }
            } else {
                this.tickOff();
            }
            if (this.soluteSlot().func_190926_b() && this.catalystSlot().func_190926_b()) {
                this.tickOff();
            }
        }
    }

    private void handlePurge() {
        if (this.isActive() && (!this.isValidPreset() || this.isValidRecipe())) {
            if (!this.soluteSlot().func_190926_b() && this.isPurgeable() && this.output.canSetOrStack(this.soluteOutSlot(), this.soluteSlot())) {
                this.output.setOrStack(0, this.soluteSlot());
                this.input.setStackInSlot(0, ItemStack.field_190927_a);
            }
            if (!this.catalystSlot().func_190926_b() && !this.recipeSolute().func_190926_b() && !this.catalystSlot().func_185136_b(this.recipeCatalyst()) && this.output.canSetOrStack(this.catalystOutSlot(), this.catalystSlot())) {
                this.output.setOrStack(1, this.catalystSlot());
                this.input.setStackInSlot(1, ItemStack.field_190927_a);
            }
        }
    }

    private boolean isPurgeable() {
        ArrayList inputOreIDs;
        return this.oredictType() ? !(inputOreIDs = CoreUtils.intArrayToList((int[])OreDictionary.getOreIDs((ItemStack)this.soluteSlot()))).contains(OreDictionary.getOreID((String)this.recipeList().get(this.getRecipeIndex()).getOredict())) : !CoreUtils.isMatchingIngredient((ItemStack)this.recipeSolute(), (ItemStack)this.soluteSlot());
    }

    private boolean canProcess() {
        return this.isActive() && this.isValidRecipe() && this.hasFuelPower() && this.hasRedstonePower() && this.hasSeparator() && this.handleSolute() && this.handleCatalyst() && this.handleSolvent() && this.handleReagent() && this.handleSolution() && this.handleByproduct() && this.handleServer(this.hasServer(), this.getServer(), this.currentFile);
    }

    private boolean handleSolute() {
        if (this.isValidRecipe() && !this.soluteSlot().func_190926_b()) {
            if (this.getCurrentRecipe().getType()) {
                ArrayList inputOreIDs = CoreUtils.intArrayToList((int[])OreDictionary.getOreIDs((ItemStack)this.soluteSlot()));
                if (!inputOreIDs.isEmpty() && !Strings.isNullOrEmpty((String)this.recipeList().get(this.getRecipeIndex()).getOredict()) && inputOreIDs.contains(OreDictionary.getOreID((String)this.recipeList().get(this.getRecipeIndex()).getOredict()))) {
                    return true;
                }
            } else {
                return !this.recipeSolute().func_190926_b() ? this.recipeList().get(this.getRecipeIndex()).getSolute().func_77969_a(this.soluteSlot()) : true;
            }
        }
        return false;
    }

    private boolean handleCatalyst() {
        return !this.recipeCatalyst().func_190926_b() ? this.isValidCatalyst(this.catalystSlot()) || CoreUtils.isMatchingIngredient((ItemStack)this.catalystSlot(), (ItemStack)this.recipeCatalyst()) : true;
    }

    private boolean handleSolvent() {
        return this.recipeSolvent() != null && this.hasIntank() && this.input.canDrainFluid(this.getIntank().getSolventFluid(), this.recipeSolvent());
    }

    private boolean handleReagent() {
        return this.recipeReagent() == null || this.recipeReagent() != null && this.hasIntank() && this.input.canDrainFluid(this.getIntank().getReagentFluid(), this.recipeReagent());
    }

    private boolean handleSolution() {
        return this.recipeSolution() != null && this.hasOuttank() && this.input.canSetOrFillFluid(this.getOuttank().solutionTank, this.getOuttank().getSolutionFluid(), this.recipeSolution());
    }

    private boolean handleByproduct() {
        return this.recipeByproduct() == null || this.recipeByproduct() != null && this.hasOuttank() && this.input.canSetOrFillFluid(this.getOuttank().byproductTank, this.getOuttank().getByproductFluid(), this.recipeByproduct());
    }

    private void process() {
        if (this.hasIntank()) {
            if (this.recipeSolvent() != null) {
                this.getIntank().solventTank.drainInternal(this.recipeSolvent(), true);
            }
            if (this.recipeReagent() != null) {
                this.getIntank().reagentTank.drainInternal(this.recipeReagent(), true);
            }
        }
        if (this.hasOuttank()) {
            if (this.recipeSolution() != null) {
                this.getOuttank().solutionTank.fillInternal(this.recipeSolution(), true);
            }
            if (this.recipeByproduct() != null) {
                this.getOuttank().byproductTank.fillInternal(this.recipeByproduct(), true);
            }
        }
        if (!this.catalystSlot().func_190926_b()) {
            int unbreakingLevel = CoreUtils.getEnchantmentLevel((Enchantment)Enchantments.field_185307_s, (ItemStack)this.catalystSlot());
            this.input.damageUnbreakingSlot(unbreakingLevel, 1);
        }
        if (!this.soluteSlot().func_190926_b()) {
            this.input.decrementSlot(0);
        }
        this.updateServer(this.hasServer(), this.getServer(), this.currentFile);
    }

    @Override
    public void loadServerStatus() {
        this.currentFile = -1;
        if (this.getServer().isActive()) {
            for (int x = 0; x < TEServer.FILE_SLOTS.length; ++x) {
                NBTTagCompound tag;
                ItemStack fileSlot = this.getServer().inputSlot(x).func_77946_l();
                if (!fileSlot.func_190926_b() && fileSlot.func_77969_a(new ItemStack(ModItems.MISC_ITEMS, 1, EnumMiscItems.SERVER_FILE.ordinal())) && fileSlot.func_77942_o() && this.isValidFile(tag = fileSlot.func_77978_p()) && tag.func_74762_e("Device") == TELabOvenController.deviceCode() && tag.func_74762_e("Recipe") < this.recipeList().size() && tag.func_74762_e("Done") > 0) {
                    if (this.recipeIndex != tag.func_74762_e("Recipe")) {
                        this.recipeIndex = tag.func_74762_e("Recipe");
                        this.markDirtyClient();
                    }
                    if (this.currentFile == x) break;
                    this.currentFile = x;
                    this.markDirtyClient();
                    break;
                }
                if (x != TEServer.FILE_SLOTS.length - 1) continue;
                this.resetFiles(this.getServer(), TELabOvenController.deviceCode());
            }
        }
    }
}

