/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.tile;

import com.globbypotato.rockhounding_chemistry.handlers.ModConfig;
import com.globbypotato.rockhounding_chemistry.machines.recipe.HeatExchangerRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.HeatExchangerRecipe;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEFlotationTank;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEGasPressurizer;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEPowerGenerator;
import com.globbypotato.rockhounding_chemistry.machines.tile.TileStructure;
import com.globbypotato.rockhounding_chemistry.machines.tile.TileVessel;
import com.globbypotato.rockhounding_chemistry.utils.ModUtils;
import com.globbypotato.rockhounding_core.machines.tileentity.MachineStackHandler;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import com.globbypotato.rockhounding_core.machines.tileentity.WrappedItemHandler;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TEHeatExchangerBase
extends TileEntityInv {
    public static final int SPEED_SLOT = 0;
    public static int templateSlots = 1;
    public static int upgradeSlots = 1;
    public HeatExchangerRecipe dummyRecipe;

    public TEHeatExchangerBase() {
        super(0, 0, templateSlots, upgradeSlots);
        this.upgrade = new MachineStackHandler(upgradeSlots, this){

            public void validateSlotIndex(int slot) {
                if (TEHeatExchangerBase.this.upgrade.getSlots() < upgradeSlots) {
                    NonNullList stacksCloned = this.stacks;
                    TEHeatExchangerBase.this.upgrade.setSize(upgradeSlots);
                    for (ItemStack stack : stacksCloned) {
                        this.stacks.set(slot, (Object)stack);
                    }
                }
                super.validateSlotIndex(slot);
            }

            public ItemStack insertItem(int slot, ItemStack insertingStack, boolean simulate) {
                if (slot == 0 && ModUtils.isValidSpeedUpgrade(insertingStack)) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                return insertingStack;
            }
        };
        this.automationUpgrade = new WrappedItemHandler((IItemHandlerModifiable)this.upgrade, WrappedItemHandler.WriteMode.IN);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        return compound;
    }

    public ItemStack speedSlot() {
        return this.upgrade.getStackInSlot(0);
    }

    public int getGUIHeight() {
        return 200;
    }

    public static String getName() {
        return "heat_exchanger_base";
    }

    private int getCooktimeMax() {
        return 20;
    }

    public int speedFactor() {
        return ModUtils.isValidSpeedUpgrade(this.speedSlot()) ? ModUtils.speedUpgrade(this.speedSlot()) : 1;
    }

    public EnumFacing poweredFacing() {
        return EnumFacing.func_176733_a((double)(this.getFacing().func_185119_l() + 270.0f));
    }

    public ArrayList<HeatExchangerRecipe> recipeList() {
        return HeatExchangerRecipes.heat_exchanger_recipes;
    }

    public HeatExchangerRecipe getRecipeList(int x) {
        return this.recipeList().get(x);
    }

    public HeatExchangerRecipe getCurrentRecipe() {
        if (this.hasCooling() && this.hasEnoughCoolant()) {
            for (int x = 0; x < this.recipeList().size(); ++x) {
                if (!this.isMatchingInput(x)) continue;
                return this.getRecipeList(x);
            }
        }
        return null;
    }

    public HeatExchangerRecipe getDummyRecipe() {
        return this.dummyRecipe;
    }

    private boolean isMatchingInput(int x) {
        return this.getRecipeList(x).getInput() != null && this.hasInTank() && this.getRecipeList(x).getInput().isFluidEqual(this.getInTank().inputTank.getFluid());
    }

    public FluidStack getRecipeInput() {
        return this.isValidRecipe() ? this.getDummyRecipe().getInput() : null;
    }

    public FluidStack getRecipeOutput() {
        return this.isValidRecipe() ? this.getDummyRecipe().getOutput() : null;
    }

    public boolean isValidRecipe() {
        return this.getDummyRecipe() != null;
    }

    public int minCoolant() {
        return 10;
    }

    public int powerConsume() {
        int baseConsume = this.coolantTemperature() / 5 * ModConfig.basePower;
        int moddedConsume = ModConfig.speedMultiplier ? baseConsume * this.speedFactor() : baseConsume;
        return this.hasTank() ? moddedConsume : baseConsume;
    }

    public int coolantTemperature() {
        return this.hasTank() ? this.getTank().inputTank.getFluid().getFluid().getTemperature() : 301;
    }

    public boolean isValidCoolant() {
        return this.coolantTemperature() > 0 && this.coolantTemperature() <= 300;
    }

    public int processRate() {
        return 100 * this.speedFactor();
    }

    public int consumeChance() {
        return 350 - this.coolantTemperature();
    }

    public int consumeRate() {
        return 100 - this.consumeChance() * 100 / 350;
    }

    public TEFlotationTank getTank() {
        TEFlotationTank tank = TileStructure.getFlotationTank(this.field_145850_b, this.field_174879_c, EnumFacing.UP, 2);
        return tank != null ? tank : null;
    }

    public boolean hasTank() {
        return this.getTank() != null && this.getTank().inputTank.getFluid() != null;
    }

    public TEGasPressurizer getPressurizer() {
        BlockPos chillerPos = this.field_174879_c.func_177967_a(EnumFacing.UP, 1);
        TEGasPressurizer pressurizer = TileStructure.getPressurizer(this.field_145850_b, chillerPos, this.isFacingAt(90), 1, 0);
        return pressurizer != null ? pressurizer : null;
    }

    public boolean hasPressurizer() {
        return this.getPressurizer() != null;
    }

    public TileVessel getInTank() {
        TileVessel vessel = TileStructure.getHolder(this.field_145850_b, this.field_174879_c, this.getFacing(), 1, 180);
        return vessel != null ? vessel : null;
    }

    public boolean hasInTank() {
        return this.getInTank() != null;
    }

    public boolean hasCooling() {
        return this.getInTank() != null && this.getInTank().inputTank.getFluid() != null;
    }

    public TileVessel getOutTank() {
        TileVessel vessel = TileStructure.getHolder(this.field_145850_b, this.field_174879_c, this.getFacing(), 1, 0);
        return vessel != null ? vessel : null;
    }

    public boolean hasOutTank() {
        return this.getOutTank() != null;
    }

    public TEPowerGenerator getEngine() {
        TEPowerGenerator engine = TileStructure.getEngine(this.field_145850_b, this.field_174879_c, this.isFacingAt(90), 1, 0);
        return engine != null ? engine : null;
    }

    public boolean hasEngine() {
        return this.getEngine() != null;
    }

    public boolean hasRedstonePower() {
        return this.hasEngine() ? this.getEngine().getRedstone() >= this.powerConsume() : false;
    }

    private void drainPower() {
        this.getEngine().redstoneCount -= this.powerConsume();
        this.getEngine().markDirtyClient();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.doPreset();
            if (this.isActive() && this.getDummyRecipe() == null) {
                this.dummyRecipe = this.getCurrentRecipe();
                this.cooktime = 0;
            }
            if (this.canCoolAir()) {
                ++this.cooktime;
                if (this.getCooktime() >= this.getCooktimeMax()) {
                    this.cooktime = 0;
                    this.drainPower();
                    this.coolAir();
                }
                this.markDirtyClient();
            } else {
                this.tickOff();
            }
        }
    }

    private void doPreset() {
        if (this.hasEngine()) {
            if (this.getEngine().enablePower) {
                this.getEngine().enablePower = false;
                this.getEngine().markDirtyClient();
            }
            if (!this.getEngine().enableRedstone) {
                this.getEngine().enableRedstone = true;
                this.getEngine().markDirtyClient();
            }
        }
    }

    public boolean canCoolAir() {
        return this.isActive() && this.isValidRecipe() && this.hasPressurizer() && this.hasRedstonePower() && this.hasInputGas() && this.canStoreGas() && this.canCool();
    }

    private boolean hasInputGas() {
        return this.hasInTank() && this.input.canDrainFluid(this.getInTank().inputTank.getFluid(), this.getRecipeInput(), this.processRate()) && this.getRecipeInput().getFluid().isGaseous();
    }

    private boolean hasEnoughCoolant() {
        return this.hasTank() && this.isValidCoolant() && this.getTank().inputTank.getFluidAmount() >= this.minCoolant();
    }

    private boolean canStoreGas() {
        return this.hasOutTank() && this.output.canSetOrAddFluid(this.getOutTank().inputTank, this.getOutTank().inputTank.getFluid(), this.getRecipeOutput(), this.processRate()) && this.getRecipeOutput().getFluid().isGaseous();
    }

    public boolean canCool() {
        return this.isValidRecipe() && this.getRecipeOutput().getFluid().getTemperature() < this.getRecipeInput().getFluid().getTemperature();
    }

    private void coolAir() {
        if (this.isValidRecipe() && this.getDummyRecipe() == this.getCurrentRecipe()) {
            this.output.setOrFillFluid(this.getOutTank().inputTank, this.getRecipeOutput(), this.processRate());
            this.input.drainOrCleanFluid(this.getInTank().inputTank, this.processRate(), true);
            if (this.hasTank() && this.rand.nextInt(this.consumeChance()) == 0) {
                this.getTank().inputTank.drainInternal(this.minCoolant(), true);
            }
        }
        this.dummyRecipe = null;
    }
}

