/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.tile;

import com.globbypotato.rockhounding_chemistry.ModBlocks;
import com.globbypotato.rockhounding_core.gas.CapabilityGasHandler;
import com.globbypotato.rockhounding_core.machines.tileentity.IGasHandlingTile;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityBase;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityFueledVessel;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityPoweredVessel;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityTankVessel;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityVessel;
import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TEGaslinePump
extends TileEntityBase
implements ITickable {
    public ArrayList<BlockPos> fluidSenders = new ArrayList();
    public ArrayList<BlockPos> fluidUsers = new ArrayList();
    public ArrayList<BlockPos> ducts = new ArrayList();
    public int numducts = 0;
    public boolean activation;
    public boolean upgrade;
    public int delay;
    private int countDelay = 0;

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.activation = compound.func_74767_n("Activation");
        this.upgrade = compound.func_74767_n("Upgrade");
        this.delay = compound.func_74762_e("Delay");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("Activation", this.isActive());
        compound.func_74757_a("Upgrade", this.hasUpgrade());
        compound.func_74768_a("Delay", this.getDelay());
        return compound;
    }

    public boolean canExtract(FluidStack extractedFluid, FluidStack receivingFluid) {
        return extractedFluid != null && extractedFluid.getFluid().isGaseous() && extractedFluid.amount > 0 && (receivingFluid == null || extractedFluid.isFluidEqual(receivingFluid) && receivingFluid.getFluid().isGaseous());
    }

    public int getFlow() {
        return this.hasUpgrade() ? 10000 : 1000;
    }

    public boolean isActive() {
        return this.activation;
    }

    public boolean hasUpgrade() {
        return this.upgrade;
    }

    public int getDelay() {
        return this.delay;
    }

    public boolean isAnyPipe(TileEntity checkTile) {
        return checkTile instanceof TEGaslinePump;
    }

    public boolean hasGasCapability(TileEntity checkTile, EnumFacing facing) {
        return checkTile.hasCapability(CapabilityGasHandler.GAS_HANDLER_CAPABILITY, facing);
    }

    public static String getName() {
        return "gasline_pump";
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.isActive()) {
                if (this.countDelay >= this.getDelay()) {
                    if (this.ducts.size() == 0) {
                        this.ducts.add(this.field_174879_c);
                    }
                    if (this.numducts < this.ducts.size()) {
                        this.addConnection(this.ducts.get(this.numducts));
                        ++this.numducts;
                    } else {
                        this.handleValves();
                        this.numducts = 0;
                        this.ducts.clear();
                        this.fluidUsers.clear();
                        this.fluidSenders.clear();
                    }
                    this.countDelay = 0;
                } else {
                    ++this.countDelay;
                }
            }
            this.markDirtyClient();
        }
    }

    private void addConnection(BlockPos duct) {
        for (EnumFacing facing : EnumFacing.values()) {
            TileEntity tile;
            BlockPos checkPos = duct.func_177972_a(facing);
            IBlockState checkState = this.field_145850_b.func_180495_p(checkPos);
            if (checkState != null && checkState.func_177230_c() == ModBlocks.GASLINE_DUCT && !this.ducts.contains(checkPos)) {
                this.ducts.add(checkPos);
            }
            if ((tile = this.field_145850_b.func_175625_s(checkPos)) == null || !(tile instanceof IGasHandlingTile)) continue;
            TileEntityInv valveTile = (TileEntityInv)tile;
            if (valveTile.getFacing() == facing && !this.fluidUsers.contains(checkPos)) {
                this.fluidUsers.add(checkPos);
            }
            if (this.numducts != 0 || valveTile.getFacing() != facing.func_176734_d() || this.fluidSenders.contains(checkPos)) continue;
            this.fluidSenders.add(checkPos);
        }
    }

    private void handleValves() {
        if (this.fluidSenders.size() > 0 && this.fluidUsers.size() > 0) {
            block0: for (BlockPos sender : this.fluidSenders) {
                TileEntity checkTile = this.field_145850_b.func_175625_s(sender);
                if (checkTile == null) continue;
                TileEntityInv send = (TileEntityInv)checkTile;
                IFluidHandler extractHandler = (IFluidHandler)checkTile.getCapability(CapabilityGasHandler.GAS_HANDLER_CAPABILITY, send.getFacing());
                if (extractHandler != null) {
                    for (BlockPos receiver : this.fluidUsers) {
                        TileEntity valveTile = this.field_145850_b.func_175625_s(receiver);
                        if (valveTile != null) {
                            IFluidHandler receiveHandler;
                            TileEntityVessel valve;
                            if (valveTile instanceof TileEntityVessel) {
                                valve = (TileEntityVessel)valveTile;
                                receiveHandler = (IFluidHandler)valve.getCapability(CapabilityGasHandler.GAS_HANDLER_CAPABILITY, valve.getFacing().func_176734_d());
                                this.handleTransfer(extractHandler, receiveHandler);
                                continue;
                            }
                            if (valveTile instanceof TileEntityFueledVessel) {
                                valve = (TileEntityFueledVessel)valveTile;
                                receiveHandler = (IFluidHandler)valve.getCapability(CapabilityGasHandler.GAS_HANDLER_CAPABILITY, valve.getFacing().func_176734_d());
                                this.handleTransfer(extractHandler, receiveHandler);
                                continue;
                            }
                            if (valveTile instanceof TileEntityPoweredVessel) {
                                valve = (TileEntityPoweredVessel)valveTile;
                                receiveHandler = (IFluidHandler)valve.getCapability(CapabilityGasHandler.GAS_HANDLER_CAPABILITY, valve.getFacing().func_176734_d());
                                this.handleTransfer(extractHandler, receiveHandler);
                                continue;
                            }
                            if (!(valveTile instanceof TileEntityTankVessel)) continue;
                            valve = (TileEntityTankVessel)valveTile;
                            receiveHandler = (IFluidHandler)valve.getCapability(CapabilityGasHandler.GAS_HANDLER_CAPABILITY, valve.getFacing().func_176734_d());
                            this.handleTransfer(extractHandler, receiveHandler);
                            continue;
                        }
                        this.fluidUsers.remove(receiver);
                        continue block0;
                    }
                    continue;
                }
                this.fluidSenders.remove(sender);
                break;
            }
        }
    }

    private void handleTransfer(IFluidHandler extractHandler, IFluidHandler receiveHandler) {
        FluidStack receivingFluid;
        FluidStack extractedFluid;
        if (receiveHandler != null && this.canExtract(extractedFluid = extractHandler.drain(this.getFlow(), false), receivingFluid = receiveHandler.drain(this.getFlow(), false))) {
            extractHandler.drain(receiveHandler.fill(extractHandler.drain(this.getFlow(), false), true), true);
        }
    }
}

