/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.tile;

import com.globbypotato.rockhounding_chemistry.handlers.ModConfig;
import com.globbypotato.rockhounding_chemistry.machines.recipe.GasPurifierRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.GasPurifierRecipe;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEGasPressurizer;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEParticulateCollector;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEPowerGenerator;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEPurifierCycloneBase;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEPurifierCycloneCap;
import com.globbypotato.rockhounding_chemistry.machines.tile.TileStructure;
import com.globbypotato.rockhounding_chemistry.machines.tile.TileVessel;
import com.globbypotato.rockhounding_chemistry.utils.ModUtils;
import com.globbypotato.rockhounding_core.machines.tileentity.MachineStackHandler;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import com.globbypotato.rockhounding_core.machines.tileentity.WrappedItemHandler;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TEGasPurifier
extends TileEntityInv {
    public static final int SPEED_SLOT = 0;
    public static int templateSlots = 1;
    public static int upgradeSlots = 1;

    public TEGasPurifier() {
        super(0, 0, templateSlots, upgradeSlots);
        this.upgrade = new MachineStackHandler(upgradeSlots, this){

            public ItemStack insertItem(int slot, ItemStack insertingStack, boolean simulate) {
                if (slot == 0 && ModUtils.isValidSpeedUpgrade(insertingStack)) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                return insertingStack;
            }
        };
        this.automationUpgrade = new WrappedItemHandler((IItemHandlerModifiable)this.upgrade, WrappedItemHandler.WriteMode.IN);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        return compound;
    }

    public ItemStack speedSlot() {
        return this.upgrade.getStackInSlot(0);
    }

    public static ArrayList<GasPurifierRecipe> recipeList() {
        return GasPurifierRecipes.gas_purifier_recipes;
    }

    public static GasPurifierRecipe getRecipeList(int x) {
        return TEGasPurifier.recipeList().get(x);
    }

    public GasPurifierRecipe getCurrentRecipe() {
        for (int x = 0; x < TEGasPurifier.recipeList().size(); ++x) {
            if (!this.isMatchingInput(x) || !this.isRecipeGaseous(x)) continue;
            return TEGasPurifier.getRecipeList(x);
        }
        return null;
    }

    private boolean isMatchingInput(int x) {
        return TEGasPurifier.getRecipeList(x).getInput() != null && this.hasInTank() && this.getInTank().inputTank.getFluid() != null && TEGasPurifier.getRecipeList(x).getInput().isFluidEqual(this.getInTank().inputTank.getFluid());
    }

    public boolean isValidRecipe() {
        return this.getCurrentRecipe() != null;
    }

    public FluidStack getRecipeInput() {
        return this.isValidRecipe() ? this.getCurrentRecipe().getInput() : null;
    }

    public FluidStack getRecipeOutput() {
        return this.isValidRecipe() ? this.getCurrentRecipe().getOutput() : null;
    }

    public ItemStack getMainSlag() {
        return this.isValidRecipe() ? this.getCurrentRecipe().getMainSlag() : ItemStack.field_190927_a;
    }

    private boolean hasMainSlag() {
        return !this.getMainSlag().func_190926_b();
    }

    public ItemStack getAltSlag() {
        return this.isValidRecipe() ? this.getCurrentRecipe().getAltSlag() : ItemStack.field_190927_a;
    }

    private boolean hasAltSlag() {
        return !this.getAltSlag().func_190926_b();
    }

    public boolean isRecipeGaseous(int x) {
        return TEGasPurifier.getRecipeList(x).getInput().getFluid().isGaseous() && TEGasPurifier.getRecipeList(x).getOutput().getFluid().isGaseous();
    }

    public int getGUIHeight() {
        return 200;
    }

    public static String getName() {
        return "gas_purifier";
    }

    public int getCooktimeMax() {
        return 30;
    }

    public BlockPos poweredPosition() {
        return this.cycloneTopCap().func_177972_a(this.poweredFacing());
    }

    public EnumFacing poweredFacing() {
        return EnumFacing.func_176733_a((double)(this.getFacing().func_185119_l() + 270.0f));
    }

    public int speedFactor() {
        return ModUtils.isValidSpeedUpgrade(this.speedSlot()) ? ModUtils.speedUpgrade(this.speedSlot()) : 1;
    }

    public int cleanRate() {
        return ModUtils.isValidSpeedUpgrade(this.speedSlot()) ? this.baseRate() * ModUtils.speedUpgrade(this.speedSlot()) : this.baseRate();
    }

    private int baseRate() {
        return 50;
    }

    public int effectiveRate() {
        if (this.hasInTank()) {
            if (this.getInTank().inputTank.getFluidAmount() >= this.cleanRate()) {
                return this.cleanRate();
            }
            return this.getInTank().inputTank.getFluidAmount();
        }
        return 0;
    }

    public TEPowerGenerator getEngine() {
        TEPowerGenerator engine = TileStructure.getEngine(this.field_145850_b, this.field_174879_c, this.isFacingAt(270), 1, 0);
        return engine != null ? engine : null;
    }

    public boolean hasEngine() {
        return this.getEngine() != null;
    }

    public boolean hasFuelPower() {
        return this.hasEngine() ? this.getEngine().getPower() > 0 : false;
    }

    private void drainPower() {
        --this.getEngine().powerCount;
        this.getEngine().markDirtyClient();
    }

    public BlockPos cycloneBasePos() {
        return this.field_174879_c.func_177967_a(EnumFacing.UP, 1);
    }

    public TEPurifierCycloneBase getCycloneBase() {
        TEPurifierCycloneBase chamber;
        TileEntity te = this.field_145850_b.func_175625_s(this.cycloneBasePos());
        if (this.field_145850_b.func_180495_p(this.cycloneBasePos()) != null && te instanceof TEPurifierCycloneBase && (chamber = (TEPurifierCycloneBase)te).getFacing() == this.getFacing()) {
            return chamber;
        }
        return null;
    }

    public boolean hasCycloneBase() {
        return this.getCycloneBase() != null;
    }

    public BlockPos cycloneTopCap() {
        return this.field_174879_c.func_177967_a(EnumFacing.UP, 3);
    }

    public TEPurifierCycloneCap getCycloneCap() {
        TEPurifierCycloneCap chamber;
        TileEntity te = this.field_145850_b.func_175625_s(this.cycloneTopCap());
        if (this.field_145850_b.func_180495_p(this.cycloneTopCap()) != null && te instanceof TEPurifierCycloneCap && (chamber = (TEPurifierCycloneCap)te).getFacing() == this.getFacing()) {
            return chamber;
        }
        return null;
    }

    public boolean hasCycloneCap() {
        return this.getCycloneCap() != null;
    }

    public boolean hasCycloneSeparator() {
        return this.hasCycloneBase() && this.hasCycloneCap();
    }

    public TEGasPressurizer getPressurizer() {
        BlockPos chillerPos = this.field_174879_c.func_177967_a(EnumFacing.UP, 3);
        TEGasPressurizer pressurizer = TileStructure.getPressurizer(this.field_145850_b, chillerPos, this.isFacingAt(90), 1, 0);
        return pressurizer != null ? pressurizer : null;
    }

    public boolean hasPressurizer() {
        return this.getPressurizer() != null;
    }

    public TileVessel getInTank() {
        TileVessel vessel = TileStructure.getHolder(this.field_145850_b, this.field_174879_c, this.isFacingAt(270), 1, 180);
        return vessel != null ? vessel : null;
    }

    public boolean hasInTank() {
        return this.getInTank() != null;
    }

    public TileVessel getOutTank() {
        TileVessel vessel = TileStructure.getHolder(this.field_145850_b, this.cycloneBasePos(), this.getFacing(), 1, 0);
        return vessel != null ? vessel : null;
    }

    public boolean hasOutTank() {
        return this.getOutTank() != null;
    }

    public TEParticulateCollector getParticulate() {
        TEParticulateCollector vessel = TileStructure.getCollector(this.field_145850_b, this.field_174879_c, this.getFacing(), 1, 0);
        return vessel != null ? vessel : null;
    }

    public boolean hasParticulate() {
        return this.getParticulate() != null;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.doPreset();
            if (this.hasParticulate()) {
                this.getParticulate().handlePreview(this.hasMainSlag(), this.getMainSlag(), this.hasAltSlag(), this.getAltSlag());
            }
            if (this.isActive()) {
                if (this.canProcess()) {
                    ++this.cooktime;
                    this.drainPower();
                    this.process();
                    if (this.getCooktime() >= this.getCooktimeMax()) {
                        this.cooktime = 0;
                    }
                    this.markDirtyClient();
                }
            } else {
                this.tickOff();
            }
        }
    }

    private void doPreset() {
        if (this.hasEngine()) {
            if (!this.getEngine().enablePower) {
                this.getEngine().enablePower = true;
                this.getEngine().markDirtyClient();
            }
            if (this.getEngine().enableRedstone) {
                this.getEngine().enableRedstone = false;
                this.getEngine().markDirtyClient();
            }
        }
    }

    private boolean canProcess() {
        return this.isValidRecipe() && this.hasFuelPower() && this.hasCycloneSeparator() && this.hasPressurizer() && this.hasOutTank() && this.isMatchingInput() && this.isMatchingOutput();
    }

    private boolean isMatchingInput() {
        return this.hasInTank() && this.input.canDrainFluid(this.getInTank().inputTank.getFluid(), this.getRecipeInput(), this.effectiveRate());
    }

    private boolean isMatchingOutput() {
        return this.hasOutTank() && this.output.canSetOrAddFluid(this.getOutTank().inputTank, this.getOutTank().inputTank.getFluid(), this.getRecipeOutput(), this.effectiveRate());
    }

    private void process() {
        this.output.setOrFillFluid(this.getOutTank().inputTank, this.getRecipeOutput(), this.effectiveRate());
        this.input.drainOrCleanFluid(this.getInTank().inputTank, this.effectiveRate(), true);
        if (this.hasParticulate() && this.isValidRecipe()) {
            this.getParticulate().handleParticulate(this.hasMainSlag(), ModConfig.purifier_main_slag, this.hasAltSlag(), ModConfig.purifier_secondary_slag);
        }
    }
}

