/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.tile;

import com.globbypotato.rockhounding_chemistry.machines.recipe.GasCondenserRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.GasCondenserRecipe;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEBufferTank;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEPowerGenerator;
import com.globbypotato.rockhounding_chemistry.machines.tile.TileStructure;
import com.globbypotato.rockhounding_chemistry.machines.tile.TileVessel;
import com.globbypotato.rockhounding_chemistry.utils.ModUtils;
import com.globbypotato.rockhounding_core.machines.tileentity.MachineStackHandler;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import com.globbypotato.rockhounding_core.machines.tileentity.WrappedItemHandler;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TEGasCondenser
extends TileEntityInv {
    public static final int SPEED_SLOT = 0;
    public static int upgradeSlots = 1;
    public static int templateSlots = 1;

    public TEGasCondenser() {
        super(0, 0, templateSlots, upgradeSlots);
        this.upgrade = new MachineStackHandler(upgradeSlots, this){

            public ItemStack insertItem(int slot, ItemStack insertingStack, boolean simulate) {
                if (slot == 0 && ModUtils.isValidSpeedUpgrade(insertingStack)) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                return insertingStack;
            }
        };
        this.automationUpgrade = new WrappedItemHandler((IItemHandlerModifiable)this.upgrade, WrappedItemHandler.WriteMode.IN);
    }

    public ItemStack speedSlot() {
        return this.upgrade.getStackInSlot(0);
    }

    public int getGUIHeight() {
        return 200;
    }

    public static String getName() {
        return "gas_condenser";
    }

    public int speedFactor() {
        return ModUtils.isValidSpeedUpgrade(this.speedSlot()) ? ModUtils.speedUpgrade(this.speedSlot()) : 1;
    }

    public EnumFacing poweredFacing() {
        return EnumFacing.func_176733_a((double)(this.getFacing().func_185119_l() + 90.0f));
    }

    public int getCooktimeMax() {
        return 30;
    }

    public static ArrayList<GasCondenserRecipe> recipeList() {
        return GasCondenserRecipes.gas_condenser_recipes;
    }

    public static GasCondenserRecipe getRecipeList(int x) {
        return TEGasCondenser.recipeList().get(x);
    }

    public GasCondenserRecipe getCurrentRecipe() {
        for (int x = 0; x < TEGasCondenser.recipeList().size(); ++x) {
            if (!this.isMatchingInput(x) || !this.isRecipeGaseous(x)) continue;
            return TEGasCondenser.getRecipeList(x);
        }
        return null;
    }

    private boolean isMatchingInput(int x) {
        return TEGasCondenser.getRecipeList(x).getInput() != null && this.hasInTank() && this.getInTank().inputTank.getFluid() != null && TEGasCondenser.getRecipeList(x).getInput().isFluidEqual(this.getInTank().inputTank.getFluid());
    }

    public boolean isValidRecipe() {
        return this.getCurrentRecipe() != null;
    }

    public FluidStack getRecipeInput() {
        return this.isValidRecipe() ? this.getCurrentRecipe().getInput() : null;
    }

    public FluidStack getRecipeOutput() {
        return this.isValidRecipe() ? this.getCurrentRecipe().getOutput() : null;
    }

    public boolean isRecipeGaseous(int x) {
        return TEGasCondenser.getRecipeList(x).getInput().getFluid().isGaseous() && !TEGasCondenser.getRecipeList(x).getOutput().getFluid().isGaseous();
    }

    public TEPowerGenerator getEngine() {
        TEPowerGenerator engine = TileStructure.getEngine(this.field_145850_b, this.field_174879_c, this.getFacing(), 1, 0);
        return engine != null ? engine : null;
    }

    public boolean hasEngine() {
        return this.getEngine() != null;
    }

    public boolean hasFuelPower() {
        return this.hasEngine() ? this.getEngine().getPower() > 0 : false;
    }

    private void drainPower() {
        --this.getEngine().powerCount;
        this.getEngine().markDirtyClient();
    }

    public TileVessel getInTank() {
        TileVessel vessel = TileStructure.getHolder(this.field_145850_b, this.field_174879_c, this.getFacing(), 1, 180);
        return vessel != null ? vessel : null;
    }

    public boolean hasInTank() {
        return this.getInTank() != null;
    }

    public TEBufferTank getOutTank() {
        TEBufferTank tank = TileStructure.getBufferTank(this.field_145850_b, this.field_174879_c, EnumFacing.UP, 1);
        return tank != null ? tank : null;
    }

    public boolean hasOutTank() {
        return this.getOutTank() != null;
    }

    public boolean isAssembled() {
        return this.hasEngine() && this.hasInTank() && this.hasOutTank();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.doPreset();
            if (this.isActive()) {
                if (this.canProcess()) {
                    ++this.cooktime;
                    this.drainPower();
                    this.process();
                    if (this.getCooktime() >= this.getCooktimeMax()) {
                        this.cooktime = 0;
                    }
                    this.markDirtyClient();
                }
            } else {
                this.tickOff();
            }
        }
    }

    private void doPreset() {
        if (this.hasEngine()) {
            if (!this.getEngine().enablePower) {
                this.getEngine().enablePower = true;
                this.getEngine().markDirtyClient();
            }
            if (this.getEngine().enableRedstone) {
                this.getEngine().enableRedstone = false;
                this.getEngine().markDirtyClient();
            }
        }
    }

    private boolean canProcess() {
        return this.isAssembled() && this.hasFuelPower() && this.canGetInput() && this.canStoreOutput();
    }

    private boolean canGetInput() {
        return this.isValidRecipe() && this.hasInTank() && this.input.canDrainFluid(this.getInTank().inputTank.getFluid(), this.getRecipeInput(), this.calculateDrain());
    }

    private boolean canStoreOutput() {
        return this.isValidRecipe() && this.hasOutTank() && this.input.canSetOrAddFluid(this.getOutTank().inputTank, this.getOutTank().inputTank.getFluid(), this.getRecipeOutput(), this.calculateFill());
    }

    private void process() {
        this.output.setOrFillFluid(this.getOutTank().inputTank, this.getRecipeOutput(), this.calculateFill());
        this.input.drainOrCleanFluid(this.getInTank().inputTank, this.calculateDrain(), true);
    }

    private int calculateFill() {
        return this.getRecipeOutput().amount * this.speedFactor();
    }

    private int calculateDrain() {
        return this.getRecipeInput().amount * this.speedFactor();
    }
}

