/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.tile;

import com.globbypotato.rockhounding_chemistry.enums.EnumMiscBlocksA;
import com.globbypotato.rockhounding_chemistry.enums.materials.EnumAirGases;
import com.globbypotato.rockhounding_chemistry.enums.materials.EnumFluid;
import com.globbypotato.rockhounding_chemistry.handlers.ModConfig;
import com.globbypotato.rockhounding_chemistry.machines.io.MachineIO;
import com.globbypotato.rockhounding_chemistry.machines.recipe.GanPlantRecipes;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEGanExpanderBase;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEGasPressurizer;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEMultivessel;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEPowerGenerator;
import com.globbypotato.rockhounding_chemistry.machines.tile.TileStructure;
import com.globbypotato.rockhounding_chemistry.machines.tile.TileVessel;
import com.globbypotato.rockhounding_chemistry.utils.ModUtils;
import com.globbypotato.rockhounding_core.machines.tileentity.MachineStackHandler;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import com.globbypotato.rockhounding_core.machines.tileentity.WrappedItemHandler;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TEGanController
extends TileEntityInv {
    public boolean enableN;
    public boolean enableO;
    public boolean enableX;
    public int[] rareGases = new int[6];
    public static final int SPEED_SLOT = 0;
    public static int upgradeSlots = 1;
    public static int templateSlots = 4;

    public TEGanController() {
        super(0, 0, templateSlots, upgradeSlots);
        this.upgrade = new MachineStackHandler(upgradeSlots, this){

            public ItemStack insertItem(int slot, ItemStack insertingStack, boolean simulate) {
                if (slot == 0 && ModUtils.isValidSpeedUpgrade(insertingStack)) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                return insertingStack;
            }
        };
        this.automationUpgrade = new WrappedItemHandler((IItemHandlerModifiable)this.upgrade, WrappedItemHandler.WriteMode.IN);
    }

    public ItemStack speedSlot() {
        return this.upgrade.getStackInSlot(0);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.enableN = !GanPlantRecipes.inhibited_gases.contains(EnumAirGases.name(6)) ? compound.func_74767_n("EnableN") : false;
        this.enableO = !GanPlantRecipes.inhibited_gases.contains(EnumAirGases.name(7)) ? compound.func_74767_n("EnableO") : false;
        this.enableX = compound.func_74767_n("EnableX");
        NBTTagCompound drainList = compound.func_74775_l("Gases");
        for (int i = 0; i < drainList.func_186856_d(); ++i) {
            this.rareGases[i] = drainList.func_74762_e("Gas" + i);
        }
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("EnableN", this.enableN());
        compound.func_74757_a("EnableO", this.enableO());
        compound.func_74757_a("EnableX", this.enableX());
        NBTTagCompound drainList = new NBTTagCompound();
        for (int i = 0; i < this.rareGases.length; ++i) {
            drainList.func_74768_a("Gas" + i, this.rareGases[i]);
        }
        compound.func_74782_a("Gases", (NBTBase)drainList);
        return compound;
    }

    public int getGUIHeight() {
        return 200;
    }

    public static String getName() {
        return "gan_controller";
    }

    public int getCooktimeMax() {
        return 30;
    }

    public int speedFactor() {
        return ModUtils.isValidSpeedUpgrade(this.speedSlot()) ? ModUtils.speedUpgrade(this.speedSlot()) : 1;
    }

    private void doPreset() {
        if (this.hasEngine()) {
            if (this.getEngine().enablePower) {
                this.getEngine().enablePower = false;
                this.getEngine().markDirtyClient();
            }
            if (!this.getEngine().enableRedstone) {
                this.getEngine().enableRedstone = true;
                this.getEngine().markDirtyClient();
            }
        }
        if (this.hasInTank() && this.getInTank().getFilter() != this.airStack()) {
            this.getInTank().filter = this.airStack();
        }
        if (this.hasFirstOutput() && this.getChOut1().getFilter() != this.nitrogenStack()) {
            this.getChOut1().filter = this.nitrogenStack();
        }
        if (this.hasSecondOutput() && this.getChOut2().getFilter() != this.oxygenStack()) {
            this.getChOut2().filter = this.oxygenStack();
        }
    }

    public EnumFacing poweredFacing() {
        return this.getFacing().func_176734_d();
    }

    public boolean enableN() {
        return this.enableN;
    }

    public boolean enableO() {
        return this.enableO;
    }

    public boolean enableX() {
        return this.enableX;
    }

    public int consumeN() {
        int baseConsume = 10 * ModConfig.basePower;
        return ModConfig.speedMultiplier ? baseConsume * this.speedFactor() : baseConsume;
    }

    public int consumeO() {
        int baseConsume = 30 * ModConfig.basePower;
        return ModConfig.speedMultiplier ? baseConsume * this.speedFactor() : baseConsume;
    }

    public int consumeX() {
        int baseConsume = 60 * ModConfig.basePower;
        return ModConfig.speedMultiplier ? baseConsume * this.speedFactor() : baseConsume;
    }

    public int calculateConsume() {
        int totConsume = 0;
        if (this.enableN()) {
            totConsume += this.consumeN();
        }
        if (this.enableO()) {
            totConsume += this.consumeO();
        }
        if (this.enableX()) {
            totConsume += this.consumeX();
        }
        return totConsume;
    }

    private FluidStack airStack() {
        return new FluidStack(EnumFluid.pickFluid(EnumFluid.COOLED_AIR), this.num_air());
    }

    public int num_air() {
        return 20 * this.speedFactor();
    }

    private FluidStack nitrogenStack() {
        return new FluidStack(EnumFluid.pickFluid(EnumFluid.NITROGEN), this.num_N());
    }

    private int num_N() {
        return 15 * this.speedFactor();
    }

    private FluidStack oxygenStack() {
        return new FluidStack(EnumFluid.pickFluid(EnumFluid.OXYGEN), this.num_O());
    }

    private int num_O() {
        return 5 * this.speedFactor();
    }

    private FluidStack stack_Ar() {
        return new FluidStack(EnumFluid.pickFluid(EnumFluid.ARGON), this.num_Ar());
    }

    private int num_Ar() {
        return 3 * this.speedFactor();
    }

    private FluidStack stack_CO() {
        return new FluidStack(EnumFluid.pickFluid(EnumFluid.CARBON_DIOXIDE), this.num_CO());
    }

    private int num_CO() {
        return 3 * this.speedFactor();
    }

    private FluidStack stack_Ne() {
        return new FluidStack(EnumFluid.pickFluid(EnumFluid.NEON), this.num_Ne());
    }

    private int num_Ne() {
        return 3 * this.speedFactor();
    }

    private FluidStack stack_He() {
        return new FluidStack(EnumFluid.pickFluid(EnumFluid.HELIUM), this.num_He());
    }

    private int num_He() {
        return 3 * this.speedFactor();
    }

    private FluidStack stack_Kr() {
        return new FluidStack(EnumFluid.pickFluid(EnumFluid.KRYPTON), this.num_Kr());
    }

    private int num_Kr() {
        return 3 * this.speedFactor();
    }

    private FluidStack stack_Xe() {
        return new FluidStack(EnumFluid.pickFluid(EnumFluid.XENON), this.num_Xe());
    }

    private int num_Xe() {
        return 3 * this.speedFactor();
    }

    public ArrayList<String> inhibitedList() {
        return GanPlantRecipes.inhibited_gases;
    }

    public BlockPos plantInverse() {
        return this.field_174879_c.func_177967_a(this.isFacingAt(90).func_176734_d(), 1);
    }

    public BlockPos plantPos1() {
        return this.field_174879_c.func_177967_a(this.isFacingAt(90), 1);
    }

    public BlockPos plantPos2() {
        return this.field_174879_c.func_177967_a(this.isFacingAt(90), 2);
    }

    public BlockPos plantPos3() {
        return this.field_174879_c.func_177967_a(this.isFacingAt(90), 3);
    }

    public BlockPos plantPos4() {
        return this.field_174879_c.func_177967_a(this.isFacingAt(90), 4);
    }

    public BlockPos plantPos5() {
        return this.field_174879_c.func_177967_a(this.isFacingAt(90), 5);
    }

    public TEPowerGenerator getEngine() {
        TEPowerGenerator engine = TileStructure.getEngine(this.field_145850_b, this.field_174879_c, this.getFacing(), 1, 0);
        return engine != null ? engine : null;
    }

    public boolean hasEngine() {
        return this.getEngine() != null;
    }

    public boolean hasRedstonePower() {
        return this.hasEngine() ? this.getEngine().getRedstone() >= this.calculateConsume() : false;
    }

    private void drainPower() {
        this.getEngine().redstoneCount -= this.calculateConsume();
        this.getEngine().markDirtyClient();
    }

    public TileVessel getInTank() {
        TileVessel vessel = TileStructure.getHolder(this.field_145850_b, this.field_174879_c, this.isFacingAt(90), 1, 180);
        return vessel != null ? vessel : null;
    }

    public boolean hasInTank() {
        return this.getInTank() != null;
    }

    public boolean inputTankHasGas() {
        return this.hasInTank() && this.input.canDrainFluid(this.getInTank().inputTank.getFluid(), this.airStack());
    }

    public boolean hasChannel1() {
        int countTower = 0;
        for (int x = 1; x <= 3; ++x) {
            BlockPos tPos = new BlockPos(this.plantPos1().func_177958_n(), this.plantPos1().func_177956_o() + x, this.plantPos1().func_177952_p());
            IBlockState state = this.field_145850_b.func_180495_p(tPos);
            Block block = state.func_177230_c();
            if (!MachineIO.miscBlocksA(block, state, EnumMiscBlocksA.GAN_TOWER.ordinal())) continue;
            ++countTower;
        }
        BlockPos tPos = new BlockPos(this.plantPos1().func_177958_n(), this.plantPos1().func_177956_o() + 4, this.plantPos1().func_177952_p());
        IBlockState state = this.field_145850_b.func_180495_p(tPos);
        Block block = state.func_177230_c();
        if (MachineIO.miscBlocksA(block, state, EnumMiscBlocksA.GAN_TOWER_TOP.ordinal())) {
            ++countTower;
        }
        if (MachineIO.miscBlocksA(block = (state = this.field_145850_b.func_180495_p(this.plantPos1())).func_177230_c(), state, EnumMiscBlocksA.GAN_INJECTOR.ordinal())) {
            ++countTower;
        }
        return countTower == 5 && this.hasFirstPressurizer() && this.hasFirstOutput();
    }

    public BlockPos pressurizer1Pos() {
        return this.plantPos1().func_177967_a(this.getFacing(), 1);
    }

    public TEGasPressurizer getPressurizer1() {
        TEGasPressurizer pressurizer = TileStructure.getPressurizer(this.field_145850_b, this.plantPos1(), this.getFacing(), 1, 0);
        return pressurizer != null ? pressurizer : null;
    }

    public boolean hasFirstPressurizer() {
        return this.getPressurizer1() != null;
    }

    public TileVessel getChOut1() {
        TileVessel vessel = TileStructure.getHolder(this.field_145850_b, this.plantPos1(), this.getFacing().func_176734_d(), 1, 0);
        return vessel != null ? vessel : null;
    }

    public boolean hasFirstOutput() {
        return this.getChOut1() != null;
    }

    public boolean hasSeparator() {
        IBlockState state = this.field_145850_b.func_180495_p(this.plantPos2());
        Block block = state.func_177230_c();
        return MachineIO.miscBlocksA(block, state, EnumMiscBlocksA.SEPARATOR.ordinal());
    }

    public TEGasPressurizer getPressurizerS() {
        TEGasPressurizer pressurizer = TileStructure.getPressurizer(this.field_145850_b, this.plantPos2(), this.getFacing().func_176734_d(), 1, 0);
        return pressurizer != null ? pressurizer : null;
    }

    public boolean hasExpanderPressurizer() {
        return this.getPressurizerS() != null;
    }

    public BlockPos expanderPos() {
        return this.plantPos2().func_177967_a(this.getFacing(), 1);
    }

    public TEGanExpanderBase getExpander() {
        TEGanExpanderBase press;
        TileEntity te = this.field_145850_b.func_175625_s(this.expanderPos());
        if (this.field_145850_b.func_180495_p(this.expanderPos()) != null && te instanceof TEGanExpanderBase && (press = (TEGanExpanderBase)te).getFacing() == this.getFacing().func_176734_d()) {
            return press;
        }
        return null;
    }

    public boolean hasExpander() {
        return this.getExpander() != null && this.hasSeparator() && this.hasExpanderPressurizer();
    }

    public boolean hasChannel2() {
        int countTower = 0;
        for (int x = 1; x <= 2; ++x) {
            BlockPos tPos = new BlockPos(this.plantPos3().func_177958_n(), this.plantPos3().func_177956_o() + x, this.plantPos3().func_177952_p());
            IBlockState state = this.field_145850_b.func_180495_p(tPos);
            Block block = state.func_177230_c();
            if (!MachineIO.miscBlocksA(block, state, EnumMiscBlocksA.GAN_TOWER.ordinal())) continue;
            ++countTower;
        }
        BlockPos tPos = new BlockPos(this.plantPos3().func_177958_n(), this.plantPos3().func_177956_o() + 4, this.plantPos3().func_177952_p());
        IBlockState state = this.field_145850_b.func_180495_p(tPos);
        Block block = state.func_177230_c();
        if (MachineIO.miscBlocksA(block, state, EnumMiscBlocksA.GAN_TOWER_TOP.ordinal())) {
            ++countTower;
        }
        if (MachineIO.miscBlocksA(block = (state = this.field_145850_b.func_180495_p(this.plantPos3())).func_177230_c(), state, EnumMiscBlocksA.GAN_INJECTOR.ordinal())) {
            ++countTower;
        }
        return countTower == 3 && this.hasSecondPressurizer() && this.hasSecondOutput();
    }

    public TEGasPressurizer getPressurizer2() {
        TEGasPressurizer pressurizer = TileStructure.getPressurizer(this.field_145850_b, this.plantPos3(), this.getFacing(), 1, 0);
        return pressurizer != null ? pressurizer : null;
    }

    public boolean hasSecondPressurizer() {
        return this.getPressurizer2() != null;
    }

    public TileVessel getChOut2() {
        TileVessel vessel = TileStructure.getHolder(this.field_145850_b, this.plantPos3(), this.getFacing().func_176734_d(), 1, 0);
        return vessel != null ? vessel : null;
    }

    public boolean hasSecondOutput() {
        return this.getChOut2() != null;
    }

    public TEMultivessel getMultivessel() {
        TEMultivessel press;
        TileEntity te = this.field_145850_b.func_175625_s(this.plantPos4());
        if (this.field_145850_b.func_180495_p(this.plantPos5()) != null && te instanceof TEMultivessel && (press = (TEMultivessel)te).getFacing() == this.isFacingAt(90)) {
            return press;
        }
        return null;
    }

    public boolean hasRareOutput() {
        return this.getMultivessel() != null;
    }

    public boolean hasChannel3() {
        return this.hasRareOutput();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.doPreset();
            if (this.isActive()) {
                if (this.canDistillate()) {
                    ++this.cooktime;
                    this.distillate();
                    if (this.getCooktime() >= this.getCooktimeMax()) {
                        this.cooktime = 0;
                    }
                    this.markDirtyClient();
                }
            } else {
                this.tickOff();
            }
        }
    }

    private boolean canDistillate() {
        return this.hasRedstonePower() && this.inputTankHasGas() && this.hasCorrectSetup();
    }

    private boolean hasCorrectSetup() {
        if (this.enableN()) {
            return this.handleCh1();
        }
        if (this.enableO()) {
            return this.handleCh2();
        }
        if (this.enableX()) {
            return this.handleCh3();
        }
        return false;
    }

    private boolean handleCh1() {
        return this.hasChannel1() && this.hasExpander() && this.output.canSetOrFillFluid(this.getChOut1().inputTank, this.getChOut1().inputTank.getFluid(), this.nitrogenStack());
    }

    private boolean handleCh2() {
        return this.handleCh1() && this.hasChannel2() && this.output.canSetOrFillFluid(this.getChOut2().inputTank, this.getChOut2().inputTank.getFluid(), this.oxygenStack());
    }

    private boolean handleCh3() {
        return this.hasChannel2() && this.hasChannel3();
    }

    public boolean doOutput1() {
        return this.enableN() && this.handleCh1();
    }

    public boolean doOutput2() {
        return this.enableO() && this.handleCh2();
    }

    public boolean doOutput3() {
        return this.enableX() && this.handleCh3();
    }

    public boolean isGasInhibited(int i) {
        return this.inhibitedList().contains(EnumAirGases.name(i));
    }

    private boolean canFillChannel(FluidTank tank, FluidStack gas) {
        return this.output.canSetOrFillFluid(tank, tank.getFluid(), gas);
    }

    private void distillate() {
        if (this.doOutput1() && !this.isGasInhibited(6)) {
            this.output.setOrFillFluid(this.getChOut1().inputTank, this.nitrogenStack());
        }
        if (this.doOutput2() && !this.isGasInhibited(7)) {
            this.output.setOrFillFluid(this.getChOut2().inputTank, this.oxygenStack());
        }
        if (this.doOutput3()) {
            if (!this.isGasInhibited(0) && this.canFillChannel(this.getMultivessel().tank_Ar, this.stack_Ar()) && this.getMultivessel().rareEnabler[0]) {
                this.rareGases[0] = this.rareGases[0] + 1;
                if (this.rareGases[0] >= 10) {
                    this.output.setOrFillFluid(this.getMultivessel().tank_Ar, this.stack_Ar());
                    this.rareGases[0] = 0;
                }
            }
            if (!this.isGasInhibited(1) && this.canFillChannel(this.getMultivessel().tank_CO, this.stack_CO()) && this.getMultivessel().rareEnabler[1]) {
                this.rareGases[1] = this.rareGases[1] + 1;
                if (this.rareGases[1] >= 20) {
                    this.output.setOrFillFluid(this.getMultivessel().tank_CO, this.stack_CO());
                    this.rareGases[1] = 0;
                }
            }
            if (!this.isGasInhibited(2) && this.canFillChannel(this.getMultivessel().tank_Ne, this.stack_Ne()) && this.getMultivessel().rareEnabler[2]) {
                this.rareGases[2] = this.rareGases[2] + 1;
                if (this.rareGases[2] >= 40) {
                    this.output.setOrFillFluid(this.getMultivessel().tank_Ne, this.stack_Ne());
                    this.rareGases[2] = 0;
                }
            }
            if (!this.isGasInhibited(3) && this.canFillChannel(this.getMultivessel().tank_He, this.stack_He()) && this.getMultivessel().rareEnabler[3]) {
                this.rareGases[3] = this.rareGases[3] + 1;
                if (this.rareGases[3] >= 100) {
                    this.output.setOrFillFluid(this.getMultivessel().tank_He, this.stack_He());
                    this.rareGases[3] = 0;
                }
            }
            if (!this.isGasInhibited(4) && this.canFillChannel(this.getMultivessel().tank_Kr, this.stack_Kr()) && this.getMultivessel().rareEnabler[4]) {
                this.rareGases[4] = this.rareGases[4] + 1;
                if (this.rareGases[4] >= 200) {
                    this.output.setOrFillFluid(this.getMultivessel().tank_Kr, this.stack_Kr());
                    this.rareGases[4] = 0;
                }
            }
            if (!this.isGasInhibited(5) && this.canFillChannel(this.getMultivessel().tank_Xe, this.stack_Xe()) && this.getMultivessel().rareEnabler[5]) {
                this.rareGases[5] = this.rareGases[5] + 1;
                if (this.rareGases[5] >= 400) {
                    this.output.setOrFillFluid(this.getMultivessel().tank_Xe, this.stack_Xe());
                    this.rareGases[5] = 0;
                }
            }
        }
        if (this.hasInTank()) {
            this.input.drainOrCleanFluid(this.getInTank().inputTank, this.num_air(), true);
        }
        this.drainPower();
    }
}

