/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.tile;

import com.globbypotato.rockhounding_chemistry.ModBlocks;
import com.globbypotato.rockhounding_chemistry.enums.EnumMiscBlocksA;
import com.globbypotato.rockhounding_chemistry.enums.materials.EnumFluid;
import com.globbypotato.rockhounding_chemistry.enums.utils.EnumSaltStages;
import com.globbypotato.rockhounding_chemistry.handlers.ModConfig;
import com.globbypotato.rockhounding_chemistry.utils.BaseRecipes;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityTank;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerConcatenate;

public class TEEvaporationTank
extends TileEntityTank {
    public FluidTank inputTank;
    public int stage;
    private int meltingTime;
    public int purge = this.finalStage();

    public TEEvaporationTank() {
        super(0, 1, 0, 0);
        this.inputTank = new FluidTank(this.getTankCapacity()){

            public boolean canFillFluidType(FluidStack fluid) {
                return TEEvaporationTank.this.handleFilling(fluid);
            }

            public boolean canDrain() {
                return TEEvaporationTank.this.isAllowedStage();
            }
        };
        this.inputTank.setTileEntity((TileEntity)this);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inputTank.readFromNBT(compound.func_74775_l("InputTank"));
        this.stage = compound.func_74762_e("Stage");
        this.meltingTime = compound.func_74762_e("MeltingCount");
        this.purge = compound.func_74762_e("Purge");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        NBTTagCompound inputTankNBT = new NBTTagCompound();
        this.inputTank.writeToNBT(inputTankNBT);
        compound.func_74782_a("InputTank", (NBTBase)inputTankNBT);
        compound.func_74768_a("MeltingCount", this.meltingTime);
        compound.func_74768_a("Stage", this.getStage());
        compound.func_74768_a("Purge", this.getPurge());
        return compound;
    }

    public FluidHandlerConcatenate getCombinedTank() {
        return new FluidHandlerConcatenate(new IFluidHandler[]{this.inputTank});
    }

    public ItemStack outputSlot() {
        return this.output.getStackInSlot(0);
    }

    public int getGUIHeight() {
        return 200;
    }

    public static String getName() {
        return "evaporation_tank";
    }

    public int evaporationSpeed() {
        return ModConfig.speedEvaporation;
    }

    public int getTankCapacity() {
        return 5000;
    }

    public boolean hasTankFluid() {
        return this.getTankFluid() != null;
    }

    public FluidStack getTankFluid() {
        return this.inputTank.getFluid();
    }

    public int getTankAmount() {
        return this.hasTankFluid() ? this.inputTank.getFluidAmount() : 0;
    }

    public boolean isTankEmpty() {
        return this.getTankAmount() == 0;
    }

    private boolean isFullTank() {
        return this.hasTankFluid() && this.getTankAmount() == this.getTankCapacity();
    }

    boolean handleFilling(FluidStack fluid) {
        return this.getStage() == 0 && fluid.isFluidEqual(new FluidStack(FluidRegistry.WATER, 1000));
    }

    public boolean isAllowedStage() {
        return this.getStage() == this.getPurge() && this.getPurge() < this.finalStage();
    }

    public int getStage() {
        return this.stage;
    }

    public int getPurge() {
        return this.purge;
    }

    private int evapLevel() {
        return 120;
    }

    public int initialStage() {
        return EnumSaltStages.STAGE_A.ordinal();
    }

    public int denseStage() {
        return EnumSaltStages.STAGE_D.ordinal();
    }

    public int finalStage() {
        return EnumSaltStages.STAGE_G.ordinal();
    }

    private int calculatedEvaporation(Biome biome) {
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY)) {
            if (this.field_174879_c.func_177956_o() > this.evapLevel()) {
                return this.evaporationSpeed() / 3;
            }
            return this.evaporationSpeed() / 2;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WET) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WATER) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.CONIFEROUS) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
            if (this.field_174879_c.func_177956_o() > this.evapLevel()) {
                return this.evaporationSpeed();
            }
            return this.evaporationSpeed() * 2;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN)) {
            if (this.field_174879_c.func_177956_o() > this.evapLevel()) {
                return this.evaporationSpeed() * 2;
            }
            return this.evaporationSpeed() * 4;
        }
        if (this.field_174879_c.func_177956_o() > this.evapLevel()) {
            return this.evaporationSpeed() / 2;
        }
        return this.evaporationSpeed();
    }

    private boolean isValidDimension() {
        boolean isBacklisted = false;
        for (int x = 0; x < ModConfig.salt_dim_blacklist.length; ++x) {
            if (this.field_145850_b.field_73011_w.getDimension() != ModConfig.salt_dim_blacklist[x]) continue;
            isBacklisted = true;
        }
        return !isBacklisted;
    }

    private boolean mustDesublimate() {
        if (this.isValidDimension()) {
            boolean desublibate = false;
            for (int x = 0; x < ModConfig.salt_dim_space.length; ++x) {
                if (this.field_145850_b.field_73011_w.getDimension() != ModConfig.salt_dim_space[x]) continue;
                desublibate = true;
            }
            return desublibate;
        }
        return false;
    }

    private boolean canEvaporate() {
        return !this.field_145850_b.func_72896_J() && this.field_145850_b.func_72935_r() && this.field_145850_b.func_175710_j(this.field_174879_c) && this.isValidDimension() && this.hasEnoughFluid();
    }

    private boolean hasEnoughFluid() {
        return this.getTankAmount() >= EnumSaltStages.getStageYeld(this.getStage());
    }

    private boolean canFillFromRain(Biome biome) {
        return this.field_145850_b.func_175710_j(this.field_174879_c) && this.field_145850_b.func_72896_J() && !biome.func_76746_c() && biome.func_76727_i() >= 0.2f;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            Biome biome = this.field_145850_b.func_180494_b(this.field_174879_c);
            if (this.canFillFromRain(biome)) {
                if (this.getStage() == this.initialStage()) {
                    this.inputTank.fillInternal(new FluidStack(FluidRegistry.WATER, 5), true);
                    if (this.meltingTime != 0) {
                        this.meltingTime = 0;
                    }
                } else {
                    ++this.meltingTime;
                    if (this.meltingTime >= ModConfig.meltingTime) {
                        this.stage = this.initialStage();
                        this.inputTank.setFluid(new FluidStack(FluidRegistry.WATER, 5000));
                        this.meltingTime = 0;
                    }
                }
            }
            if (this.mustDesublimate()) {
                if (this.getStage() == 0 && this.getTankAmount() >= 1000) {
                    this.cooktime = 0;
                    this.stage = this.finalStage();
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187659_cY, SoundCategory.AMBIENT, 1.0f, 1.0f);
                    this.setPoorSalt();
                    this.meltingTime = 0;
                }
            } else if (this.canProcess()) {
                ++this.cooktime;
                this.meltingTime = 0;
                if (this.getCooktime() >= this.calculatedEvaporation(biome)) {
                    this.cooktime = 0;
                    this.process();
                }
            } else {
                this.cooktime = 0;
            }
            if (this.getStage() == this.finalStage()) {
                if (this.outputSlot().func_190926_b()) {
                    this.stage = this.initialStage();
                }
            } else if (this.getTankAmount() == 0) {
                this.stage = this.initialStage();
            }
            this.markDirtyClient();
        }
    }

    private void setRawSalt() {
        this.inputTank.setFluid(null);
        this.output.setStackInSlot(0, new ItemStack(ModBlocks.MISC_BLOCKS_A, 1, EnumMiscBlocksA.RAW_SALT.ordinal()));
    }

    private void setPoorSalt() {
        this.inputTank.setFluid(null);
        this.output.setStackInSlot(0, new ItemStack(ModBlocks.MISC_BLOCKS_A, 1, EnumMiscBlocksA.POOR_RAW_SALT.ordinal()));
    }

    private boolean canProcess() {
        return this.getStage() < this.finalStage() && (this.getStage() > 0 && this.hasTankFluid() || this.getStage() == 0 && this.isFullTank()) && this.canEvaporate();
    }

    private void process() {
        if (this.getStage() == this.initialStage()) {
            this.inputTank.setFluid(BaseRecipes.getFluid(EnumFluid.VIRGIN_WATER, EnumSaltStages.getStageYeld(EnumSaltStages.STAGE_B.ordinal())));
        } else if (this.getStage() == EnumSaltStages.STAGE_B.ordinal()) {
            this.inputTank.setFluid(BaseRecipes.getFluid(EnumFluid.SALT_BRINE, EnumSaltStages.getStageYeld(EnumSaltStages.STAGE_C.ordinal())));
        } else if (this.getStage() == EnumSaltStages.STAGE_C.ordinal()) {
            this.inputTank.setFluid(BaseRecipes.getFluid(EnumFluid.SALT_BRINE, EnumSaltStages.getStageYeld(EnumSaltStages.STAGE_D.ordinal())));
        } else if (this.getStage() == EnumSaltStages.STAGE_D.ordinal()) {
            this.inputTank.setFluid(BaseRecipes.getFluid(EnumFluid.DENSE_BRINE, EnumSaltStages.getStageYeld(EnumSaltStages.STAGE_E.ordinal())));
        } else if (this.getStage() == EnumSaltStages.STAGE_E.ordinal()) {
            this.inputTank.setFluid(BaseRecipes.getFluid(EnumFluid.MOTHER_LIQUOR, EnumSaltStages.getStageYeld(EnumSaltStages.STAGE_F.ordinal())));
        } else if (this.getStage() == EnumSaltStages.STAGE_F.ordinal()) {
            this.setRawSalt();
        }
        if (this.getStage() < this.finalStage()) {
            ++this.stage;
        }
    }
}

