/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.tile;

import com.globbypotato.rockhounding_chemistry.ModItems;
import com.globbypotato.rockhounding_chemistry.enums.EnumMiscBlocksA;
import com.globbypotato.rockhounding_chemistry.enums.EnumMiscItems;
import com.globbypotato.rockhounding_chemistry.enums.utils.EnumServer;
import com.globbypotato.rockhounding_chemistry.handlers.ModConfig;
import com.globbypotato.rockhounding_chemistry.machines.io.MachineIO;
import com.globbypotato.rockhounding_chemistry.machines.recipe.DepositionChamberRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.DepositionChamberRecipe;
import com.globbypotato.rockhounding_chemistry.machines.tile.IInternalServer;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEDepositionChamberBase;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEGasPressurizer;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEPowerGenerator;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEServer;
import com.globbypotato.rockhounding_chemistry.machines.tile.TileStructure;
import com.globbypotato.rockhounding_chemistry.machines.tile.TileVessel;
import com.globbypotato.rockhounding_chemistry.utils.ModUtils;
import com.globbypotato.rockhounding_core.machines.tileentity.MachineStackHandler;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import com.globbypotato.rockhounding_core.machines.tileentity.WrappedItemHandler;
import com.globbypotato.rockhounding_core.utils.CoreUtils;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.oredict.OreDictionary;

public class TEDepositionChamberTop
extends TileEntityInv
implements IInternalServer {
    public static int inputSlots = 1;
    public static int outputSlots = 1;
    public static int templateSlots = 3;
    public int temperatureCount = 0;
    public int temperatureMax = 3000;
    public int pressureCount = 0;
    public int pressureMax = 32000;
    public int currentFile = -1;
    public boolean isRepeatable;
    public DepositionChamberRecipe dummyRecipe;

    public TEDepositionChamberTop() {
        super(inputSlots, outputSlots, templateSlots, 0);
        this.input = new MachineStackHandler(inputSlots, this){

            public ItemStack insertItem(int slot, ItemStack insertingStack, boolean simulate) {
                if (slot == 0 && TEDepositionChamberTop.this.isActive() && TEDepositionChamberTop.this.isValidInput(insertingStack)) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                return insertingStack;
            }
        };
        this.automationInput = new WrappedItemHandler((IItemHandlerModifiable)this.input, WrappedItemHandler.WriteMode.IN);
    }

    public ItemStack inputSlot() {
        return this.input.getStackInSlot(0);
    }

    public ItemStack outputSlot() {
        return this.output.getStackInSlot(0);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.pressureCount = compound.func_74762_e("PressureCount");
        this.temperatureCount = compound.func_74762_e("TemperatureCount");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("PressureCount", this.pressureCount);
        compound.func_74768_a("TemperatureCount", this.temperatureCount);
        return compound;
    }

    public ItemStackHandler getTemplate() {
        return this.template;
    }

    public int getGUIHeight() {
        return 200;
    }

    public static String getName() {
        return "deposition_chamber_top";
    }

    public int speedFactor() {
        return this.hasChamber() && ModUtils.isValidSpeedUpgrade(this.getChamber().speedSlot()) ? ModUtils.speedUpgrade(this.getChamber().speedSlot()) : 1;
    }

    public int getCooktimeMax() {
        return this.hasChamber() && ModUtils.isValidSpeedUpgrade(this.getChamber().speedSlot()) ? ModConfig.speedDeposition / ModUtils.speedUpgrade(this.getChamber().speedSlot()) : ModConfig.speedDeposition;
    }

    private static int deviceCode() {
        return EnumServer.DEPOSITION.ordinal();
    }

    public BlockPos poweredPosition() {
        return this.chamberPos().func_177972_a(this.poweredFacing());
    }

    public EnumFacing poweredFacing() {
        return this.getFacing().func_176734_d();
    }

    public boolean isValidPreset() {
        return this.getRecipeIndex() > -1 && this.getRecipeIndex() < this.recipeList().size();
    }

    public ArrayList<DepositionChamberRecipe> recipeList() {
        return DepositionChamberRecipes.deposition_chamber_recipes;
    }

    public DepositionChamberRecipe getRecipeList(int x) {
        return this.recipeList().get(x);
    }

    boolean isValidInput(ItemStack stack) {
        ArrayList inputOreIDs;
        return this.isValidPreset() && !stack.func_190926_b() && (this.recipeList().get(this.getRecipeIndex()).getType() ? !(inputOreIDs = CoreUtils.intArrayToList((int[])OreDictionary.getOreIDs((ItemStack)stack))).isEmpty() && inputOreIDs.contains(OreDictionary.getOreID((String)this.recipeList().get(this.getRecipeIndex()).getOredict())) : this.recipeList().get(this.getRecipeIndex()).getInput().func_77969_a(stack));
    }

    public DepositionChamberRecipe getCurrentRecipe() {
        if (this.isValidPreset() && this.isValidInput(this.inputSlot()) && this.handleSolvent() && this.handleCarrier() && this.handleProduct()) {
            return this.getRecipeList(this.getRecipeIndex());
        }
        return null;
    }

    public DepositionChamberRecipe getDummyRecipe() {
        return this.dummyRecipe;
    }

    public boolean isValidRecipe() {
        return this.getDummyRecipe() != null;
    }

    public ItemStack recipeInput() {
        return this.isValidPreset() ? this.getRecipeList(this.getRecipeIndex()).getInput() : ItemStack.field_190927_a;
    }

    public FluidStack recipeSolvent() {
        return this.isValidPreset() ? this.getRecipeList(this.getRecipeIndex()).getSolvent() : null;
    }

    public FluidStack recipeCarrier() {
        return this.isValidPreset() ? this.getRecipeList(this.getRecipeIndex()).getCarrier() : null;
    }

    public ItemStack recipeOutput() {
        return this.isValidPreset() ? this.getRecipeList(this.getRecipeIndex()).getOutput() : ItemStack.field_190927_a;
    }

    public boolean oredictType() {
        return this.isValidPreset() ? this.getRecipeList(this.getRecipeIndex()).getType() : false;
    }

    private void doPreset() {
        if (this.hasEngine()) {
            if (this.getEngine().enablePower) {
                this.getEngine().enablePower = false;
                this.getEngine().markDirtyClient();
            }
            if (!this.getEngine().enableRedstone) {
                this.getEngine().enableRedstone = true;
                this.getEngine().markDirtyClient();
            }
        }
        if (this.isValidPreset()) {
            if (this.hasInputVessel() && this.getInputVessel().getFilter() != this.recipeSolvent()) {
                this.getInputVessel().filter = this.recipeSolvent();
            }
            if (this.hasCarrierVessel() && this.getCarrierVessel().getFilter() != this.recipeCarrier()) {
                this.getCarrierVessel().filter = this.recipeCarrier();
            }
        }
    }

    public int getPressure() {
        return this.pressureCount;
    }

    public int getPressureMax() {
        return this.pressureMax;
    }

    public int getTemperature() {
        return this.temperatureCount;
    }

    public int getTemperatureMax() {
        return this.temperatureMax;
    }

    public int takenRF() {
        int baseConsume = 1000 * ModConfig.basePower;
        return ModConfig.speedMultiplier ? baseConsume * this.speedFactor() : baseConsume;
    }

    public TEPowerGenerator getEngine() {
        TEPowerGenerator engine = TileStructure.getEngine(this.field_145850_b, this.field_174879_c, this.getFacing(), 1, 0);
        return engine != null ? engine : null;
    }

    public boolean hasEngine() {
        return this.getEngine() != null;
    }

    public BlockPos chamberPos() {
        return this.field_174879_c.func_177967_a(EnumFacing.DOWN, 1);
    }

    public TEDepositionChamberBase getChamber() {
        TEDepositionChamberBase tank;
        TileEntity te = this.field_145850_b.func_175625_s(this.chamberPos());
        if (this.field_145850_b.func_180495_p(this.chamberPos()) != null && te instanceof TEDepositionChamberBase && (tank = (TEDepositionChamberBase)te).getFacing() == this.getFacing()) {
            return tank;
        }
        return null;
    }

    public boolean hasChamber() {
        return this.getChamber() != null;
    }

    public Block getSeparator1() {
        BlockPos separatorPos = this.chamberPos().func_177967_a(this.getFacing(), 1);
        IBlockState sepState = this.field_145850_b.func_180495_p(separatorPos);
        Block separator = sepState.func_177230_c();
        if (MachineIO.miscBlocksA(separator, sepState, EnumMiscBlocksA.SEPARATOR.ordinal())) {
            return separator;
        }
        return null;
    }

    public Block getSeparator2() {
        BlockPos separatorPos = this.chamberPos().func_177967_a(this.getFacing(), 2);
        IBlockState sepState = this.field_145850_b.func_180495_p(separatorPos);
        Block separator = sepState.func_177230_c();
        if (MachineIO.miscBlocksA(separator, sepState, EnumMiscBlocksA.SEPARATOR.ordinal())) {
            return separator;
        }
        return null;
    }

    public TileVessel getInputVessel() {
        TileVessel vessel = TileStructure.getHolder(this.field_145850_b, this.chamberPos(), this.isFacingAt(270), 1, 180);
        return vessel != null ? vessel : null;
    }

    public boolean hasInputVessel() {
        return this.getInputVessel() != null;
    }

    public TileVessel getCarrierVessel() {
        TileVessel vessel = TileStructure.getHolder(this.field_145850_b, this.field_174879_c, this.isFacingAt(90), 1, 180);
        return vessel != null ? vessel : null;
    }

    public boolean hasCarrierVessel() {
        return this.getCarrierVessel() != null;
    }

    public TileVessel getPurgeVessel() {
        TileVessel vessel = TileStructure.getHolder(this.field_145850_b, this.chamberPos(), this.getFacing(), 3, 0);
        return vessel != null ? vessel : null;
    }

    public boolean hasPurgeVessel() {
        return this.getPurgeVessel() != null;
    }

    public TEGasPressurizer getPressurizer1() {
        BlockPos pressurizerPos = this.chamberPos().func_177967_a(this.getFacing(), 1);
        TEGasPressurizer pressurizer = TileStructure.getPressurizer(this.field_145850_b, pressurizerPos, this.isFacingAt(90), 1, 0);
        return pressurizer != null ? pressurizer : null;
    }

    public TEGasPressurizer getPressurizer2() {
        BlockPos pressurizerPos = this.chamberPos().func_177967_a(this.getFacing(), 1);
        TEGasPressurizer pressurizer = TileStructure.getPressurizer(this.field_145850_b, pressurizerPos, this.isFacingAt(270), 1, 0);
        return pressurizer != null ? pressurizer : null;
    }

    public boolean hasPressurizers() {
        return this.getPressurizer1() != null && this.getPressurizer2() != null && this.getSeparator1() != null && this.getSeparator2() != null && this.getChamber() != null;
    }

    public TEServer getServer() {
        TEServer server = TileStructure.getServer(this.field_145850_b, this.chamberPos(), this.isFacingAt(270), 1, 0);
        return server != null ? server : null;
    }

    public boolean hasServer() {
        return this.getServer() != null;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.doPreset();
            this.handlePurge();
            this.initializeServer(this.isRepeatable, this.hasServer(), this.getServer(), TEDepositionChamberTop.deviceCode());
            if (this.isActive() && this.getDummyRecipe() == null) {
                this.dummyRecipe = this.getCurrentRecipe();
                this.cooktime = 0;
            }
            if (this.isValidPreset()) {
                this.handleParameters();
                if (this.canProcess()) {
                    ++this.cooktime;
                    if (this.getCooktime() >= this.getCooktimeMax()) {
                        this.cooktime = 0;
                        this.process();
                    }
                    this.markDirtyClient();
                } else {
                    this.cooktime = 0;
                }
            } else {
                this.handleRelaxing();
            }
        }
    }

    public boolean canProcess() {
        return this.isActive() && this.hasPressurizers() && this.hasTemperature() && this.hasPressure() && this.handleServer(this.hasServer(), this.getServer(), this.currentFile);
    }

    private boolean hasPressure() {
        return this.isValidPreset() && this.getPressure() >= this.getRecipeList(this.getRecipeIndex()).getPressure();
    }

    private boolean hasTemperature() {
        return this.isValidPreset() && this.getTemperature() >= this.getRecipeList(this.getRecipeIndex()).getTemperature();
    }

    private void process() {
        if (this.getDummyRecipe() != null && this.getDummyRecipe() == this.getCurrentRecipe()) {
            if (this.hasChamber()) {
                ((MachineStackHandler)this.getChamber().getOutput()).setOrStack(0, this.recipeOutput());
            }
            if (this.hasInputVessel() && this.recipeSolvent() != null) {
                this.getInputVessel().inputTank.drainInternal(this.recipeSolvent(), true);
            }
            if (this.hasCarrierVessel() && this.recipeCarrier() != null) {
                this.getCarrierVessel().inputTank.drainInternal(this.recipeCarrier(), true);
            }
            this.temperatureCount /= 3;
            this.pressureCount /= 3;
            this.input.decrementSlot(0);
            this.updateServer(this.hasServer(), this.getServer(), this.currentFile);
        }
        this.dummyRecipe = null;
    }

    private void handlePurge() {
        if (!(!this.isActive() || this.isValidPreset() && this.isValidRecipe())) {
            if (!this.inputSlot().func_190926_b() && this.isPurgeable() && this.output.canSetOrStack(this.outputSlot(), this.inputSlot())) {
                this.output.setOrStack(0, this.inputSlot());
                this.input.setStackInSlot(0, ItemStack.field_190927_a);
            }
            if (this.hasPurgeVessel()) {
                int canSend;
                int canReceive;
                if (this.hasInputVessel() && this.isWrongSolvent() && this.canPurgeSolvent()) {
                    canReceive = this.getPurgeVessel().inputTank.getCapacity() - this.getPurgeVessel().inputTank.getFluidAmount();
                    canSend = Math.min(this.getInputVessel().inputTank.getFluidAmount(), canReceive);
                    this.input.setOrFillFluid(this.getPurgeVessel().inputTank, this.vesselSolvent(), canSend);
                    this.input.drainOrCleanFluid(this.getInputVessel().inputTank, canSend, true);
                }
                if (this.hasCarrierVessel() && this.isWrongCarrier() && this.canPurgeCarrier()) {
                    canReceive = this.getPurgeVessel().inputTank.getCapacity() - this.getPurgeVessel().inputTank.getFluidAmount();
                    canSend = Math.min(this.getCarrierVessel().inputTank.getFluidAmount(), canReceive);
                    this.input.setOrFillFluid(this.getPurgeVessel().inputTank, this.vesselCarrier(), canSend);
                    this.input.drainOrCleanFluid(this.getCarrierVessel().inputTank, canSend, true);
                }
            }
        }
    }

    private boolean isPurgeable() {
        ArrayList inputOreIDs;
        return this.oredictType() ? !(inputOreIDs = CoreUtils.intArrayToList((int[])OreDictionary.getOreIDs((ItemStack)this.inputSlot()))).contains(OreDictionary.getOreID((String)this.recipeList().get(this.getRecipeIndex()).getOredict())) : !CoreUtils.isMatchingIngredient((ItemStack)this.recipeInput(), (ItemStack)this.inputSlot());
    }

    public FluidStack vesselSolvent() {
        return this.hasInputVessel() ? this.getInputVessel().inputTank.getFluid() : null;
    }

    public FluidStack vesselCarrier() {
        return this.hasCarrierVessel() ? this.getCarrierVessel().inputTank.getFluid() : null;
    }

    private boolean isWrongSolvent() {
        return this.vesselSolvent() != null && (this.recipeSolvent() == null || this.recipeSolvent() != null && !this.recipeSolvent().isFluidEqual(this.vesselSolvent()));
    }

    private boolean isWrongCarrier() {
        return this.vesselCarrier() != null && (this.recipeCarrier() == null || this.recipeCarrier() != null && !this.recipeCarrier().isFluidEqual(this.vesselCarrier()));
    }

    private boolean canPurgeSolvent() {
        return this.vesselSolvent() != null && this.input.canSetOrFillFluid(this.getPurgeVessel().inputTank, this.getPurgeVessel().inputTank.getFluid(), this.vesselSolvent());
    }

    private boolean canPurgeCarrier() {
        return this.vesselCarrier() != null && this.input.canSetOrFillFluid(this.getPurgeVessel().inputTank, this.getPurgeVessel().inputTank.getFluid(), this.vesselCarrier());
    }

    private boolean handleSolvent() {
        return this.recipeSolvent() != null && this.hasInputVessel() && this.input.canDrainFluid(this.getInputVessel().getTankFluid(), this.recipeSolvent());
    }

    private boolean handleCarrier() {
        return this.recipeCarrier() != null && this.hasCarrierVessel() && this.input.canDrainFluid(this.getCarrierVessel().getTankFluid(), this.recipeCarrier());
    }

    private boolean handleProduct() {
        return this.recipeOutput() == null || this.recipeOutput() != null && this.hasChamber() && this.input.canSetOrStack(this.getChamber().outputSlot(), this.recipeOutput());
    }

    private void handleParameters() {
        this.handleRelaxing();
        if (this.hasEngine() && this.isActive()) {
            int temp = this.getRecipeList(this.getRecipeIndex()).getTemperature();
            int press = this.getRecipeList(this.getRecipeIndex()).getPressure();
            if (this.getEngine().getRedstone() >= this.takenRF() && this.getTemperature() < temp && temp < this.getTemperatureMax() - this.tempYeld()) {
                this.getEngine().redstoneCount -= this.takenRF();
                this.temperatureCount += this.tempYeld();
                this.getEngine().markDirtyClient();
                this.markDirtyClient();
            }
            if (this.getEngine().getRedstone() >= this.takenRF() && this.getPressure() < press && press < this.getPressureMax() - this.pressYeld()) {
                this.getEngine().redstoneCount -= this.takenRF();
                this.pressureCount += this.pressYeld();
                this.getEngine().markDirtyClient();
                this.markDirtyClient();
            }
        }
    }

    private void handleRelaxing() {
        if (this.getTemperature() > this.tempStability() && this.rand.nextInt(10) == 0 && this.rand.nextInt(this.stabilityDelta()) == 0) {
            this.temperatureCount -= this.tempStability();
            this.markDirtyClient();
        }
        if (this.getPressure() > this.pressStability() && this.rand.nextInt(10) == 0 && this.rand.nextInt(this.stabilityDelta()) == 0) {
            this.pressureCount -= this.pressStability();
            this.markDirtyClient();
        }
    }

    public int tempYeld() {
        return 10 * this.getCasing();
    }

    public int pressYeld() {
        return 30 * this.getCasing();
    }

    private int getCasing() {
        return this.hasChamber() && this.getChamber().hasCasing() ? 10 : 1;
    }

    public int tempStability() {
        return 300 / this.getInsulation();
    }

    public int pressStability() {
        return 500 / this.getInsulation();
    }

    public int stabilityDelta() {
        return 100 + 10 * this.getInsulation();
    }

    private int getInsulation() {
        return this.hasChamber() && this.getChamber().hasInsulation() ? 10 : 1;
    }

    @Override
    public void loadServerStatus() {
        this.currentFile = -1;
        if (this.getServer().isActive()) {
            for (int x = 0; x < TEServer.FILE_SLOTS.length; ++x) {
                NBTTagCompound tag;
                ItemStack fileSlot = this.getServer().inputSlot(x).func_77946_l();
                if (!fileSlot.func_190926_b() && fileSlot.func_77969_a(new ItemStack(ModItems.MISC_ITEMS, 1, EnumMiscItems.SERVER_FILE.ordinal())) && fileSlot.func_77942_o() && this.isValidFile(tag = fileSlot.func_77978_p()) && tag.func_74762_e("Device") == TEDepositionChamberTop.deviceCode() && tag.func_74762_e("Recipe") < this.recipeList().size() && tag.func_74762_e("Done") > 0) {
                    if (this.recipeIndex != tag.func_74762_e("Recipe")) {
                        this.recipeIndex = tag.func_74762_e("Recipe");
                        this.markDirtyClient();
                    }
                    if (this.currentFile == x) break;
                    this.currentFile = x;
                    this.markDirtyClient();
                    break;
                }
                if (x != TEServer.FILE_SLOTS.length - 1) continue;
                this.resetFiles(this.getServer(), TEDepositionChamberTop.deviceCode());
            }
        }
    }
}

