/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.tile;

import com.globbypotato.rockhounding_chemistry.ModItems;
import com.globbypotato.rockhounding_chemistry.enums.materials.EnumChemicals;
import com.globbypotato.rockhounding_chemistry.enums.materials.EnumFluid;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEExtractorStabilizer;
import com.globbypotato.rockhounding_chemistry.machines.tile.TELabOvenChamber;
import com.globbypotato.rockhounding_chemistry.machines.tile.TELabOvenController;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEReformerController;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEReformerReactor;
import com.globbypotato.rockhounding_chemistry.machines.tile.TETubularBedLow;
import com.globbypotato.rockhounding_chemistry.machines.tile.TileStructure;
import com.globbypotato.rockhounding_chemistry.machines.tile.TileVessel;
import com.globbypotato.rockhounding_chemistry.utils.BaseRecipes;
import com.globbypotato.rockhounding_core.machines.tileentity.MachineStackHandler;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityTank;
import com.globbypotato.rockhounding_core.utils.CoreBasics;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerConcatenate;

public class TECatalystRegen
extends TileEntityTank {
    public static int outputSlots = 1;
    public static int templateSlots = 1;
    public FluidTank inputTank = new FluidTank(this.getTankCapacity()){

        public boolean canFillFluidType(FluidStack fluid) {
            return fluid.isFluidEqual(CoreBasics.waterStack((int)1000));
        }

        public boolean canDrain() {
            return false;
        }
    };
    public int catSlot;
    public int systSlot;

    public TECatalystRegen() {
        super(0, outputSlots, templateSlots, 0);
        this.inputTank.setTileEntity((TileEntity)this);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inputTank.readFromNBT(compound.func_74775_l("InputTank"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        NBTTagCompound inputTankNBT = new NBTTagCompound();
        this.inputTank.writeToNBT(inputTankNBT);
        compound.func_74782_a("InputTank", (NBTBase)inputTankNBT);
        return compound;
    }

    public FluidHandlerConcatenate getCombinedTank() {
        return new FluidHandlerConcatenate(new IFluidHandler[]{this.inputTank});
    }

    public ItemStack outputSlot() {
        return this.output.getStackInSlot(0);
    }

    public int getGUIHeight() {
        return 200;
    }

    public static String getName() {
        return "catalyst_regen";
    }

    public EnumFacing poweredFacing() {
        return this.getFacing();
    }

    public int getTankCapacity() {
        return 5000;
    }

    public boolean hasInputFluid() {
        return this.inputTank.getFluid() != null;
    }

    public FluidStack getInputFluid() {
        return this.hasInputFluid() ? this.inputTank.getFluid() : null;
    }

    public int getInputAmount() {
        return this.hasInputFluid() ? this.inputTank.getFluidAmount() : 0;
    }

    public int consumedGas() {
        return 200;
    }

    public int consumedWater() {
        return 1000;
    }

    public TileVessel getInTank() {
        TileVessel vessel = TileStructure.getHolder(this.field_145850_b, this.field_174879_c, this.getFacing(), 1, 180);
        return vessel != null ? vessel : null;
    }

    public boolean hasInTank() {
        return this.getInTank() != null;
    }

    private boolean hasFluegas() {
        return this.hasInTank() && this.input.canDrainFluid(this.getInTank().inputTank.getFluid(), TECatalystRegen.fluegas(), this.consumedGas());
    }

    private static FluidStack fluegas() {
        return BaseRecipes.getFluid(EnumFluid.FLUE_GAS, 1000);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            TileEntity tile;
            if (this.isActive() && this.field_145850_b.field_73012_v.nextInt(6) == 0 && (tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a())) != null) {
                TileEntity reactor;
                if (tile instanceof TEExtractorStabilizer) {
                    TEExtractorStabilizer served = (TEExtractorStabilizer)tile;
                    for (int x = 0; x < TEExtractorStabilizer.SLOT_INPUTS.length; ++x) {
                        ItemStack thisCat = served.catSlot(x);
                        this.regenCat(thisCat);
                    }
                } else if (tile instanceof TEReformerController) {
                    TileEntity reactor2 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177981_b(2));
                    if (reactor2 != null) {
                        TEReformerReactor served = (TEReformerReactor)reactor2;
                        for (int x = 0; x < TEReformerReactor.totCatalysts; ++x) {
                            ItemStack thisCat = served.inputSlot(x);
                            this.regenCat(thisCat);
                        }
                    }
                } else if (tile instanceof TELabOvenChamber) {
                    TileEntity reactor3 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177981_b(2));
                    if (reactor3 != null) {
                        TELabOvenController served = (TELabOvenController)reactor3;
                        if (this.canRegen()) {
                            ItemStack thisCat = served.catalystSlot();
                            this.regenCat(thisCat);
                        }
                    }
                } else if (tile instanceof TETubularBedLow && (reactor = this.field_145850_b.func_175625_s(this.field_174879_c.func_177981_b(2))) != null) {
                    TETubularBedLow served = (TETubularBedLow)reactor;
                    for (int x = 0; x < TETubularBedLow.SLOT_INPUTS.length; ++x) {
                        ItemStack thisCat = served.catalystSlot(x);
                        this.regenCat(thisCat);
                    }
                }
            }
            this.markDirtyClient();
        }
    }

    private void regenCat(ItemStack thisCat) {
        if (this.canRegen() && !thisCat.func_190926_b() && this.shouldRegen(thisCat)) {
            thisCat.func_77964_b(0);
            this.consumeStats();
        }
    }

    private boolean canRegen() {
        return this.getInputAmount() >= this.consumedWater() && this.hasFluegas();
    }

    private boolean shouldRegen(ItemStack thisCat) {
        return thisCat.func_77958_k() - thisCat.func_77952_i() < thisCat.func_77958_k() / 4;
    }

    private void consumeStats() {
        this.input.drainOrCleanFluid(this.inputTank, this.consumedWater(), true);
        ((MachineStackHandler)this.getInTank().getInput()).drainOrCleanFluid(this.getInTank().inputTank, this.consumedGas(), true);
        if (this.field_145850_b.field_73012_v.nextInt(3) == 0) {
            ItemStack coke_compound = new ItemStack(ModItems.CHEMICAL_ITEMS, 1, EnumChemicals.COKE_COMPOUND.ordinal());
            if (this.output.canSetOrStack(this.outputSlot(), coke_compound)) {
                this.output.setOrIncrement(0, coke_compound);
            }
        }
    }
}

