/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.tile;

import com.globbypotato.rockhounding_chemistry.ModItems;
import com.globbypotato.rockhounding_chemistry.enums.EnumMiscItems;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEServer;
import com.globbypotato.rockhounding_core.utils.CoreUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public interface IInternalServer {
    default public void initializeServer(boolean isRepeatable, boolean hasServer, TEServer server, int code) {
        if (hasServer) {
            this.setServerCode(server, code);
            this.checkRepeatable(isRepeatable, server, code);
            this.loadServerStatus();
        }
    }

    default public void loadServerStatus() {
    }

    default public void setServerCode(TEServer server, int code) {
        if (server.servedDevice() != code) {
            server.applyServer(code);
        }
    }

    default public void checkRepeatable(boolean isRepeatable, TEServer server, int code) {
        isRepeatable = false;
        for (int x = 0; x < TEServer.FILE_SLOTS.length; ++x) {
            NBTTagCompound tag;
            ItemStack fileSlot = server.inputSlot(x).func_77946_l();
            if (!fileSlot.func_77942_o() || !this.isValidFile(tag = fileSlot.func_77978_p()) || tag.func_74762_e("Device") != code || !tag.func_74767_n("Cycle")) continue;
            isRepeatable = true;
            break;
        }
    }

    default public void resetFiles(TEServer server, int code) {
        for (int k = 0; k < TEServer.FILE_SLOTS.length; ++k) {
            NBTTagCompound tag;
            ItemStack fileSlot = server.inputSlot(k);
            if (fileSlot.func_190926_b() || !fileSlot.func_77969_a(new ItemStack(ModItems.MISC_ITEMS, 1, EnumMiscItems.SERVER_FILE.ordinal())) || !fileSlot.func_77942_o() || !this.isValidFile(tag = fileSlot.func_77978_p()) || tag.func_74762_e("Device") != code || !tag.func_74767_n("Cycle") || tag.func_74762_e("Done") > 0) continue;
            tag.func_74768_a("Done", tag.func_74762_e("Amount"));
        }
    }

    default public boolean handleServer(boolean hasServer, TEServer server, int currentFile) {
        return this.isServerOpen(hasServer, server, currentFile) || this.isServedClosed(hasServer, server);
    }

    default public boolean isServedClosed(boolean hasServer, TEServer server) {
        return !hasServer || hasServer && !server.isActive();
    }

    default public boolean isServerOpen(boolean hasServer, TEServer server, int currentFile) {
        return this.isServerOn(hasServer, server) && this.hasActiveFile(currentFile);
    }

    default public boolean handleFilter(ItemStack inputstack, ItemStack filterstack) {
        if (!filterstack.func_190926_b()) {
            return CoreUtils.isMatchingIngredient((ItemStack)inputstack, (ItemStack)filterstack);
        }
        return true;
    }

    default public boolean isServerOn(boolean hasServer, TEServer server) {
        return hasServer && server.isActive();
    }

    default public boolean hasActiveFile(int currentFile) {
        return currentFile > -1;
    }

    default public void updateServer(boolean hasServer, TEServer server, int currentFile) {
        if (this.isServerOpen(hasServer, server, currentFile)) {
            this.refreshServer(server, currentFile);
        }
    }

    default public void refreshServer(TEServer server, int currentFile) {
        NBTTagCompound tag;
        if (this.hasActiveFile(currentFile) && this.isValidFile(tag = server.inputSlot(currentFile).func_77978_p())) {
            int doRecipe = tag.func_74762_e("Done") - 1;
            tag.func_74768_a("Done", doRecipe);
        }
    }

    default public boolean isValidFile(NBTTagCompound tag) {
        return tag.func_74764_b("Device") && tag.func_74764_b("Cycle") && tag.func_74764_b("Recipe") && tag.func_74764_b("Done");
    }
}

