/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.tile;

import com.globbypotato.rockhounding_chemistry.ModBlocks;
import com.globbypotato.rockhounding_chemistry.handlers.ModConfig;
import com.globbypotato.rockhounding_chemistry.machines.recipe.PollutantRecipes;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEExhaustionValve;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraft.block.material.Material;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidTank;

public interface ICollapse {
    default public ArrayList<FluidTank> collapseList() {
        ArrayList<FluidTank> tanks = new ArrayList<FluidTank>();
        return tanks;
    }

    default public boolean handleCollapse(int collapse, World world, BlockPos pos) {
        for (FluidTank tank : this.collapseList()) {
            if (tank.getFluid() == null || !tank.getFluid().getFluid().isGaseous() || tank.getFluidAmount() < tank.getCapacity()) continue;
            return true;
        }
        return false;
    }

    default public boolean handleRelease(int collapse, World world, BlockPos pos) {
        boolean full = false;
        for (FluidTank tank : this.collapseList()) {
            if (tank.getFluidAmount() < tank.getCapacity()) continue;
            full = true;
        }
        return !full;
    }

    default public void doExhaustion(World world, BlockPos pos, int size) {
        for (FluidTank tank : this.collapseList()) {
            if (!this.isFullTank(tank)) continue;
            int dumpAmount = tank.getFluidAmount() * ModConfig.exhaustRate / 100;
            tank.drainInternal(dumpAmount, true);
            world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187659_cY, SoundCategory.AMBIENT, 1.0f, 0.2f);
            if (!this.isHazardousGas(tank)) continue;
            this.spawnCloud(world, pos, size);
        }
    }

    default public boolean isFullTank(FluidTank tank) {
        return tank.getFluid() != null && tank.getFluid().getFluid().isGaseous() && tank.getFluidAmount() >= tank.getCapacity();
    }

    default public boolean isHazardousGas(FluidTank tank) {
        return PollutantRecipes.pollutant_gases.size() > 0 && PollutantRecipes.pollutant_gases.contains(tank.getFluid());
    }

    default public void spawnCloud(World world, BlockPos pos, int size) {
        LinkedList queue = Lists.newLinkedList();
        ArrayList list = Lists.newArrayList();
        queue.add(new Tuple((Object)pos, (Object)0));
        int i = 0;
        while (!queue.isEmpty()) {
            Tuple tuple = (Tuple)queue.poll();
            BlockPos blockpos = (BlockPos)tuple.func_76341_a();
            int j = (Integer)tuple.func_76340_b();
            for (EnumFacing enumfacing : EnumFacing.values()) {
                BlockPos blockpos1 = blockpos.func_177972_a(enumfacing);
                if (world.func_180495_p(blockpos1).func_185904_a() != Material.field_151579_a) continue;
                world.func_180501_a(blockpos1, ModBlocks.TOXIC_CLOUD.func_176223_P(), 2);
                list.add(blockpos1);
                ++i;
                if (j >= 6) continue;
                queue.add(new Tuple((Object)blockpos1, (Object)(j + 1)));
            }
            if (i <= ModConfig.toxicCloudSize * size) continue;
            break;
        }
    }

    default public TEExhaustionValve getExhaust(World world, BlockPos pos, int offset) {
        BlockPos exhaustPos = pos.func_177967_a(EnumFacing.UP, offset);
        TileEntity te = world.func_175625_s(exhaustPos);
        if (world.func_180495_p(exhaustPos) != null && te instanceof TEExhaustionValve) {
            TEExhaustionValve chamber = (TEExhaustionValve)te;
            return chamber;
        }
        return null;
    }

    default public boolean hasExhaust(World world, BlockPos pos, int offset) {
        return this.getExhaust(world, pos, offset) != null;
    }
}

