/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.gui;

import com.globbypotato.rockhounding_chemistry.machines.container.COPipelineValve;
import com.globbypotato.rockhounding_chemistry.machines.gui.GuiBase;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEPipelineValve;
import com.globbypotato.rockhounding_core.machines.gui.GuiUtils;
import java.util.List;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class UIPipelineValve
extends GuiBase {
    public static final ResourceLocation TEXTURE_REF = new ResourceLocation("rockhounding_chemistry:textures/gui/guipipelinevalve.png");
    private final TEPipelineValve tile;

    public UIPipelineValve(InventoryPlayer playerInv, TEPipelineValve tile) {
        super(new COPipelineValve((IInventory)playerInv, tile), 200);
        TEXTURE = TEXTURE_REF;
        this.tile = tile;
        this.containerName = "container.pipeline_valve";
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float f) {
        super.func_73863_a(mouseX, mouseY, f);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        for (int side = 0; side < this.tile.sideFilter.length; ++side) {
            int offset = side * 18;
            String filterString = TextFormatting.BLUE + "Fluid Filter: " + TextFormatting.WHITE + "use a filled ampoule to set";
            if (this.tile.sideFilter[side] != null) {
                filterString = TextFormatting.GRAY + "Filter: " + TextFormatting.AQUA + this.tile.sideFilter[side].getLocalizedName();
            }
            if (GuiUtils.hoveringArea((int)(34 + offset), (int)63, (int)18, (int)18, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
                List tooltip = GuiUtils.drawLabel((String)filterString, (int)mouseX, (int)mouseY);
                this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
            }
            String statusString = TextFormatting.RED + "Disabled";
            if (this.tile.tiltStatus[side]) {
                statusString = TextFormatting.GOLD + "Unavailable";
            } else if (this.tile.sideStatus[side]) {
                statusString = TextFormatting.GREEN + "Enabled";
            }
            String gaugestring = TextFormatting.GRAY + UIPipelineValve.formalDir(EnumFacing.func_82600_a((int)side).func_176610_l()) + " joint: " + statusString;
            if (GuiUtils.hoveringArea((int)(34 + offset), (int)30, (int)18, (int)32, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
                List tooltip = GuiUtils.drawLabel((String)gaugestring, (int)mouseX, (int)mouseY);
                this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
            }
            String robinString = TextFormatting.RED + "Disabled";
            if (this.tile.hasRoundRobin()) {
                robinString = TextFormatting.GREEN + "Enabled";
            }
            String robin = TextFormatting.GRAY + "Round Robin: " + robinString;
            if (!GuiUtils.hoveringArea((int)11, (int)53, (int)18, (int)18, (int)mouseX, (int)mouseY, (int)x, (int)y)) continue;
            List tooltip = GuiUtils.drawLabel((String)robin, (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
    }

    @Override
    public void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int offset;
        int side;
        super.func_146976_a(partialTicks, mouseX, mouseY);
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        for (side = 0; side < this.tile.sideStatus.length; ++side) {
            offset = side * 18;
            if (!this.tile.tiltStatus[side]) {
                if (!this.tile.sideStatus[side]) continue;
                this.func_73729_b(i + 36 + offset, j + 46, 176, 14, 14, 14);
                continue;
            }
            if (!this.tile.sideStatus[side]) continue;
            this.func_73729_b(i + 36 + offset, j + 46, 176, 0, 14, 14);
        }
        if (this.tile.hasRoundRobin()) {
            this.func_73729_b(i + 13, j + 55, 176, 28, 14, 14);
        }
        for (side = 0; side < this.tile.sideFilter.length; ++side) {
            if (this.tile.sideFilter[side] == null) continue;
            offset = side * 18;
            GuiUtils.renderFluidBar((FluidStack)this.tile.sideFilter[side], (int)1000, (int)1000, (int)(i + 35 + offset), (int)(j + 64), (int)16, (int)16);
        }
    }

    private static String formalDir(String dir) {
        return dir.substring(0, 1).toUpperCase() + dir.substring(1);
    }
}

