/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.gui;

import com.globbypotato.rockhounding_chemistry.enums.materials.EnumElements;
import com.globbypotato.rockhounding_chemistry.machines.container.COMetalAlloyer;
import com.globbypotato.rockhounding_chemistry.machines.gui.GuiBase;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.MetalAlloyerRecipe;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEMetalAlloyer;
import com.globbypotato.rockhounding_core.machines.gui.GuiUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class UIMetalAlloyer
extends GuiBase {
    public static ResourceLocation TEXTURE_REF = new ResourceLocation("rockhounding_chemistry:textures/gui/guimetalalloyer.png");
    public static ResourceLocation TEXTURE_JEI = new ResourceLocation("rockhounding_chemistry:textures/gui/jei/guimetalalloyerjei.png");
    private final TEMetalAlloyer tile;
    private List<String> alloy;

    public UIMetalAlloyer(InventoryPlayer playerInv, TEMetalAlloyer tile) {
        super(new COMetalAlloyer((IInventory)playerInv, tile), 200);
        GuiBase.TEXTURE = TEXTURE_REF;
        this.tile = tile;
        this.containerName = "container." + TEMetalAlloyer.getName();
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float f) {
        List tooltip;
        super.func_73863_a(mouseX, mouseY, f);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        if (GuiUtils.hoveringArea((int)79, (int)96, (int)18, (int)18, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
            tooltip = GuiUtils.drawLabel((String)this.activation_label, (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
        if (GuiUtils.hoveringArea((int)7, (int)20, (int)18, (int)18, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
            tooltip = GuiUtils.drawLabel((String)"Server", (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
        if (GuiUtils.hoveringArea((int)25, (int)20, (int)18, (int)18, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
            tooltip = GuiUtils.drawLabel((String)"Previous Recipe", (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
        if (GuiUtils.hoveringArea((int)43, (int)20, (int)18, (int)18, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
            tooltip = GuiUtils.drawLabel((String)"Next Recipe", (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
        if (this.tile.previewSlot().func_190926_b() && GuiUtils.hoveringArea((int)14, (int)60, (int)18, (int)18, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
            tooltip = GuiUtils.drawLabel((String)"Output Preview", (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
        this.alloy = new ArrayList<String>();
        String recipeready = "";
        recipeready = this.tile.isValidRecipe() ? TextFormatting.DARK_GREEN + "Complete recipe:" : TextFormatting.GOLD + "Uncomplete recipe:";
        if (this.tile.isValidPreset()) {
            this.alloy.add(recipeready);
            MetalAlloyerRecipe recipe = this.tile.getRecipeList(this.tile.getRecipeIndex());
            for (int ingr = 0; ingr < recipe.getInputs().size(); ++ingr) {
                int element;
                boolean ingredientFound = false;
                String ingrOredict = recipe.getInputs().get(ingr);
                int ingrQuantity = recipe.getQuantities().get(ingr);
                if (!this.tile.hasCabinet() || !this.tile.hasMaterial()) continue;
                for (element = 0; element < this.tile.getCabinet().elementList.length; ++element) {
                    if (!EnumElements.getDust(element).matches(ingrOredict) || ingrQuantity > this.tile.getCabinet().elementList[element]) continue;
                    ingredientFound = true;
                }
                for (element = 0; element < this.tile.materialList().size(); ++element) {
                    if (!this.tile.getMaterialList(element).getOredict().matches(ingrOredict) || ingrQuantity > this.tile.getMaterial().elementList[element]) continue;
                    ingredientFound = true;
                }
                String ingredient = "";
                ingredient = ingredientFound ? TextFormatting.GREEN + ingrOredict + ": " + TextFormatting.YELLOW + ingrQuantity + " ppc" : TextFormatting.DARK_RED + ingrOredict + ": " + TextFormatting.YELLOW + ingrQuantity + " ppc";
                this.alloy.add(ingredient);
            }
        } else {
            recipeready = TextFormatting.RED + "Invalid recipe";
            this.alloy.add(recipeready);
        }
        if (GuiUtils.hoveringArea((int)16, (int)79, (int)14, (int)14, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
            this.drawHoveringText(this.alloy, mouseX, mouseY, this.field_146289_q);
        }
        if (GuiUtils.hoveringArea((int)49, (int)85, (int)14, (int)14, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
            String sf = TextFormatting.GRAY + "Tier: " + TextFormatting.AQUA + this.tile.speedFactor() + "x";
            String tk = TextFormatting.GRAY + "Process: " + TextFormatting.YELLOW + this.tile.getCooktimeMax() + " ticks";
            String[] multistring = new String[]{sf, tk};
            tooltip = GuiUtils.drawMultiLabel((String[])multistring, (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
        if (GuiUtils.hoveringArea((int)144, (int)60, (int)18, (int)18, (int)mouseX, (int)mouseY, (int)x, (int)y) && this.tile.speedSlot().func_190926_b()) {
            tooltip = GuiUtils.drawLabel((String)this.speed_label, (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
    }

    @Override
    public void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        String recipeLabel = "No recipe selected";
        if (this.tile.isValidPreset()) {
            recipeLabel = this.tile.getRecipeList(this.tile.getRecipeIndex()).getOutput().func_82833_r();
        }
        this.field_146289_q.func_78276_b(recipeLabel, 62, 25, 0x404040);
    }

    @Override
    public void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        super.func_146976_a(partialTicks, mouseX, mouseY);
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.tile.isActive()) {
            if (this.tile.isPowered()) {
                this.func_73729_b(i + 81, j + 97, 190, 10, 14, 14);
            } else {
                this.func_73729_b(i + 81, j + 97, 176, 10, 14, 14);
            }
        }
        if (this.tile.getCooktime() > 0) {
            int k = GuiUtils.getScaledValue((int)22, (int)this.tile.getCooktime(), (int)this.tile.getCooktimeMax());
            this.func_73729_b(i + 111, j + 58, 176, 42, 22, k);
        }
        if (!this.tile.isServedClosed(this.tile.hasServer(), this.tile.getServer())) {
            this.func_73729_b(i + 9, j + 22, 176, 25, 14, 14);
        }
        if (this.tile.isValidRecipe()) {
            this.func_73729_b(i + 16, j + 79, 176, 65, 14, 14);
        }
    }
}

