/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.gui;

import com.globbypotato.rockhounding_chemistry.machines.container.COMaterialCabinetBase;
import com.globbypotato.rockhounding_chemistry.machines.gui.GuiBase;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEMaterialCabinetBase;
import com.globbypotato.rockhounding_core.machines.gui.GuiUtils;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class UIMaterialCabinetBase
extends GuiBase {
    public static ResourceLocation TEXTURE_REF = new ResourceLocation("rockhounding_chemistry:textures/gui/guimaterialcabinet.png");
    private final TEMaterialCabinetBase tile;

    public UIMaterialCabinetBase(InventoryPlayer playerInv, TEMaterialCabinetBase tile) {
        super(new COMaterialCabinetBase((IInventory)playerInv, tile), 200);
        GuiBase.TEXTURE = TEXTURE_REF;
        this.tile = tile;
        this.containerName = "container." + TEMaterialCabinetBase.getName();
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float f) {
        super.func_73863_a(mouseX, mouseY, f);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        int colOffset = 8 + x;
        int rowOffset = 19 + y;
        for (int row = 0; row < 7; ++row) {
            for (int col = 0; col < 9; ++col) {
                int enumDust;
                int xSpace = col * 18;
                int ySpace = row * 14;
                if (mouseX < colOffset + xSpace || mouseX > colOffset + xSpace + 15 || mouseY < rowOffset + ySpace || mouseY > rowOffset + ySpace + 12 || (enumDust = row * 9 + col) >= this.tile.recipeList().size()) continue;
                String formalElement = this.tile.getRecipeList(enumDust).getName();
                String elementText = formalElement + " : " + TextFormatting.YELLOW + this.tile.elementList[enumDust] + "/" + this.tile.getExtractingFactor() + " ppc";
                String oredictElement = TextFormatting.DARK_AQUA + "(" + this.tile.getRecipeList(enumDust).getOredict() + ")";
                String dustCount = TextFormatting.DARK_GREEN + "Not enough element";
                int dustNum = this.tile.elementList[enumDust] / this.tile.getExtractingFactor();
                if (dustNum > 0) {
                    dustCount = TextFormatting.DARK_GREEN + String.valueOf(dustNum) + " dust/s available";
                }
                String[] multilabel = new String[]{elementText, dustCount, oredictElement};
                List tooltip = GuiUtils.drawMultiLabel((String[])multilabel, (int)mouseX, (int)mouseY);
                this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
            }
        }
    }

    @Override
    public void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        for (int vSlot = 0; vSlot < 7; ++vSlot) {
            for (int hSlot = 0; hSlot < 9; ++hSlot) {
                int slotID = vSlot * 9 + hSlot;
                if (slotID >= this.tile.recipeList().size()) continue;
                String symbol = this.tile.getRecipeList(slotID).getSymbol();
                this.field_146289_q.func_78276_b(symbol, 10 + 18 * hSlot, 20 + 14 * vSlot, 0x404040);
            }
        }
    }

    @Override
    public void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        super.func_146976_a(partialTicks, mouseX, mouseY);
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        for (int vSlot = 0; vSlot < 7; ++vSlot) {
            for (int hSlot = 0; hSlot < 9; ++hSlot) {
                int slotID = vSlot * 9 + hSlot;
                if (slotID >= this.tile.recipeList().size()) continue;
                int cab = GuiUtils.getScaledValue((int)19, (int)this.tile.elementList[slotID], (int)this.tile.getExtractingFactor());
                if (cab > 16) {
                    cab = 16;
                }
                this.func_73729_b(i + 8 + 18 * hSlot, j + 28 + 14 * vSlot, 176, 0, cab, 3);
            }
        }
    }
}

