/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.gui;

import com.globbypotato.rockhounding_chemistry.enums.materials.EnumAirGases;
import com.globbypotato.rockhounding_chemistry.machines.container.COGanController;
import com.globbypotato.rockhounding_chemistry.machines.gui.GuiBase;
import com.globbypotato.rockhounding_chemistry.machines.recipe.GanPlantRecipes;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEGanController;
import com.globbypotato.rockhounding_core.machines.gui.GuiUtils;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class UIGanController
extends GuiBase {
    public static ResourceLocation TEXTURE_REF = new ResourceLocation("rockhounding_chemistry:textures/gui/guigancontroller.png");
    public static ResourceLocation TEXTURE_JEI = new ResourceLocation("rockhounding_chemistry:textures/gui/jei/guigancontrollerjei.png");
    private final TEGanController tile;

    public UIGanController(InventoryPlayer playerInv, TEGanController tile) {
        super(new COGanController((IInventory)playerInv, tile), 200);
        GuiBase.TEXTURE = TEXTURE_REF;
        this.tile = tile;
        this.containerName = "container." + TEGanController.getName();
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float f) {
        String[] multiString;
        String mainprod;
        String caption;
        List tooltip;
        super.func_73863_a(mouseX, mouseY, f);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        if (GuiUtils.hoveringArea((int)79, (int)96, (int)18, (int)18, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
            tooltip = GuiUtils.drawLabel((String)this.activation_label, (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
        if (GuiUtils.hoveringArea((int)7, (int)28, (int)18, (int)18, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
            caption = TextFormatting.WHITE + "Enable Channel 1: Nitrogen" + this.inhibitedTag(6);
            mainprod = TextFormatting.AQUA + "Nitrogen: 0.300 cu/sec";
            multiString = new String[]{caption, mainprod};
            tooltip = GuiUtils.drawMultiLabel((String[])multiString, (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
        if (GuiUtils.hoveringArea((int)26, (int)28, (int)18, (int)18, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
            caption = TextFormatting.WHITE + "Enable Channel 2: Oxygen" + this.inhibitedTag(7);
            mainprod = TextFormatting.AQUA + "Oxygen: 0.100 cu/sec";
            multiString = new String[]{caption, mainprod};
            tooltip = GuiUtils.drawMultiLabel((String[])multiString, (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
        if (GuiUtils.hoveringArea((int)45, (int)28, (int)18, (int)18, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
            caption = TextFormatting.WHITE + "Enable Channel 3: Rare gases";
            String prod_Ar = TextFormatting.AQUA + "Argon: 0.006 cu/sec" + this.inhibitedTag(0);
            String prod_CO = TextFormatting.AQUA + "Carbon Dioxide: 0.003 cu/sec" + this.inhibitedTag(1);
            String prod_Ne = TextFormatting.AQUA + "Neon: 0.090 cu/min" + this.inhibitedTag(2);
            String prod_He = TextFormatting.AQUA + "Helium: 0.036 cu/min" + this.inhibitedTag(3);
            String prod_Kr = TextFormatting.AQUA + "Krypton: 0.008 cu/min" + this.inhibitedTag(4);
            String prod_Xe = TextFormatting.AQUA + "Xenon: 0.009 cu/min" + this.inhibitedTag(5);
            multiString = new String[]{caption, prod_Ar, prod_CO, prod_Ne, prod_He, prod_Kr, prod_Xe};
            tooltip = GuiUtils.drawMultiLabel((String[])multiString, (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
        if (GuiUtils.hoveringArea((int)137, (int)28, (int)14, (int)14, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
            String tk = TextFormatting.GRAY + "Process: " + TextFormatting.YELLOW + this.tile.num_air() + " cu/t";
            String cons = TextFormatting.GRAY + "Energy: " + TextFormatting.RED + this.tile.calculateConsume() + " RF/t";
            String speed = TextFormatting.GRAY + "Tier: " + TextFormatting.AQUA + this.tile.speedFactor() + "x";
            multiString = new String[]{tk, speed, cons};
            tooltip = GuiUtils.drawMultiLabel((String[])multiString, (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
        if (GuiUtils.hoveringArea((int)7, (int)67, (int)18, (int)18, (int)mouseX, (int)mouseY, (int)x, (int)y) && this.tile.speedSlot().func_190926_b()) {
            tooltip = GuiUtils.drawLabel((String)this.speed_label, (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
    }

    private boolean isInhibited(int gas) {
        return GanPlantRecipes.inhibited_gases.contains(EnumAirGases.name(gas));
    }

    private String inhibitedTag(int gas) {
        if (this.isInhibited(gas)) {
            return TextFormatting.RED + " - inhibited";
        }
        return "";
    }

    @Override
    public void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        super.func_146976_a(partialTicks, mouseX, mouseY);
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.tile.isActive()) {
            if (this.tile.isPowered()) {
                this.func_73729_b(i + 81, j + 97, 190, 10, 14, 14);
            } else {
                this.func_73729_b(i + 81, j + 97, 176, 10, 14, 14);
            }
        }
        if (this.tile.enableN()) {
            this.func_73729_b(i + 9, j + 30, 204, 10, 14, 14);
        } else if (this.isInhibited(6)) {
            this.func_73729_b(i + 9, j + 30, 204, 24, 14, 14);
        }
        if (this.tile.enableO()) {
            this.func_73729_b(i + 28, j + 30, 218, 10, 14, 14);
        } else if (this.isInhibited(7)) {
            this.func_73729_b(i + 28, j + 30, 218, 24, 14, 14);
        }
        if (this.tile.enableX()) {
            this.func_73729_b(i + 47, j + 30, 232, 10, 14, 14);
        }
        if (this.tile.getCooktime() > 0) {
            int k = GuiUtils.getScaledValue((int)60, (int)this.tile.getCooktime(), (int)this.tile.getCooktimeMax());
            this.func_73729_b(i + 71, j + 25 + (60 - k), 176, 25, 20, k);
            int p = GuiUtils.getScaledValue((int)34, (int)this.tile.getCooktime(), (int)this.tile.getCooktimeMax());
            this.func_73729_b(i + 112, j + 51, 176, 92, 20, p);
        }
    }
}

