/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.gui;

import com.globbypotato.rockhounding_chemistry.enums.materials.EnumElements;
import com.globbypotato.rockhounding_chemistry.machines.container.COExtractorCabinetBase;
import com.globbypotato.rockhounding_chemistry.machines.gui.GuiBase;
import com.globbypotato.rockhounding_chemistry.machines.recipe.ChemicalExtractorRecipes;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEElementsCabinetBase;
import com.globbypotato.rockhounding_core.machines.gui.GuiUtils;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class UIElementsCabinetBase
extends GuiBase {
    public static ResourceLocation TEXTURE_REF = new ResourceLocation("rockhounding_chemistry:textures/gui/guiextractorcabinet.png");
    private final TEElementsCabinetBase tile;

    public UIElementsCabinetBase(InventoryPlayer playerInv, TEElementsCabinetBase tile) {
        super(new COExtractorCabinetBase((IInventory)playerInv, tile), 200);
        GuiBase.TEXTURE = TEXTURE_REF;
        this.tile = tile;
        this.containerName = "container." + TEElementsCabinetBase.getName();
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float f) {
        super.func_73863_a(mouseX, mouseY, f);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        int colOffset = 10 + x;
        int rowOffset = 19 + y;
        for (int row = 0; row < 7; ++row) {
            for (int col = 0; col < 8; ++col) {
                int enumDust;
                int xSpace = col * 20;
                int ySpace = row * 14;
                if (mouseX < colOffset + xSpace || mouseX > colOffset + xSpace + 15 || mouseY < rowOffset + ySpace || mouseY > rowOffset + ySpace + 12 || (enumDust = row * 8 + col) >= EnumElements.size()) continue;
                String inhibit = "";
                for (int ix = 0; ix < ChemicalExtractorRecipes.inhibited_elements.size(); ++ix) {
                    if (!EnumElements.getDust(enumDust).toLowerCase().matches(ChemicalExtractorRecipes.inhibited_elements.get(ix).toLowerCase())) continue;
                    inhibit = " - (Inhibited)";
                }
                String formalElement = EnumElements.getName(enumDust).substring(0, 1).toUpperCase() + EnumElements.getName(enumDust).substring(1);
                String elementText = formalElement + " : " + TextFormatting.YELLOW + this.tile.elementList[enumDust] + "/" + this.tile.getExtractingFactor() + " ppc" + TextFormatting.RED + inhibit;
                String oredictElement = TextFormatting.DARK_AQUA + "(" + EnumElements.getDust(enumDust) + ")";
                String dustCount = TextFormatting.DARK_GREEN + "Not enough element";
                int dustNum = this.tile.elementList[enumDust] / this.tile.getExtractingFactor();
                if (dustNum > 0) {
                    dustCount = TextFormatting.DARK_GREEN + String.valueOf(dustNum) + " dust/s available";
                }
                String[] multilabel = new String[]{elementText, dustCount, oredictElement};
                List tooltip = GuiUtils.drawMultiLabel((String[])multilabel, (int)mouseX, (int)mouseY);
                this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
            }
        }
    }

    @Override
    public void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        super.func_146976_a(partialTicks, mouseX, mouseY);
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        for (int hSlot = 0; hSlot <= 6; ++hSlot) {
            for (int vSlot = 0; vSlot <= 7; ++vSlot) {
                int slotID = hSlot * 8 + vSlot;
                int cab = GuiUtils.getScaledValue((int)19, (int)this.tile.elementList[slotID], (int)this.tile.getExtractingFactor());
                if (cab > 16) {
                    cab = 16;
                }
                this.func_73729_b(i + 10 + 20 * vSlot, j + 28 + 14 * hSlot, 176, 0, cab, 3);
            }
        }
    }
}

