/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines;

import com.globbypotato.rockhounding_chemistry.Rhchemistry;
import com.globbypotato.rockhounding_chemistry.enums.machines.EnumMachinesF;
import com.globbypotato.rockhounding_chemistry.machines.io.MachineIO;
import com.globbypotato.rockhounding_chemistry.machines.tile.TETubularBedBase;
import com.globbypotato.rockhounding_chemistry.machines.tile.TETubularBedController;
import com.globbypotato.rockhounding_chemistry.machines.tile.TETubularBedLow;
import com.globbypotato.rockhounding_chemistry.machines.tile.TETubularBedMid;
import com.globbypotato.rockhounding_chemistry.machines.tile.TETubularBedTank;
import com.globbypotato.rockhounding_chemistry.machines.tile.TETubularBedTop;
import com.globbypotato.rockhounding_chemistry.machines.tile.TileTank;
import com.globbypotato.rockhounding_core.machines.tileentity.IFluidHandlingTile;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import com.globbypotato.rockhounding_core.utils.CoreUtils;
import com.globbypotato.rockhounding_core.utils.MachinesUtils;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class MachinesF
extends MachineIO {
    public static PropertyEnum VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumMachinesF.class);

    public MachinesF(String name) {
        super(name, Material.field_151573_f, EnumMachinesF.getNames(), 3.0f, 5.0f, SoundType.field_185852_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)VARIANT, (Comparable)((Object)EnumMachinesF.values()[0])).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)EnumMachinesF.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumMachinesF)((Object)state.func_177229_b((IProperty)VARIANT))).ordinal();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityInv tile = (TileEntityInv)world.func_175625_s(pos);
        return state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)tile.facing));
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT, FACING});
    }

    @Override
    public boolean hiddenParts(int meta) {
        return meta == EnumMachinesF.TUBULAR_BED_LOW.ordinal() || meta == EnumMachinesF.TUBULAR_BED_TOP.ordinal() || meta == EnumMachinesF.TUBULAR_BED_CONTROLLER.ordinal();
    }

    @Override
    public boolean baseParts(int meta) {
        return meta == EnumMachinesF.TUBULAR_BED_BASE.ordinal() || meta == EnumMachinesF.TUBULAR_BED_MID.ordinal() || meta == EnumMachinesF.TUBULAR_BED_TANK.ordinal();
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        int meta = stack.func_77952_i();
        EnumFacing isFacing = EnumFacing.func_82600_a((int)2);
        world.func_180501_a(pos, state.func_177226_a((IProperty)VARIANT, (Comparable)((Object)EnumMachinesF.values()[meta])).func_177226_a((IProperty)FACING, (Comparable)isFacing), 2);
        TileEntity te = world.func_175625_s(pos);
        if (world.func_175625_s(pos) != null) {
            TileEntityInv reactor;
            if (te instanceof TETubularBedBase) {
                reactor = (TETubularBedBase)world.func_175625_s(pos);
                this.setOrDropBlock(world, state, pos, reactor.getFacing(), placer, EnumMachinesF.TUBULAR_BED_LOW);
            }
            if (te instanceof TETubularBedMid) {
                reactor = (TETubularBedMid)world.func_175625_s(pos);
                this.setOrDropBlock(world, state, pos, reactor.getFacing(), placer, EnumMachinesF.TUBULAR_BED_TOP);
            }
            if (te instanceof TETubularBedTank) {
                reactor = (TETubularBedTank)world.func_175625_s(pos);
                this.setOrDropBlock(world, state, pos, reactor.getFacing(), placer, EnumMachinesF.TUBULAR_BED_CONTROLLER);
            }
        }
    }

    @Override
    public void checkFullBlocks(World world, BlockPos pos, IBlockState state) {
        int meta = state.func_177230_c().func_176201_c(state);
        if (meta == EnumMachinesF.TUBULAR_BED_BASE.ordinal()) {
            this.checkTopBlocks(world, world.func_180495_p(pos), world.func_180495_p(pos.func_177984_a()), pos);
        }
        if (meta == EnumMachinesF.TUBULAR_BED_LOW.ordinal()) {
            MachinesF.checkBaseBlocks(world, world.func_180495_p(pos.func_177977_b()), pos);
        }
        if (meta == EnumMachinesF.TUBULAR_BED_MID.ordinal()) {
            this.checkTopBlocks(world, world.func_180495_p(pos), world.func_180495_p(pos.func_177984_a()), pos);
        }
        if (meta == EnumMachinesF.TUBULAR_BED_TOP.ordinal()) {
            MachinesF.checkBaseBlocks(world, world.func_180495_p(pos.func_177977_b()), pos);
        }
        if (meta == EnumMachinesF.TUBULAR_BED_TANK.ordinal()) {
            this.checkTopBlocks(world, world.func_180495_p(pos), world.func_180495_p(pos.func_177984_a()), pos);
        }
        if (meta == EnumMachinesF.TUBULAR_BED_CONTROLLER.ordinal()) {
            MachinesF.checkBaseBlocks(world, world.func_180495_p(pos.func_177977_b()), pos);
        }
    }

    private void setOrDropBlock(World world, IBlockState state, BlockPos pos, EnumFacing facing, EntityLivingBase placer, EnumMachinesF prop) {
        if (world.func_180495_p(pos.func_177984_a()).func_177230_c().isAir(world.func_180495_p(pos.func_177984_a()), (IBlockAccess)world, pos)) {
            world.func_180501_a(pos.func_177984_a(), this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)prop)).func_177226_a((IProperty)FACING, (Comparable)facing), 2);
            TileEntityInv top = (TileEntityInv)world.func_175625_s(pos.func_177984_a());
            top.facing = facing.ordinal();
        } else {
            int meta = state.func_177230_c().func_176201_c(state);
            if (meta == EnumMachinesF.TUBULAR_BED_BASE.ordinal() || meta == EnumMachinesF.TUBULAR_BED_MID.ordinal() || meta == EnumMachinesF.TUBULAR_BED_TANK.ordinal()) {
                TileEntity te = world.func_175625_s(pos);
                ItemStack itemstack = this.func_180643_i(state);
                this.handleTileNBT(te, itemstack);
                MachinesF.func_180635_a((World)world, (BlockPos)pos, (ItemStack)itemstack);
            } else {
                this.func_176226_b(world, pos, state, 0);
            }
            world.func_175698_g(pos);
        }
    }

    private void checkTopBlocks(World world, IBlockState state, IBlockState stateUp, BlockPos pos) {
        int meta = state.func_177230_c().func_176201_c(state);
        TileEntity te = world.func_175625_s(pos);
        TileEntity teUp = world.func_175625_s(pos.func_177984_a());
        if (teUp == null || te instanceof TETubularBedBase && !(teUp instanceof TETubularBedLow) || te instanceof TETubularBedMid && !(teUp instanceof TETubularBedTop) || te instanceof TETubularBedTank && !(teUp instanceof TETubularBedController)) {
            ItemStack itemstack = this.func_180643_i(state);
            if (meta == EnumMachinesF.TUBULAR_BED_BASE.ordinal() || meta == EnumMachinesF.TUBULAR_BED_MID.ordinal() || meta == EnumMachinesF.TUBULAR_BED_TANK.ordinal()) {
                this.handleTileNBT(te, itemstack);
            }
            MachinesF.func_180635_a((World)world, (BlockPos)pos, (ItemStack)itemstack);
            world.func_175698_g(pos);
        }
    }

    private static void checkBaseBlocks(World world, IBlockState state, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        TileEntity teDown = world.func_175625_s(pos.func_177977_b());
        if (teDown == null || te instanceof TETubularBedLow && !(teDown instanceof TETubularBedBase) || te instanceof TETubularBedTop && !(teDown instanceof TETubularBedMid) || te instanceof TETubularBedController && !(teDown instanceof TETubularBedTank)) {
            world.func_175698_g(pos);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        int meta = state.func_177230_c().func_176201_c(state);
        return field_185505_j;
    }

    public boolean canEmitSignal(IBlockState state) {
        int meta = state.func_177230_c().func_176201_c(state);
        return false;
    }

    public boolean func_149744_f(IBlockState state) {
        return this.canEmitSignal(state);
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.canEmitSignal(state);
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return blockState.func_185911_a(blockAccess, pos, side);
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        int currentPower = 0;
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileTank) {
            TileTank tank = (TileTank)te;
            currentPower = tank.emittedPower();
        }
        return currentPower;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        int meta = state.func_177230_c().func_176201_c(state);
        if (meta == EnumMachinesF.TUBULAR_BED_BASE.ordinal()) {
            return new TETubularBedBase();
        }
        if (meta == EnumMachinesF.TUBULAR_BED_LOW.ordinal()) {
            return new TETubularBedLow();
        }
        if (meta == EnumMachinesF.TUBULAR_BED_MID.ordinal()) {
            return new TETubularBedMid();
        }
        if (meta == EnumMachinesF.TUBULAR_BED_TOP.ordinal()) {
            return new TETubularBedTop();
        }
        if (meta == EnumMachinesF.TUBULAR_BED_TANK.ordinal()) {
            return new TETubularBedTank();
        }
        if (meta == EnumMachinesF.TUBULAR_BED_CONTROLLER.ordinal()) {
            return new TETubularBedController();
        }
        return null;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            int meta = state.func_177230_c().func_176201_c(state);
            if (world.func_175625_s(pos) != null) {
                if (world.func_175625_s(pos) instanceof IFluidHandlingTile && !player.func_184614_ca().func_190926_b() && CoreUtils.isBucketType((ItemStack)player.func_184614_ca())) {
                    ((IFluidHandlingTile)world.func_175625_s(pos)).interactWithFluidHandler(player, hand, world, pos, facing);
                    return true;
                }
                if (this.hasNullifier(player, hand)) {
                    this.handleNullifier(world, pos, player, hand, state.func_177230_c(), meta);
                    return false;
                }
                if (meta == EnumMachinesF.TUBULAR_BED_LOW.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 81, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                if (meta == EnumMachinesF.TUBULAR_BED_BASE.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 81, world, pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p());
                }
                if (meta == EnumMachinesF.TUBULAR_BED_MID.ordinal() && world.func_175625_s(pos.func_177979_c(1)) != null && world.func_175625_s(pos.func_177979_c(1)) instanceof TETubularBedLow) {
                    player.openGui((Object)Rhchemistry.instance, 81, world, pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p());
                }
                if (meta == EnumMachinesF.TUBULAR_BED_TOP.ordinal() && world.func_175625_s(pos.func_177979_c(2)) != null && world.func_175625_s(pos.func_177979_c(2)) instanceof TETubularBedLow) {
                    player.openGui((Object)Rhchemistry.instance, 81, world, pos.func_177958_n(), pos.func_177956_o() - 2, pos.func_177952_p());
                }
                if (meta == EnumMachinesF.TUBULAR_BED_TANK.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 82, world, pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p());
                }
                if (meta == EnumMachinesF.TUBULAR_BED_CONTROLLER.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 82, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
            }
        }
        return true;
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        IBlockState state = world.func_180495_p(pos);
        int meta = state.func_177230_c().func_176201_c(state);
        if (CoreUtils.hasWrench((EntityPlayer)player)) {
            this.handleRotation(world, pos, player, meta);
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        int meta = state.func_177230_c().func_176201_c(state);
        return meta != EnumMachinesF.TUBULAR_BED_LOW.ordinal() && meta != EnumMachinesF.TUBULAR_BED_TOP.ordinal() && meta != EnumMachinesF.TUBULAR_BED_CONTROLLER.ordinal() ? Item.func_150898_a((Block)this) : null;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        int meta = state.func_177230_c().func_176201_c(state);
        return meta != EnumMachinesF.TUBULAR_BED_LOW.ordinal() && meta != EnumMachinesF.TUBULAR_BED_TOP.ordinal() && meta != EnumMachinesF.TUBULAR_BED_CONTROLLER.ordinal();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        int meta = state.func_177230_c().func_176201_c(state);
        if (meta == EnumMachinesF.TUBULAR_BED_LOW.ordinal()) {
            return new ItemStack(Item.func_150898_a((Block)this), 1, EnumMachinesF.TUBULAR_BED_BASE.ordinal());
        }
        if (meta == EnumMachinesF.TUBULAR_BED_TOP.ordinal()) {
            return new ItemStack(Item.func_150898_a((Block)this), 1, EnumMachinesF.TUBULAR_BED_MID.ordinal());
        }
        if (meta == EnumMachinesF.TUBULAR_BED_CONTROLLER.ordinal()) {
            return new ItemStack(Item.func_150898_a((Block)this), 1, EnumMachinesF.TUBULAR_BED_TANK.ordinal());
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, @Nullable ItemStack stack) {
        player.func_71029_a(StatList.func_188055_a((Block)this));
        player.func_71020_j(0.025f);
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        int meta = this.func_176201_c(state);
        ItemStack itemstack = ItemStack.field_190927_a;
        if (meta != EnumMachinesF.TUBULAR_BED_LOW.ordinal() && meta != EnumMachinesF.TUBULAR_BED_TOP.ordinal() && meta != EnumMachinesF.TUBULAR_BED_CONTROLLER.ordinal()) {
            itemstack = new ItemStack((Block)this, 1, meta);
        }
        this.handleTileNBT(te, itemstack);
        if (!itemstack.func_190926_b()) {
            items.add(itemstack);
        }
        ForgeEventFactory.fireBlockHarvesting(items, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)player);
        for (ItemStack item : items) {
            MachinesF.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)item);
        }
    }

    public void handleTileNBT(TileEntity te, ItemStack itemstack) {
        if (te != null) {
            MachinesUtils.addMachineNbt((ItemStack)itemstack, (TileEntity)te);
        }
    }
}

