/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines;

import com.globbypotato.rockhounding_chemistry.ModBlocks;
import com.globbypotato.rockhounding_chemistry.Rhchemistry;
import com.globbypotato.rockhounding_chemistry.enums.machines.EnumMachinesD;
import com.globbypotato.rockhounding_chemistry.fluids.ModFluids;
import com.globbypotato.rockhounding_chemistry.handlers.Reference;
import com.globbypotato.rockhounding_chemistry.machines.io.MachineIO;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEContainmentTank;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEDepositionChamberBase;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEDepositionChamberTop;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEFlotationTank;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEFluidpedia;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEGasHolderBase;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEGasHolderTop;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEMaterialCabinetBase;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEMaterialCabinetTop;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEMetalAlloyer;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEMetalAlloyerTank;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEOrbiter;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEPullingCrucibleBase;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEPullingCrucibleTop;
import com.globbypotato.rockhounding_chemistry.machines.tile.TETransposer;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEWasteDumper;
import com.globbypotato.rockhounding_chemistry.machines.tile.TileTank;
import com.globbypotato.rockhounding_chemistry.machines.tile.TileVessel;
import com.globbypotato.rockhounding_core.enums.EnumFluidNbt;
import com.globbypotato.rockhounding_core.machines.tileentity.IFluidHandlingTile;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import com.globbypotato.rockhounding_core.utils.CoreUtils;
import com.globbypotato.rockhounding_core.utils.MachinesUtils;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class MachinesD
extends MachineIO {
    public static PropertyEnum VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumMachinesD.class);
    public static final AxisAlignedBB FLOTATION_BLOCK_AABB = new AxisAlignedBB(0.2, 0.0, 0.2, 0.8, 1.0, 0.8);

    public MachinesD(String name) {
        super(name, Material.field_151573_f, EnumMachinesD.getNames(), 3.0f, 5.0f, SoundType.field_185852_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)VARIANT, (Comparable)((Object)EnumMachinesD.values()[0])).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)EnumMachinesD.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumMachinesD)((Object)state.func_177229_b((IProperty)VARIANT))).ordinal();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityInv tile = (TileEntityInv)world.func_175625_s(pos);
        return state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)tile.facing));
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT, FACING});
    }

    @Override
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        super.func_149666_a(tab, items);
        for (Fluid gas : ModFluids.GASES) {
            ItemStack filledvessel = new ItemStack(ModBlocks.MACHINES_D, 1, EnumMachinesD.GAS_HOLDER_BASE.ordinal());
            filledvessel.func_77973_b().func_77637_a(Reference.RockhoundingChemistry);
            filledvessel.func_77982_d(new NBTTagCompound());
            NBTTagCompound solvent = new NBTTagCompound();
            FluidStack gasstack = new FluidStack(gas, 1000000);
            if (gas != null) {
                gasstack.writeToNBT(solvent);
                filledvessel.func_77978_p().func_74782_a(EnumFluidNbt.GAS.nameTag(), (NBTBase)solvent);
            }
            items.add((Object)filledvessel);
        }
    }

    @Override
    public boolean hiddenParts(int meta) {
        return meta == EnumMachinesD.METAL_ALLOYER_TANK.ordinal() || meta == EnumMachinesD.MATERIAL_CABINET_TOP.ordinal() || meta == EnumMachinesD.DEPOSITION_CHAMBER_TOP.ordinal() || meta == EnumMachinesD.GAS_HOLDER_TOP.ordinal() || meta == EnumMachinesD.PULLING_CRUCIBLE_TOP.ordinal();
    }

    @Override
    public boolean baseParts(int meta) {
        return meta == EnumMachinesD.METAL_ALLOYER.ordinal() || meta == EnumMachinesD.MATERIAL_CABINET_BASE.ordinal() || meta == EnumMachinesD.DEPOSITION_CHAMBER_BASE.ordinal() || meta == EnumMachinesD.GAS_HOLDER_BASE.ordinal() || meta == EnumMachinesD.PULLING_CRUCIBLE_BASE.ordinal();
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        int meta = stack.func_77952_i();
        EnumFacing isFacing = EnumFacing.func_82600_a((int)2);
        world.func_180501_a(pos, state.func_177226_a((IProperty)VARIANT, (Comparable)((Object)EnumMachinesD.values()[meta])).func_177226_a((IProperty)FACING, (Comparable)isFacing), 2);
        TileEntity te = world.func_175625_s(pos);
        if (world.func_175625_s(pos) != null) {
            Object reactor;
            if (te instanceof TEMaterialCabinetBase) {
                TEMaterialCabinetBase cabinet = (TEMaterialCabinetBase)world.func_175625_s(pos);
                MachinesD.restoreCabinetNBT(stack, te);
                this.setOrDropBlock(world, state, pos, cabinet.getFacing(), placer, EnumMachinesD.MATERIAL_CABINET_TOP);
            }
            if (te instanceof TEMetalAlloyer) {
                reactor = (TEMetalAlloyer)world.func_175625_s(pos);
                this.setOrDropBlock(world, state, pos, reactor.getFacing(), placer, EnumMachinesD.METAL_ALLOYER_TANK);
            }
            if (te instanceof TEDepositionChamberBase) {
                reactor = (TEDepositionChamberBase)world.func_175625_s(pos);
                this.setOrDropBlock(world, state, pos, reactor.getFacing(), placer, EnumMachinesD.DEPOSITION_CHAMBER_TOP);
            }
            if (te instanceof TEGasHolderBase) {
                reactor = (TEGasHolderBase)world.func_175625_s(pos);
                MachinesD.restoreGasHolderNBT(stack, te);
                this.setOrDropBlock(world, state, pos, reactor.getFacing(), placer, EnumMachinesD.GAS_HOLDER_TOP);
            }
            if (te instanceof TEPullingCrucibleBase) {
                reactor = (TEPullingCrucibleBase)world.func_175625_s(pos);
                this.setOrDropBlock(world, state, pos, reactor.getFacing(), placer, EnumMachinesD.PULLING_CRUCIBLE_TOP);
            }
            if (te instanceof TEOrbiter) {
                this.restoreOrbiterNBT(stack, te);
            }
            if (te instanceof TETransposer) {
                MachinesD.restoreTransposerNBT(stack, te);
            }
            if (te instanceof TEWasteDumper) {
                MachinesD.restoreWasteDumperNBT(stack, te);
            }
            if (te instanceof TEFlotationTank) {
                MachinesD.restoreFlotationTankNBT(stack, te);
            }
            if (te instanceof TEContainmentTank) {
                MachinesD.restoreContainmentTankNBT(stack, te);
            }
        }
    }

    @Override
    public void checkFullBlocks(World world, BlockPos pos, IBlockState state) {
        int meta = state.func_177230_c().func_176201_c(state);
        if (meta == EnumMachinesD.MATERIAL_CABINET_BASE.ordinal()) {
            this.checkTopBlocks(world, world.func_180495_p(pos), world.func_180495_p(pos.func_177984_a()), pos);
        }
        if (meta == EnumMachinesD.MATERIAL_CABINET_TOP.ordinal()) {
            MachinesD.checkBaseBlocks(world, world.func_180495_p(pos.func_177977_b()), pos);
        }
        if (meta == EnumMachinesD.METAL_ALLOYER.ordinal()) {
            this.checkTopBlocks(world, world.func_180495_p(pos), world.func_180495_p(pos.func_177984_a()), pos);
        }
        if (meta == EnumMachinesD.METAL_ALLOYER_TANK.ordinal()) {
            MachinesD.checkBaseBlocks(world, world.func_180495_p(pos.func_177977_b()), pos);
        }
        if (meta == EnumMachinesD.DEPOSITION_CHAMBER_BASE.ordinal()) {
            this.checkTopBlocks(world, world.func_180495_p(pos), world.func_180495_p(pos.func_177984_a()), pos);
        }
        if (meta == EnumMachinesD.DEPOSITION_CHAMBER_TOP.ordinal()) {
            MachinesD.checkBaseBlocks(world, world.func_180495_p(pos.func_177977_b()), pos);
        }
        if (meta == EnumMachinesD.GAS_HOLDER_BASE.ordinal()) {
            this.checkTopBlocks(world, world.func_180495_p(pos), world.func_180495_p(pos.func_177984_a()), pos);
        }
        if (meta == EnumMachinesD.GAS_HOLDER_TOP.ordinal()) {
            MachinesD.checkBaseBlocks(world, world.func_180495_p(pos.func_177977_b()), pos);
        }
        if (meta == EnumMachinesD.PULLING_CRUCIBLE_BASE.ordinal()) {
            this.checkTopBlocks(world, world.func_180495_p(pos), world.func_180495_p(pos.func_177984_a()), pos);
        }
        if (meta == EnumMachinesD.PULLING_CRUCIBLE_TOP.ordinal()) {
            MachinesD.checkBaseBlocks(world, world.func_180495_p(pos.func_177977_b()), pos);
        }
    }

    private void setOrDropBlock(World world, IBlockState state, BlockPos pos, EnumFacing facing, EntityLivingBase placer, EnumMachinesD prop) {
        if (world.func_180495_p(pos.func_177984_a()).func_177230_c().isAir(world.func_180495_p(pos.func_177984_a()), (IBlockAccess)world, pos)) {
            world.func_180501_a(pos.func_177984_a(), this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)prop)).func_177226_a((IProperty)FACING, (Comparable)facing), 2);
            TileEntityInv top = (TileEntityInv)world.func_175625_s(pos.func_177984_a());
            top.facing = facing.ordinal();
        } else {
            int meta = state.func_177230_c().func_176201_c(state);
            if (meta == EnumMachinesD.GAS_HOLDER_BASE.ordinal() || meta == EnumMachinesD.MATERIAL_CABINET_BASE.ordinal()) {
                TileEntity te = world.func_175625_s(pos);
                ItemStack itemstack = this.func_180643_i(state);
                this.handleTileNBT(te, itemstack);
                MachinesD.func_180635_a((World)world, (BlockPos)pos, (ItemStack)itemstack);
            } else {
                this.func_176226_b(world, pos, state, 0);
            }
            world.func_175698_g(pos);
        }
    }

    private void checkTopBlocks(World world, IBlockState state, IBlockState stateUp, BlockPos pos) {
        int meta = state.func_177230_c().func_176201_c(state);
        TileEntity te = world.func_175625_s(pos);
        TileEntity teUp = world.func_175625_s(pos.func_177984_a());
        if (teUp == null || te instanceof TEMaterialCabinetBase && !(teUp instanceof TEMaterialCabinetTop) || te instanceof TEMetalAlloyer && !(teUp instanceof TEMetalAlloyerTank) || te instanceof TEDepositionChamberBase && !(teUp instanceof TEDepositionChamberTop) || te instanceof TEGasHolderBase && !(teUp instanceof TEGasHolderTop) || te instanceof TEPullingCrucibleBase && !(teUp instanceof TEPullingCrucibleTop)) {
            ItemStack itemstack = this.func_180643_i(state);
            if (meta == EnumMachinesD.MATERIAL_CABINET_BASE.ordinal() || meta == EnumMachinesD.METAL_ALLOYER.ordinal() || meta == EnumMachinesD.DEPOSITION_CHAMBER_BASE.ordinal() || meta == EnumMachinesD.GAS_HOLDER_BASE.ordinal() || meta == EnumMachinesD.PULLING_CRUCIBLE_BASE.ordinal()) {
                this.handleTileNBT(te, itemstack);
            }
            MachinesD.func_180635_a((World)world, (BlockPos)pos, (ItemStack)itemstack);
            world.func_175698_g(pos);
        }
    }

    private static void checkBaseBlocks(World world, IBlockState state, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        TileEntity teDown = world.func_175625_s(pos.func_177977_b());
        if (teDown == null || te instanceof TEMaterialCabinetTop && !(teDown instanceof TEMaterialCabinetBase) || te instanceof TEMetalAlloyerTank && !(teDown instanceof TEMetalAlloyer) || te instanceof TEDepositionChamberTop && !(teDown instanceof TEDepositionChamberBase) || te instanceof TEGasHolderTop && !(teDown instanceof TEGasHolderBase) || te instanceof TEPullingCrucibleTop && !(teDown instanceof TEPullingCrucibleBase)) {
            world.func_175698_g(pos);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        int meta = state.func_177230_c().func_176201_c(state);
        return meta == EnumMachinesD.FLOTATION_TANK.ordinal() ? FLOTATION_BLOCK_AABB : field_185505_j;
    }

    public boolean canEmitSignal(IBlockState state) {
        int meta = state.func_177230_c().func_176201_c(state);
        return meta == EnumMachinesD.CONTAINMENT_TANK.ordinal() || meta == EnumMachinesD.GAS_HOLDER_BASE.ordinal();
    }

    public boolean func_149744_f(IBlockState state) {
        return this.canEmitSignal(state);
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.canEmitSignal(state);
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return blockState.func_185911_a(blockAccess, pos, side);
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        int currentPower = 0;
        TileEntity te = world.func_175625_s(pos);
        if (te != null) {
            Object tank;
            if (te instanceof TileTank) {
                tank = (TileTank)te;
                currentPower = ((TileTank)((Object)tank)).emittedPower();
            }
            if (te instanceof TileVessel) {
                tank = (TileVessel)te;
                currentPower = ((TileVessel)tank).emittedPower();
            }
        }
        return currentPower;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        int meta = state.func_177230_c().func_176201_c(state);
        if (meta == EnumMachinesD.MATERIAL_CABINET_BASE.ordinal()) {
            return new TEMaterialCabinetBase();
        }
        if (meta == EnumMachinesD.MATERIAL_CABINET_TOP.ordinal()) {
            return new TEMaterialCabinetTop();
        }
        if (meta == EnumMachinesD.METAL_ALLOYER.ordinal()) {
            return new TEMetalAlloyer();
        }
        if (meta == EnumMachinesD.METAL_ALLOYER_TANK.ordinal()) {
            return new TEMetalAlloyerTank();
        }
        if (meta == EnumMachinesD.DEPOSITION_CHAMBER_BASE.ordinal()) {
            return new TEDepositionChamberBase();
        }
        if (meta == EnumMachinesD.DEPOSITION_CHAMBER_TOP.ordinal()) {
            return new TEDepositionChamberTop();
        }
        if (meta == EnumMachinesD.GAS_HOLDER_BASE.ordinal()) {
            return new TEGasHolderBase();
        }
        if (meta == EnumMachinesD.GAS_HOLDER_TOP.ordinal()) {
            return new TEGasHolderTop();
        }
        if (meta == EnumMachinesD.PULLING_CRUCIBLE_BASE.ordinal()) {
            return new TEPullingCrucibleBase();
        }
        if (meta == EnumMachinesD.PULLING_CRUCIBLE_TOP.ordinal()) {
            return new TEPullingCrucibleTop();
        }
        if (meta == EnumMachinesD.ORBITER.ordinal()) {
            return new TEOrbiter();
        }
        if (meta == EnumMachinesD.TRANSPOSER.ordinal()) {
            return new TETransposer();
        }
        if (meta == EnumMachinesD.FLUIDPEDIA.ordinal()) {
            return new TEFluidpedia();
        }
        if (meta == EnumMachinesD.WASTE_DUMPER.ordinal()) {
            return new TEWasteDumper();
        }
        if (meta == EnumMachinesD.FLOTATION_TANK.ordinal()) {
            return new TEFlotationTank();
        }
        if (meta == EnumMachinesD.CONTAINMENT_TANK.ordinal()) {
            return new TEContainmentTank();
        }
        return null;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            int meta = state.func_177230_c().func_176201_c(state);
            if (world.func_175625_s(pos) != null) {
                TEMetalAlloyer alloyer;
                if (world.func_175625_s(pos) instanceof IFluidHandlingTile && !player.func_184614_ca().func_190926_b() && CoreUtils.isBucketType((ItemStack)player.func_184614_ca())) {
                    ((IFluidHandlingTile)world.func_175625_s(pos)).interactWithFluidHandler(player, hand, world, pos, facing);
                    return true;
                }
                if (this.hasNullifier(player, hand)) {
                    this.handleNullifier(world, pos, player, hand, state.func_177230_c(), meta);
                    return false;
                }
                if (meta == EnumMachinesD.MATERIAL_CABINET_BASE.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 49, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                if (meta == EnumMachinesD.MATERIAL_CABINET_TOP.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 50, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                if (meta == EnumMachinesD.METAL_ALLOYER.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 48, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    alloyer = (TEMetalAlloyer)world.func_175625_s(pos);
                    alloyer.showPreview();
                }
                if (meta == EnumMachinesD.METAL_ALLOYER_TANK.ordinal() && world.func_175625_s(pos.func_177979_c(1)) != null && world.func_175625_s(pos.func_177979_c(1)) instanceof TEMetalAlloyer) {
                    player.openGui((Object)Rhchemistry.instance, 48, world, pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p());
                    alloyer = (TEMetalAlloyer)world.func_175625_s(pos.func_177977_b());
                    alloyer.showPreview();
                }
                if (meta == EnumMachinesD.DEPOSITION_CHAMBER_BASE.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 51, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                if (meta == EnumMachinesD.DEPOSITION_CHAMBER_TOP.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 52, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                if (meta == EnumMachinesD.GAS_HOLDER_BASE.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 53, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                if (meta == EnumMachinesD.GAS_HOLDER_TOP.ordinal() && world.func_175625_s(pos.func_177979_c(1)) != null && world.func_175625_s(pos.func_177979_c(1)) instanceof TEGasHolderBase) {
                    player.openGui((Object)Rhchemistry.instance, 53, world, pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p());
                }
                if (meta == EnumMachinesD.PULLING_CRUCIBLE_BASE.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 54, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                if (meta == EnumMachinesD.PULLING_CRUCIBLE_TOP.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 55, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                if (meta == EnumMachinesD.ORBITER.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 56, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    TEOrbiter orbiter = (TEOrbiter)world.func_175625_s(pos);
                    orbiter.offScale = orbiter.calculateRetrievedXP(player, 0) > orbiter.getstoredXP();
                }
                if (meta == EnumMachinesD.TRANSPOSER.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 57, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                if (meta == EnumMachinesD.FLUIDPEDIA.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 58, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    TEFluidpedia pedia = (TEFluidpedia)world.func_175625_s(pos);
                    pedia.collectFluids(pedia.getAlphabet(), pedia.getView());
                }
                if (meta == EnumMachinesD.WASTE_DUMPER.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 59, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                if (meta == EnumMachinesD.FLOTATION_TANK.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 60, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                if (meta == EnumMachinesD.CONTAINMENT_TANK.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 61, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
            }
        }
        return true;
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        IBlockState state = world.func_180495_p(pos);
        int meta = state.func_177230_c().func_176201_c(state);
        if (CoreUtils.hasWrench((EntityPlayer)player)) {
            this.handleRotation(world, pos, player, meta);
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        int meta = state.func_177230_c().func_176201_c(state);
        return meta != EnumMachinesD.MATERIAL_CABINET_TOP.ordinal() && meta != EnumMachinesD.METAL_ALLOYER_TANK.ordinal() && meta != EnumMachinesD.DEPOSITION_CHAMBER_TOP.ordinal() && meta != EnumMachinesD.GAS_HOLDER_TOP.ordinal() && meta != EnumMachinesD.PULLING_CRUCIBLE_TOP.ordinal() ? Item.func_150898_a((Block)this) : null;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        int meta = state.func_177230_c().func_176201_c(state);
        return meta != EnumMachinesD.MATERIAL_CABINET_TOP.ordinal() && meta != EnumMachinesD.METAL_ALLOYER_TANK.ordinal() && meta != EnumMachinesD.DEPOSITION_CHAMBER_TOP.ordinal() && meta != EnumMachinesD.GAS_HOLDER_TOP.ordinal() && meta != EnumMachinesD.PULLING_CRUCIBLE_TOP.ordinal();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        int meta = state.func_177230_c().func_176201_c(state);
        if (meta == EnumMachinesD.MATERIAL_CABINET_TOP.ordinal()) {
            return new ItemStack(Item.func_150898_a((Block)this), 1, EnumMachinesD.MATERIAL_CABINET_BASE.ordinal());
        }
        if (meta == EnumMachinesD.METAL_ALLOYER_TANK.ordinal()) {
            return new ItemStack(Item.func_150898_a((Block)this), 1, EnumMachinesD.METAL_ALLOYER.ordinal());
        }
        if (meta == EnumMachinesD.DEPOSITION_CHAMBER_TOP.ordinal()) {
            return new ItemStack(Item.func_150898_a((Block)this), 1, EnumMachinesD.DEPOSITION_CHAMBER_BASE.ordinal());
        }
        if (meta == EnumMachinesD.GAS_HOLDER_TOP.ordinal()) {
            return new ItemStack(Item.func_150898_a((Block)this), 1, EnumMachinesD.GAS_HOLDER_BASE.ordinal());
        }
        if (meta == EnumMachinesD.PULLING_CRUCIBLE_TOP.ordinal()) {
            return new ItemStack(Item.func_150898_a((Block)this), 1, EnumMachinesD.PULLING_CRUCIBLE_BASE.ordinal());
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, @Nullable ItemStack stack) {
        player.func_71029_a(StatList.func_188055_a((Block)this));
        player.func_71020_j(0.025f);
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        int meta = this.func_176201_c(state);
        ItemStack itemstack = ItemStack.field_190927_a;
        if (meta != EnumMachinesD.MATERIAL_CABINET_TOP.ordinal() && meta != EnumMachinesD.METAL_ALLOYER_TANK.ordinal() && meta != EnumMachinesD.DEPOSITION_CHAMBER_TOP.ordinal() && meta != EnumMachinesD.GAS_HOLDER_TOP.ordinal() && meta != EnumMachinesD.PULLING_CRUCIBLE_TOP.ordinal()) {
            itemstack = new ItemStack((Block)this, 1, meta);
        }
        this.handleTileNBT(te, itemstack);
        if (!itemstack.func_190926_b()) {
            items.add(itemstack);
        }
        ForgeEventFactory.fireBlockHarvesting(items, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)player);
        for (ItemStack item : items) {
            MachinesD.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)item);
        }
    }

    public void handleTileNBT(TileEntity te, ItemStack itemstack) {
        if (te != null) {
            MachinesUtils.addMachineNbt((ItemStack)itemstack, (TileEntity)te);
            if (te instanceof TEMaterialCabinetBase) {
                MachinesD.addCabinetNbt(itemstack, te);
            }
            if (te instanceof TEGasHolderBase) {
                MachinesD.addGasHolderNbt(itemstack, te);
            }
            if (te instanceof TEOrbiter) {
                this.addOrbiterNbt(itemstack, te);
            }
            if (te instanceof TETransposer) {
                MachinesD.addTransposerNbt(itemstack, te);
            }
            if (te instanceof TEWasteDumper) {
                MachinesD.addWasteDumperNbt(itemstack, te);
            }
            if (te instanceof TEFlotationTank) {
                MachinesD.addFlotationTankNbt(itemstack, te);
            }
            if (te instanceof TEContainmentTank) {
                MachinesD.addContainmentTankNbt(itemstack, te);
            }
        }
    }

    private static void addCabinetNbt(ItemStack itemstack, TileEntity te) {
        TEMaterialCabinetBase cabinet = (TEMaterialCabinetBase)te;
        NBTTagList quantityList = new NBTTagList();
        for (int i = 0; i < cabinet.elementList.length; ++i) {
            NBTTagCompound tagQuantity = new NBTTagCompound();
            tagQuantity.func_74768_a("Element" + i, cabinet.elementList[i]);
            quantityList.func_74742_a((NBTBase)tagQuantity);
        }
        itemstack.func_77978_p().func_74782_a("ElementsList", (NBTBase)quantityList);
    }

    private static void restoreCabinetNBT(ItemStack itemstack, TileEntity te) {
        TEMaterialCabinetBase cabinet = (TEMaterialCabinetBase)te;
        if (itemstack.func_77942_o() && itemstack.func_77978_p().func_74764_b("ElementsList")) {
            NBTTagList quantityList = itemstack.func_77978_p().func_150295_c("ElementsList", 10);
            for (int i = 0; i < quantityList.func_74745_c(); ++i) {
                NBTTagCompound getQuantities = quantityList.func_150305_b(i);
                cabinet.elementList[i] = getQuantities.func_74762_e("Element" + i);
            }
        }
    }

    private static void addGasHolderNbt(ItemStack itemstack, TileEntity te) {
        TEGasHolderBase tank = (TEGasHolderBase)te;
        NBTTagCompound solvent = new NBTTagCompound();
        if (tank.inputTank.getFluid() != null) {
            tank.inputTank.getFluid().writeToNBT(solvent);
            itemstack.func_77978_p().func_74782_a(EnumFluidNbt.GAS.nameTag(), (NBTBase)solvent);
        }
        if (tank.getFilter() != null) {
            NBTTagCompound filterNBT = new NBTTagCompound();
            tank.filter.writeToNBT(filterNBT);
            itemstack.func_77978_p().func_74782_a("Filter", (NBTBase)filterNBT);
        }
        itemstack.func_77978_p().func_74768_a("Collapse", tank.collapseRate);
    }

    private static void restoreGasHolderNBT(ItemStack itemstack, TileEntity te) {
        TEGasHolderBase tank = (TEGasHolderBase)te;
        if (itemstack.func_77942_o() && tank != null) {
            if (itemstack.func_77978_p().func_74764_b(EnumFluidNbt.GAS.nameTag())) {
                tank.inputTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemstack.func_77978_p().func_74775_l(EnumFluidNbt.GAS.nameTag())));
            }
            if (itemstack.func_77978_p().func_74764_b("Filter")) {
                tank.filter = FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemstack.func_77978_p().func_74775_l("Filter"));
            }
            tank.collapseRate = itemstack.func_77978_p().func_74762_e("Collapse");
        }
    }

    private void addOrbiterNbt(ItemStack itemstack, TileEntity te) {
        TEOrbiter tank = (TEOrbiter)te;
        NBTTagCompound solvent = new NBTTagCompound();
        if (tank.inputTank.getFluid() != null) {
            tank.inputTank.getFluid().writeToNBT(solvent);
            itemstack.func_77978_p().func_74782_a(EnumFluidNbt.BATH.nameTag(), (NBTBase)solvent);
        }
        if (tank.xpJuiceExists()) {
            NBTTagCompound juice = new NBTTagCompound();
            if (tank.outputTank.getFluid() != null) {
                tank.outputTank.getFluid().writeToNBT(juice);
                itemstack.func_77978_p().func_74782_a(EnumFluidNbt.SOLUTION.nameTag(), (NBTBase)juice);
            }
        }
        itemstack.func_77978_p().func_74768_a("XPCount", tank.getXPCount());
    }

    private void restoreOrbiterNBT(ItemStack itemstack, TileEntity te) {
        TEOrbiter tank = (TEOrbiter)te;
        if (itemstack.func_77942_o() && tank != null) {
            if (itemstack.func_77978_p().func_74764_b(EnumFluidNbt.BATH.nameTag())) {
                tank.inputTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemstack.func_77978_p().func_74775_l(EnumFluidNbt.BATH.nameTag())));
            }
            if (tank.xpJuiceExists() && itemstack.func_77978_p().func_74764_b(EnumFluidNbt.SOLUTION.nameTag())) {
                tank.outputTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemstack.func_77978_p().func_74775_l(EnumFluidNbt.SOLUTION.nameTag())));
            }
        }
        if (itemstack.func_77978_p().func_74764_b("XPCount")) {
            tank.xpCount = itemstack.func_77978_p().func_74762_e("XPCount");
        }
    }

    private static void addTransposerNbt(ItemStack itemstack, TileEntity te) {
        TETransposer tank = (TETransposer)te;
        NBTTagCompound fluidin = new NBTTagCompound();
        if (tank.inputTankMain.getFluid() != null) {
            tank.inputTankMain.getFluid().writeToNBT(fluidin);
            itemstack.func_77978_p().func_74782_a(EnumFluidNbt.FLUID_IN.nameTag(), (NBTBase)fluidin);
        }
        if (tank.getFilterMain() != null) {
            NBTTagCompound filterFluidNBT = new NBTTagCompound();
            tank.filterMain.writeToNBT(filterFluidNBT);
            itemstack.func_77978_p().func_74782_a("Filter", (NBTBase)filterFluidNBT);
        }
        NBTTagCompound fluidout = new NBTTagCompound();
        if (tank.outputTankFluid.getFluid() != null) {
            tank.outputTankFluid.getFluid().writeToNBT(fluidout);
            itemstack.func_77978_p().func_74782_a(EnumFluidNbt.FLUID.nameTag(), (NBTBase)fluidout);
        }
        NBTTagCompound gasout = new NBTTagCompound();
        if (tank.outputTankGas.getFluid() != null) {
            tank.outputTankGas.getFluid().writeToNBT(gasout);
            itemstack.func_77978_p().func_74782_a(EnumFluidNbt.GAS.nameTag(), (NBTBase)gasout);
        }
        itemstack.func_77978_p().func_74768_a("Collapse", tank.collapseRate);
    }

    private static void restoreTransposerNBT(ItemStack itemstack, TileEntity te) {
        TETransposer tank = (TETransposer)te;
        if (itemstack.func_77942_o() && tank != null) {
            if (itemstack.func_77978_p().func_74764_b(EnumFluidNbt.FLUID_IN.nameTag())) {
                tank.inputTankMain.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemstack.func_77978_p().func_74775_l(EnumFluidNbt.FLUID_IN.nameTag())));
            }
            if (itemstack.func_77978_p().func_74764_b("Filter")) {
                tank.filterMain = FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemstack.func_77978_p().func_74775_l("Filter"));
            }
            if (itemstack.func_77978_p().func_74764_b(EnumFluidNbt.FLUID.nameTag())) {
                tank.outputTankFluid.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemstack.func_77978_p().func_74775_l(EnumFluidNbt.FLUID.nameTag())));
            }
            if (itemstack.func_77978_p().func_74764_b(EnumFluidNbt.GAS.nameTag())) {
                tank.outputTankGas.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemstack.func_77978_p().func_74775_l(EnumFluidNbt.GAS.nameTag())));
            }
            tank.collapseRate = itemstack.func_77978_p().func_74762_e("Collapse");
        }
    }

    private static void addWasteDumperNbt(ItemStack itemstack, TileEntity te) {
        TEWasteDumper tank = (TEWasteDumper)te;
        if (tank.getFilter() != null) {
            NBTTagCompound filterNBT = new NBTTagCompound();
            tank.filter.writeToNBT(filterNBT);
            itemstack.func_77978_p().func_74782_a("Filter", (NBTBase)filterNBT);
        }
    }

    private static void restoreWasteDumperNBT(ItemStack itemstack, TileEntity te) {
        TEWasteDumper tank = (TEWasteDumper)te;
        if (itemstack.func_77942_o() && tank != null && itemstack.func_77978_p().func_74764_b("Filter")) {
            tank.filter = FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemstack.func_77978_p().func_74775_l("Filter"));
        }
    }

    private static void addFlotationTankNbt(ItemStack itemstack, TileEntity te) {
        TEFlotationTank tank = (TEFlotationTank)te;
        NBTTagCompound solvent = new NBTTagCompound();
        if (tank.inputTank.getFluid() != null) {
            tank.inputTank.getFluid().writeToNBT(solvent);
            itemstack.func_77978_p().func_74782_a(EnumFluidNbt.SOLVENT.nameTag(), (NBTBase)solvent);
        }
        if (tank.getFilterSolvent() != null) {
            NBTTagCompound filterSolventNBT = new NBTTagCompound();
            tank.filterSolvent.writeToNBT(filterSolventNBT);
            itemstack.func_77978_p().func_74782_a("FilterSolvent", (NBTBase)filterSolventNBT);
        }
    }

    private static void restoreFlotationTankNBT(ItemStack stack, TileEntity te) {
        TEFlotationTank tank = (TEFlotationTank)te;
        if (stack.func_77942_o() && tank != null) {
            if (stack.func_77978_p().func_74764_b(EnumFluidNbt.SOLVENT.nameTag())) {
                tank.inputTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l(EnumFluidNbt.SOLVENT.nameTag())));
            }
            if (stack.func_77978_p().func_74764_b("FilterSolvent")) {
                tank.filterSolvent = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l("FilterSolvent"));
            }
        }
    }

    private static void addContainmentTankNbt(ItemStack itemstack, TileEntity te) {
        TEContainmentTank tank = (TEContainmentTank)te;
        NBTTagCompound solvent = new NBTTagCompound();
        if (tank.inputTank.getFluid() != null) {
            tank.inputTank.getFluid().writeToNBT(solvent);
            itemstack.func_77978_p().func_74782_a(EnumFluidNbt.FLUID.nameTag(), (NBTBase)solvent);
        }
        if (tank.getFilter() != null) {
            NBTTagCompound filterNBT = new NBTTagCompound();
            tank.filter.writeToNBT(filterNBT);
            itemstack.func_77978_p().func_74782_a("Filter", (NBTBase)filterNBT);
        }
    }

    private static void restoreContainmentTankNBT(ItemStack stack, TileEntity te) {
        TEContainmentTank tank = (TEContainmentTank)te;
        if (stack.func_77942_o() && tank != null) {
            if (stack.func_77978_p().func_74764_b(EnumFluidNbt.FLUID.nameTag())) {
                tank.inputTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l(EnumFluidNbt.FLUID.nameTag())));
            }
            if (stack.func_77978_p().func_74764_b("Filter")) {
                tank.filter = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l("Filter"));
            }
        }
    }
}

