/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.handlers;

import com.globbypotato.rockhounding_chemistry.ModBlocks;
import com.globbypotato.rockhounding_chemistry.ModItems;
import com.globbypotato.rockhounding_chemistry.enums.EnumMiscBlocksA;
import com.globbypotato.rockhounding_chemistry.enums.EnumMiscItems;
import com.globbypotato.rockhounding_chemistry.enums.machines.EnumMachinesB;
import com.globbypotato.rockhounding_chemistry.enums.machines.EnumMachinesD;
import com.globbypotato.rockhounding_chemistry.enums.utils.EnumCasting;
import com.globbypotato.rockhounding_chemistry.enums.utils.EnumServer;
import com.globbypotato.rockhounding_chemistry.enums.utils.EnumSpeeds;
import com.globbypotato.rockhounding_chemistry.fluids.ModFluids;
import com.globbypotato.rockhounding_chemistry.handlers.ModConfig;
import com.globbypotato.rockhounding_chemistry.items.ProbeItems;
import com.globbypotato.rockhounding_chemistry.machines.io.MachineIO;
import com.globbypotato.rockhounding_chemistry.machines.recipe.BedReactorRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.ChemicalExtractorRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.DepositionChamberRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.GasReformerRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.LabOvenRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.LeachingVatRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.MetalAlloyerRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.MineralSizerRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.PrecipitationRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.RetentionVatRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.ChemicalExtractorRecipe;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.LeachingVatRecipe;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.MineralSizerRecipe;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.RetentionVatRecipe;
import com.globbypotato.rockhounding_chemistry.utils.BaseRecipes;
import com.globbypotato.rockhounding_chemistry.utils.ModUtils;
import com.globbypotato.rockhounding_core.enums.EnumFluidNbt;
import com.globbypotato.rockhounding_core.utils.CoreUtils;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class GlobbyEventHandler {
    ItemStack petroStack;
    ItemStack mineralStack;
    Random rand = new Random();

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void handleTooltip(ItemTooltipEvent event) {
        ItemStack itemstack = event.getItemStack();
        if (itemstack != ItemStack.field_190927_a) {
            int y;
            if (itemstack.func_77973_b() == ModItems.SPEED_ITEMS && itemstack.func_77952_i() > 0) {
                event.getToolTip().add(TextFormatting.GREEN + "Increases the machine speed by " + (itemstack.func_77952_i() + 1));
            }
            if (itemstack.func_77973_b() == ModItems.FILTER_ITEMS && itemstack.func_77952_i() > 0) {
                event.getToolTip().add(TextFormatting.GREEN + "Thickens the leaching filter mesh by " + (float)itemstack.func_77952_i() * 0.5f);
                event.getToolTip().add(TextFormatting.GREEN + "Sets the filter step to " + ModUtils.stepDivision(itemstack.func_77952_i()));
            }
            if (itemstack.func_77973_b() == ModItems.PROBE_ITEMS) {
                event.getToolTip().add(TextFormatting.GREEN + "Increases the Orbiter radius to " + ProbeItems.orbiterUpgrade(itemstack) + " block/s");
            }
            for (MineralSizerRecipe mineralSizerRecipe : MineralSizerRecipes.mineral_sizer_recipes) {
                for (y = 0; y < mineralSizerRecipe.getOutput().size(); ++y) {
                    if (!ItemStack.func_179545_c((ItemStack)mineralSizerRecipe.getOutput().get(y), (ItemStack)itemstack)) continue;
                    String comText = TextFormatting.GRAY + "Required Comminution Level: " + TextFormatting.GREEN + mineralSizerRecipe.getComminution().get(y);
                    if (event.getToolTip().contains(comText)) continue;
                    event.getToolTip().add(comText);
                }
            }
            for (LeachingVatRecipe leachingVatRecipe : LeachingVatRecipes.leaching_vat_recipes) {
                if (leachingVatRecipe.getOutput().size() < 1) continue;
                for (y = 0; y < leachingVatRecipe.getOutput().size(); ++y) {
                    if (!ItemStack.func_179545_c((ItemStack)leachingVatRecipe.getOutput().get(y), (ItemStack)itemstack)) continue;
                    float realgravity = leachingVatRecipe.getGravity().get(y).floatValue();
                    event.getToolTip().add(TextFormatting.GRAY + "Specific Gravity: " + TextFormatting.LIGHT_PURPLE + realgravity);
                }
            }
            for (RetentionVatRecipe retentionVatRecipe : RetentionVatRecipes.retention_vat_recipes) {
                if (retentionVatRecipe.getOutput().size() < 1) continue;
                for (y = 0; y < retentionVatRecipe.getOutput().size(); ++y) {
                    if (!ItemStack.func_179545_c((ItemStack)retentionVatRecipe.getOutput().get(y), (ItemStack)itemstack)) continue;
                    float realgravity = retentionVatRecipe.getGravity().get(y).floatValue();
                    String gravText = TextFormatting.GRAY + "Specific Gravity: " + TextFormatting.LIGHT_PURPLE + realgravity;
                    if (event.getToolTip().contains(gravText)) continue;
                    event.getToolTip().add(gravText);
                }
            }
            for (ChemicalExtractorRecipe chemicalExtractorRecipe : ChemicalExtractorRecipes.extractor_recipes) {
                if (chemicalExtractorRecipe.getType()) {
                    ArrayList inputOreIDs = CoreUtils.intArrayToList((int[])OreDictionary.getOreIDs((ItemStack)itemstack));
                    if (inputOreIDs.size() <= 0 || !inputOreIDs.contains(OreDictionary.getOreID((String)chemicalExtractorRecipe.getOredict()))) continue;
                    this.addExtractorRecipe(chemicalExtractorRecipe, event);
                    continue;
                }
                if (chemicalExtractorRecipe.getInput().func_190926_b() || !itemstack.func_77969_a(chemicalExtractorRecipe.getInput())) continue;
                this.addExtractorRecipe(chemicalExtractorRecipe, event);
            }
            if (itemstack.func_77942_o()) {
                FluidStack filterfluid;
                int n;
                NBTTagCompound tag;
                if (itemstack.func_77969_a(BaseRecipes.sampling_ampoule)) {
                    tag = itemstack.func_77978_p();
                    if (tag.func_74764_b(EnumFluidNbt.GAS.nameTag())) {
                        String string = TextFormatting.GRAY + "Sample: " + TextFormatting.BOLD + TextFormatting.AQUA + "Empty";
                        FluidStack sampledGas = FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemstack.func_77978_p().func_74775_l(EnumFluidNbt.GAS.nameTag()));
                        if (sampledGas != null && sampledGas.getFluid() != null && sampledGas.getFluid().isGaseous()) {
                            String string2 = TextFormatting.GRAY + "Sampled Gas: " + TextFormatting.BOLD + TextFormatting.AQUA + sampledGas.getLocalizedName();
                            event.getToolTip().add(string2);
                        }
                    } else if (tag.func_74764_b(EnumFluidNbt.FLUID.nameTag())) {
                        String string = TextFormatting.GRAY + "Sample: " + TextFormatting.BOLD + TextFormatting.AQUA + "Empty";
                        FluidStack sampledGas = FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemstack.func_77978_p().func_74775_l(EnumFluidNbt.FLUID.nameTag()));
                        if (sampledGas != null && sampledGas.getFluid() != null) {
                            String string3 = TextFormatting.GRAY + "Sampled Fluid: " + TextFormatting.BOLD + TextFormatting.AQUA + sampledGas.getLocalizedName();
                            event.getToolTip().add(string3);
                        }
                    }
                }
                if (itemstack.func_77969_a(new ItemStack(ModBlocks.MACHINES_D, 1, EnumMachinesD.ORBITER.ordinal())) && (tag = itemstack.func_77978_p()).func_74764_b("XPCount") && (n = tag.func_74762_e("XPCount")) > 0) {
                    String xp = TextFormatting.GRAY + "Stored Experience: " + TextFormatting.BOLD + TextFormatting.DARK_GREEN + n + " xp";
                    event.getToolTip().add(xp);
                }
                if (itemstack.func_77969_a(new ItemStack(ModItems.MISC_ITEMS, 1, EnumMiscItems.SERVER_FILE.ordinal())) && itemstack.func_77942_o() && GlobbyEventHandler.isValidNBT(tag = itemstack.func_77978_p())) {
                    ItemStack filter;
                    float currentGravity;
                    int n2 = tag.func_74762_e("Device");
                    boolean cycle = tag.func_74767_n("Cycle");
                    int recipe = tag.func_74762_e("Recipe");
                    int amount = tag.func_74762_e("Amount");
                    int done = tag.func_74762_e("Done");
                    event.getToolTip().add(TextFormatting.GRAY + "Served Device: " + TextFormatting.BOLD + TextFormatting.YELLOW + EnumServer.values()[n2].func_176610_l());
                    event.getToolTip().add(TextFormatting.GRAY + "Repeatable: " + TextFormatting.BOLD + TextFormatting.YELLOW + cycle);
                    if (n2 == EnumServer.LAB_OVEN.ordinal()) {
                        if (Strings.isNullOrEmpty((String)LabOvenRecipes.lab_oven_recipes.get(recipe).getRecipeName())) {
                            event.getToolTip().add(TextFormatting.GRAY + "Recipe: " + TextFormatting.BOLD + TextFormatting.YELLOW + LabOvenRecipes.lab_oven_recipes.get(recipe).getSolution().getLocalizedName());
                        } else {
                            event.getToolTip().add(TextFormatting.GRAY + "Recipe: " + TextFormatting.BOLD + TextFormatting.YELLOW + LabOvenRecipes.lab_oven_recipes.get(recipe).getRecipeName());
                        }
                    } else if (n2 == EnumServer.METAL_ALLOYER.ordinal()) {
                        event.getToolTip().add(TextFormatting.GRAY + "Recipe: " + TextFormatting.BOLD + TextFormatting.YELLOW + MetalAlloyerRecipes.metal_alloyer_recipes.get(recipe).getOutput().func_82833_r());
                    } else if (n2 == EnumServer.DEPOSITION.ordinal()) {
                        event.getToolTip().add(TextFormatting.GRAY + "Recipe: " + TextFormatting.BOLD + TextFormatting.YELLOW + DepositionChamberRecipes.deposition_chamber_recipes.get(recipe).getOutput().func_82833_r());
                    } else if (n2 == EnumServer.SIZER.ordinal()) {
                        event.getToolTip().add(TextFormatting.GRAY + "Comminution Level: " + TextFormatting.BOLD + TextFormatting.YELLOW + recipe);
                    } else if (n2 == EnumServer.LEACHING.ordinal()) {
                        currentGravity = (float)(recipe * 2) + 2.0f;
                        event.getToolTip().add(TextFormatting.GRAY + "Gravity: " + TextFormatting.BOLD + TextFormatting.YELLOW + (currentGravity - 2.0f) + " to " + (currentGravity + 2.0f));
                    } else if (n2 == EnumServer.RETENTION.ordinal()) {
                        currentGravity = (float)(recipe * 2) + 2.0f;
                        event.getToolTip().add(TextFormatting.GRAY + "Gravity: " + TextFormatting.BOLD + TextFormatting.YELLOW + (currentGravity - 2.0f) + " to " + (currentGravity + 2.0f));
                    } else if (n2 == EnumServer.CASTING.ordinal()) {
                        event.getToolTip().add(TextFormatting.GRAY + "Pattern: " + TextFormatting.BOLD + TextFormatting.YELLOW + EnumCasting.getFormalName(recipe));
                    } else if (n2 == EnumServer.REFORMER.ordinal()) {
                        event.getToolTip().add(TextFormatting.GRAY + "Recipe: " + TextFormatting.BOLD + TextFormatting.YELLOW + GasReformerRecipes.gas_reformer_recipes.get(recipe).getOutput().getLocalizedName());
                    } else if (n2 == EnumServer.EXTRACTOR.ordinal()) {
                        event.getToolTip().add(TextFormatting.GRAY + "Intensity Level: " + TextFormatting.BOLD + TextFormatting.YELLOW + recipe);
                    } else if (n2 == EnumServer.PRECIPITATOR.ordinal()) {
                        if (Strings.isNullOrEmpty((String)PrecipitationRecipes.precipitation_recipes.get(recipe).getRecipeName())) {
                            event.getToolTip().add(TextFormatting.GRAY + "Recipe: " + TextFormatting.BOLD + TextFormatting.YELLOW + PrecipitationRecipes.precipitation_recipes.get(recipe).getSolution().getLocalizedName());
                        } else {
                            event.getToolTip().add(TextFormatting.GRAY + "Recipe: " + TextFormatting.BOLD + TextFormatting.YELLOW + PrecipitationRecipes.precipitation_recipes.get(recipe).getRecipeName());
                        }
                    } else if (n2 == EnumServer.BED_REACTOR.ordinal()) {
                        event.getToolTip().add(TextFormatting.GRAY + "Recipe: " + TextFormatting.BOLD + TextFormatting.YELLOW + BedReactorRecipes.bed_reactor_recipes.get(recipe).getOutput().getLocalizedName());
                    }
                    if (tag.func_74764_b("FilterStack") && !(filter = new ItemStack(tag.func_74775_l("FilterStack"))).func_190926_b()) {
                        event.getToolTip().add(TextFormatting.GRAY + "Filter: " + TextFormatting.BOLD + TextFormatting.DARK_GREEN + filter.func_82833_r());
                    }
                    if (tag.func_74764_b("FilterFluid") && (filter = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.func_74775_l("FilterFluid"))) != null) {
                        event.getToolTip().add(TextFormatting.GRAY + "Filter: " + TextFormatting.BOLD + TextFormatting.DARK_GREEN + filter.getLocalizedName());
                    }
                    event.getToolTip().add(TextFormatting.GRAY + "Amount: " + TextFormatting.BOLD + TextFormatting.YELLOW + amount + " scheduled");
                    event.getToolTip().add(TextFormatting.GRAY + "Process: " + TextFormatting.BOLD + TextFormatting.YELLOW + done + " to do");
                }
                if (itemstack.func_77969_a(new ItemStack(ModItems.SPEED_ITEMS, 1, EnumSpeeds.BASE.ordinal()))) {
                    if (itemstack.func_77978_p().func_74764_b("Title")) {
                        event.getToolTip().add(itemstack.func_77978_p().func_74779_i("Title"));
                    }
                    if (itemstack.func_77978_p().func_74764_b("DustList")) {
                        void var4_20;
                        NBTTagList dustList = itemstack.func_77978_p().func_150295_c("DustList", 10);
                        boolean bl = false;
                        while (var4_20 < dustList.func_74745_c()) {
                            NBTTagCompound getQuantities = dustList.func_150305_b((int)var4_20);
                            event.getToolTip().add(getQuantities.func_74779_i("Ingr" + (int)var4_20));
                            ++var4_20;
                        }
                    }
                }
                if (!ModUtils.hasWawla() && itemstack.func_77973_b() instanceof UniversalBucket && FluidUtil.getFluidContained((ItemStack)itemstack) != null) {
                    filterfluid = FluidUtil.getFluidContained((ItemStack)itemstack);
                    event.getToolTip().add(TextFormatting.GRAY + "Temperature: " + TextFormatting.BOLD + TextFormatting.YELLOW + filterfluid.getFluid().getTemperature() + "K");
                }
                if (itemstack.func_77969_a(new ItemStack(ModBlocks.MACHINES_B, 1, EnumMachinesB.PRESSURE_VESSEL.ordinal())) && itemstack.func_77978_p().func_74764_b(EnumFluidNbt.GAS.nameTag()) && (filterfluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemstack.func_77978_p().func_74775_l(EnumFluidNbt.GAS.nameTag()))) != null) {
                    event.getToolTip().add(TextFormatting.GRAY + "Temperature: " + TextFormatting.BOLD + TextFormatting.YELLOW + filterfluid.getFluid().getTemperature() + "K");
                }
            }
        }
    }

    private void addExtractorRecipe(ChemicalExtractorRecipe recipe, ItemTooltipEvent event) {
        String inhibit = "";
        event.getToolTip().add(TextFormatting.GRAY + "Category: " + TextFormatting.YELLOW + recipe.getCategory());
        for (int x = 0; x < recipe.getElements().size(); ++x) {
            inhibit = "";
            String recipeDict = recipe.getElements().get(x);
            ArrayList firstDict = new ArrayList();
            if (OreDictionary.getOres((String)recipeDict).isEmpty()) continue;
            firstDict.addAll(OreDictionary.getOres((String)recipeDict));
            if (firstDict.isEmpty() || firstDict.size() <= 0) continue;
            for (int ix = 0; ix < ChemicalExtractorRecipes.inhibited_elements.size(); ++ix) {
                if (!recipeDict.toLowerCase().matches(ChemicalExtractorRecipes.inhibited_elements.get(ix).toLowerCase())) continue;
                inhibit = " - (Inhibited)";
            }
            event.getToolTip().add(TextFormatting.GRAY + ((ItemStack)firstDict.get(0)).func_82833_r() + " - " + TextFormatting.WHITE + TextFormatting.BOLD + recipe.getQuantities().get(x) + "%" + TextFormatting.RESET + TextFormatting.RED + inhibit);
        }
    }

    @SubscribeEvent
    public void onBlockBurn(FurnaceFuelBurnTimeEvent event) {
        if (event.getItemStack().func_77969_a(new ItemStack(ModBlocks.MISC_BLOCKS_A, 1, EnumMiscBlocksA.CHARCOAL_BLOCK.ordinal()))) {
            event.setBurnTime(16000);
        }
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent.RightClickBlock event) {
        if (Loader.isModLoaded((String)ModUtils.thermal_f_id) && event.getWorld().func_180495_p(event.getPos()) != null && event.getWorld().func_180495_p(event.getPos()).func_177230_c() instanceof MachineIO && !event.getItemStack().func_190926_b() && !ModUtils.thermal_f_wrench().func_190926_b() && event.getItemStack().func_77969_a(ModUtils.thermal_f_wrench())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void killDrops(LivingDeathEvent event) {
        if (ModConfig.fluidDamage && ModConfig.xpDrop) {
            EntityLivingBase entity = event.getEntityLiving();
            World world = entity.func_130014_f_();
            if (event.getSource() == ModFluids.SPILL) {
                double fx = world.field_73012_v.nextDouble();
                double fy = world.field_73012_v.nextDouble();
                double fz = world.field_73012_v.nextDouble();
                EntityXPOrb orb = new EntityXPOrb(world, entity.field_70165_t + fx, entity.field_70163_u + fy, entity.field_70161_v + fz, world.field_73012_v.nextInt(3) + 1);
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)orb);
                }
            }
        }
    }

    private static boolean isValidNBT(NBTTagCompound tag) {
        return tag.func_74764_b("Device") && tag.func_74762_e("Device") > -1 && tag.func_74764_b("Cycle") && tag.func_74764_b("Recipe") && tag.func_74764_b("Amount") && tag.func_74764_b("Done");
    }
}

