/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.fluids;

import com.globbypotato.rockhounding_chemistry.entities.EntityToxicSlime;
import com.globbypotato.rockhounding_chemistry.enums.materials.EnumFluid;
import com.globbypotato.rockhounding_chemistry.handlers.ModConfig;
import com.globbypotato.rockhounding_chemistry.handlers.Reference;
import com.globbypotato.rockhounding_chemistry.machines.recipe.ToxicMutationRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.ToxicMutationRecipe;
import com.globbypotato.rockhounding_core.utils.CoreUtils;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModFluids {
    static Random rand = new Random();
    public static final Set<Fluid> FLUIDS = new HashSet<Fluid>();
    public static final Set<Fluid> GASES = new HashSet<Fluid>();
    public static final Set<BlockFluidClassic> MOD_FLUID_BLOCKS = new HashSet<BlockFluidClassic>();
    public static DamageSource ACID = new DamageSource("acid").func_76348_h();
    public static DamageSource CHEMICALS = new DamageSource("chemicals").func_76348_h();
    public static DamageSource SPILL = new DamageSource("spill").func_76348_h();
    public static final Fluid SULFURIC_ACID = ModFluids.createFluid(EnumFluid.SULFURIC_ACID.getFluidName(), true, -1, "blur", 1000, 1000, 300, false, 0, fluid -> new BlockFluidClassic((Fluid)fluid, Material.field_151586_h){

        public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
            super.func_180634_a(worldIn, pos, state, entityIn);
            ModFluids.applyDamage(ACID, entityIn, 8.0f);
        }
    });
    public static final Fluid SODIUM_HYDROXIDE = ModFluids.createFluid(EnumFluid.SODIUM_HYDROXIDE.getFluidName(), true, -1, "blur", 1000, 1000, 300, false, 0, fluid -> new BlockFluidClassic((Fluid)fluid, Material.field_151586_h){

        public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
            ModFluids.applyDamage(CHEMICALS, entityIn, 4.0f);
        }
    });
    public static final Fluid HYDROCHLORIC_ACID = ModFluids.createFluid(EnumFluid.HYDROCHLORIC_ACID.getFluidName(), true, -4462610, "blur", 1000, 1000, 300, false, 0, fluid -> new BlockFluidClassic((Fluid)fluid, Material.field_151586_h){

        public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
            ModFluids.applyDamage(ACID, entityIn, 3.0f);
        }
    });
    public static final Fluid HYDROFLUORIC_ACID = ModFluids.createFluid(EnumFluid.HYDROFLUORIC_ACID.getFluidName(), true, -1315141, "blur", 1000, 1000, 300, false, 0, fluid -> new BlockFluidClassic((Fluid)fluid, Material.field_151586_h){

        public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
            ModFluids.applyDamage(ACID, entityIn, 3.0f);
        }
    });
    public static final Fluid CHLOROMETHANE = ModFluids.createFluid(EnumFluid.CHLOROMETHANE.getFluidName(), true, -3618616, "blur", 1000, 1000, 300, false, 0, fluid -> new BlockFluidClassic((Fluid)fluid, Material.field_151586_h){

        public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
            ModFluids.applyDamage(CHEMICALS, entityIn, 2.0f);
        }
    });
    public static final Fluid LIQUID_AMMONIA = ModFluids.createFluid(EnumFluid.LIQUID_AMMONIA.getFluidName(), true, -3678521, "blur", 1000, 1000, 300, false, 0, fluid -> new BlockFluidClassic((Fluid)fluid, Material.field_151586_h){

        public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
            ModFluids.applyDamage(ACID, entityIn, 5.0f);
        }
    });
    public static final Fluid NITRIC_ACID = ModFluids.createFluid(EnumFluid.NITRIC_ACID.getFluidName(), true, -2173241, "blur", 1000, 1000, 350, false, 0, fluid -> new BlockFluidClassic((Fluid)fluid, Material.field_151586_h){

        public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
            ModFluids.applyDamage(ACID, entityIn, 16.0f);
        }
    });
    public static final Fluid SODIUM_CYANIDE = ModFluids.createFluid(EnumFluid.SODIUM_CYANIDE.getFluidName(), true, -2302756, "blur", 1000, 1000, 300, false, 0, fluid -> new BlockFluidClassic((Fluid)fluid, Material.field_151586_h){

        public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
            ModFluids.applyDamage(ACID, entityIn, 6.0f);
        }
    });
    public static final Fluid LIQUID_NITROGEN = ModFluids.createFluid(EnumFluid.LIQUID_NITROGEN.getFluidName(), true, -2302756, "blur", 10, 10, 70, false, 0, fluid -> new BlockFluidClassic((Fluid)fluid, Material.field_151586_h){

        public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
            ModFluids.applyDamage(CHEMICALS, entityIn, 4.0f);
        }

        @SideOnly(value=Side.CLIENT)
        public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
            ModFluids.doVaporize(pos, worldIn, rand, EnumParticleTypes.EXPLOSION_NORMAL);
        }

        public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
            super.func_180650_b(worldIn, pos, state, rand);
            ModFluids.vaporizeGas(pos, worldIn, 10);
            worldIn.func_180497_b(pos, (Block)this, 1, 0);
        }
    });
    public static final Fluid LIQUID_OXYGEN = ModFluids.createFluid(EnumFluid.LIQUID_OXYGEN.getFluidName(), true, -2302756, "blur", 10, 10, 60, false, 0, fluid -> new BlockFluidClassic((Fluid)fluid, Material.field_151586_h){

        public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
            ModFluids.applyDamage(CHEMICALS, entityIn, 4.0f);
        }

        @SideOnly(value=Side.CLIENT)
        public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
            ModFluids.doVaporize(pos, worldIn, rand, EnumParticleTypes.EXPLOSION_NORMAL);
        }

        public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
            super.func_180650_b(worldIn, pos, state, rand);
            ModFluids.vaporizeGas(pos, worldIn, 10);
            worldIn.func_180497_b(pos, (Block)this, 1, 0);
        }
    });
    public static final Fluid METHANOL = ModFluids.createFluid(EnumFluid.METHANOL.getFluidName(), true, -3618616, "blur", 1000, 1000, 300, false, 0, fluid -> new BlockFluidClassic((Fluid)fluid, Material.field_151586_h){

        public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
            ModFluids.applyDamage(CHEMICALS, entityIn, 2.0f);
        }
    });
    public static final Fluid ACRYLIC_ACID = ModFluids.createFluid(EnumFluid.ACRYLIC_ACID.getFluidName(), true, -1, "blur", 1000, 1000, 300, false, 0, fluid -> new BlockFluidClassic((Fluid)fluid, Material.field_151586_h){

        public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
            ModFluids.applyDamage(ACID, entityIn, 4.0f);
        }
    });
    public static final Fluid VIRGIN_WATER = ModFluids.createFluid(EnumFluid.VIRGIN_WATER.getFluidName(), true, -8798498, "blur", 1000, 1000, 300, false, 0, fluid -> new BlockFluidClassic((Fluid)fluid, Material.field_151586_h){});
    public static final Fluid SALT_BRINE = ModFluids.createFluid(EnumFluid.SALT_BRINE.getFluidName(), true, -9333081, "blur", 1000, 1000, 300, false, 0, fluid -> new BlockFluidClassic((Fluid)fluid, Material.field_151586_h){});
    public static final Fluid DENSE_BRINE = ModFluids.createFluid(EnumFluid.DENSE_BRINE.getFluidName(), true, -2775386, "blur", 1000, 1000, 300, false, 0, fluid -> new BlockFluidClassic((Fluid)fluid, Material.field_151586_h){});
    public static final Fluid MOTHER_LIQUOR = ModFluids.createFluid(EnumFluid.MOTHER_LIQUOR.getFluidName(), true, -10538, "fill", 1000, 1000, 300, false, 0, fluid -> new BlockFluidClassic((Fluid)fluid, Material.field_151586_h){});
    public static final Fluid LEACHATE = ModFluids.createFluid(EnumFluid.LEACHATE.getFluidName(), true, -11714543, "fill", 3000, 3000, 300, false, 0, fluid -> new BlockFluidClassic(fluid, Material.field_151586_h));
    public static final Fluid COAL_SLURRY = ModFluids.createFluid(EnumFluid.COAL_SLURRY.getFluidName(), false, -16777216, "fill", 3000, 4000, 300, false, 0, fluid -> new BlockFluidClassic(fluid, Material.field_151586_h));
    public static final Fluid ORGANIC_SLURRY = ModFluids.createFluid(EnumFluid.ORGANIC_SLURRY.getFluidName(), true, -7632024, "fill", 2000, 2000, 300, false, 0, fluid -> new BlockFluidClassic(fluid, Material.field_151586_h));
    public static final Fluid COAL_TAR = ModFluids.createFluid(EnumFluid.COAL_TAR.getFluidName(), false, -16777216, "fill", 5000, 7000, 300, false, 0, fluid -> new BlockFluidClassic((Fluid)fluid, Material.field_151586_h){

        public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
            entityIn.func_70110_aj();
        }
    });
    public static final Fluid SILICONE = ModFluids.createFluid(EnumFluid.SILICONE.getFluidName(), false, -6773069, "fill", 9000, 9000, 300, false, 0, fluid -> new BlockFluidClassic((Fluid)fluid, Material.field_151586_h){

        public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
            entityIn.func_70110_aj();
        }
    });
    public static final Fluid TOXIC_WASTE = ModFluids.createFluid(EnumFluid.TOXIC_WASTE.getFluidName(), true, -7230863, "molten", 1500, 2025, 350, false, 0, fluid -> new BlockFluidClassic((Fluid)fluid, Material.field_151586_h){

        public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
            ModFluids.applyDamage(SPILL, entityIn, 12.0f);
        }

        @SideOnly(value=Side.CLIENT)
        public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
            ModFluids.doSparks(pos, worldIn, rand, EnumParticleTypes.SMOKE_NORMAL, 32);
        }

        public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
            if (this.isSourceBlock((IBlockAccess)world, pos)) {
                List entities = world.func_175647_a(EntityItem.class, new AxisAlignedBB(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o() + 1, pos.func_177952_p() + 1)), EntitySelectors.field_94557_a);
                if (!entities.isEmpty() && entities.size() > 0) {
                    block0: for (int i = 0; i < entities.size(); ++i) {
                        EntityItem drop = (EntityItem)entities.get(i);
                        ItemStack dropStack = drop.func_92059_d();
                        if (dropStack.func_190926_b()) continue;
                        for (ToxicMutationRecipe recipe : ToxicMutationRecipes.toxic_mutation_recipes) {
                            if (!recipe.getType()) {
                                if (recipe.getInput().func_190926_b() || !recipe.getInput().func_77969_a(dropStack)) continue;
                                this.doMutation(recipe, world, pos, dropStack, drop);
                                continue block0;
                            }
                            ArrayList inputOreIDs = CoreUtils.intArrayToList((int[])OreDictionary.getOreIDs((ItemStack)dropStack));
                            if (inputOreIDs.isEmpty() || Strings.isNullOrEmpty((String)recipe.getOredict()) || !inputOreIDs.contains(OreDictionary.getOreID((String)recipe.getOredict()))) continue;
                            this.doMutation(recipe, world, pos, dropStack, drop);
                            continue block0;
                        }
                    }
                }
                world.func_180497_b(pos, (Block)this, 10, 0);
            }
            super.func_180650_b(world, pos, state, rand);
        }

        private void doMutation(ToxicMutationRecipe recipe, World world, BlockPos pos, ItemStack dropStack, EntityItem drop) {
            if (!world.field_72995_K) {
                ItemStack mutationDrop = recipe.getOutput();
                mutationDrop.func_190920_e(dropStack.func_190916_E());
                EntityItem mutation = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), mutationDrop);
                mutation.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
                mutation.field_70159_w = 0.0;
                mutation.field_70181_x = 0.0;
                mutation.field_70179_y = 0.0;
                drop.func_70106_y();
                world.func_72838_d((Entity)mutation);
            }
            ModFluids.doClickSound(null, world, pos, SoundEvents.field_187570_aq, 0.3f, 2.0f);
        }
    });
    public static final Fluid TOXIC_SLUDGE = ModFluids.createFluid(EnumFluid.TOXIC_SLUDGE.getFluidName(), true, -7230863, "blur", 1000, 1000, 300, false, 0, fluid -> new BlockFluidClassic((Fluid)fluid, Material.field_151586_h){

        public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
            ModFluids.applyDamage(SPILL, entityIn, 8.0f);
        }

        @SideOnly(value=Side.CLIENT)
        public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
            ModFluids.doSparks(pos, worldIn, rand, EnumParticleTypes.CRIT_MAGIC, 16);
        }

        public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
            if (ModConfig.enableHazard && this.isSourceBlock((IBlockAccess)worldIn, pos)) {
                if (worldIn.func_175659_aa() != EnumDifficulty.PEACEFUL && worldIn.field_73012_v.nextInt(ModConfig.slimeChance + 1) == 0 && !worldIn.field_72995_K) {
                    EntityToxicSlime slime = new EntityToxicSlime(worldIn);
                    slime.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                    NBTTagCompound tag = new NBTTagCompound();
                    slime.func_70014_b(tag);
                    tag.func_74768_a("Size", 1);
                    slime.func_70037_a(tag);
                    worldIn.func_72838_d((Entity)slime);
                    slime.func_70642_aH();
                }
                worldIn.func_180497_b(pos, (Block)this, 10, 0);
            }
            super.func_180650_b(worldIn, pos, state, rand);
        }
    });
    public static final Fluid THIN_AIR = ModFluids.createFluid(EnumFluid.THIN_AIR.getFluidName(), true, -2302756, "blur", 10, 10, 120, true, 0, fluid -> new BlockFluidClassic(fluid, Material.field_151579_a));
    public static final Fluid NITROGEN = ModFluids.createFluid(EnumFluid.NITROGEN.getFluidName(), true, -2302756, "blur", 10, 10, 120, true, 0, fluid -> new BlockFluidClassic(fluid, Material.field_151579_a));
    public static final Fluid OXYGEN = ModFluids.createFluid(EnumFluid.OXYGEN.getFluidName(), true, -2302756, "blur", 10, 10, 110, true, 0, fluid -> new BlockFluidClassic(fluid, Material.field_151579_a));
    public static final Fluid RAW_SYNGAS = ModFluids.createFluid(EnumFluid.RAW_SYNGAS.getFluidName(), true, -10854309, "blur", 10, 10, 400, true, 0, fluid -> new BlockFluidClassic(fluid, Material.field_151579_a));
    public static final Fluid SYNGAS = ModFluids.createFluid(EnumFluid.SYNGAS.getFluidName(), true, -12040120, "blur", 10, 10, 305, true, 0, fluid -> new BlockFluidClassic(fluid, Material.field_151579_a));
    public static final Fluid COMPRESSED_AIR = ModFluids.createFluid(EnumFluid.COMPRESSED_AIR.getFluidName(), true, -3473412, "blur", 10, 10, 280, true, 0, fluid -> new BlockFluidClassic(fluid, Material.field_151579_a));
    public static final Fluid REFINED_AIR = ModFluids.createFluid(EnumFluid.REFINED_AIR.getFluidName(), true, -7354135, "blur", 10, 10, 250, true, 0, fluid -> new BlockFluidClassic(fluid, Material.field_151579_a));
    public static final Fluid COOLED_AIR = ModFluids.createFluid(EnumFluid.COOLED_AIR.getFluidName(), true, -9197586, "blur", 10, 10, 140, true, 0, fluid -> new BlockFluidClassic(fluid, Material.field_151579_a));
    public static final Fluid ARGON = ModFluids.createFluid(EnumFluid.ARGON.getFluidName(), true, -8172902, "blur", 10, 10, 60, true, 0, fluid -> new BlockFluidClassic(fluid, Material.field_151579_a));
    public static final Fluid CARBON_DIOXIDE = ModFluids.createFluid(EnumFluid.CARBON_DIOXIDE.getFluidName(), true, -8287591, "blur", 10, 10, 200, true, 0, fluid -> new BlockFluidClassic(fluid, Material.field_151579_a));
    public static final Fluid HELIUM = ModFluids.createFluid(EnumFluid.HELIUM.getFluidName(), true, -37888, "blur", 10, 10, 50, true, 0, fluid -> new BlockFluidClassic(fluid, Material.field_151579_a));
    public static final Fluid NEON = ModFluids.createFluid(EnumFluid.NEON.getFluidName(), true, -65536, "blur", 10, 10, 70, true, 0, fluid -> new BlockFluidClassic(fluid, Material.field_151579_a));
    public static final Fluid KRYPTON = ModFluids.createFluid(EnumFluid.KRYPTON.getFluidName(), true, -10253622, "blur", 10, 10, 60, true, 0, fluid -> new BlockFluidClassic(fluid, Material.field_151579_a));
    public static final Fluid XENON = ModFluids.createFluid(EnumFluid.XENON.getFluidName(), true, -14407778, "blur", 10, 10, 70, true, 0, fluid -> new BlockFluidClassic(fluid, Material.field_151579_a));
    public static final Fluid WATER_VAPOUR = ModFluids.createFluid(EnumFluid.WATER_VAPOUR.getFluidName(), true, -2302756, "blur", 10, 10, 340, true, 0, fluid -> new BlockFluidClassic(fluid, Material.field_151579_a));
    public static final Fluid AMMONIA = ModFluids.createFluid(EnumFluid.AMMONIA.getFluidName(), true, -3678521, "blur", 10, 10, 300, true, 0, fluid -> new BlockFluidClassic(fluid, Material.field_151579_a));
    public static final Fluid HYDROGEN = ModFluids.createFluid(EnumFluid.HYDROGEN.getFluidName(), true, -2302756, "blur", 10, 10, 110, true, 0, fluid -> new BlockFluidClassic(fluid, Material.field_151579_a));
    public static final Fluid RAW_FLUE_GAS = ModFluids.createFluid(EnumFluid.RAW_FLUE_GAS.getFluidName(), true, -5918022, "blur", 10, 10, 450, true, 0, fluid -> new BlockFluidClassic(fluid, Material.field_151579_a));
    public static final Fluid FLUE_GAS = ModFluids.createFluid(EnumFluid.FLUE_GAS.getFluidName(), true, -4206888, "blur", 10, 10, 310, true, 0, fluid -> new BlockFluidClassic(fluid, Material.field_151579_a));
    public static final Fluid PROPYLENE = ModFluids.createFluid(EnumFluid.PROPYLENE.getFluidName(), true, -3750202, "blur", 10, 10, 305, true, 0, fluid -> new BlockFluidClassic(fluid, Material.field_151579_a));
    public static final Fluid MOLTEN_VANADIUM = ModFluids.createFluid(EnumFluid.MOLTEN_VANADIUM.getFluidName(), false, -3480445, "molten", 2000, 10000, 1000, false, 10, fluid -> new BlockFluidClassic(fluid, Material.field_151587_i));
    public static final Fluid MOLTEN_TITANIUM = ModFluids.createFluid(EnumFluid.MOLTEN_TITANIUM.getFluidName(), false, -5855578, "molten", 2000, 10000, 1000, false, 10, fluid -> new BlockFluidClassic(fluid, Material.field_151587_i));
    public static final Fluid MOLTEN_CUBE = ModFluids.createFluid(EnumFluid.MOLTEN_CUBE.getFluidName(), false, -44032, "molten", 2000, 10000, 1000, false, 10, fluid -> new BlockFluidClassic(fluid, Material.field_151587_i));
    public static final Fluid MOLTEN_SCAL = ModFluids.createFluid(EnumFluid.MOLTEN_SCAL.getFluidName(), false, -1, "molten", 2000, 10000, 1000, false, 10, fluid -> new BlockFluidClassic(fluid, Material.field_151587_i));
    public static final Fluid MOLTEN_BAM = ModFluids.createFluid(EnumFluid.MOLTEN_BAM.getFluidName(), false, -8223349, "molten", 2000, 10000, 1000, false, 10, fluid -> new BlockFluidClassic(fluid, Material.field_151587_i));
    public static final Fluid MOLTEN_STELLITE = ModFluids.createFluid(EnumFluid.MOLTEN_STELLITE.getFluidName(), false, -2502777, "molten", 2000, 10000, 1000, false, 10, fluid -> new BlockFluidClassic(fluid, Material.field_151587_i));
    public static final Fluid MOLTEN_CUPRONICKEL = ModFluids.createFluid(EnumFluid.MOLTEN_CUPRONICKEL.getFluidName(), false, -4875379, "molten", 2000, 10000, 1000, false, 10, fluid -> new BlockFluidClassic(fluid, Material.field_151587_i));
    public static final Fluid MOLTEN_NIMONIC = ModFluids.createFluid(EnumFluid.MOLTEN_NIMONIC.getFluidName(), false, -1, "molten", 2000, 10000, 1000, false, 10, fluid -> new BlockFluidClassic(fluid, Material.field_151587_i));
    public static final Fluid MOLTEN_HASTELLOY = ModFluids.createFluid(EnumFluid.MOLTEN_HASTELLOY.getFluidName(), false, -11250604, "molten", 2000, 10000, 1000, false, 10, fluid -> new BlockFluidClassic(fluid, Material.field_151587_i));
    public static final Fluid MOLTEN_NICHROME = ModFluids.createFluid(EnumFluid.MOLTEN_NICHROME.getFluidName(), false, -8752792, "molten", 2000, 10000, 1000, false, 10, fluid -> new BlockFluidClassic(fluid, Material.field_151587_i));
    public static final Fluid MOLTEN_CUNIFE = ModFluids.createFluid(EnumFluid.MOLTEN_CUNIFE.getFluidName(), false, -6721, "molten", 2000, 10000, 1000, false, 10, fluid -> new BlockFluidClassic(fluid, Material.field_151587_i));
    public static final Fluid MOLTEN_HYDRONALIUM = ModFluids.createFluid(EnumFluid.MOLTEN_HYDRONALIUM.getFluidName(), false, -5525326, "molten", 2000, 10000, 1000, false, 10, fluid -> new BlockFluidClassic(fluid, Material.field_151587_i));
    public static final Fluid MOLTEN_VANASTEEL = ModFluids.createFluid(EnumFluid.MOLTEN_VANASTEEL.getFluidName(), false, -3157084, "molten", 2000, 10000, 1000, false, 10, fluid -> new BlockFluidClassic(fluid, Material.field_151587_i));
    public static final Fluid MOLTEN_TANTALOY = ModFluids.createFluid(EnumFluid.MOLTEN_TANTALOY.getFluidName(), false, -12696006, "molten", 2000, 10000, 1000, false, 10, fluid -> new BlockFluidClassic(fluid, Material.field_151587_i));
    public static final Fluid MOLTEN_CORTEN = ModFluids.createFluid(EnumFluid.MOLTEN_CORTEN.getFluidName(), false, -8702452, "molten", 2000, 10000, 1000, false, 10, fluid -> new BlockFluidClassic(fluid, Material.field_151587_i));
    public static final Fluid MOLTEN_PEWTER = ModFluids.createFluid(EnumFluid.MOLTEN_PEWTER.getFluidName(), false, -4996938, "molten", 2000, 10000, 1000, false, 10, fluid -> new BlockFluidClassic(fluid, Material.field_151587_i));
    public static final Fluid MOLTEN_NIAL = ModFluids.createFluid(EnumFluid.MOLTEN_NIAL.getFluidName(), false, -4015197, "molten", 2000, 10000, 1000, false, 10, fluid -> new BlockFluidClassic(fluid, Material.field_151587_i));
    public static final Fluid MOLTEN_INCONEL = ModFluids.createFluid(EnumFluid.MOLTEN_INCONEL.getFluidName(), false, -5133974, "molten", 2000, 10000, 1000, false, 10, fluid -> new BlockFluidClassic(fluid, Material.field_151587_i));
    public static final Fluid MOLTEN_ZIRCALOY = ModFluids.createFluid(EnumFluid.MOLTEN_ZIRCALOY.getFluidName(), false, -2762817, "molten", 2000, 10000, 1000, false, 10, fluid -> new BlockFluidClassic(fluid, Material.field_151587_i));

    static void applyDamage(DamageSource type, Entity entityIn, float damage) {
        if (ModConfig.fluidDamage && entityIn != null && entityIn instanceof EntityLivingBase && !(entityIn instanceof EntityToxicSlime)) {
            entityIn.func_70097_a(type, damage);
        }
    }

    static void doSparks(BlockPos pos, World worldIn, Random rand, EnumParticleTypes particles, int i) {
        if (rand.nextInt(i) == 0) {
            double d0 = (double)pos.func_177958_n() + rand.nextDouble();
            double d1 = (double)pos.func_177956_o() + rand.nextDouble() * 0.5 + 0.5;
            double d2 = (double)pos.func_177952_p() + rand.nextDouble();
            worldIn.func_175688_a(particles, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    static void doVaporize(BlockPos pos, World worldIn, Random rand, EnumParticleTypes particles) {
        for (int i = 0; i < 8; ++i) {
            double d0 = (double)pos.func_177958_n() + rand.nextDouble();
            double d1 = (double)pos.func_177956_o() + rand.nextDouble() * 0.5 + 0.5;
            double d2 = (double)pos.func_177952_p() + rand.nextDouble();
            worldIn.func_175688_a(particles, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    static void vaporizeGas(BlockPos pos, World world, int i) {
        if (rand.nextInt(i) == 0) {
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
    }

    static void doClickSound(EntityPlayer player, World world, BlockPos pos, SoundEvent sound, float volume, float pitch) {
        world.func_184133_a(player, pos, sound, SoundCategory.BLOCKS, volume, pitch);
    }

    private static <T extends BlockFluidClassic> Fluid createFluid(String name, boolean hasFlowIcon, int fluidcolor, String alpha, int fluiddensity, int fluidviscosity, int fluidtemperature, boolean fluidgaseous, int fluidluminosity, Function<Fluid, T> blockFactory) {
        boolean useOwnFluid;
        String texturePrefix = "rockhounding_chemistry:fluids/";
        ResourceLocation still = new ResourceLocation(texturePrefix + alpha + "_basefluid_still");
        ResourceLocation flowing = hasFlowIcon ? new ResourceLocation(texturePrefix + alpha + "_basefluid_flow") : still;
        Fluid fluid = new Fluid(name, still, flowing);
        fluid.setColor(fluidcolor);
        if (fluiddensity != 1000) {
            fluid.setDensity(fluiddensity);
        }
        if (fluidviscosity != 1000) {
            fluid.setViscosity(fluidviscosity);
        }
        if (fluidtemperature != 300) {
            fluid.setTemperature(fluidtemperature);
        }
        if (fluidgaseous) {
            fluid.setGaseous(fluidgaseous);
        }
        if (fluidluminosity > 0) {
            fluid.setLuminosity(fluidluminosity);
        }
        if (useOwnFluid = FluidRegistry.registerFluid((Fluid)fluid)) {
            MOD_FLUID_BLOCKS.add((BlockFluidClassic)blockFactory.apply(fluid));
        } else {
            fluid = FluidRegistry.getFluid((String)name);
        }
        FLUIDS.add(fluid);
        if (fluid.isGaseous()) {
            GASES.add(fluid);
        }
        return fluid;
    }

    public static void registerFluidContainers() {
        for (Fluid fluid : FLUIDS) {
            ModFluids.registerBucket(fluid);
        }
    }

    private static void registerBucket(Fluid fluid) {
        FluidRegistry.addBucketForFluid((Fluid)fluid);
    }

    @Mod.EventBusSubscriber(modid="rockhounding_chemistry")
    public static class RegistrationHandler {
        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            IForgeRegistry registry = event.getRegistry();
            for (BlockFluidClassic fluidBlock : MOD_FLUID_BLOCKS) {
                fluidBlock.setRegistryName("rockhounding_chemistry", "fluid." + fluidBlock.getFluid().getName());
                fluidBlock.func_149663_c("rockhounding_chemistry:" + fluidBlock.getFluid().getUnlocalizedName());
                if (!fluidBlock.getFluid().isGaseous()) {
                    fluidBlock.func_149647_a(Reference.RockhoundingChemistry);
                } else {
                    fluidBlock.func_149647_a(null);
                }
                registry.register((IForgeRegistryEntry)fluidBlock);
            }
        }

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            IForgeRegistry registry = event.getRegistry();
            for (BlockFluidClassic fluidBlock : MOD_FLUID_BLOCKS) {
                ItemBlock itemBlock = new ItemBlock((Block)fluidBlock);
                itemBlock.setRegistryName(fluidBlock.getRegistryName());
                registry.register((IForgeRegistryEntry)itemBlock);
            }
        }
    }
}

