/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.enums;

import com.globbypotato.rockhounding_chemistry.enums.BaseEnum;

public enum EnumAlloyTech implements BaseEnum
{
    CUBE("Cube"),
    SCAL("Scal"),
    BAM("Bam"),
    STELLITE("Stellite"),
    CUPRONICKEL("Cupronickel"),
    NIMONIC("Nimonic"),
    HASTELLOY("Hastelloy"),
    NICHROME("Nichrome"),
    CUNIFE("Cunife"),
    SIENA("SiliconNitride"),
    CARBORUNDUM("Carborundum"),
    TINITE("Tinite"),
    HYDRONALIUM("Hydronalium"),
    VANASTEEL("Vanasteel"),
    WIDIA("Widia"),
    TANTALOY("Tantaloy");

    public String formal;

    private EnumAlloyTech(String formal) {
        this.formal = formal;
    }

    public static int size() {
        return EnumAlloyTech.values().length;
    }

    public static String name(int index) {
        return EnumAlloyTech.values()[index].func_176610_l();
    }

    public static String[] getAlloys() {
        String[] temp = new String[EnumAlloyTech.size()];
        for (int i = 0; i < EnumAlloyTech.size(); ++i) {
            temp[i] = EnumAlloyTech.getAlloy(i);
        }
        return temp;
    }

    public static String getAlloy(int index) {
        return EnumAlloyTech.name(index);
    }

    public static String[] getFormals() {
        String[] temp = new String[EnumAlloyTech.size()];
        for (int i = 0; i < EnumAlloyTech.size(); ++i) {
            temp[i] = EnumAlloyTech.formalName(i);
        }
        return temp;
    }

    private static String formalName(int index) {
        return EnumAlloyTech.values()[index].formal;
    }

    public static String[] getItemNames() {
        String[] temp = new String[EnumAlloyTech.size() * 3];
        for (int i = 0; i < EnumAlloyTech.size(); ++i) {
            temp[i * 3] = EnumAlloyTech.getItemDust(i);
            temp[i * 3 + 1] = EnumAlloyTech.getItemIngot(i);
            temp[i * 3 + 2] = EnumAlloyTech.getItemNugget(i);
        }
        return temp;
    }

    public static String getItemName(int index) {
        return EnumAlloyTech.getItemNames()[index].toString();
    }

    public static String[] getDust() {
        String[] temp = new String[EnumAlloyTech.size()];
        for (int i = 0; i < EnumAlloyTech.size(); ++i) {
            temp[i] = EnumAlloyTech.getDust(i);
        }
        return temp;
    }

    public static String getItemDust(int index) {
        return EnumAlloyTech.name(index) + "_dust";
    }

    public static String getDust(int index) {
        return "dust" + EnumAlloyTech.formalName(index);
    }

    public static String[] getIngots() {
        String[] temp = new String[EnumAlloyTech.size()];
        for (int i = 0; i < EnumAlloyTech.size(); ++i) {
            temp[i] = EnumAlloyTech.getIngot(i);
        }
        return temp;
    }

    public static String getItemIngot(int index) {
        return EnumAlloyTech.name(index) + "_ingot";
    }

    public static String getIngot(int index) {
        return "ingot" + EnumAlloyTech.formalName(index);
    }

    public static String[] getNuggets() {
        String[] temp = new String[EnumAlloyTech.size()];
        for (int i = 0; i < EnumAlloyTech.size(); ++i) {
            temp[i] = EnumAlloyTech.getNugget(i);
        }
        return temp;
    }

    public static String getItemNugget(int index) {
        return EnumAlloyTech.name(index) + "_nugget";
    }

    public static String getNugget(int index) {
        return "nugget" + EnumAlloyTech.formalName(index);
    }

    public static String[] getBlocks() {
        String[] temp = new String[EnumAlloyTech.size()];
        for (int i = 0; i < EnumAlloyTech.size(); ++i) {
            temp[i] = EnumAlloyTech.getBlock(i);
        }
        return temp;
    }

    public static String getBlock(int index) {
        return "block" + EnumAlloyTech.formalName(index);
    }
}

