/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.compat.waila;

import com.globbypotato.rockhounding_chemistry.machines.MachinesB;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEAirCompressor;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEGasifierBurner;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEGasifierCooler;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEGasifierTank;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEPressureVessel;
import com.globbypotato.rockhounding_chemistry.machines.tile.TESlurryPond;
import com.globbypotato.rockhounding_chemistry.machines.tile.TileVessel;
import com.globbypotato.rockhounding_core.machines.gui.GuiUtils;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidTank;

public class WailaMachinesB
implements IWailaDataProvider {
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return new ItemStack(accessor.getBlock(), 1, accessor.getMetadata());
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        BlockPos pos = accessor.getPosition();
        World world = accessor.getWorld();
        TileEntity te = world.func_175625_s(pos);
        if (te != null) {
            Object tank;
            if (te instanceof TESlurryPond) {
                tank = (TESlurryPond)te;
                if (((TESlurryPond)tank).hasInputFluid()) {
                    currenttip.add(TextFormatting.GRAY + "Input: " + TextFormatting.WHITE + ((TESlurryPond)tank).getInputFluid().getLocalizedName() + " - " + ((TESlurryPond)tank).getInputAmount() + "/" + ((TESlurryPond)tank).getTankCapacity() + " mB");
                } else {
                    currenttip.add(TextFormatting.GRAY + "Input: " + TextFormatting.WHITE + "Empty");
                }
                if (((TESlurryPond)tank).hasOutputFluid()) {
                    currenttip.add(TextFormatting.GRAY + "Output: " + TextFormatting.WHITE + ((TESlurryPond)tank).getOutputFluid().getLocalizedName() + " - " + ((TESlurryPond)tank).getOutputAmount() + "/" + ((TESlurryPond)tank).getTankCapacity() + " mB");
                } else {
                    currenttip.add(TextFormatting.GRAY + "Output: " + TextFormatting.WHITE + "Empty");
                }
            }
            if (te instanceof TEGasifierTank) {
                tank = (TEGasifierTank)te;
                if (((TEGasifierTank)tank).hasInputFluid()) {
                    currenttip.add(TextFormatting.GRAY + "Content: " + TextFormatting.WHITE + ((TEGasifierTank)tank).getInputFluid().getLocalizedName() + " - " + ((TEGasifierTank)tank).getInputAmount() + "/" + ((TEGasifierTank)tank).getTankCapacity() + " mB");
                } else {
                    currenttip.add(TextFormatting.GRAY + "Content: " + TextFormatting.WHITE + "Empty");
                }
            }
            if (te instanceof TEGasifierCooler) {
                tank = (TEGasifierCooler)te;
                currenttip.add(TextFormatting.GRAY + "Temperature: " + TextFormatting.WHITE + ((TEGasifierCooler)((Object)tank)).getTemperature() + "/" + ((TEGasifierCooler)((Object)tank)).getTemperatureMax() + "K");
            }
            if (te instanceof TEGasifierBurner) {
                tank = (TEGasifierBurner)te;
                if (((TEGasifierBurner)tank).hasReactant()) {
                    currenttip.add(TextFormatting.GRAY + "Content: " + TextFormatting.WHITE + ((TEGasifierBurner)tank).getReactant().getLocalizedName() + " - " + ((TEGasifierBurner)tank).getReactantAmount() + "/" + ((TEGasifierBurner)tank).getTankCapacity() + " mB");
                } else {
                    currenttip.add(TextFormatting.GRAY + "Content: " + TextFormatting.WHITE + "Empty");
                }
            }
            if (te instanceof TEPressureVessel) {
                tank = (TEPressureVessel)te;
                if (((TileVessel)tank).inputTankHasGas()) {
                    String content = GuiUtils.composeGasContent((FluidTank)((TEPressureVessel)tank).inputTank);
                    currenttip.add(TextFormatting.GRAY + "Content: " + TextFormatting.WHITE + content);
                } else {
                    currenttip.add(TextFormatting.GRAY + "Storage: " + TextFormatting.WHITE + "Empty");
                }
            }
            if (te instanceof TEAirCompressor) {
                TEAirCompressor engine = (TEAirCompressor)te;
                currenttip.add(TextFormatting.GRAY + "Fuel Storage: " + TextFormatting.GOLD + engine.getPower() + "/" + engine.getPowerMax() + " ticks");
            }
        }
        return currenttip;
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        return tag;
    }

    public static void callbackRegister(IWailaRegistrar registrar) {
        registrar.registerBodyProvider((IWailaDataProvider)new WailaMachinesB(), MachinesB.class);
    }
}

