/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.compat.top;

import com.globbypotato.rockhounding_chemistry.enums.utils.EnumCasting;
import com.globbypotato.rockhounding_chemistry.enums.utils.EnumSaltStages;
import com.globbypotato.rockhounding_chemistry.handlers.ModConfig;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEAirCompressor;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEBufferTank;
import com.globbypotato.rockhounding_chemistry.machines.tile.TECatalystRegen;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEContainmentTank;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEEvaporationTank;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEExhaustionValve;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEFlotationTank;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEFluidInputTank;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEFluidOutputTank;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEFluidTank;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEGasHolderBase;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEGasHolderTop;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEGasifierBurner;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEGasifierCooler;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEGasifierTank;
import com.globbypotato.rockhounding_chemistry.machines.tile.TELeachingVatTank;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEMineralSizerController;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEMultivessel;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEOrbiter;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEPowerGenerator;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEPressureVessel;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEProfilingBench;
import com.globbypotato.rockhounding_chemistry.machines.tile.TESlurryDrum;
import com.globbypotato.rockhounding_chemistry.machines.tile.TESlurryPond;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEStirredTankOut;
import com.globbypotato.rockhounding_chemistry.machines.tile.TETransposer;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEWaterPump;
import com.globbypotato.rockhounding_chemistry.machines.tile.TileVessel;
import com.globbypotato.rockhounding_core.machines.gui.GuiUtils;
import com.google.common.base.Function;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeConfigProvider;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.NumberFormat;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidTank;

public class TopMachines
implements IProbeInfoProvider {
    public String getID() {
        return "rockhounding_chemistry:machines";
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntity te = world.func_175625_s(data.getPos());
        if (te != null) {
            TEGasHolderBase tank;
            TileEntity base;
            String suffix;
            Object tank2;
            Object tile;
            if (te instanceof TEPowerGenerator) {
                tile = (TEPowerGenerator)te;
                if (tile.hasPower()) {
                    probeInfo.progress(tile.getPower(), tile.getPowerMax(), probeInfo.defaultProgressStyle().suffix(" ticks").filledColor(-19456).alternateFilledColor(-36352).borderColor(0).numberFormat(NumberFormat.FULL));
                }
                if (tile.hasRedstone() && !tile.hasFuelBlend()) {
                    probeInfo.progress(tile.getRedstone(), tile.getRedstoneMax(), probeInfo.defaultProgressStyle().suffix(" RF").filledColor(-65536).alternateFilledColor(-10878205).borderColor(0).numberFormat(NumberFormat.FULL));
                }
            }
            if (te instanceof TEAirCompressor) {
                tile = (TEAirCompressor)te;
                probeInfo.progress(tile.getPower(), tile.getPowerMax(), probeInfo.defaultProgressStyle().suffix(" ticks").filledColor(-19456).alternateFilledColor(-36352).borderColor(0).numberFormat(NumberFormat.FULL));
            }
            if (te instanceof TEMineralSizerController) {
                tile = (TEMineralSizerController)te;
                String comm = TextFormatting.GRAY + "Comminution Level: " + TextFormatting.GREEN + tile.getComminution();
                String[] multistring = new String[]{comm};
                for (int x = 0; x < multistring.length; ++x) {
                    probeInfo.text(multistring[x]);
                }
            }
            if (te instanceof TEFluidTank && (tank2 = (TEFluidTank)te).hasTankFluid()) {
                probeInfo.progress(tank2.getTankAmount(), tank2.getTankCapacity(), probeInfo.defaultProgressStyle().suffix(" mB").filledColor(-1).alternateFilledColor(-2894893).borderColor(0).numberFormat(NumberFormat.FULL));
            }
            if (te instanceof TEFluidInputTank) {
                tank2 = (TEFluidInputTank)te;
                if (((TEFluidInputTank)tank2).hasSolventFluid()) {
                    probeInfo.progress(((TEFluidInputTank)tank2).getSolventAmount(), ((TEFluidInputTank)tank2).getTankCapacity(), probeInfo.defaultProgressStyle().suffix(" mB - Solvent").filledColor(-1).alternateFilledColor(-7275521).borderColor(0).numberFormat(NumberFormat.FULL));
                }
                if (((TEFluidInputTank)tank2).hasReagentFluid()) {
                    probeInfo.progress(((TEFluidInputTank)tank2).getReagentAmount(), ((TEFluidInputTank)tank2).getTankCapacity(), probeInfo.defaultProgressStyle().suffix(" mB - Reagent").filledColor(-1).alternateFilledColor(-7274561).borderColor(0).numberFormat(NumberFormat.FULL));
                }
            }
            if (te instanceof TEFluidOutputTank) {
                tank2 = (TEFluidOutputTank)te;
                if (((TEFluidOutputTank)tank2).hasSolutionFluid()) {
                    probeInfo.progress(((TEFluidOutputTank)tank2).getSolutionAmount(), ((TEFluidOutputTank)tank2).getTankCapacity(), probeInfo.defaultProgressStyle().suffix(" mB - Solution").filledColor(-1).alternateFilledColor(-1441904).borderColor(0).numberFormat(NumberFormat.FULL));
                }
                if (((TEFluidOutputTank)tank2).hasByproductFluid()) {
                    probeInfo.progress(((TEFluidOutputTank)tank2).getByproductAmount(), ((TEFluidOutputTank)tank2).getTankCapacity(), probeInfo.defaultProgressStyle().suffix(" mB - Byproduct").filledColor(-1).alternateFilledColor(-8560).borderColor(0).numberFormat(NumberFormat.FULL));
                }
            }
            if (te instanceof TEProfilingBench) {
                TEProfilingBench bench = (TEProfilingBench)te;
                String pattern = TextFormatting.GRAY + "Pattern: " + TextFormatting.AQUA + EnumCasting.getFormalName(bench.getCasting());
                probeInfo.text(pattern);
            }
            if (te instanceof TESlurryPond) {
                tank2 = (TESlurryPond)te;
                if (((TESlurryPond)tank2).hasInputFluid()) {
                    probeInfo.progress(((TESlurryPond)tank2).getInputAmount(), ((TESlurryPond)tank2).getTankCapacity(), probeInfo.defaultProgressStyle().suffix(" mB").filledColor(-8073985).alternateFilledColor(-16738561).borderColor(0).numberFormat(NumberFormat.FULL));
                }
                if (((TESlurryPond)tank2).hasOutputFluid()) {
                    probeInfo.progress(((TESlurryPond)tank2).getOutputAmount(), ((TESlurryPond)tank2).getTankCapacity(), probeInfo.defaultProgressStyle().suffix(" mB").filledColor(-4013374).alternateFilledColor(-10131607).borderColor(0).numberFormat(NumberFormat.FULL));
                }
            }
            if (te instanceof TEEvaporationTank) {
                tank2 = (TEEvaporationTank)te;
                probeInfo.text("Stage " + (((TEEvaporationTank)((Object)tank2)).getStage() + 1) + ": " + EnumSaltStages.getStageName(((TEEvaporationTank)((Object)tank2)).getStage()));
                if (((TEEvaporationTank)((Object)tank2)).getStage() == EnumSaltStages.STAGE_A.ordinal() && ((TEEvaporationTank)((Object)tank2)).hasTankFluid()) {
                    probeInfo.progress(((TEEvaporationTank)((Object)tank2)).getTankAmount(), ((TEEvaporationTank)((Object)tank2)).getTankCapacity(), probeInfo.defaultProgressStyle().suffix(" mB").filledColor(-8073985).alternateFilledColor(-16738561).borderColor(0).numberFormat(NumberFormat.FULL));
                }
                String purge = TextFormatting.GRAY + "Purging: " + TextFormatting.RED + "Disabled";
                if (((TEEvaporationTank)((Object)tank2)).getPurge() < ((TEEvaporationTank)((Object)tank2)).finalStage()) {
                    purge = TextFormatting.GRAY + "Purging: " + TextFormatting.AQUA + EnumSaltStages.getStageName(((TEEvaporationTank)((Object)tank2)).getPurge());
                    probeInfo.text(purge);
                } else {
                    probeInfo.text(purge);
                }
            }
            if (te instanceof TEGasifierTank && ((TEGasifierTank)(tank2 = (TEGasifierTank)te)).hasInputFluid()) {
                probeInfo.progress(((TEGasifierTank)tank2).getInputAmount(), ((TEGasifierTank)tank2).getTankCapacity(), probeInfo.defaultProgressStyle().suffix(" mB").filledColor(-8073985).alternateFilledColor(-16738561).borderColor(0).numberFormat(NumberFormat.FULL));
            }
            if (te instanceof TEGasifierCooler) {
                tank2 = (TEGasifierCooler)te;
                probeInfo.progress(((TEGasifierCooler)((Object)tank2)).getTemperature(), ((TEGasifierCooler)((Object)tank2)).getTemperatureMax(), probeInfo.defaultProgressStyle().suffix("k").filledColor(-36352).alternateFilledColor(-65536).borderColor(0).numberFormat(NumberFormat.FULL));
            }
            if (te instanceof TEGasifierBurner && ((TEGasifierBurner)(tank2 = (TEGasifierBurner)te)).hasReactant()) {
                probeInfo.progress(((TEGasifierBurner)tank2).getReactantAmount(), ((TEGasifierBurner)tank2).getTankCapacity(), probeInfo.defaultProgressStyle().suffix(" mB").filledColor(-8073985).alternateFilledColor(-16738561).borderColor(0).numberFormat(NumberFormat.FULL));
            }
            if (te instanceof TEPressureVessel && ((TileVessel)(tank2 = (TEPressureVessel)te)).inputTankHasGas()) {
                int gasColor = ((TEPressureVessel)tank2).inputTank.getFluid().getFluid().getColor();
                suffix = GuiUtils.composeGasContent((FluidTank)((TEPressureVessel)tank2).inputTank);
                probeInfo.progress(((TEPressureVessel)tank2).inputTank.getFluidAmount(), ((TEPressureVessel)tank2).inputTank.getCapacity(), probeInfo.defaultProgressStyle().suffix(suffix).filledColor(gasColor).alternateFilledColor(gasColor).borderColor(0).numberFormat(NumberFormat.NONE));
            }
            if (te instanceof TELeachingVatTank && ((TELeachingVatTank)(tank2 = (TELeachingVatTank)te)).hasTankFluid()) {
                probeInfo.progress(((TELeachingVatTank)tank2).getTankAmount(), ((TELeachingVatTank)tank2).getTankCapacity(), probeInfo.defaultProgressStyle().suffix(" mB").filledColor(-1).alternateFilledColor(-2894893).borderColor(0).numberFormat(NumberFormat.FULL));
            }
            if (te instanceof TEGasHolderBase && ((TileVessel)(tank2 = (TEGasHolderBase)te)).inputTankHasGas()) {
                int gasColor = ((TEGasHolderBase)tank2).inputTank.getFluid().getFluid().getColor();
                suffix = GuiUtils.composeGasContent((FluidTank)((TEGasHolderBase)tank2).inputTank);
                probeInfo.progress(((TEGasHolderBase)tank2).inputTank.getFluidAmount(), ((TEGasHolderBase)tank2).inputTank.getCapacity(), probeInfo.defaultProgressStyle().suffix(suffix).filledColor(gasColor).alternateFilledColor(gasColor).borderColor(0).numberFormat(NumberFormat.NONE));
            }
            if (te instanceof TEGasHolderTop && (base = world.func_175625_s(data.getPos().func_177972_a(EnumFacing.DOWN))) instanceof TEGasHolderBase && (tank = (TEGasHolderBase)base).inputTankHasGas()) {
                int gasColor = tank.inputTank.getFluid().getFluid().getColor();
                String suffix2 = GuiUtils.composeGasContent((FluidTank)tank.inputTank);
                probeInfo.progress(tank.inputTank.getFluidAmount(), tank.inputTank.getCapacity(), probeInfo.defaultProgressStyle().suffix(suffix2).filledColor(gasColor).alternateFilledColor(gasColor).borderColor(0).numberFormat(NumberFormat.NONE));
            }
            if (te instanceof TEOrbiter) {
                tank2 = (TEOrbiter)te;
                if (((TEOrbiter)((Object)tank2)).wasteHasFluid()) {
                    probeInfo.progress(((TEOrbiter)((Object)tank2)).getWasteAmount(), ((TEOrbiter)((Object)tank2)).getWasteCapacity(), probeInfo.defaultProgressStyle().suffix(" mB").filledColor(-6246285).alternateFilledColor(-9208234).borderColor(0).numberFormat(NumberFormat.FULL));
                }
                if (((TEOrbiter)((Object)tank2)).xpJuiceExists()) {
                    if (((TEOrbiter)((Object)tank2)).juiceHasFluid()) {
                        probeInfo.progress(((TEOrbiter)((Object)tank2)).getJuiceAmount(), ((TEOrbiter)((Object)tank2)).getJuiceCapacity(), probeInfo.defaultProgressStyle().suffix(" mB").filledColor(-12345856).alternateFilledColor(-10627325).borderColor(0).numberFormat(NumberFormat.FULL));
                    }
                } else if (((TEOrbiter)((Object)tank2)).getXPCount() > 0) {
                    probeInfo.progress(((TEOrbiter)((Object)tank2)).getXPCount(), ((TEOrbiter)((Object)tank2)).getXPCountMax(), probeInfo.defaultProgressStyle().suffix(" xp").filledColor(-12345856).alternateFilledColor(-10627325).borderColor(0).numberFormat(NumberFormat.FULL));
                }
            }
            if (te instanceof TETransposer) {
                tank2 = (TETransposer)te;
                if (((TETransposer)tank2).hasInputTankMain()) {
                    if (((TETransposer)tank2).getInputTankMain().getFluid().isGaseous()) {
                        int gasColor = ((TETransposer)tank2).inputTankMain.getFluid().getFluid().getColor();
                        String suffix3 = GuiUtils.composeGasContent((FluidTank)((TETransposer)tank2).inputTankMain);
                        probeInfo.progress(((TETransposer)tank2).inputTankMain.getFluidAmount(), ((TETransposer)tank2).inputTankMain.getCapacity(), probeInfo.defaultProgressStyle().suffix(suffix3).filledColor(gasColor).alternateFilledColor(gasColor).borderColor(0).numberFormat(NumberFormat.NONE));
                    } else {
                        probeInfo.progress(((TETransposer)tank2).getInputTankMainAmount(), ((TETransposer)tank2).getFluidCapacity(), probeInfo.defaultProgressStyle().suffix(" mB").filledColor(-1).alternateFilledColor(-2894893).borderColor(0).numberFormat(NumberFormat.FULL));
                    }
                }
                if (((TETransposer)tank2).hasOutputTankFluid()) {
                    probeInfo.progress(((TETransposer)tank2).getOutputTankFluidAmount(), ((TETransposer)tank2).getFluidCapacity(), probeInfo.defaultProgressStyle().suffix(" mB").filledColor(-1).alternateFilledColor(-2894893).borderColor(0).numberFormat(NumberFormat.FULL));
                }
                if (((TETransposer)tank2).hasOutputTankGas()) {
                    int gasColor = ((TETransposer)tank2).outputTankGas.getFluid().getFluid().getColor();
                    String suffix4 = GuiUtils.composeGasContent((FluidTank)((TETransposer)tank2).outputTankGas);
                    probeInfo.progress(((TETransposer)tank2).outputTankGas.getFluidAmount(), ((TETransposer)tank2).outputTankGas.getCapacity(), probeInfo.defaultProgressStyle().suffix(suffix4).filledColor(gasColor).alternateFilledColor(gasColor).borderColor(0).numberFormat(NumberFormat.NONE));
                }
            }
            if (te instanceof TEFlotationTank && ((TEFlotationTank)(tank2 = (TEFlotationTank)te)).hasSolventFluid()) {
                probeInfo.progress(((TEFlotationTank)tank2).getSolventAmount(), ((TEFlotationTank)tank2).getTankCapacity(), probeInfo.defaultProgressStyle().suffix(" mB - Solvent").filledColor(-1).alternateFilledColor(-7275521).borderColor(0).numberFormat(NumberFormat.FULL));
            }
            if (te instanceof TEContainmentTank && (tank2 = (TEContainmentTank)te).hasTankFluid()) {
                probeInfo.progress(tank2.getTankAmount(), tank2.getTankCapacity(), probeInfo.defaultProgressStyle().suffix(" mB").filledColor(-1).alternateFilledColor(-2894893).borderColor(0).numberFormat(NumberFormat.FULL));
            }
            if (te instanceof TEWaterPump) {
                tank2 = (TEWaterPump)te;
                if (((TEWaterPump)((Object)tank2)).hasTankFluid()) {
                    probeInfo.progress(((TEWaterPump)((Object)tank2)).getTankAmount(), ((TEWaterPump)((Object)tank2)).getTankCapacity(), probeInfo.defaultProgressStyle().suffix(" mB").filledColor(-1).alternateFilledColor(-2894893).borderColor(0).numberFormat(NumberFormat.FULL));
                }
                String status = TextFormatting.GRAY + "Compression: " + TextFormatting.AQUA + ((TEWaterPump)((Object)tank2)).getCompressor();
                probeInfo.text(status);
                String tier = TextFormatting.GRAY + "Tier: " + TextFormatting.DARK_AQUA + (((TEWaterPump)((Object)tank2)).getTier() + 1) + TextFormatting.GRAY + " (" + ((TEWaterPump)((Object)tank2)).tierFactor() + " mB)";
                probeInfo.text(tier);
            }
            if (te instanceof TEExhaustionValve) {
                TileEntity holder;
                TileEntity vessel = world.func_175625_s(data.getPos().func_177972_a(EnumFacing.DOWN));
                if (vessel instanceof TEPressureVessel) {
                    TEPressureVessel ves = (TEPressureVessel)vessel;
                    probeInfo.progress(ves.getCollapse(), ModConfig.pressureTolerance, probeInfo.defaultProgressStyle().prefix("Tolerance: ").suffix("/" + ModConfig.pressureTolerance + " units").filledColor(-1238759).alternateFilledColor(0).borderColor(0).numberFormat(NumberFormat.FULL));
                }
                if (vessel instanceof TEMultivessel) {
                    TEMultivessel ves = (TEMultivessel)vessel;
                    probeInfo.progress(ves.getCollapse(), ModConfig.pressureTolerance, probeInfo.defaultProgressStyle().prefix("Tolerance: ").suffix("/" + ModConfig.pressureTolerance + " units").filledColor(-1238759).alternateFilledColor(0).borderColor(0).numberFormat(NumberFormat.FULL));
                }
                if (vessel instanceof TETransposer) {
                    TETransposer ves = (TETransposer)vessel;
                    probeInfo.progress(ves.getCollapse(), ModConfig.pressureTolerance, probeInfo.defaultProgressStyle().prefix("Tolerance: ").suffix("/" + ModConfig.pressureTolerance + " units").filledColor(-1238759).alternateFilledColor(0).borderColor(0).numberFormat(NumberFormat.FULL));
                }
                if (vessel instanceof TEGasHolderTop && (holder = world.func_175625_s(data.getPos().func_177967_a(EnumFacing.DOWN, 2))) instanceof TEGasHolderBase) {
                    TEGasHolderBase ves = (TEGasHolderBase)holder;
                    probeInfo.progress(ves.getCollapse(), ModConfig.pressureTolerance, probeInfo.defaultProgressStyle().prefix("Tolerance: ").suffix("/" + ModConfig.pressureTolerance + " units").filledColor(-1238759).alternateFilledColor(0).borderColor(0).numberFormat(NumberFormat.FULL));
                }
            }
            if (te instanceof TECatalystRegen && ((TECatalystRegen)((Object)(tank2 = (TECatalystRegen)te))).hasInputFluid()) {
                probeInfo.progress(((TECatalystRegen)((Object)tank2)).getInputAmount(), ((TECatalystRegen)((Object)tank2)).getTankCapacity(), probeInfo.defaultProgressStyle().suffix(" mB").filledColor(-1).alternateFilledColor(-2894893).borderColor(0).numberFormat(NumberFormat.FULL));
            }
            if (te instanceof TESlurryDrum && (tank2 = (TESlurryDrum)te).hasTankFluid()) {
                probeInfo.progress(tank2.getTankAmount(), ((TESlurryDrum)((Object)tank2)).getTankCapacity(), probeInfo.defaultProgressStyle().suffix(" mB").filledColor(-1).alternateFilledColor(-2894893).borderColor(0).numberFormat(NumberFormat.FULL));
            }
            if (te instanceof TEBufferTank && ((TEBufferTank)(tank2 = (TEBufferTank)te)).hasTankFluid()) {
                probeInfo.progress(((TEBufferTank)tank2).getTankAmount(), ((TEBufferTank)tank2).getTankCapacity(), probeInfo.defaultProgressStyle().suffix(" mB").filledColor(-1).alternateFilledColor(-2894893).borderColor(0).numberFormat(NumberFormat.FULL));
            }
            if (te instanceof TEStirredTankOut && ((TEStirredTankOut)(tank2 = (TEStirredTankOut)te)).hasTankFluid()) {
                probeInfo.progress(((TEStirredTankOut)tank2).getTankAmount(), ((TEStirredTankOut)tank2).getTankCapacity(), probeInfo.defaultProgressStyle().suffix(" mB").filledColor(-1).alternateFilledColor(-2894893).borderColor(0).numberFormat(NumberFormat.FULL));
            }
        }
    }

    public static class getTOP
    implements Function<ITheOneProbe, Void> {
        public static ITheOneProbe top;

        @Nullable
        public Void apply(ITheOneProbe theOneProbe) {
            top = theOneProbe;
            top.registerProvider((IProbeInfoProvider)new TopMachines());
            top.registerProbeConfigProvider((IProbeConfigProvider)new EnergyInfo());
            return null;
        }
    }

    public static class EnergyInfo
    implements IProbeConfigProvider {
        public void getProbeConfig(IProbeConfig config, EntityPlayer player, World world, Entity entity, IProbeHitEntityData data) {
        }

        public void getProbeConfig(IProbeConfig config, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
            TileEntity te = world.func_175625_s(data.getPos());
            if (te != null && (te instanceof TEPowerGenerator || te instanceof TEAirCompressor)) {
                config.setRFMode(0);
            }
        }
    }
}

