/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.compat.jei.stirred_tank;

import com.globbypotato.rockhounding_chemistry.compat.jei.RHRecipeWrapper;
import com.globbypotato.rockhounding_chemistry.machines.recipe.StirredTankRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.StirredTankRecipe;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fluids.FluidStack;

public class StirredTankWrapper
extends RHRecipeWrapper<StirredTankRecipe> {
    public StirredTankWrapper(@Nonnull StirredTankRecipe recipe) {
        super(recipe);
    }

    public static List<StirredTankWrapper> getRecipes() {
        ArrayList<StirredTankWrapper> recipes = new ArrayList<StirredTankWrapper>();
        for (StirredTankRecipe recipe : StirredTankRecipes.stirred_tank_recipes) {
            if (recipe.getReagent() == null || recipe.getSolvent() == null || recipe.getSolution() == null) continue;
            recipes.add(new StirredTankWrapper(recipe));
        }
        return recipes;
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        String voltString = "N/A";
        if (((StirredTankRecipe)this.getRecipe()).getVoltage() > 0) {
            voltString = String.valueOf(((StirredTankRecipe)this.getRecipe()).getVoltage() * 10) + " RF";
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179139_a((double)0.85, (double)0.85, (double)1.0);
        minecraft.field_71466_p.func_78276_b(voltString, 3, 5, Color.RED.getRGB());
        GlStateManager.func_179139_a((double)0.6, (double)0.6, (double)1.0);
        minecraft.field_71466_p.func_78276_b("Primary", 24, 146, Color.BLUE.getRGB());
        minecraft.field_71466_p.func_78276_b("Secondary", 210, 146, Color.BLUE.getRGB());
        GlStateManager.func_179121_F();
    }

    @Nonnull
    public List<FluidStack> getSolvents() {
        return Collections.singletonList(((StirredTankRecipe)this.getRecipe()).getSolvent());
    }

    @Nonnull
    public List<FluidStack> getReagents() {
        return Collections.singletonList(((StirredTankRecipe)this.getRecipe()).getReagent());
    }

    @Nonnull
    public List<FluidStack> getSolutions() {
        return Collections.singletonList(((StirredTankRecipe)this.getRecipe()).getSolution());
    }

    @Nullable
    public List<FluidStack> getFumes() {
        return Collections.singletonList(((StirredTankRecipe)this.getRecipe()).getFume());
    }

    public List<Integer> getVoltages() {
        return Collections.singletonList(((StirredTankRecipe)this.getRecipe()).getVoltage());
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.FLUID, Arrays.asList(this.getSolvents(), this.getReagents()));
        ingredients.setOutputLists(VanillaTypes.FLUID, Arrays.asList(this.getSolutions(), this.getFumes()));
    }
}

