/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.compat.jei.retention_vat;

import com.globbypotato.rockhounding_chemistry.compat.jei.RHRecipeWrapper;
import com.globbypotato.rockhounding_chemistry.enums.materials.EnumFluid;
import com.globbypotato.rockhounding_chemistry.machines.recipe.RetentionVatRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.RetentionVatRecipe;
import com.globbypotato.rockhounding_chemistry.utils.BaseRecipes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class RetentionVatWrapper
extends RHRecipeWrapper<RetentionVatRecipe> {
    public RetentionVatWrapper(@Nonnull RetentionVatRecipe recipe) {
        super(recipe);
    }

    public static List<RetentionVatWrapper> getRecipes() {
        ArrayList<RetentionVatWrapper> recipes = new ArrayList<RetentionVatWrapper>();
        for (RetentionVatRecipe recipe : RetentionVatRecipes.retention_vat_recipes) {
            if (recipe.getInput() == null && recipe.getOutput().size() <= 0) continue;
            recipes.add(new RetentionVatWrapper(recipe));
        }
        return recipes;
    }

    @Nonnull
    public List<FluidStack> getInputs() {
        return Collections.singletonList(((RetentionVatRecipe)this.getRecipe()).getInput());
    }

    @Nonnull
    public List<ItemStack> getOutputs() {
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        outputs.addAll(((RetentionVatRecipe)this.getRecipe()).getOutput());
        return outputs;
    }

    @Nonnull
    public List<FluidStack> getSolvents() {
        ArrayList<FluidStack> outputs = new ArrayList<FluidStack>();
        outputs.add(BaseRecipes.getFluid(EnumFluid.HYDROFLUORIC_ACID, 1000));
        outputs.add(BaseRecipes.getFluid(EnumFluid.WATER_VAPOUR, 1000));
        outputs.add(new FluidStack(FluidRegistry.WATER, 1000));
        return outputs;
    }

    @Nonnull
    public List<FluidStack> getSolutions() {
        ArrayList<FluidStack> outputs = new ArrayList<FluidStack>();
        outputs.add(BaseRecipes.getFluid(EnumFluid.TOXIC_WASTE, 1000));
        return outputs;
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.FLUID, Arrays.asList(this.getInputs(), this.getSolvents()));
        ingredients.setOutputs(VanillaTypes.ITEM, this.getOutputs());
        ingredients.setOutputs(VanillaTypes.FLUID, this.getSolutions());
    }
}

