/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.compat.jei.lab_oven;

import com.globbypotato.rockhounding_chemistry.compat.jei.RHRecipeWrapper;
import com.globbypotato.rockhounding_chemistry.machines.recipe.LabOvenRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.LabOvenRecipe;
import com.google.common.base.Strings;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class LabOvenWrapper
extends RHRecipeWrapper<LabOvenRecipe> {
    public LabOvenWrapper(@Nonnull LabOvenRecipe recipe) {
        super(recipe);
    }

    public static List<LabOvenWrapper> getRecipes() {
        ArrayList<LabOvenWrapper> recipes = new ArrayList<LabOvenWrapper>();
        for (LabOvenRecipe recipe : LabOvenRecipes.lab_oven_recipes) {
            if (!LabOvenWrapper.isValidRecipe(recipe)) continue;
            recipes.add(new LabOvenWrapper(recipe));
        }
        return recipes;
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        String altString = "N/A";
        altString = !Strings.isNullOrEmpty((String)((LabOvenRecipe)this.getRecipe()).getRecipeName()) ? ((LabOvenRecipe)this.getRecipe()).getRecipeName() : ((LabOvenRecipe)this.getRecipe()).getSolution().getLocalizedName();
        GlStateManager.func_179094_E();
        GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)1.0);
        minecraft.field_71466_p.func_78276_b(altString, 0, 0, Color.RED.getRGB());
        minecraft.field_71466_p.func_78276_b("Primary", 22, 57, Color.BLUE.getRGB());
        minecraft.field_71466_p.func_78276_b("Secondary", 22, 113, Color.BLUE.getRGB());
        minecraft.field_71466_p.func_78276_b("Produce", 178, 57, Color.BLUE.getRGB());
        minecraft.field_71466_p.func_78276_b("Waste", 191, 113, Color.BLUE.getRGB());
        GlStateManager.func_179121_F();
    }

    private static boolean isValidRecipe(LabOvenRecipe recipe) {
        return (!recipe.getType() && !recipe.getSolute().func_190926_b() || recipe.getType() && OreDictionary.getOres((String)recipe.getOredict()).size() > 0) && recipe.getSolvent() != null;
    }

    public List<ItemStack> getSolutes() {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        if (((LabOvenRecipe)this.getRecipe()).getType()) {
            inputs.addAll((Collection<ItemStack>)OreDictionary.getOres((String)((LabOvenRecipe)this.getRecipe()).getOredict()));
        } else {
            inputs.add(((LabOvenRecipe)this.getRecipe()).getSolute());
        }
        return inputs;
    }

    public List<ItemStack> getCatalysts() {
        return Collections.singletonList(((LabOvenRecipe)this.getRecipe()).getCatalyst());
    }

    @Nonnull
    public List<FluidStack> getSolvents() {
        return Collections.singletonList(((LabOvenRecipe)this.getRecipe()).getSolvent());
    }

    public List<FluidStack> getReagents() {
        return Collections.singletonList(((LabOvenRecipe)this.getRecipe()).getReagent());
    }

    @Nonnull
    public List<FluidStack> getSolutions() {
        return Collections.singletonList(((LabOvenRecipe)this.getRecipe()).getSolution());
    }

    public List<FluidStack> getByproducts() {
        return Collections.singletonList(((LabOvenRecipe)this.getRecipe()).getByproduct());
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, Arrays.asList(this.getSolutes(), this.getCatalysts()));
        ingredients.setInputLists(VanillaTypes.FLUID, Arrays.asList(this.getSolvents(), this.getReagents()));
        ingredients.setOutputLists(VanillaTypes.FLUID, Arrays.asList(this.getSolutions(), this.getByproducts()));
    }
}

