/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.compat.crafttweaker;

import com.globbypotato.rockhounding_chemistry.compat.crafttweaker.CTSupport;
import com.globbypotato.rockhounding_chemistry.machines.recipe.SlurryPondRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.SlurryPondRecipe;
import com.google.common.base.Strings;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.rockhounding_chemistry.SlurryPond")
public class CT_SlurryPond
extends CTSupport {
    public static String name = "Slurry Pond";
    public static ArrayList<SlurryPondRecipe> recipeList = SlurryPondRecipes.slurry_pond_recipes;

    @ZenMethod
    public static void add(IItemStack input, ILiquidStack bath, ILiquidStack output) {
        if (input == null || bath == null || output == null) {
            CT_SlurryPond.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new Add(new SlurryPondRecipe(CT_SlurryPond.toStack(input), CT_SlurryPond.toFluid(bath), CT_SlurryPond.toFluid(output))));
    }

    @ZenMethod
    public static void add(String oredict, ILiquidStack bath, ILiquidStack output) {
        if (bath == null || output == null) {
            CT_SlurryPond.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new Add(new SlurryPondRecipe(oredict, CT_SlurryPond.toFluid(bath), CT_SlurryPond.toFluid(output))));
    }

    @ZenMethod
    public static void removeByInput(IItemStack input) {
        if (input == null) {
            CT_SlurryPond.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new RemoveByInput(CT_SlurryPond.toStack(input)));
    }

    @ZenMethod
    public static void removeByOredict(String input) {
        if (input == null) {
            CT_SlurryPond.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new RemoveByOredict(input));
    }

    @ZenMethod
    public static void removeByOutput(ILiquidStack output) {
        if (output == null) {
            CT_SlurryPond.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new RemoveByOutput(CT_SlurryPond.toFluid(output)));
    }

    private static class RemoveByOutput
    implements IAction {
        private FluidStack output;

        public RemoveByOutput(FluidStack output) {
            this.output = output;
        }

        public void apply() {
            for (SlurryPondRecipe recipe : recipeList) {
                if (this.output == null || !recipe.getOutput().isFluidEqual(this.output)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class RemoveByOredict
    implements IAction {
        private String input;

        public RemoveByOredict(String input) {
            this.input = input;
        }

        public void apply() {
            for (SlurryPondRecipe recipe : recipeList) {
                if (Strings.isNullOrEmpty((String)this.input) || !recipe.getType() || !recipe.getOredict().matches(this.input)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class RemoveByInput
    implements IAction {
        private ItemStack input;

        public RemoveByInput(ItemStack input) {
            this.input = input;
        }

        public void apply() {
            for (SlurryPondRecipe recipe : recipeList) {
                if (this.input.func_190926_b() || recipe.getType() || !recipe.getInput().func_77969_a(this.input)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class Add
    implements IAction {
        private final SlurryPondRecipe recipe;

        public Add(SlurryPondRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            recipeList.add(this.recipe);
        }

        public String describe() {
            return CTSupport.addCaption(name);
        }
    }
}

