/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.compat.crafttweaker;

import com.globbypotato.rockhounding_chemistry.compat.crafttweaker.CTSupport;
import com.globbypotato.rockhounding_chemistry.machines.recipe.PollutantRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.PollutantGasRecipe;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.ArrayList;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.rockhounding_chemistry.PollutantGases")
public class CT_PollutantGases
extends CTSupport {
    public static String name = "Pollutant Gases";
    public static ArrayList<FluidStack> pollutantList = PollutantRecipes.pollutant_gases;
    public static ArrayList<PollutantGasRecipe> recipeList = PollutantRecipes.pollutant_gas_recipes;

    @ZenMethod
    public static void pollute(ILiquidStack fluid) {
        if (fluid == null || !CT_PollutantGases.toFluid(fluid).getFluid().isGaseous()) {
            CT_PollutantGases.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new DeclarePollutant(CT_PollutantGases.toFluid(fluid)));
    }

    private static class DeclarePollutant
    implements IAction {
        FluidStack input;

        public DeclarePollutant(FluidStack input) {
            this.input = input;
        }

        public void apply() {
            if (!pollutantList.contains(this.input)) {
                pollutantList.add(this.input);
                recipeList.add(new PollutantGasRecipe(this.input));
            }
        }

        public String describe() {
            return CTSupport.addCaption(name);
        }
    }
}

