/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.compat.crafttweaker;

import com.globbypotato.rockhounding_chemistry.compat.crafttweaker.CTSupport;
import com.globbypotato.rockhounding_chemistry.machines.recipe.MetalAlloyerRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.MetalAlloyerRecipe;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IItemStack;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.rockhounding_chemistry.MetalAlloyer")
public class CT_MetalAlloyer
extends CTSupport {
    public static String name = "Metal Alloyer";
    public static ArrayList<MetalAlloyerRecipe> recipeList = MetalAlloyerRecipes.metal_alloyer_recipes;

    @ZenMethod
    public static void add(String[] input, int[] quantity, IItemStack output) {
        if (input == null || output == null || input.length != quantity.length) {
            CT_MetalAlloyer.error(name);
            return;
        }
        ArrayList<String> inputs = new ArrayList<String>();
        for (int x = 0; x < input.length; ++x) {
            inputs.add(input[x]);
        }
        ArrayList<Integer> quantities = new ArrayList<Integer>();
        for (int x = 0; x < quantity.length; ++x) {
            quantities.add(quantity[x]);
        }
        CraftTweakerAPI.apply((IAction)new Add(new MetalAlloyerRecipe(inputs, quantities, CT_MetalAlloyer.toStack(output))));
    }

    @ZenMethod
    public static void remove(IItemStack input) {
        if (input == null) {
            CT_MetalAlloyer.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new Remove(CT_MetalAlloyer.toStack(input)));
    }

    private static class Remove
    implements IAction {
        private ItemStack input;

        public Remove(ItemStack input) {
            this.input = input;
        }

        public void apply() {
            for (MetalAlloyerRecipe recipe : recipeList) {
                if (this.input.func_190926_b() || !recipe.getOutput().func_77969_a(this.input)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class Add
    implements IAction {
        private final MetalAlloyerRecipe recipe;

        public Add(MetalAlloyerRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            recipeList.add(this.recipe);
        }

        public String describe() {
            return CTSupport.addCaption(name);
        }
    }
}

