/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.compat.crafttweaker;

import com.globbypotato.rockhounding_chemistry.compat.crafttweaker.CTSupport;
import com.globbypotato.rockhounding_chemistry.machines.recipe.LeachingVatRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.LeachingVatRecipe;
import com.google.common.base.Strings;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.rockhounding_chemistry.LeachingVat")
public class CT_LeachingVat
extends CTSupport {
    public static String name = "Leaching Vat";
    public static ArrayList<LeachingVatRecipe> recipeList = LeachingVatRecipes.leaching_vat_recipes;

    @ZenMethod
    public static void add(IItemStack input, IItemStack[] output, float[] gravity, ILiquidStack pulp) {
        if (input == null || output == null) {
            CT_LeachingVat.error(name);
            return;
        }
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        ArrayList<Float> gravities = new ArrayList<Float>();
        for (int x = 0; x < output.length; ++x) {
            outputs.add(CT_LeachingVat.toStack(output[x]));
            gravities.add(Float.valueOf(gravity[x]));
        }
        CraftTweakerAPI.apply((IAction)new Add(new LeachingVatRecipe(CT_LeachingVat.toStack(input), outputs, gravities, CT_LeachingVat.toFluid(pulp))));
    }

    @ZenMethod
    public static void add(String input, IItemStack[] output, float[] gravity, ILiquidStack pulp) {
        if (input == null || output == null) {
            CT_LeachingVat.error(name);
            return;
        }
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        ArrayList<Float> gravities = new ArrayList<Float>();
        for (int x = 0; x < output.length; ++x) {
            outputs.add(CT_LeachingVat.toStack(output[x]));
            gravities.add(Float.valueOf(gravity[x]));
        }
        CraftTweakerAPI.apply((IAction)new Add(new LeachingVatRecipe(input, outputs, gravities, CT_LeachingVat.toFluid(pulp))));
    }

    @ZenMethod
    public static void remove(IItemStack input) {
        if (input == null) {
            CT_LeachingVat.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new Remove(CT_LeachingVat.toStack(input)));
    }

    @ZenMethod
    public static void removeByInput(IItemStack input) {
        if (input == null) {
            CT_LeachingVat.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new Remove(CT_LeachingVat.toStack(input)));
    }

    @ZenMethod
    public static void removeByOredict(String input) {
        if (input == null) {
            CT_LeachingVat.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new RemoveByOredict(input));
    }

    private static class RemoveByOredict
    implements IAction {
        private String input;

        public RemoveByOredict(String input) {
            this.input = input;
        }

        public void apply() {
            for (LeachingVatRecipe recipe : recipeList) {
                if (Strings.isNullOrEmpty((String)this.input) || !recipe.getType() || !recipe.getOredict().matches(this.input)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class Remove
    implements IAction {
        private ItemStack input;

        public Remove(ItemStack input) {
            this.input = input;
        }

        public void apply() {
            for (LeachingVatRecipe recipe : recipeList) {
                if (this.input.func_190926_b() || recipe.getType() || !recipe.getInput().func_77969_a(this.input)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class Add
    implements IAction {
        private final LeachingVatRecipe recipe;

        public Add(LeachingVatRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            recipeList.add(this.recipe);
        }

        public String describe() {
            return CTSupport.addCaption(name);
        }
    }
}

