/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.compat.crafttweaker;

import com.globbypotato.rockhounding_chemistry.compat.crafttweaker.CTSupport;
import com.globbypotato.rockhounding_chemistry.machines.recipe.BedReactorRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.BedReactorRecipe;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.ArrayList;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.rockhounding_chemistry.BedReactor")
public class CT_BedReactor
extends CTSupport {
    public static String name = "Fixed Bed Reactor";
    public static ArrayList<BedReactorRecipe> recipeList = BedReactorRecipes.bed_reactor_recipes;

    @ZenMethod
    public static void add(String recipename, ILiquidStack input1, ILiquidStack input2, ILiquidStack input3, ILiquidStack input4, ILiquidStack output, IItemStack catalyst) {
        if (input1 == null || output == null) {
            CT_BedReactor.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new Add(new BedReactorRecipe(recipename, CT_BedReactor.toFluid(input1), CT_BedReactor.toFluid(input2), CT_BedReactor.toFluid(input3), CT_BedReactor.toFluid(input4), CT_BedReactor.toFluid(output), CT_BedReactor.toStack(catalyst))));
    }

    @ZenMethod
    public static void removeByInput1(ILiquidStack input) {
        if (input == null) {
            CT_BedReactor.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new removeByInput1(CT_BedReactor.toFluid(input)));
    }

    @ZenMethod
    public static void removeByInput2(ILiquidStack input) {
        if (input == null) {
            CT_BedReactor.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new removeByInput2(CT_BedReactor.toFluid(input)));
    }

    @ZenMethod
    public static void removeByInput3(ILiquidStack input) {
        if (input == null) {
            CT_BedReactor.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new removeByInput3(CT_BedReactor.toFluid(input)));
    }

    @ZenMethod
    public static void removeByInput4(ILiquidStack input) {
        if (input == null) {
            CT_BedReactor.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new removeByInput4(CT_BedReactor.toFluid(input)));
    }

    @ZenMethod
    public static void removeByOutput(ILiquidStack output) {
        if (output == null) {
            CT_BedReactor.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new RemoveByOutput(CT_BedReactor.toFluid(output)));
    }

    private static class RemoveByOutput
    implements IAction {
        private FluidStack output;

        public RemoveByOutput(FluidStack output) {
            this.output = output;
        }

        public void apply() {
            for (BedReactorRecipe recipe : recipeList) {
                if (this.output == null || !recipe.getOutput().isFluidEqual(this.output)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class removeByInput4
    implements IAction {
        private FluidStack input;

        public removeByInput4(FluidStack input) {
            this.input = input;
        }

        public void apply() {
            for (BedReactorRecipe recipe : recipeList) {
                if (this.input == null || !recipe.getInput4().isFluidEqual(this.input)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class removeByInput3
    implements IAction {
        private FluidStack input;

        public removeByInput3(FluidStack input) {
            this.input = input;
        }

        public void apply() {
            for (BedReactorRecipe recipe : recipeList) {
                if (this.input == null || !recipe.getInput3().isFluidEqual(this.input)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class removeByInput2
    implements IAction {
        private FluidStack input;

        public removeByInput2(FluidStack input) {
            this.input = input;
        }

        public void apply() {
            for (BedReactorRecipe recipe : recipeList) {
                if (this.input == null || !recipe.getInput2().isFluidEqual(this.input)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class removeByInput1
    implements IAction {
        private FluidStack input;

        public removeByInput1(FluidStack input) {
            this.input = input;
        }

        public void apply() {
            for (BedReactorRecipe recipe : recipeList) {
                if (this.input == null || !recipe.getInput1().isFluidEqual(this.input)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class Add
    implements IAction {
        private final BedReactorRecipe recipe;

        public Add(BedReactorRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            recipeList.add(this.recipe);
        }

        public String describe() {
            return CTSupport.addCaption(name);
        }
    }
}

