/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.elements.forestry;

import io.github.drmanganese.topaddons.elements.ElementRenderHelper;
import io.netty.buffer.ByteBuf;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.network.NetworkTools;
import mcjty.theoneprobe.rendering.RenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class ElementForestryFarm
implements IElement {
    private int id;
    private final NonNullList<ItemStack> farmIcons;
    private String oneDirection;
    private NonNullList<ItemStack> inventoryStacks;

    public ElementForestryFarm(int id, NonNullList<ItemStack> farmIcons, String oneDirection, boolean renderInventory, NonNullList<ItemStack> inventoryStacks) {
        this.id = id;
        this.farmIcons = farmIcons;
        this.oneDirection = oneDirection;
        this.inventoryStacks = inventoryStacks;
    }

    public ElementForestryFarm(ByteBuf buf) {
        int i;
        this.farmIcons = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
        for (i = 0; i < 5; ++i) {
            this.farmIcons.set(i, (Object)NetworkTools.readItemStack((ByteBuf)buf));
        }
        this.oneDirection = NetworkTools.readString((ByteBuf)buf);
        if (buf.readBoolean()) {
            this.inventoryStacks = NonNullList.func_191197_a((int)20, (Object)ItemStack.field_190927_a);
            for (i = 0; i < 20; ++i) {
                this.inventoryStacks.set(i, (Object)NetworkTools.readItemStack((ByteBuf)buf));
            }
        } else {
            this.inventoryStacks = NonNullList.func_191196_a();
        }
    }

    public void render(int x, int y) {
        Minecraft minecraft = Minecraft.func_71410_x();
        int centerX = x + 31;
        int centerY = y + 18;
        ElementForestryFarm.drawPlus(centerX - 22, centerY - 22, centerX + 38, centerY + 38);
        RenderHelper.renderItemStack((Minecraft)minecraft, (RenderItem)minecraft.func_175599_af(), (ItemStack)((ItemStack)this.farmIcons.get(4)), (int)centerX, (int)(centerY + 2), (String)"");
        RenderHelper.renderItemStack((Minecraft)minecraft, (RenderItem)minecraft.func_175599_af(), (ItemStack)((ItemStack)this.farmIcons.get(0)), (int)centerX, (int)(centerY - 17), (String)I18n.func_135052_a((String)("for.gui.solder." + this.oneDirection), (Object[])new Object[0]));
        RenderHelper.renderItemStack((Minecraft)minecraft, (RenderItem)minecraft.func_175599_af(), (ItemStack)((ItemStack)this.farmIcons.get(1)), (int)(centerX + 19), (int)(centerY + 2), (String)I18n.func_135052_a((String)("for.gui.solder." + this.nextDirection()), (Object[])new Object[0]));
        RenderHelper.renderItemStack((Minecraft)minecraft, (RenderItem)minecraft.func_175599_af(), (ItemStack)((ItemStack)this.farmIcons.get(2)), (int)centerX, (int)(centerY + 21), (String)I18n.func_135052_a((String)("for.gui.solder." + this.nextDirection()), (Object[])new Object[0]));
        RenderHelper.renderItemStack((Minecraft)minecraft, (RenderItem)minecraft.func_175599_af(), (ItemStack)((ItemStack)this.farmIcons.get(3)), (int)(centerX - 19), (int)(centerY + 2), (String)I18n.func_135052_a((String)("for.gui.solder." + this.nextDirection()), (Object[])new Object[0]));
        this.nextDirection();
        if (this.inventoryStacks.size() > 0) {
            int slot;
            int yOffset;
            int xOffset;
            int k;
            int j;
            int i;
            ElementRenderHelper.drawGreyBox(x, y + 60, x + 38, y + 116);
            ElementRenderHelper.drawGreyBox(x + 40, y + 60, x + 78, y + 116);
            ElementRenderHelper.drawGreyBox(x, y + 120, x + 38, y + 158);
            ElementRenderHelper.drawGreyBox(x + 40, y + 120, x + 78, y + 158);
            for (i = 0; i < 2; ++i) {
                for (j = 0; j < 3; ++j) {
                    for (k = 0; k < 2; ++k) {
                        xOffset = x + 2 + 4 * i + (2 * i + k % 2) * 18;
                        yOffset = y + 62 + j * 18;
                        slot = i * 6 + j * 2 + k;
                        if (((ItemStack)this.inventoryStacks.get(slot)).func_190926_b()) continue;
                        RenderHelper.renderItemStack((Minecraft)minecraft, (RenderItem)minecraft.func_175599_af(), (ItemStack)((ItemStack)this.inventoryStacks.get(slot)), (int)xOffset, (int)yOffset, (String)(((ItemStack)this.inventoryStacks.get(slot)).func_190916_E() + ""));
                    }
                }
            }
            for (i = 0; i < 2; ++i) {
                for (j = 0; j < 2; ++j) {
                    for (k = 0; k < 2; ++k) {
                        xOffset = x + 2 + 4 * i + (2 * i + k % 2) * 18;
                        yOffset = y + 122 + j * 18;
                        slot = i * 4 + j * 2 + k + 12;
                        if (((ItemStack)this.inventoryStacks.get(slot)).func_190926_b()) continue;
                        RenderHelper.renderItemStack((Minecraft)minecraft, (RenderItem)minecraft.func_175599_af(), (ItemStack)((ItemStack)this.inventoryStacks.get(slot)), (int)xOffset, (int)yOffset, (String)(((ItemStack)this.inventoryStacks.get(slot)).func_190916_E() + ""));
                    }
                }
            }
        }
    }

    public int getWidth() {
        return 60;
    }

    public int getHeight() {
        return this.inventoryStacks.size() > 0 ? 160 : 60;
    }

    public void toBytes(ByteBuf buf) {
        for (ItemStack farmIcon : this.farmIcons) {
            NetworkTools.writeItemStack((ByteBuf)buf, (ItemStack)farmIcon);
        }
        NetworkTools.writeString((ByteBuf)buf, (String)this.oneDirection);
        if (this.inventoryStacks.size() > 0) {
            buf.writeBoolean(true);
            for (ItemStack inventoryStack : this.inventoryStacks) {
                NetworkTools.writeItemStack((ByteBuf)buf, (ItemStack)inventoryStack);
            }
        } else {
            buf.writeBoolean(false);
        }
    }

    public int getID() {
        return this.id;
    }

    private String nextDirection() {
        switch (this.oneDirection) {
            case "north": {
                this.oneDirection = "east";
                return "east";
            }
            case "east": {
                this.oneDirection = "south";
                return "south";
            }
            case "south": {
                this.oneDirection = "west";
                return "west";
            }
            case "west": {
                this.oneDirection = "north";
                return "north";
            }
        }
        return this.oneDirection;
    }

    private static void drawPlus(int x1, int y1, int x2, int y2) {
        Gui.func_73734_a((int)(x1 + 21), (int)(y1 + 4), (int)(x2 - 21), (int)(y2 - 37), (int)0x44969696);
        Gui.func_73734_a((int)(x1 + 21), (int)(y1 + 41), (int)(x2 - 21), (int)y2, (int)0x44969696);
        Gui.func_73734_a((int)(x1 + 2), (int)(y1 + 23), (int)(x2 - 2), (int)(y2 - 19), (int)0x44969696);
        RenderHelper.drawHorizontalLine((int)(x1 + 21), (int)(y1 + 3), (int)(x2 - 21), (int)-6908266);
        RenderHelper.drawVerticalLine((int)(x1 + 20), (int)(y1 + 3), (int)(y1 + 23), (int)-6908266);
        RenderHelper.drawVerticalLine((int)(x2 - 21), (int)(y1 + 3), (int)(y1 + 23), (int)-6908266);
        RenderHelper.drawHorizontalLine((int)(x1 + 40), (int)(y1 + 22), (int)(x2 - 2), (int)-6908266);
        RenderHelper.drawVerticalLine((int)(x2 - 2), (int)(y1 + 22), (int)(y1 + 42), (int)-6908266);
        RenderHelper.drawHorizontalLine((int)(x1 + 40), (int)(y1 + 41), (int)(x2 - 2), (int)-6908266);
        RenderHelper.drawVerticalLine((int)(x1 + 20), (int)(y1 + 41), (int)(y1 + 61), (int)-6908266);
        RenderHelper.drawVerticalLine((int)(x2 - 21), (int)(y1 + 41), (int)(y1 + 61), (int)-6908266);
        RenderHelper.drawHorizontalLine((int)(x1 + 21), (int)(y1 + 60), (int)(x2 - 21), (int)-6908266);
        RenderHelper.drawHorizontalLine((int)(x1 + 2), (int)(y1 + 22), (int)(x2 - 40), (int)-6908266);
        RenderHelper.drawVerticalLine((int)(x1 + 1), (int)(y1 + 22), (int)(y1 + 42), (int)-6908266);
        RenderHelper.drawHorizontalLine((int)(x1 + 2), (int)(y1 + 41), (int)(x2 - 40), (int)-6908266);
    }
}

