/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.addons.subaddons.binniesmods;

import binnie.botany.api.gardening.IBlockSoil;
import binnie.botany.api.genetics.IFlower;
import binnie.botany.api.genetics.IFlowerColor;
import binnie.botany.tile.TileEntityFlower;
import binnie.core.genetics.AlleleHelper;
import forestry.api.genetics.EnumTolerance;
import io.github.drmanganese.topaddons.Util;
import io.github.drmanganese.topaddons.addons.AddonBlank;
import io.github.drmanganese.topaddons.elements.binnies.ElementFlowerColor;
import java.util.Collections;
import java.util.List;
import mcjty.theoneprobe.Tools;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IBlockDisplayOverride;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.config.Config;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class SubAddonBotany
extends AddonBlank {
    @GameRegistry.ObjectHolder(value="botany:soil_meter")
    private static final Item SOIL_METER = null;
    @GameRegistry.ObjectHolder(value="botany:flower")
    private static final Block FLOWER_BLOCK = null;
    @GameRegistry.ObjectHolder(value="botany:soil")
    private static final Block SOIL = null;

    private IProbeInfo addColorBox(IProbeInfo probeInfo, IFlowerColor color, EntityPlayer player) {
        return probeInfo.element((IElement)new ElementFlowerColor(SubAddonBotany.getElementId(player, "flowerColor"), color.getColor(false))).text(color.getColorName());
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntity tile = world.func_175625_s(data.getPos());
        if (tile instanceof TileEntityFlower) {
            IFlower flower = ((TileEntityFlower)tile).getFlower();
            if (flower.isAnalyzed()) {
                SubAddonBotany.textPrefixed(probeInfo, "Age", Integer.toString(flower.getAge()));
                IProbeInfo hori = probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER).spacing(2)).text(TextStyleClass.LABEL + "Color:");
                this.addColorBox(hori, flower.getGenome().getPrimaryColor(), player);
                hori.text("and");
                this.addColorBox(hori, flower.getGenome().getSecondaryColor(), player);
                hori = probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER).spacing(2)).text(TextStyleClass.LABEL + "Stem:");
                this.addColorBox(hori, flower.getGenome().getStemColor(), player);
                if (mode == ProbeMode.EXTENDED) {
                    SubAddonBotany.textPrefixed(probeInfo, "Temp. Tolerance", AlleleHelper.getAllele((EnumTolerance)flower.getGenome().getToleranceTemperature()).getAlleleName());
                    SubAddonBotany.textPrefixed(probeInfo, "Moist. Tolerance", AlleleHelper.getAllele((EnumTolerance)flower.getGenome().getToleranceMoisture()).getAlleleName());
                    SubAddonBotany.textPrefixed(probeInfo, "pH Tolerance", AlleleHelper.getAllele((EnumTolerance)flower.getGenome().getTolerancePH()).getAlleleName());
                }
            } else if (mode == ProbeMode.EXTENDED) {
                probeInfo.text(TextStyleClass.OBSOLETE + "{*for.gui.unknown*}");
            }
            IBlockState blockStateBelow = world.func_180495_p(data.getPos().func_177977_b());
            if (Util.isHoldingItem(player, SOIL_METER) && blockStateBelow.func_177230_c() == SOIL) {
                IBlockSoil soil = (IBlockSoil)blockStateBelow.func_177230_c();
                IProbeInfo soilInfo = probeInfo.horizontal(probeInfo.defaultLayoutStyle().borderColor(Integer.valueOf(MapColor.field_151664_l.field_76291_p + -16777216))).item(SOIL.getPickBlock(blockStateBelow, null, world, data.getPos().func_177977_b(), player)).vertical();
                SubAddonBotany.textPrefixed(soilInfo, "{*botany.moisture*}", "{*botany.moisture." + soil.getMoisture(world, data.getPos().func_177977_b()).func_176610_l() + "*}");
                SubAddonBotany.textPrefixed(soilInfo, "{*botany.ph*}", "{*botany.ph." + soil.getPH(world, data.getPos().func_177977_b()).func_176610_l() + "*}");
            }
        }
        if (blockState.func_177230_c() instanceof IBlockSoil && Util.isHoldingItem(player, SOIL_METER)) {
            IBlockSoil soil = (IBlockSoil)blockState.func_177230_c();
            SubAddonBotany.textPrefixed(probeInfo, "{*botany.moisture*}", "{*botany.moisture." + soil.getMoisture(world, data.getPos()).func_176610_l() + "*}");
            SubAddonBotany.textPrefixed(probeInfo, "{*botany.ph*}", "{*botany.ph." + soil.getPH(world, data.getPos()).func_176610_l() + "*}");
            if (soil.resistsWeeds(world, data.getPos())) {
                probeInfo.text(TextStyleClass.OK + "{*botany.soil.weedkiller*}");
            }
        }
    }

    @Override
    public List<IBlockDisplayOverride> getBlockDisplayOverrides() {
        return Collections.singletonList((mode, probeInfo, player, world, blockState, data) -> {
            if (blockState.func_177230_c() == FLOWER_BLOCK) {
                TileEntityFlower tile = (TileEntityFlower)world.func_175625_s(data.getPos());
                if (Tools.show((ProbeMode)mode, (IProbeConfig.ConfigMode)Config.getRealConfig().getShowModName())) {
                    probeInfo.horizontal().item(tile.getItemStack()).vertical().text(tile.getItemStack().func_82833_r()).text(TextStyleClass.MODNAME + Tools.getModName((Block)FLOWER_BLOCK));
                } else {
                    probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item(tile.getItemStack()).text(tile.getItemStack().func_82833_r());
                }
                return true;
            }
            return false;
        });
    }
}

