/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.addons;

import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import io.github.drmanganese.topaddons.addons.AddonBlank;
import io.github.drmanganese.topaddons.api.TOPAddon;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.config.Config;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.GameRegistry;

@TOPAddon(dependency="storagedrawers")
public class AddonStorageDrawers
extends AddonBlank {
    @GameRegistry.ObjectHolder(value="theoneprobe:probe")
    private static final Item PROBE = null;
    private boolean replaceDrawers = true;

    @Override
    public void updateConfigs(Configuration config) {
        this.replaceDrawers = config.get("storagedrawers", "replaceDrawers", true, "Replace Storage Drawers default extended info.").setLanguageKey("topaddons.config:storagedrawers_extended").getBoolean();
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        if (world.func_175625_s(data.getPos()) instanceof TileEntityDrawers) {
            TileEntityDrawers tile = (TileEntityDrawers)world.func_175625_s(data.getPos());
            if (tile.getDrawerAttributes().isConcealed()) {
                probeInfo.text(TextStyleClass.LABEL + "{*topaddons.storage_drawers:shrouded*}");
                return;
            }
            if (mode == ProbeMode.EXTENDED && this.replaceDrawers) {
                NonNullList stacks = NonNullList.func_191196_a();
                for (int i = 0; i < tile.getGroup().getDrawerCount(); ++i) {
                    ItemStack stack = tile.getGroup().getDrawer(i).getStoredItemPrototype().func_77946_l();
                    if (stack.func_190926_b()) continue;
                    stack.func_190920_e(tile.getGroup().getDrawer(i).getStoredItemCount());
                    stacks.add((Object)stack);
                }
                if (stacks.size() > 0) {
                    IProbeInfo vertical = probeInfo.vertical(probeInfo.defaultLayoutStyle().borderColor(Integer.valueOf(Config.chestContentsBorderColor)).spacing(0));
                    for (ItemStack stack : stacks) {
                        if (tile.getDrawerAttributes().isUnlimitedVending()) {
                            ItemStack infiStack = stack.func_77946_l();
                            infiStack.func_190920_e(1);
                            vertical.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item(infiStack).vertical(probeInfo.defaultLayoutStyle().spacing(0)).itemLabel(stack).text(TextStyleClass.INFOIMP + "[\u221e]");
                            continue;
                        }
                        if (stack.func_190926_b()) continue;
                        int mss = stack.func_77976_d();
                        int r = stack.func_190916_E() % mss;
                        int q = (stack.func_190916_E() - r) / mss;
                        vertical.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item(stack).vertical(probeInfo.defaultLayoutStyle().spacing(0)).itemLabel(stack).text(TextStyleClass.LABEL + "[" + (stack.func_190916_E() >= mss ? q + "x" + mss + " + " : "") + r + "]");
                    }
                }
                AddonStorageDrawers.textPrefixed(probeInfo, "{*storagedrawers.waila.config.displayStackLimit*}", tile.getDrawerAttributes().isUnlimitedStorage() ? "\u221e" : tile.getDrawerCapacity() * tile.upgrades().getStorageMultiplier() + " (x" + tile.upgrades().getStorageMultiplier() + ")");
                if (tile.getOwner() != null && tile.getOwner().compareTo(player.func_110124_au()) != 0) {
                    probeInfo.text(TextStyleClass.ERROR + "{*storagedrawers.waila.protected*}");
                }
            }
        }
    }

    @Override
    public void getProbeConfig(IProbeConfig config, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        if (world.func_175625_s(data.getPos()) instanceof TileEntityDrawers) {
            boolean probeInMain;
            boolean bl = probeInMain = player.func_184614_ca().func_77973_b() == PROBE;
            if (this.replaceDrawers && player.func_70093_af() && (Config.needsProbe != 3 || probeInMain) || Config.extendedInMain && probeInMain) {
                config.showChestContents(IProbeConfig.ConfigMode.NOT);
            } else {
                config.showChestContents(IProbeConfig.ConfigMode.EXTENDED);
            }
        }
    }
}

