/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.addons;

import ic2.api.crops.ICropTile;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.tile.IKineticSource;
import ic2.api.item.IElectricItem;
import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorChamber;
import ic2.api.recipe.ISemiFluidFuelManager;
import ic2.api.recipe.Recipes;
import ic2.core.block.BlockIC2Fence;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.TileEntityHeatSourceInventory;
import ic2.core.block.comp.Energy;
import ic2.core.block.comp.Fluids;
import ic2.core.block.generator.tileentity.TileEntityBaseGenerator;
import ic2.core.block.generator.tileentity.TileEntityConversionGenerator;
import ic2.core.block.generator.tileentity.TileEntityGenerator;
import ic2.core.block.generator.tileentity.TileEntityGeoGenerator;
import ic2.core.block.generator.tileentity.TileEntityKineticGenerator;
import ic2.core.block.generator.tileentity.TileEntityRTGenerator;
import ic2.core.block.generator.tileentity.TileEntitySemifluidGenerator;
import ic2.core.block.generator.tileentity.TileEntitySolarGenerator;
import ic2.core.block.generator.tileentity.TileEntityStirlingGenerator;
import ic2.core.block.generator.tileentity.TileEntityWaterGenerator;
import ic2.core.block.generator.tileentity.TileEntityWindGenerator;
import ic2.core.block.kineticgenerator.tileentity.TileEntityStirlingKineticGenerator;
import ic2.core.block.machine.tileentity.TileEntityAdvMiner;
import ic2.core.block.machine.tileentity.TileEntityBlastFurnace;
import ic2.core.block.machine.tileentity.TileEntityCanner;
import ic2.core.block.machine.tileentity.TileEntityCentrifuge;
import ic2.core.block.machine.tileentity.TileEntityCondenser;
import ic2.core.block.machine.tileentity.TileEntityFermenter;
import ic2.core.block.machine.tileentity.TileEntityFluidBottler;
import ic2.core.block.machine.tileentity.TileEntityFluidDistributor;
import ic2.core.block.machine.tileentity.TileEntityFluidRegulator;
import ic2.core.block.machine.tileentity.TileEntityInduction;
import ic2.core.block.machine.tileentity.TileEntityLiquidHeatExchanger;
import ic2.core.block.machine.tileentity.TileEntityMagnetizer;
import ic2.core.block.machine.tileentity.TileEntityMatter;
import ic2.core.block.machine.tileentity.TileEntityMiner;
import ic2.core.block.machine.tileentity.TileEntityPatternStorage;
import ic2.core.block.machine.tileentity.TileEntityReplicator;
import ic2.core.block.machine.tileentity.TileEntityScanner;
import ic2.core.block.machine.tileentity.TileEntitySolarDestiller;
import ic2.core.block.machine.tileentity.TileEntityStandardMachine;
import ic2.core.block.machine.tileentity.TileEntitySteamGenerator;
import ic2.core.block.machine.tileentity.TileEntityTeleporter;
import ic2.core.block.machine.tileentity.TileEntityTerra;
import ic2.core.block.personal.TileEntityPersonalChest;
import ic2.core.block.personal.TileEntityTradeOMat;
import ic2.core.block.reactor.tileentity.TileEntityNuclearReactorElectric;
import ic2.core.block.reactor.tileentity.TileEntityReactorChamberElectric;
import ic2.core.block.wiring.TileEntityChargepadBlock;
import ic2.core.block.wiring.TileEntityElectricBlock;
import ic2.core.init.MainConfig;
import ic2.core.item.armor.ItemArmorHazmat;
import ic2.core.item.armor.ItemArmorNanoSuit;
import ic2.core.item.armor.ItemArmorQuantumSuit;
import ic2.core.item.armor.ItemArmorSolarHelmet;
import ic2.core.ref.ItemName;
import ic2.core.util.ConfigUtil;
import io.github.drmanganese.topaddons.Util;
import io.github.drmanganese.topaddons.addons.AddonBlank;
import io.github.drmanganese.topaddons.addons.AddonForge;
import io.github.drmanganese.topaddons.api.TOPAddon;
import io.github.drmanganese.topaddons.reference.Colors;
import io.github.drmanganese.topaddons.reference.EnumChip;
import io.github.drmanganese.topaddons.reference.Names;
import io.github.drmanganese.topaddons.styles.ProgressStyleTOPAddonGrey;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProgressStyle;
import mcjty.theoneprobe.api.NumberFormat;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.config.Config;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

@TOPAddon(dependency="ic2", order=0)
public class AddonIndustrialCraft2
extends AddonBlank {
    private static final Map<Class<? extends TileEntityBaseGenerator>, Double> MULTIPLIERS = new HashMap<Class<? extends TileEntityBaseGenerator>, Double>();
    private static final Map<Class<? extends TileEntityBaseGenerator>, Function<TileEntityBaseGenerator, Double>> OUTPUTS = new HashMap<Class<? extends TileEntityBaseGenerator>, Function<TileEntityBaseGenerator, Double>>();

    @Override
    public void addFluidColors() {
        Colors.FLUID_NAME_COLOR_MAP.put("ic2uu_matter", -12909261);
        Colors.FLUID_NAME_COLOR_MAP.put("ic2construction_foam", -14671840);
        Colors.FLUID_NAME_COLOR_MAP.put("ic2coolant", -15443350);
        Colors.FLUID_NAME_COLOR_MAP.put("ic2hot_coolant", -4904908);
        Colors.FLUID_NAME_COLOR_MAP.put("ic2pahoehoe_lava", -8686484);
        Colors.FLUID_NAME_COLOR_MAP.put("ic2biomass", -13144283);
        Colors.FLUID_NAME_COLOR_MAP.put("ic2biogas", -5793716);
        Colors.FLUID_NAME_COLOR_MAP.put("ic2distilled_water", -12364043);
        Colors.FLUID_NAME_COLOR_MAP.put("ic2superheated_steam", -3485231);
        Colors.FLUID_NAME_COLOR_MAP.put("ic2steam", -4408132);
        Colors.FLUID_NAME_COLOR_MAP.put("ic2hot_water", -12132609);
        Colors.FLUID_NAME_COLOR_MAP.put("ic2weed_ex", -16298220);
        Colors.FLUID_NAME_COLOR_MAP.put("ic2air", -2302756);
        Colors.FLUID_NAME_COLOR_MAP.put("ic2hydrogen", -2302756);
        Colors.FLUID_NAME_COLOR_MAP.put("ic2oxygen", -2302756);
        Colors.FLUID_NAME_COLOR_MAP.put("ic2heavy_water", -12364043);
    }

    @Override
    public void addTankNames() {
        Names.tankNamesMap.put(TileEntityGeoGenerator.class, new String[]{"Buffer"});
        Names.tankNamesMap.put(TileEntityCanner.class, new String[]{"Input", "Output"});
        Names.tankNamesMap.put(TileEntityLiquidHeatExchanger.class, new String[]{"Hot liquid", "Cold liquid"});
        Names.tankNamesMap.put(TileEntityCondenser.class, new String[]{"Gas", "Liquid"});
        Names.tankNamesMap.put(TileEntityReactorChamberElectric.class, new String[]{"Cold liquid", "Hot liquid"});
        Names.tankNamesMap.put(TileEntityStirlingKineticGenerator.class, new String[]{"Cold liquid", "Hot liquid"});
    }

    @Override
    public Map<Class<? extends ItemArmor>, EnumChip> getSpecialHelmets() {
        HashMap<Class<? extends ItemArmor>, EnumChip> map = new HashMap<Class<? extends ItemArmor>, EnumChip>();
        map.put(ItemArmorNanoSuit.class, EnumChip.IC2);
        map.put(ItemArmorQuantumSuit.class, EnumChip.IC2);
        map.put(ItemArmorHazmat.class, EnumChip.IC2);
        map.put(ItemArmorSolarHelmet.class, EnumChip.IC2);
        map.put(ItemArmorHazmat.class, EnumChip.IC2);
        return map;
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntityTradeOMat trader;
        ICropTile crop;
        TileEntityMatter tileMatter;
        TileEntityReplicator replicator;
        TileEntityScanner scanner;
        TileEntityMiner miner;
        TileEntityStandardMachine machine;
        TileEntity tile = world.func_175625_s(data.getPos());
        if (tile instanceof TileEntityBlock) {
            TileEntityBlock tileBlock = (TileEntityBlock)tile;
            if (tileBlock.hasComponent(Energy.class)) {
                Energy energy = (Energy)tileBlock.getComponent(Energy.class);
                AddonIndustrialCraft2.euBar(probeInfo, (int)energy.getEnergy(), (int)energy.getCapacity());
            }
            if (tileBlock.hasComponent(Fluids.class)) {
                Iterator tanks = ((Fluids)tileBlock.getComponent(Fluids.class)).getAllTanks().iterator();
                int i = 0;
                while (tanks.hasNext()) {
                    AddonForge.addTankElement(probeInfo, tile.getClass(), (FluidTank)tanks.next(), i, mode, player);
                    ++i;
                }
            }
        }
        if (tile instanceof TileEntityStandardMachine) {
            boolean hasWork;
            block69: {
                machine = (TileEntityStandardMachine)tile;
                hasWork = false;
                try {
                    hasWork = !machine.inputSlot.isEmpty();
                }
                catch (NullPointerException e) {
                    if (!(tile instanceof TileEntityFluidBottler)) break block69;
                    boolean bl = hasWork = !((TileEntityFluidBottler)tile).fillInputSlot.isEmpty() || !((TileEntityFluidBottler)tile).drainInputSlot.isEmpty();
                }
            }
            if (hasWork) {
                this.progressBar(probeInfo, (int)(machine.getProgress() * 100.0f), -5592406, -7829368);
            }
            if (mode == ProbeMode.EXTENDED) {
                AddonIndustrialCraft2.textPrefixed(probeInfo, "{*topaddons:consumption*}", machine.energyConsume + " EU/t");
            }
        }
        if (tile instanceof TileEntityInduction) {
            machine = (TileEntityInduction)tile;
            probeInfo.progress((int)Math.floor(machine.heat / 100), 100, probeInfo.defaultProgressStyle().prefix("Heat: ").suffix("%").filledColor(-2741474).alternateFilledColor(-2741474));
            if (!machine.inputSlotA.isEmpty() || !machine.inputSlotB.isEmpty()) {
                this.progressBar(probeInfo, Math.min(machine.progress / 40, 100), -5592406, -7829368);
            }
            if (mode == ProbeMode.EXTENDED) {
                AddonIndustrialCraft2.textPrefixed(probeInfo, "{*topaddons:consumption*}", "15 EU/t");
            }
        }
        if (tile instanceof TileEntityCentrifuge) {
            machine = (TileEntityCentrifuge)tile;
            if (!machine.inputSlot.isEmpty() || machine.heat > 0) {
                probeInfo.progress((int)machine.heat, (int)machine.workheat, probeInfo.defaultProgressStyle().filledColor(-2741474).alternateFilledColor(-2741474).showText(false).height(8));
            }
        }
        if (tile instanceof TileEntityBlastFurnace) {
            machine = (TileEntityBlastFurnace)tile;
            if (!machine.inputSlot.isEmpty()) {
                this.progressBar(probeInfo, (int)(machine.getGuiValue("progress") * 100.0), -5592406, -7829368);
            }
            if (!machine.inputSlot.isEmpty() || machine.heat > 0) {
                probeInfo.progress(machine.heat, TileEntityBlastFurnace.maxHeat, probeInfo.defaultProgressStyle().filledColor(-2741474).alternateFilledColor(-2741474).showText(false).height(8));
            }
        }
        if (tile instanceof TileEntityMiner) {
            miner = (TileEntityMiner)tile;
            if (miner.drillSlot.isEmpty()) {
                probeInfo.text(TextStyleClass.ERROR + "{*topaddons.ic2:miner_no_drill*}");
            } else {
                probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).text(TextStyleClass.LABEL + "{*topaddons.ic2:miner_drill*}: ").item(miner.drillSlot.get());
            }
            if (miner.pipeSlot.isEmpty()) {
                probeInfo.text(TextStyleClass.ERROR + "{*topaddons.ic2:miner_no_pipes*}");
            } else {
                probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).text(TextStyleClass.LABEL + "{*topaddons.ic2:miner_pipes*}: ").item(miner.pipeSlot.get());
            }
            if (miner.scannerSlot.isEmpty()) {
                AddonIndustrialCraft2.textPrefixed(probeInfo, "{*topaddons.ic2:miner_scanner*}", "{*topaddons:none*}");
            } else {
                probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).text(TextStyleClass.LABEL + "{*topaddons.ic2:miner_scanner*}: ").item(miner.scannerSlot.get()).text(miner.scannerSlot.get().func_82833_r());
            }
        }
        if (tile instanceof TileEntityAdvMiner) {
            miner = (TileEntityAdvMiner)tile;
            if (miner.scannerSlot.isEmpty()) {
                probeInfo.text(TextStyleClass.ERROR + "{*topaddons.ic2:miner_no_scanner*}");
            } else {
                probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).text(TextStyleClass.LABEL + "{*topaddons.ic2:miner_scanner*}: ").item(miner.scannerSlot.get()).text(miner.scannerSlot.get().func_82833_r());
            }
        }
        if (tile instanceof TileEntityElectricBlock) {
            TileEntityElectricBlock tileElectric = (TileEntityElectricBlock)tile;
            if (mode == ProbeMode.EXTENDED) {
                probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item(new ItemStack(Items.field_151137_ax)).text(tileElectric.getRedstoneMode().replaceFirst(".+:\\s", ""));
            }
            AddonIndustrialCraft2.textPrefixed(probeInfo, "{*topaddons.ic2:max_output*}", new DecimalFormat("##.#").format(tileElectric.getOutputEnergyUnitsPerTick()) + " EU/t");
        }
        if (tile instanceof IKineticSource) {
            AddonIndustrialCraft2.textPrefixed(probeInfo, "{*topaddons.ic2:buffer*}", new DecimalFormat("##.#").format(((IKineticSource)tile).getConnectionBandwidth(((TileEntityBlock)tile).getFacing())) + " kU");
        }
        if (tile instanceof TileEntitySolarGenerator && ((TileEntitySolarGenerator)tile).skyLight == 0.0f) {
            probeInfo.text(TextFormatting.RED + "{*topaddons.ic2:no_sky*}");
        }
        if (tile instanceof TileEntitySolarDestiller && TileEntitySolarGenerator.getSkyLight((World)world, (BlockPos)data.getPos()) == 0.0f) {
            probeInfo.text(TextFormatting.RED + "{*topaddons.ic2:no_sky*}");
        }
        if (tile instanceof TileEntityTeleporter) {
            BlockPos pos = ((TileEntityTeleporter)tile).getTarget();
            AddonIndustrialCraft2.textPrefixed(probeInfo, "{*topaddons.ic2:destination*}", ((TileEntityTeleporter)tile).hasTarget() ? String.format("%d %d %d", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()) : "none");
        }
        if (tile instanceof TileEntityTerra) {
            if (!((TileEntityTerra)tile).tfbpSlot.isEmpty()) {
                AddonIndustrialCraft2.textPrefixed(probeInfo, "{*topaddons.ic2:blueprint*}", ((TileEntityTerra)tile).tfbpSlot.get().func_82833_r().substring(7));
            } else {
                AddonIndustrialCraft2.textPrefixed(probeInfo, "{*topaddons.ic2:blueprint*}", "{*topaddons:none*}");
            }
        }
        if (tile instanceof TileEntityHeatSourceInventory) {
            AddonIndustrialCraft2.textPrefixed(probeInfo, "{*topaddons.ic2:transmitting*}", ((TileEntityHeatSourceInventory)tile).gettransmitHeat() + " hU");
            AddonIndustrialCraft2.textPrefixed(probeInfo, "{*topaddons.ic2:buffer*}", ((TileEntityHeatSourceInventory)tile).getHeatBuffer() + " hU");
            AddonIndustrialCraft2.textPrefixed(probeInfo, "{*topaddons.ic2:max_transfer*}", ((TileEntityHeatSourceInventory)tile).getMaxHeatEmittedPerTick() + " hU");
        }
        if (tile instanceof TileEntityFermenter) {
            TileEntityFermenter fermenter = (TileEntityFermenter)tile;
            probeInfo.progress(Math.round(100.0 * fermenter.getGuiValue("heat")), 100L, (IProgressStyle)new ProgressStyleTOPAddonGrey().prefix("Conversion: ").suffix("%").alternateFilledColor(-2023135).filledColor(-7924716));
            probeInfo.progress(Math.round(100.0 * fermenter.getGuiValue("progress")), 100L, (IProgressStyle)new ProgressStyleTOPAddonGrey().prefix("Waste: ").suffix("%").alternateFilledColor(-15829490).filledColor(-16234744));
        }
        if (tile instanceof TileEntityBaseGenerator && OUTPUTS.containsKey(tile.getClass())) {
            AddonIndustrialCraft2.textPrefixed(probeInfo, "{*topaddons:generating*}", new DecimalFormat("#.##").format(OUTPUTS.get(tile.getClass()).apply((TileEntityBaseGenerator)tile)) + " EU/t");
        }
        if (tile instanceof TileEntityStirlingGenerator) {
            AddonIndustrialCraft2.textPrefixed(probeInfo, "{*topaddons:generating*}", ((TileEntityConversionGenerator)tile).getProduction() + " EU/t");
        }
        if (tile instanceof TileEntityKineticGenerator) {
            AddonIndustrialCraft2.textPrefixed(probeInfo, "{*topaddons:generating*}", ((TileEntityKineticGenerator)tile).getProduction() + " EU/t");
        }
        if (tile instanceof IReactor || tile instanceof IReactorChamber && ((IReactorChamber)tile).getReactorInstance() != null) {
            IReactor reactor;
            IReactor iReactor = reactor = tile instanceof IReactorChamber ? ((IReactorChamber)tile).getReactorInstance() : (IReactor)tile;
            if (reactor.isFluidCooled()) {
                AddonIndustrialCraft2.textPrefixed(probeInfo, "{*topaddons.ic2:heat_production*}", new DecimalFormat("#.##").format(((TileEntityNuclearReactorElectric)reactor.getCoreTe()).EmitHeat) + " hU/t");
            } else {
                AddonIndustrialCraft2.textPrefixed(probeInfo, "{*topaddons:generating*}", new DecimalFormat("#.##").format(reactor.getReactorEUEnergyOutput()) + " EU/t");
            }
            float ratio = 1.0f * (float)reactor.getHeat() / (float)reactor.getMaxHeat();
            int color = Util.blendColors(-16729088, -1238771, Math.min(1.0f, ratio));
            probeInfo.progress(reactor.getHeat(), Math.max(reactor.getHeat(), reactor.getMaxHeat()), probeInfo.defaultProgressStyle().suffix("\u00b0C").filledColor(color).alternateFilledColor(color));
        }
        if (tile instanceof TileEntityChargepadBlock && tile.func_145835_a((double)player.func_180425_c().func_177958_n(), (double)player.func_180425_c().func_177956_o(), (double)player.func_180425_c().func_177952_p()) <= 0.75) {
            IProbeInfo hori = probeInfo.horizontal();
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IElectricItem)) continue;
                hori.item(stack);
            }
        }
        if (tile instanceof TileEntityScanner && !(scanner = (TileEntityScanner)tile).func_191420_l()) {
            AddonIndustrialCraft2.textPrefixed(probeInfo, "{*topaddons.ic2:uu_scanning*}", scanner.inputSlot.get().func_82833_r());
            this.progressBar(probeInfo, scanner.progress / 33, -5592406, -7829368);
        }
        if (tile instanceof TileEntityPatternStorage) {
            AddonIndustrialCraft2.textPrefixed(probeInfo, "{*topaddons.ic2:uu_stored_patterns*}", String.valueOf(((TileEntityPatternStorage)tile).getPatterns().size()));
        }
        if (tile instanceof TileEntityReplicator && (replicator = (TileEntityReplicator)tile).getMode() != TileEntityReplicator.Mode.STOPPED) {
            int multiplier = 1;
            char prefix = '\u0000';
            if (replicator.patternUu < 0.002) {
                multiplier = 1000000;
                prefix = '\u00b5';
            } else if (replicator.patternUu < 5.0) {
                multiplier = 1000;
                prefix = 'm';
            }
            AddonIndustrialCraft2.textPrefixed(probeInfo, "{*topaddons.ic2:uu_replicating*}", replicator.pattern.func_82833_r());
            AddonIndustrialCraft2.textPrefixed(probeInfo, "{*topaddons.ic2:mode*}", "{*" + (replicator.getMode() == TileEntityReplicator.Mode.SINGLE ? "ic2.Replicator.gui.info.single" : "ic2.Replicator.gui.info.repeat") + "*}");
            probeInfo.progress((int)(replicator.uuProcessed * (double)multiplier), (int)(replicator.patternUu * (double)multiplier), probeInfo.defaultProgressStyle().suffix(" " + prefix + 'B'));
        }
        if (tile instanceof TileEntityMatter && (tileMatter = (TileEntityMatter)tile).amplificationIsAvailable()) {
            probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).text(TextStyleClass.LABEL + "{*topaddons.ic2:uu_amplifier*}:").item(tileMatter.amplifierSlot.get());
        }
        if (tile instanceof TileEntityPersonalChest) {
            AddonIndustrialCraft2.textPrefixed(probeInfo, "{*topaddons.ic2:owner*}", ((TileEntityPersonalChest)tile).getOwner() != null ? ((TileEntityPersonalChest)tile).getOwner().getName() : "");
        }
        if (tile instanceof TileEntityFluidDistributor) {
            probeInfo.text(TextStyleClass.LABEL + "{*ic2.FluidDistributor.gui.mode.info*} " + TextStyleClass.INFO + (((TileEntityFluidDistributor)tile).getActive() ? "{*ic2.FluidDistributor.gui.mode.concentrate*}" : "{*ic2.FluidDistributor.gui.mode.distribute*}"));
        }
        if (tile instanceof TileEntityFluidRegulator) {
            TileEntityFluidRegulator regulator = (TileEntityFluidRegulator)tile;
            AddonIndustrialCraft2.textPrefixed(probeInfo, "{*topaddons.ic2:mb_rate*}", regulator.getoutputmb() + " mB" + regulator.getmodegui());
        }
        if (tile instanceof TileEntitySteamGenerator) {
            TileEntitySteamGenerator generator = (TileEntitySteamGenerator)tile;
            AddonIndustrialCraft2.textPrefixed(probeInfo, "Output Fluid", "{*" + generator.getOutputFluidName() + "*}");
            AddonIndustrialCraft2.textPrefixed(probeInfo, "Output Rate", generator.getOutputMB() + " mB/t");
            probeInfo.progress((int)generator.getCalcification(), 100, probeInfo.defaultProgressStyle().backgroundColor(-16744963).filledColor(-4276290).alternateFilledColor(-4276290).prefix("Calcification: ").suffix(new DecimalFormat("##.#").format(generator.getCalcification()) + "%").numberFormat(NumberFormat.NONE));
        }
        if (tile instanceof TileEntityMagnetizer && !BlockIC2Fence.hasMetalShoes((EntityPlayer)player)) {
            probeInfo.text(TextStyleClass.OBSOLETE + "{*ic2.Magnetizer.gui.noMetalShoes*}");
        }
        if (tile instanceof TileEntityBlock && mode == ProbeMode.EXTENDED && ((TileEntityBlock)tile).hasComponent(Energy.class)) {
            Energy energy = (Energy)((TileEntityBlock)tile).getComponent(Energy.class);
            if (!energy.getSourceDirs().isEmpty()) {
                AddonIndustrialCraft2.textPrefixed(probeInfo, "{*topaddons.ic2:power_tier*}", String.valueOf(energy.getSourceTier()));
            } else if (!energy.getSinkDirs().isEmpty()) {
                AddonIndustrialCraft2.textPrefixed(probeInfo, "{*topaddons.ic2:power_tier*}", String.valueOf(energy.getSinkTier()));
            }
        }
        if (tile instanceof ICropTile && (crop = (ICropTile)tile).getCrop() != null) {
            AddonIndustrialCraft2.textPrefixed(probeInfo, "{*topaddons.forestry:maturity*}", TextStyleClass.WARNING + String.valueOf(100 * crop.getCurrentSize() / crop.getCrop().getMaxSize()) + "%");
            if (this.hodlingCropnalyzer(player)) {
                AddonIndustrialCraft2.textPrefixed(probeInfo, "{*topaddons.ic2:crop_nutrient*}", String.format("%d/%d", crop.getStorageNutrients(), 100));
                AddonIndustrialCraft2.textPrefixed(probeInfo, "{*topaddons.ic2:crop_water*}", String.format("%d/%d", crop.getStorageWater(), 200));
                AddonIndustrialCraft2.textPrefixed(probeInfo, "{*topaddons.ic2:crop_weedex*}", String.format("%d/%d", crop.getStorageWeedEX(), 100));
                AddonIndustrialCraft2.textPrefixed(probeInfo, "{*topaddons.ic2:crop_growth*}", String.format("%d/%d", crop.getGrowthPoints(), 300));
            } else if (crop.getScanLevel() > 0) {
                AddonIndustrialCraft2.textPrefixed(probeInfo, "{*topaddons.ic2:crop_name*}", "{*" + crop.getCrop().getUnlocalizedName() + "*}");
                if (crop.getScanLevel() >= 2) {
                    AddonIndustrialCraft2.textPrefixed(probeInfo, "Tier", Util.getRomanNumeral(crop.getCrop().getProperties().getTier()));
                }
                if (crop.getScanLevel() >= 4) {
                    AddonIndustrialCraft2.textPrefixed(probeInfo, "Growth", String.valueOf(crop.getStatGrowth()));
                    AddonIndustrialCraft2.textPrefixed(probeInfo, "Gain", String.valueOf(crop.getStatGain()));
                    AddonIndustrialCraft2.textPrefixed(probeInfo, "Resis.", String.valueOf(crop.getStatResistance()));
                }
            }
        }
        if (tile instanceof TileEntityTradeOMat && (trader = (TileEntityTradeOMat)tile).getOwner() != null) {
            AddonIndustrialCraft2.textPrefixed(probeInfo, "{*topaddons.ic2:owner*}", trader.getOwner().getName());
        }
    }

    private boolean hodlingCropnalyzer(EntityPlayer player) {
        for (EnumHand enumHand : EnumHand.values()) {
            ItemStack heldStack = player.func_184586_b(enumHand);
            if (heldStack.func_77973_b() != ItemName.cropnalyzer.getInstance() || heldStack.func_77952_i() >= heldStack.func_77958_k()) continue;
            return true;
        }
        return false;
    }

    public static void euBar(IProbeInfo probeInfo, int energy, int capacity) {
        probeInfo.progress(energy, capacity, probeInfo.defaultProgressStyle().suffix("EU").filledColor(Config.rfbarFilledColor).alternateFilledColor(Config.rfbarAlternateFilledColor).borderColor(Config.rfbarBorderColor).numberFormat(NumberFormat.COMPACT));
    }

    static {
        MULTIPLIERS.put(TileEntitySolarGenerator.class, ConfigUtil.getDouble((ic2.core.util.Config)MainConfig.get(), (String)"balance/energy/generator/solar"));
        MULTIPLIERS.put(TileEntityGenerator.class, Double.valueOf(ConfigUtil.getFloat((ic2.core.util.Config)MainConfig.get(), (String)"balance/energy/generator/generator")));
        MULTIPLIERS.put(TileEntityRTGenerator.class, Double.valueOf(ConfigUtil.getFloat((ic2.core.util.Config)MainConfig.get(), (String)"balance/energy/generator/radioisotope")));
        MULTIPLIERS.put(TileEntityWaterGenerator.class, ConfigUtil.getDouble((ic2.core.util.Config)MainConfig.get(), (String)"balance/energy/generator/water"));
        MULTIPLIERS.put(TileEntityWindGenerator.class, ConfigUtil.getDouble((ic2.core.util.Config)MainConfig.get(), (String)"balance/energy/generator/wind"));
        OUTPUTS.put(TileEntitySolarGenerator.class, tile -> (double)((TileEntitySolarGenerator)tile).skyLight * MULTIPLIERS.get(TileEntitySolarGenerator.class));
        OUTPUTS.put(TileEntityGenerator.class, tile -> 10.0 * MULTIPLIERS.get(TileEntityGenerator.class));
        OUTPUTS.put(TileEntityGeoGenerator.class, tile -> 20.0);
        OUTPUTS.put(TileEntityRTGenerator.class, tile -> {
            TileEntityRTGenerator RTGGenerator = (TileEntityRTGenerator)tile;
            int counter = 0;
            for (int i = 0; i < RTGGenerator.fuelSlot.size(); ++i) {
                if (RTGGenerator.fuelSlot.isEmpty(i)) continue;
                ++counter;
            }
            if (counter == 0) {
                return 0.0;
            }
            return Math.pow(2.0, counter - 1) * MULTIPLIERS.get(TileEntityRTGenerator.class);
        });
        OUTPUTS.put(TileEntitySemifluidGenerator.class, tile -> {
            ISemiFluidFuelManager.BurnProperty property;
            FluidStack fluidStack = ((Fluids)tile.getComponent(Fluids.class)).getFluidTank("fluid").getFluid();
            if (fluidStack != null && (property = Recipes.semiFluidGenerator.getBurnProperty(fluidStack.getFluid())) != null && fluidStack.amount >= property.amount) {
                return property.power;
            }
            return 0.0;
        });
        OUTPUTS.put(TileEntityWaterGenerator.class, tile -> {
            TileEntityWaterGenerator waterGenerator = (TileEntityWaterGenerator)tile;
            if (waterGenerator.fuel <= 0) {
                return EnergyNet.instance.getNodeStats(EnergyNet.instance.getTile(tile.func_145831_w(), tile.func_174877_v())).getEnergyOut();
            }
            if (waterGenerator.fuelSlot.get().func_77973_b().hasContainerItem(waterGenerator.fuelSlot.get())) {
                return 1.0;
            }
            return 2.0;
        });
        OUTPUTS.put(TileEntityWindGenerator.class, tile -> {
            try {
                return EnergyNet.instance.getNodeStats(EnergyNet.instance.getTile(tile.func_145831_w(), tile.func_174877_v())).getEnergyOut();
            }
            catch (NullPointerException e) {
                return 0.0;
            }
        });
    }
}

